/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations;

import de.uni_freiburg.informatik.ultimate.core.model.models.IElement;
import de.uni_freiburg.informatik.ultimate.core.model.models.IModifiableMultigraphEdge;
import de.uni_freiburg.informatik.ultimate.core.model.models.ModelUtils;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.BasicIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ActionUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IActionWithBranchEncoders;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IForkActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgForkTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgInternalTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgJoinTransitionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgReturnTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgSummaryTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfgTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IJoinActionThreadCurrent;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgCallTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdgeFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocationIterator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.BlockEncodingBacktranslator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class IcfgDuplicator {
    private final ILogger mLogger;
    private final BlockEncodingBacktranslator mBacktranslator;
    private final Map<IIcfgCallTransition<IcfgLocation>, IIcfgCallTransition<IcfgLocation>> mCallCache;
    private final ManagedScript mManagedScript;
    private final Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> mOld2New;

    public IcfgDuplicator(ILogger logger, IUltimateServiceProvider services, ManagedScript managedScript, BlockEncodingBacktranslator backtranslator) {
        this.mLogger = logger;
        this.mBacktranslator = backtranslator;
        this.mCallCache = new HashMap<IIcfgCallTransition<IcfgLocation>, IIcfgCallTransition<IcfgLocation>>();
        this.mManagedScript = Objects.requireNonNull(managedScript);
        this.mOld2New = new HashMap<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>>();
    }

    public BasicIcfg<IcfgLocation> copy(IIcfg<?> originalIcfg) {
        BasicIcfg<IcfgLocation> newIcfg = new BasicIcfg<IcfgLocation>(String.valueOf(originalIcfg.getIdentifier()) + "_BEv2", originalIcfg.getCfgSmtToolkit(), IcfgLocation.class);
        ModelUtils.copyAnnotations(originalIcfg, newIcfg);
        HashMap<IcfgLocation, IcfgLocation> old2new = new HashMap<IcfgLocation, IcfgLocation>();
        IcfgLocationIterator iter = new IcfgLocationIterator(originalIcfg.getProcedureEntryNodes().values());
        HashSet<Pair> openReturns = new HashSet<Pair>();
        while (iter.hasNext()) {
            Object oldLoc = iter.next();
            String proc = ((IcfgLocation)oldLoc).getProcedure();
            IcfgLocation newLoc = this.createLocCopy((IcfgLocation)oldLoc);
            boolean isError = originalIcfg.getProcedureErrorNodes().get(proc) != null && originalIcfg.getProcedureErrorNodes().get(proc).contains(oldLoc);
            newIcfg.addLocation(newLoc, originalIcfg.getInitialNodes().contains(oldLoc), isError, ((IcfgLocation)oldLoc).equals(originalIcfg.getProcedureEntryNodes().get(proc)), ((IcfgLocation)oldLoc).equals(originalIcfg.getProcedureExitNodes().get(proc)), originalIcfg.getLoopLocations().contains(oldLoc));
            old2new.put((IcfgLocation)oldLoc, newLoc);
        }
        assert (this.noEdges(newIcfg)) : "Icfg contains edges but should not";
        IcfgEdgeFactory edgeFactory = newIcfg.getCfgSmtToolkit().getIcfgEdgeFactory();
        for (Map.Entry nodePair : old2new.entrySet()) {
            IcfgLocation newSource = (IcfgLocation)nodePair.getValue();
            for (IcfgEdge oldEdge : ((IcfgLocation)nodePair.getKey()).getOutgoingEdges()) {
                IIcfgSummaryTransition oldSummary;
                if (oldEdge instanceof IIcfgReturnTransition) {
                    openReturns.add(new Pair((Object)newSource, (Object)oldEdge));
                    continue;
                }
                if (oldEdge instanceof IIcfgSummaryTransition && (oldSummary = (IIcfgSummaryTransition)((Object)oldEdge)).calledProcedureHasImplementation()) continue;
                this.createEdgeCopy(old2new, newSource, oldEdge, edgeFactory);
            }
        }
        openReturns.stream().forEach(a -> {
            IcfgEdge icfgEdge = this.createEdgeCopy(old2new, (IcfgLocation)a.getFirst(), (IcfgEdge)a.getSecond(), edgeFactory);
        });
        this.mBacktranslator.removeIntermediateMappings();
        return newIcfg;
    }

    private IcfgLocation createLocCopy(IcfgLocation oldLoc) {
        IcfgLocation newLoc = new IcfgLocation(oldLoc.getDebugIdentifier(), oldLoc.getProcedure());
        ModelUtils.copyAnnotations((IElement)oldLoc, (IElement)newLoc);
        this.mBacktranslator.mapLocations(newLoc, oldLoc);
        return newLoc;
    }

    private boolean noEdges(IIcfg<IcfgLocation> icfg) {
        Set programPoints = icfg.getProgramPoints().entrySet().stream().flatMap(a -> ((Map)a.getValue()).entrySet().stream()).map(Map.Entry::getValue).collect(Collectors.toSet());
        for (IcfgLocation loc : programPoints) {
            if (loc.getOutgoingEdges().isEmpty() && loc.getIncomingEdges().isEmpty()) continue;
            this.mLogger.fatal((Object)("Location " + loc + " contains incoming or outgoing edges"));
            this.mLogger.fatal((Object)("Incoming: " + loc.getIncomingEdges()));
            this.mLogger.fatal((Object)("Outgoing: " + loc.getOutgoingEdges()));
            return false;
        }
        return true;
    }

    private IcfgEdge createEdgeCopy(Map<IcfgLocation, IcfgLocation> old2new, IcfgLocation newSource, IcfgEdge oldEdge, IcfgEdgeFactory edgeFactory) {
        IcfgLocation newTarget = old2new.get(oldEdge.getTarget());
        assert (newTarget != null);
        IcfgEdge newEdge = this.createUnconnectedCopy(newSource, newTarget, oldEdge, edgeFactory);
        newSource.addOutgoing((IModifiableMultigraphEdge)newEdge);
        newTarget.addIncoming((IModifiableMultigraphEdge)newEdge);
        ModelUtils.copyAnnotations((IElement)oldEdge, (IElement)newEdge);
        this.mBacktranslator.mapEdges((IIcfgTransition<IcfgLocation>)newEdge, oldEdge);
        this.mOld2New.put(oldEdge, newEdge);
        return newEdge;
    }

    private IcfgEdge createUnconnectedCopy(IcfgLocation newSource, IcfgLocation newTarget, IIcfgTransition<?> oldEdge, IcfgEdgeFactory edgeFactory) {
        IcfgEdge rtr;
        IAction newAction = ActionUtils.constructCopy(this.mManagedScript, oldEdge);
        if (oldEdge instanceof IIcfgInternalTransition) {
            UnmodifiableTransFormula tfWithBE = oldEdge instanceof IActionWithBranchEncoders ? TransFormulaBuilder.constructCopy(this.mManagedScript, ((IActionWithBranchEncoders)((Object)oldEdge)).getTransitionFormulaWithBranchEncoders(), Collections.emptySet(), Collections.emptySet(), Collections.emptyMap()) : newAction.getTransformula();
            rtr = edgeFactory.createInternalTransition(newSource, newTarget, null, newAction.getTransformula(), tfWithBE);
        } else if (oldEdge instanceof IIcfgCallTransition) {
            rtr = this.createCopyCall(newSource, newTarget, oldEdge, newAction, edgeFactory);
        } else if (oldEdge instanceof IIcfgReturnTransition) {
            IIcfgReturnTransition oldReturn = (IIcfgReturnTransition)oldEdge;
            Object oldCorrespondingCall = oldReturn.getCorrespondingCall();
            IIcfgCallTransition correspondingCall = this.mCallCache.get(oldCorrespondingCall);
            if (correspondingCall == null) {
                this.mLogger.warn((Object)("Creating raw copy for unreachable call because return is reachable in graph view: " + oldCorrespondingCall));
                correspondingCall = (IIcfgCallTransition)((Object)this.createUnconnectedCopy(null, null, (IIcfgTransition<?>)oldCorrespondingCall, edgeFactory));
            }
            IReturnAction rAction = (IReturnAction)newAction;
            rtr = edgeFactory.createReturnTransition(newSource, newTarget, correspondingCall, null, rAction.getAssignmentOfReturn(), rAction.getLocalVarsAssignmentOfCall());
        } else if (oldEdge instanceof IIcfgForkTransitionThreadCurrent) {
            IForkActionThreadCurrent fAction = (IForkActionThreadCurrent)newAction;
            rtr = edgeFactory.createForkThreadCurrentTransition(newSource, newTarget, null, fAction.getTransformula(), fAction.getForkSmtArguments(), fAction.getNameOfForkedProcedure());
        } else if (oldEdge instanceof IIcfgJoinTransitionThreadCurrent) {
            IJoinActionThreadCurrent jAction = (IJoinActionThreadCurrent)newAction;
            rtr = edgeFactory.createJoinThreadCurrentTransition(newSource, newTarget, null, jAction.getTransformula(), jAction.getJoinSmtArguments());
        } else {
            throw new UnsupportedOperationException("Unknown IcfgEdge subtype: " + oldEdge.getClass());
        }
        return rtr;
    }

    private IcfgEdge createCopyCall(IcfgLocation source, IcfgLocation target, IIcfgTransition<?> oldEdge, IAction newAction, IcfgEdgeFactory edgeFactory) {
        ICallAction cAction = (ICallAction)newAction;
        IcfgCallTransition rtr = edgeFactory.createCallTransition(source, target, null, cAction.getLocalVarsAssignment());
        this.mCallCache.put((IIcfgCallTransition)oldEdge, rtr);
        return rtr;
    }

    public Map<IIcfgTransition<IcfgLocation>, IIcfgTransition<IcfgLocation>> getOld2NewEdgeMapping() {
        return Collections.unmodifiableMap(this.mOld2New);
    }
}

