/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.DefaultIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IntraproceduralReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.LocalReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ReplacementVarFactory {
    private final ManagedScript mMgdScript;
    private final CfgSmtToolkit mCsToolkit;
    private final Map<Term, IReplacementVarOrConst> mRepVarMapping = new HashMap<Term, IReplacementVarOrConst>();
    private final Map<String, TermVariable> mAuxVarMapping = new HashMap<String, TermVariable>();
    private final boolean mUseIntraproceduralReplacementVar;

    public ReplacementVarFactory(CfgSmtToolkit csToolkit, boolean useIntraproceduralReplacementVars) {
        this.mMgdScript = csToolkit.getManagedScript();
        this.mCsToolkit = csToolkit;
        this.mUseIntraproceduralReplacementVar = useIntraproceduralReplacementVars;
    }

    public IReplacementVarOrConst getOrConstuctReplacementVar(Term definition, boolean useGlobalVarInsteadOfConstant) {
        return this.getOrConstuctReplacementVar(definition, useGlobalVarInsteadOfConstant, definition.getSort());
    }

    public IReplacementVarOrConst getOrConstuctReplacementVar(Term definition, boolean useGlobalVarInsteadOfConstant, Sort sort) {
        IReplacementVarOrConst newRepVar;
        IReplacementVarOrConst repVar = this.mRepVarMapping.get(definition);
        if (repVar != null) {
            return repVar;
        }
        String nameCandidate = "rep" + SmtUtils.removeSmtQuoteCharacters((String)definition.toString());
        TermVariable tv = this.mMgdScript.constructFreshTermVariable(nameCandidate, sort);
        if (this.mUseIntraproceduralReplacementVar) {
            newRepVar = new IntraproceduralReplacementVar(tv.getName(), definition, tv);
            this.mRepVarMapping.put(definition, newRepVar);
        } else {
            Pair<Set<Class<? extends IProgramVarOrConst>>, Set<String>> analysisResult = this.analyzeDefinition(definition);
            if (((Set)analysisResult.getFirst()).contains(IProgramNonOldVar.class) && ((Set)analysisResult.getFirst()).contains(IProgramOldVar.class)) {
                throw new UnsupportedOperationException("nonold and old");
            }
            if (((Set)analysisResult.getFirst()).contains(ILocalProgramVar.class)) {
                if (((Set)analysisResult.getSecond()).size() > 1) {
                    throw new UnsupportedOperationException("more than one procedure");
                }
                String proc = (String)((Set)analysisResult.getSecond()).iterator().next();
                newRepVar = this.constructLocalReplacementVar(definition, tv, proc);
                this.mRepVarMapping.put(definition, newRepVar);
            } else if (((Set)analysisResult.getFirst()).contains(IProgramNonOldVar.class)) {
                ReplacementOldVar oldVar = this.constructOldNonOldPairForNonOldDefinition(definition, tv);
                ReplacementNonOldVar nonOldVar = (ReplacementNonOldVar)oldVar.getNonOldVar();
                this.mRepVarMapping.put(oldVar.getDefinition(), oldVar);
                this.mRepVarMapping.put(nonOldVar.getDefinition(), nonOldVar);
                newRepVar = nonOldVar;
            } else if (((Set)analysisResult.getFirst()).contains(IProgramOldVar.class)) {
                ReplacementOldVar oldVar = this.constructOldNonOldPairForOldVarDefinition(definition, tv);
                ReplacementNonOldVar nonOldVar = (ReplacementNonOldVar)oldVar.getNonOldVar();
                this.mRepVarMapping.put(oldVar.getDefinition(), oldVar);
                this.mRepVarMapping.put(nonOldVar.getDefinition(), nonOldVar);
                newRepVar = oldVar;
            } else if (useGlobalVarInsteadOfConstant) {
                ReplacementOldVar oldVar = this.constructOldNonOldPairForNonOldDefinition(definition, tv);
                ReplacementNonOldVar nonOldVar = (ReplacementNonOldVar)oldVar.getNonOldVar();
                this.mRepVarMapping.put(oldVar.getDefinition(), oldVar);
                this.mRepVarMapping.put(nonOldVar.getDefinition(), nonOldVar);
                newRepVar = nonOldVar;
            } else {
                newRepVar = this.constructReplacementConst(definition, tv);
                this.mRepVarMapping.put(definition, newRepVar);
            }
        }
        assert (this.checkOldVar(newRepVar)) : newRepVar + " breaks oldVar-nonOldVar relation";
        return newRepVar;
    }

    private boolean checkOldVar(IReplacementVarOrConst newRepVar) {
        if (newRepVar instanceof IProgramOldVar) {
            IProgramOldVar oldVar = (IProgramOldVar)((Object)newRepVar);
            return Objects.equals(oldVar, oldVar.getNonOldVar().getOldVar());
        }
        if (newRepVar instanceof IProgramNonOldVar) {
            IProgramNonOldVar var = (IProgramNonOldVar)((Object)newRepVar);
            return Objects.equals(var, var.getOldVar().getNonOldVar());
        }
        return true;
    }

    private ReplacementOldVar constructOldNonOldPairForOldVarDefinition(Term oldVarDefinition, TermVariable oldVarTv) {
        ReplacementOldVar oldVar = this.constructReplacementOldVar(oldVarDefinition, oldVarTv);
        Term definition = oldVar.getDefinition();
        Term nonOldVarDefinition = ProgramVarUtils.renameOldGlobalsToNonOldGlobals(definition, this.mCsToolkit.getSymbolTable(), this.mMgdScript);
        TermVariable nonoldVarTv = this.mMgdScript.constructFreshTermVariable("nonold(" + oldVar.getIdentifierOfNonOldVar() + ")", definition.getSort());
        this.constructReplacementNonOldVar(nonOldVarDefinition, nonoldVarTv, oldVar);
        return oldVar;
    }

    private ReplacementOldVar constructOldNonOldPairForNonOldDefinition(Term nonOldDefinition, TermVariable nonOldTv) {
        Term oldVarDefinition = ProgramVarUtils.renameNonOldGlobalsToOldGlobals(nonOldDefinition, this.mCsToolkit.getSymbolTable(), this.mMgdScript);
        TermVariable oldVarTv = this.mMgdScript.constructFreshTermVariable("old(" + nonOldTv.getName() + ")", nonOldDefinition.getSort());
        ReplacementOldVar oldVar = this.constructReplacementOldVar(oldVarDefinition, oldVarTv);
        this.constructReplacementNonOldVar(nonOldDefinition, nonOldTv, oldVar);
        return oldVar;
    }

    private ReplacementConst constructReplacementConst(Term definition, TermVariable tv) {
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.declareFun((Object)this, tv.getName(), new Sort[0], tv.getSort());
        ApplicationTerm smtConstant = (ApplicationTerm)this.mMgdScript.term((Object)this, tv.getName(), new Term[0]);
        this.mMgdScript.unlock((Object)this);
        return new ReplacementConst(tv.getName(), smtConstant, definition);
    }

    private LocalReplacementVar constructLocalReplacementVar(Term definition, TermVariable tv, String proc) {
        this.mMgdScript.lock((Object)this);
        ApplicationTerm defaultConstant = ProgramVarUtils.constructDefaultConstant(this.mMgdScript, this, tv.getSort(), tv.getName());
        ApplicationTerm primedContant = ProgramVarUtils.constructPrimedConstant(this.mMgdScript, this, tv.getSort(), tv.getName());
        this.mMgdScript.unlock((Object)this);
        return new LocalReplacementVar(tv.getName(), proc, tv, defaultConstant, primedContant, definition);
    }

    private ReplacementOldVar constructReplacementOldVar(Term definition, TermVariable tv) {
        this.mMgdScript.lock((Object)this);
        ApplicationTerm defaultConstant = ProgramVarUtils.constructDefaultConstant(this.mMgdScript, this, tv.getSort(), tv.getName());
        ApplicationTerm primedContant = ProgramVarUtils.constructPrimedConstant(this.mMgdScript, this, tv.getSort(), tv.getName());
        this.mMgdScript.unlock((Object)this);
        return new ReplacementOldVar(tv.getName(), tv, defaultConstant, primedContant, definition);
    }

    private ReplacementNonOldVar constructReplacementNonOldVar(Term definition, TermVariable tv, ReplacementOldVar oldVar) {
        this.mMgdScript.lock((Object)this);
        ApplicationTerm defaultConstant = ProgramVarUtils.constructDefaultConstant(this.mMgdScript, this, tv.getSort(), tv.getName());
        ApplicationTerm primedContant = ProgramVarUtils.constructPrimedConstant(this.mMgdScript, this, tv.getSort(), tv.getName());
        this.mMgdScript.unlock((Object)this);
        ReplacementNonOldVar repNonOldVar = new ReplacementNonOldVar(tv.getName(), tv, defaultConstant, primedContant, oldVar, definition);
        oldVar.setNonOldVar(repNonOldVar);
        return repNonOldVar;
    }

    public TermVariable getOrConstructAuxVar(String name, Sort sort) {
        TermVariable auxVar = this.mAuxVarMapping.get(name);
        if (auxVar == null) {
            auxVar = this.mMgdScript.constructFreshTermVariable(SmtUtils.removeSmtQuoteCharacters((String)name), sort);
            this.mAuxVarMapping.put(name, auxVar);
        } else if (sort != auxVar.getSort()) {
            throw new AssertionError((Object)"cannot construct auxVars with same name and different sort");
        }
        return auxVar;
    }

    private Pair<Set<Class<? extends IProgramVarOrConst>>, Set<String>> analyzeDefinition(Term definition) {
        HashSet<Class> constOrVarKinds = new HashSet<Class>();
        HashSet<String> procs = new HashSet<String>();
        TermVariable[] termVariableArray = definition.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar pv = this.mCsToolkit.getSymbolTable().getProgramVar(tv);
            if (pv instanceof ILocalProgramVar) {
                constOrVarKinds.add(ILocalProgramVar.class);
                procs.add(pv.getProcedure());
            } else if (pv instanceof IProgramNonOldVar) {
                constOrVarKinds.add(IProgramNonOldVar.class);
            } else if (pv instanceof IProgramOldVar) {
                constOrVarKinds.add(IProgramOldVar.class);
            } else {
                throw new AssertionError((Object)"unknown kind of variable");
            }
            ++n2;
        }
        Set constants = SmtUtils.extractConstants((Term)definition, (boolean)true);
        if (!constants.isEmpty()) {
            constOrVarKinds.add(IProgramConst.class);
        }
        return new Pair(constOrVarKinds, procs);
    }

    public IIcfgSymbolTable constructIIcfgSymbolTable() {
        DefaultIcfgSymbolTable result = new DefaultIcfgSymbolTable(this.mCsToolkit.getSymbolTable(), this.mCsToolkit.getProcedures());
        for (Map.Entry<Term, IReplacementVarOrConst> entry : this.mRepVarMapping.entrySet()) {
            if (entry.getValue() instanceof IProgramOldVar) continue;
            result.add(entry.getValue());
        }
        result.finishConstruction();
        return result;
    }

    public ModifiableGlobalsTable constructModifiableGlobalsTable() {
        HashRelation proc2Globals = new HashRelation();
        for (String string : this.mCsToolkit.getProcedures()) {
            Set<IProgramNonOldVar> mod = this.mCsToolkit.getModifiableGlobalsTable().getModifiedBoogieVars(string);
            for (IProgramNonOldVar nonOld : mod) {
                proc2Globals.addPair((Object)string, (Object)nonOld);
            }
        }
        for (Map.Entry entry : this.mRepVarMapping.entrySet()) {
            if (!(entry.getValue() instanceof ReplacementNonOldVar)) continue;
            ReplacementNonOldVar nonOld = (ReplacementNonOldVar)entry.getValue();
            for (String proc : this.mCsToolkit.getProcedures()) {
                proc2Globals.addPair((Object)proc, (Object)nonOld);
            }
        }
        return new ModifiableGlobalsTable((HashRelation<String, IProgramNonOldVar>)proc2Globals);
    }

    public boolean isUnused() {
        return this.mRepVarMapping.isEmpty() && this.mAuxVarMapping.isEmpty();
    }
}

