/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ModifiableTransFormula
extends TransFormula {
    private final Map<TermVariable, IProgramVar> mInVarsReverseMapping = new LinkedHashMap<TermVariable, IProgramVar>();
    private final Map<TermVariable, IProgramVar> mOutVarsReverseMapping = new LinkedHashMap<TermVariable, IProgramVar>();
    private Term mFormula;

    public ModifiableTransFormula(Term formula) {
        super(new LinkedHashMap<IProgramVar, TermVariable>(), new LinkedHashMap<IProgramVar, TermVariable>(), new LinkedHashSet<TermVariable>(), new LinkedHashSet<IProgramConst>());
        this.mFormula = formula;
    }

    public ModifiableTransFormula(ModifiableTransFormula other) {
        this(other.getFormula());
        this.mInVars.putAll(other.mInVars);
        this.mInVarsReverseMapping.putAll(other.mInVarsReverseMapping);
        this.mOutVars.putAll(other.mOutVars);
        this.mOutVarsReverseMapping.putAll(other.mOutVarsReverseMapping);
        this.mAuxVars.addAll(other.mAuxVars);
        this.mNonTheoryConsts.addAll(other.mNonTheoryConsts);
    }

    public Map<Term, IProgramVar> getInVarsReverseMapping() {
        return Collections.unmodifiableMap(this.mInVarsReverseMapping);
    }

    public Map<Term, IProgramVar> getOutVarsReverseMapping() {
        return Collections.unmodifiableMap(this.mOutVarsReverseMapping);
    }

    public void addInVar(IProgramVar rkVar, TermVariable var) {
        Term oldValue = (Term)this.mInVars.put(rkVar, var);
        if (oldValue == null) {
            this.mInVarsReverseMapping.put(var, rkVar);
        } else if (oldValue != var) {
            throw new IllegalArgumentException(oldValue + " is already the inVar of " + rkVar);
        }
    }

    public void removeInVar(IProgramVar rkVar) {
        Term tv = (Term)this.mInVars.remove(rkVar);
        if (tv == null) {
            throw new AssertionError((Object)"cannot remove variable that is not contained");
        }
        this.mInVarsReverseMapping.remove(tv);
    }

    public void addOutVar(IProgramVar rkVar, TermVariable var) {
        Term oldValue = (Term)this.mOutVars.put(rkVar, var);
        if (oldValue == null) {
            this.mOutVarsReverseMapping.put(var, rkVar);
        } else if (oldValue != var) {
            throw new IllegalArgumentException(oldValue + " is already the outVar of " + rkVar);
        }
    }

    public void removeOutVar(IProgramVar rkVar) {
        Term tv = (Term)this.mOutVars.remove(rkVar);
        if (tv == null) {
            throw new AssertionError((Object)"cannot remove variable that is not contained");
        }
        this.mOutVarsReverseMapping.remove(tv);
    }

    public void removeAuxVar(TermVariable auxVar) {
        boolean modified = this.mAuxVars.remove(auxVar);
        if (!modified) {
            throw new AssertionError((Object)"cannot remove variable that is not contained");
        }
    }

    public void addAuxVars(Set<TermVariable> auxVars) {
        this.mAuxVars.addAll(auxVars);
    }

    @Override
    public Term getFormula() {
        return this.mFormula;
    }

    public void setFormula(Term formula) {
        this.mFormula = formula;
    }

    public void addNonTheoryConsts(Collection<IProgramConst> nonTheoryConsts) {
        this.mNonTheoryConsts.addAll(nonTheoryConsts);
    }

    public boolean auxVarsDisjointFromInOutVars() {
        for (Term auxVar : this.mAuxVars) {
            if (this.mInVarsReverseMapping.containsKey(auxVar)) {
                return false;
            }
            if (!this.mOutVarsReverseMapping.containsKey(auxVar)) continue;
            return false;
        }
        return true;
    }

    public TermVariable allAreInOutAux(TermVariable[] tvs) {
        TermVariable[] termVariableArray = tvs;
        int n = tvs.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            if (!this.isInOurAux(tv)) {
                return tv;
            }
            ++n2;
        }
        return null;
    }

    @Override
    public Set<IProgramVar> getAssignedVars() {
        return Collections.unmodifiableSet(TransFormulaUtils.computeAssignedVars(this.mInVars, this.mOutVars));
    }

    private boolean isInOurAux(TermVariable tv) {
        if (this.mInVarsReverseMapping.containsKey(tv) || this.mOutVarsReverseMapping.containsKey(tv)) {
            return true;
        }
        return this.mAuxVars.contains(tv);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InVars: ");
        sb.append(this.mInVars.toString());
        sb.append("\nOutVars: ");
        sb.append(this.mOutVars.toString());
        sb.append("\nAuxVars: ");
        sb.append(this.mAuxVars.toString());
        sb.append("\nTransition formula: ");
        sb.append(new SMTPrettyPrinter(this.mFormula));
        return sb.toString();
    }
}

