/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ModifiableTransFormulaUtils {
    public static boolean allVariablesAreInVars(List<Term> terms, ModifiableTransFormula tf) {
        return terms.stream().allMatch(x -> ModifiableTransFormulaUtils.allVariablesAreInVars(x, tf));
    }

    public static boolean allVariablesAreOutVars(List<Term> terms, ModifiableTransFormula tf) {
        return terms.stream().allMatch(x -> ModifiableTransFormulaUtils.allVariablesAreOutVars(x, tf));
    }

    public static boolean allVariablesAreVisible(List<Term> terms, ModifiableTransFormula tf) {
        return terms.stream().allMatch(x -> ModifiableTransFormulaUtils.allVariablesAreVisible(x, tf));
    }

    public static boolean allVariablesAreInVars(Term term, ModifiableTransFormula tf) {
        return Arrays.stream(term.getFreeVars()).allMatch(x -> ModifiableTransFormulaUtils.isInVar(x, tf));
    }

    public static boolean allVariablesAreOutVars(Term term, ModifiableTransFormula tf) {
        return Arrays.stream(term.getFreeVars()).allMatch(x -> ModifiableTransFormulaUtils.isOutVar(x, tf));
    }

    public static boolean allVariablesAreVisible(Term term, ModifiableTransFormula tf) {
        return Arrays.stream(term.getFreeVars()).allMatch(x -> ModifiableTransFormulaUtils.isVisible(x, tf));
    }

    private static boolean isVisible(TermVariable tv, ModifiableTransFormula tf) {
        return ModifiableTransFormulaUtils.isInVar(tv, tf) || ModifiableTransFormulaUtils.isOutVar(tv, tf);
    }

    public static boolean isInVar(TermVariable tv, ModifiableTransFormula tf) {
        return tf.getInVarsReverseMapping().keySet().contains(tv);
    }

    public static boolean isOutVar(TermVariable tv, ModifiableTransFormula tf) {
        return tf.getOutVarsReverseMapping().keySet().contains(tv);
    }

    public static Script.LBool implies(IUltimateServiceProvider services, ILogger logger, ModifiableTransFormula antecedent, ModifiableTransFormula consequent, ManagedScript mgdScript, IIcfgSymbolTable symbTab) {
        Term antecentTerm = ModifiableTransFormulaUtils.renameToConstants(services, logger, mgdScript, symbTab, antecedent);
        Term consequentTerm = ModifiableTransFormulaUtils.renameToConstants(services, logger, mgdScript, symbTab, consequent);
        mgdScript.getScript().push(1);
        mgdScript.getScript().assertTerm(antecentTerm);
        mgdScript.getScript().assertTerm(SmtUtils.not((Script)mgdScript.getScript(), (Term)consequentTerm));
        mgdScript.getScript().assertTerm(ModifiableTransFormulaUtils.getAdditionalEqualities(Arrays.asList(antecedent, consequent), symbTab, mgdScript.getScript()));
        Script.LBool result = mgdScript.getScript().checkSat();
        mgdScript.getScript().pop(1);
        return result;
    }

    private static Term getAdditionalEqualities(List<ModifiableTransFormula> transformulas, IIcfgSymbolTable symbTab, Script script) {
        HashSet<Term> result = new HashSet<Term>();
        HashSet<TermVariable> vars = new HashSet<TermVariable>();
        HashSet<IProgramVar> programVars = new HashSet<IProgramVar>();
        for (ModifiableTransFormula tf : transformulas) {
            for (IProgramVar programVar : tf.getInVars().keySet()) {
                programVars.add(programVar);
                vars.addAll(Arrays.asList(ReplacementVarUtils.getDefinition(programVar).getFreeVars()));
            }
            for (IProgramVar programVar : tf.getOutVars().keySet()) {
                programVars.add(programVar);
                vars.addAll(Arrays.asList(ReplacementVarUtils.getDefinition(programVar).getFreeVars()));
            }
        }
        for (TermVariable var : vars) {
            IProgramVar boogieVar = symbTab.getProgramVar(var);
            if (programVars.contains(boogieVar)) continue;
            Term equality = SmtUtils.binaryEquality((Script)script, (Term)boogieVar.getDefaultConstant(), (Term)boogieVar.getPrimedConstant());
            result.add(equality);
        }
        return SmtUtils.and((Script)script, result);
    }

    private static Term renameToConstants(IUltimateServiceProvider services, ILogger logger, ManagedScript mgdScript, IIcfgSymbolTable symbTab, ModifiableTransFormula tf) {
        Term definition;
        HashMap<Term, Object> substitutionMapping = new HashMap<Term, Object>();
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
            if (entry.getKey() instanceof IReplacementVarOrConst) {
                definition = ReplacementVarUtils.getDefinition(entry.getKey());
                substitutionMapping.put((Term)entry.getValue(), ModifiableTransFormulaUtils.renameVars(mgdScript, symbTab, definition, IProgramVar::getDefaultConstant));
                continue;
            }
            substitutionMapping.put((Term)entry.getValue(), entry.getKey().getDefaultConstant());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getOutVars().entrySet()) {
            if (entry.getKey() instanceof IReplacementVarOrConst) {
                definition = ReplacementVarUtils.getDefinition(entry.getKey());
                substitutionMapping.put((Term)entry.getValue(), ModifiableTransFormulaUtils.renameVars(mgdScript, symbTab, definition, IProgramVar::getPrimedConstant));
                continue;
            }
            substitutionMapping.put((Term)entry.getValue(), entry.getKey().getPrimedConstant());
        }
        Term result = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)tf.getFormula());
        result = SmtUtils.and((Script)mgdScript.getScript(), (Term[])new Term[]{result, ModifiableTransFormulaUtils.constructEqualitiesForCoinciding(mgdScript.getScript(), tf)});
        if (!tf.getAuxVars().isEmpty()) {
            logger.warn((Object)(String.valueOf(tf.getAuxVars().size()) + " quantified variables"));
            TermVariable[] auxVarsArray = tf.getAuxVars().toArray(new TermVariable[tf.getAuxVars().size()]);
            result = mgdScript.getScript().quantifier(0, auxVarsArray, result, (Term[][])new Term[0][]);
        }
        assert (Arrays.asList(result.getFreeVars()).isEmpty()) : "there must not be a TermVariable left";
        return result;
    }

    private static Term renameVars(ManagedScript mgdScript, IIcfgSymbolTable symbTab, Term term, Function<IProgramVar, Term> termProvider) {
        HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar bv = symbTab.getProgramVar(tv);
            if (bv == null) {
                throw new IllegalArgumentException("term contains unknown variable");
            }
            substitutionMapping.put(tv, termProvider.apply(bv));
            ++n2;
        }
        return Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term);
    }

    public static Term getDefinition(ModifiableTransFormula tf, TermVariable tv) {
        IProgramVar rv = tf.getInVarsReverseMapping().get(tv);
        if (rv == null) {
            rv = tf.getOutVarsReverseMapping().get(tv);
        }
        if (rv == null) {
            return null;
        }
        return ReplacementVarUtils.getDefinition(rv);
    }

    public static Term translateTermVariablesToDefinitions(ManagedScript script, ModifiableTransFormula tf, Term term) {
        HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            Term definition = ModifiableTransFormulaUtils.getDefinition(tf, tv);
            if (definition == null) {
                throw new IllegalArgumentException(tv + "has no RankVar");
            }
            substitutionMapping.put(tv, definition);
            ++n2;
        }
        return Substitution.apply((ManagedScript)script, substitutionMapping, (Term)term);
    }

    public static List<Term> translateTermVariablesToDefinitions(ManagedScript script, ModifiableTransFormula tf, List<Term> terms) {
        return terms.stream().map(term -> ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(script, tf, term)).collect(Collectors.toList());
    }

    public static Term translateTermVariablesToInVars(ManagedScript script, ModifiableTransFormula tf, Term term, IIcfgSymbolTable symbolTable) {
        HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar bv = symbolTable.getProgramVar(tv);
            Term inVar = (Term)tf.getInVars().get(bv);
            assert (inVar != null) : "no inVar for " + bv;
            substitutionMapping.put(tv, inVar);
            ++n2;
        }
        return Substitution.apply((ManagedScript)script, substitutionMapping, (Term)term);
    }

    public static boolean inVarAndOutVarCoincide(IProgramVar rv, ModifiableTransFormula rf) {
        return rf.getInVars().get(rv) == rf.getOutVars().get(rv);
    }

    private static Term constructEqualitiesForCoinciding(Script script, ModifiableTransFormula tf) {
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        for (IProgramVar rv : tf.getInVars().keySet()) {
            if (rv instanceof IReplacementVarOrConst || !ModifiableTransFormulaUtils.inVarAndOutVarCoincide(rv, tf)) continue;
            IProgramVar bv = rv;
            conjuncts.add(SmtUtils.binaryEquality((Script)script, (Term)bv.getDefaultConstant(), (Term)bv.getPrimedConstant()));
        }
        return SmtUtils.and((Script)script, conjuncts);
    }

    public static ModifiableTransFormula buildTransFormula(TransFormula inputTf, ManagedScript mgdScript) {
        return ModifiableTransFormulaUtils.buildTransFormulaHelper(inputTf, null, mgdScript);
    }

    public static ModifiableTransFormula buildTransFormula(TransFormula inputTf, ReplacementVarFactory replacementVarFactory, ManagedScript mgdScript) {
        return ModifiableTransFormulaUtils.buildTransFormulaHelper(inputTf, replacementVarFactory, mgdScript);
    }

    private static ModifiableTransFormula buildTransFormulaHelper(TransFormula inputTf, ReplacementVarFactory replacementVarFactory, ManagedScript mgdScript) {
        HashMap<Object, Object> substitutionMapping = new HashMap<Object, Object>();
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>();
        for (TermVariable auxVar : inputTf.getAuxVars()) {
            TermVariable newAuxVar = mgdScript.constructFreshCopy(auxVar);
            auxVars.add(newAuxVar);
            substitutionMapping.put(auxVar, newAuxVar);
        }
        ModifiableTransFormula newTf = new ModifiableTransFormula(null);
        if (replacementVarFactory != null) {
            for (IProgramConst progConst : inputTf.getNonTheoryConsts()) {
                ApplicationTerm constVar = progConst.getDefaultConstant();
                IReplacementVar repVar = (IReplacementVar)replacementVarFactory.getOrConstuctReplacementVar((Term)constVar, true);
                newTf.addInVar(repVar, repVar.getTermVariable());
                newTf.addOutVar(repVar, repVar.getTermVariable());
                substitutionMapping.put(constVar, repVar.getTermVariable());
            }
        } else {
            newTf.addNonTheoryConsts(inputTf.getNonTheoryConsts());
        }
        Term formula = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)inputTf.getFormula());
        newTf.setFormula(formula);
        for (Map.Entry<IProgramVar, TermVariable> entry : inputTf.getInVars().entrySet()) {
            newTf.addInVar(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : inputTf.getOutVars().entrySet()) {
            newTf.addOutVar(entry.getKey(), entry.getValue());
        }
        newTf.addAuxVars(auxVars);
        return newTf;
    }
}

