/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalNestedStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.binaryrelation.SolvedBinaryRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.polynomials.PolynomialRelation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.DualJunctionDer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.EqualityInformation;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SimultaneousUpdate {
    private final Map<IProgramVar, Term> mDeterministicAssignment;
    private final NestedMap2<IProgramVar, ArrayIndex, Term> mDeterministicArrayWrites;
    private final Set<IProgramVar> mHavocedVars;
    private final Set<IProgramVar> mReadonlyVars;

    public SimultaneousUpdate(Map<IProgramVar, Term> deterministicAssignment, NestedMap2<IProgramVar, ArrayIndex, Term> deterministicArrayWrites, Set<IProgramVar> havocedVars, Set<IProgramVar> readonlyVars) {
        this.mDeterministicAssignment = deterministicAssignment;
        this.mDeterministicArrayWrites = deterministicArrayWrites;
        this.mHavocedVars = havocedVars;
        this.mReadonlyVars = readonlyVars;
    }

    public static SimultaneousUpdate fromTransFormula(IUltimateServiceProvider services, TransFormula tf, ManagedScript mgdScript) throws SimultaneousUpdateException {
        HashSet<IProgramVar> havocedVars = new HashSet<IProgramVar>();
        HashSet<IProgramVar> assignmentCandidates = new HashSet<IProgramVar>();
        HashSet<IProgramVar> unmodifiedVars = new HashSet<IProgramVar>();
        Set<IProgramVar> allProgVars = TransFormula.collectAllProgramVars(tf);
        for (IProgramVar pv : allProgVars) {
            if (tf.getInVars().get(pv) == tf.getOutVars().get(pv)) {
                unmodifiedVars.add(pv);
                continue;
            }
            if (tf.isHavocedOut(pv)) {
                havocedVars.add(pv);
                continue;
            }
            assignmentCandidates.add(pv);
        }
        Map<TermVariable, IProgramVar> inVarsReverseMapping = TransFormulaUtils.constructReverseMapping(tf.getInVars());
        Map<TermVariable, IProgramVar> outVarsReverseMapping = TransFormulaUtils.constructReverseMapping(tf.getOutVars());
        Term[] conjuncts = SmtUtils.getConjuncts((Term)tf.getFormula());
        HashRelation pv2conjuncts = new HashRelation();
        Term[] termArray = conjuncts;
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term conjunct = termArray[n2];
            TermVariable[] termVariableArray = conjunct.getFreeVars();
            int n3 = termVariableArray.length;
            int n4 = 0;
            while (n4 < n3) {
                TermVariable tv = termVariableArray[n4];
                IProgramVar pv = outVarsReverseMapping.get(tv);
                if (pv != null) {
                    pv2conjuncts.addPair((Object)pv, (Object)conjunct);
                }
                ++n4;
            }
            ++n2;
        }
        HashMap<IProgramVar, Term> deterministicAssignment = new HashMap<IProgramVar, Term>();
        NestedMap2 deterministicArrayWrites = new NestedMap2();
        for (IProgramVar pv : assignmentCandidates) {
            Set pvContainingConjuncts = pv2conjuncts.getImage((Object)pv);
            if (pvContainingConjuncts.isEmpty()) {
                if (tf.getInVars().get(pv) != tf.getOutVars().get(pv)) {
                    throw new AssertionError((Object)"in and out have to be similar");
                }
                continue;
            }
            Term boolConst = SimultaneousUpdate.isAssignedWithBooleanConstant(mgdScript, tf, pv, pvContainingConjuncts);
            if (boolConst != null) {
                deterministicAssignment.put(pv, boolConst);
                continue;
            }
            Term cfr_ignored_0 = (Term)pvContainingConjuncts.iterator().next();
            TermVariable outVar = tf.getOutVars().get(pv);
            Term renamed = SimultaneousUpdate.extractUpdateRhs(services, outVar, tf, inVarsReverseMapping.keySet(), mgdScript);
            if (renamed == null) {
                throw new SimultaneousUpdateException(String.format("Cannot find an inVar-based term that is equivalent to %s's outVar %s in TransFormula %s", pv, outVar, tf));
            }
            if (SmtSortUtils.isArraySort((Sort)pv.getSort())) {
                MultiDimensionalNestedStore mdns = MultiDimensionalNestedStore.convert((Script)mgdScript.getScript(), (Term)renamed);
                if (mdns.getIndices().size() > 1) {
                    throw new UnsupportedOperationException("Nested stores not yet supported");
                }
                if (!pv.getTermVariable().equals(mdns.getArray())) {
                    throw new UnsupportedOperationException("Only self-update supported");
                }
                deterministicArrayWrites.put((Object)pv, (Object)((ArrayIndex)mdns.getIndices().get(0)), (Object)((Term)mdns.getValues().get(0)));
                continue;
            }
            deterministicAssignment.put(pv, renamed);
        }
        HashSet<IProgramVar> readonlyVariables = new HashSet<IProgramVar>();
        for (IProgramVar pv : unmodifiedVars) {
            if (!SimultaneousUpdate.isReadInSomeAssignment(pv, deterministicAssignment)) continue;
            readonlyVariables.add(pv);
        }
        return new SimultaneousUpdate(deterministicAssignment, (NestedMap2<IProgramVar, ArrayIndex, Term>)deterministicArrayWrites, havocedVars, readonlyVariables);
    }

    private static boolean isReadInSomeAssignment(IProgramVar pv, Map<IProgramVar, Term> deterministicAssignment) {
        for (Map.Entry<IProgramVar, Term> entry : deterministicAssignment.entrySet()) {
            if (!Arrays.asList(entry.getValue().getFreeVars()).contains(pv.getTermVariable())) continue;
            return true;
        }
        return false;
    }

    private static Term tryToExtractAssigedTerm(Script script, Term conjunction, TermVariable outVar, Set<TermVariable> outVars) {
        Term[] conjuncts;
        Term[] termArray = conjuncts = SmtUtils.getConjuncts((Term)conjunction);
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            PolynomialRelation polyRel;
            SolvedBinaryRelation sbr;
            Term conjunct = termArray[n2];
            if (Arrays.asList(conjunct.getFreeVars()).contains(outVar) && (sbr = (polyRel = PolynomialRelation.convert((Script)script, (Term)conjunct)).solveForSubject(script, (Term)outVar)) != null) {
                Term lhs = sbr.getLeftHandSide();
                if (Arrays.asList(lhs.getFreeVars()).stream().noneMatch(outVars::contains)) {
                    return lhs;
                }
            }
            ++n2;
        }
        return null;
    }

    private static Term isAssignedWithBooleanConstant(ManagedScript mgdScript, TransFormula tf, IProgramVar pv, Set<Term> pvContainingConjuncts) {
        if (SmtSortUtils.isBoolSort((Sort)pv.getTerm().getSort()) && pvContainingConjuncts.size() == 1) {
            Term conjunct = pvContainingConjuncts.iterator().next();
            if (DualJunctionDer.isSimilarModuloNegation((Term)conjunct, (Term)((Term)tf.getOutVars().get(pv)))) {
                return mgdScript.getScript().term("true", new Term[0]);
            }
            if (DualJunctionDer.isDistinctModuloNegation((Term)conjunct, (Term)((Term)tf.getOutVars().get(pv)))) {
                return mgdScript.getScript().term("false", new Term[0]);
            }
        }
        return null;
    }

    private static Term extractUpdateRhs(IUltimateServiceProvider services, TermVariable outVar, TransFormula tf, Set<TermVariable> inVarSet, ManagedScript mgdScript) {
        Set nonInvars = Arrays.asList(tf.getFormula().getFreeVars()).stream().filter(x -> x != outVar && !inVarSet.contains(x)).collect(Collectors.toSet());
        Term quantified = SmtUtils.quantifier((Script)mgdScript.getScript(), (int)0, nonInvars, (Term)tf.getFormula());
        Term eliminated = PartialQuantifierElimination.eliminateLight((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (Term)quantified);
        Term[] conjuncts = SmtUtils.getConjuncts((Term)eliminated);
        EqualityInformation ei = EqualityInformation.getEqinfo((Script)mgdScript.getScript(), (Term)outVar, (Term[])conjuncts, null, (int)0);
        if (ei == null) {
            return null;
        }
        Term rhs = ei.getRelatedTerm();
        Term renamed = TransFormulaUtils.renameInvarsToDefaultVars(tf, mgdScript, rhs);
        return renamed;
    }

    public Map<IProgramVar, Term> getDeterministicAssignment() {
        return this.mDeterministicAssignment;
    }

    public NestedMap2<IProgramVar, ArrayIndex, Term> getDeterministicArrayWrites() {
        return this.mDeterministicArrayWrites;
    }

    public Set<IProgramVar> getHavocedVars() {
        return this.mHavocedVars;
    }

    public Set<IProgramVar> getReadonlyVars() {
        return this.mReadonlyVars;
    }

    public static class SimultaneousUpdateException
    extends Exception {
        public SimultaneousUpdateException(String errorMessage) {
            super(errorMessage);
        }
    }
}

