/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ITransitionRelation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class TransFormula
implements ITransitionRelation {
    protected final Map<IProgramVar, TermVariable> mInVars;
    protected final Map<IProgramVar, TermVariable> mOutVars;
    protected final Set<TermVariable> mAuxVars;
    protected final Set<IProgramConst> mNonTheoryConsts;

    public TransFormula(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, Set<TermVariable> auxVars, Set<IProgramConst> nonTheoryConsts) {
        this.mInVars = inVars;
        this.mOutVars = outVars;
        this.mAuxVars = auxVars;
        this.mNonTheoryConsts = nonTheoryConsts;
    }

    public abstract Term getFormula();

    @Override
    public Map<IProgramVar, TermVariable> getInVars() {
        return Collections.unmodifiableMap(this.mInVars);
    }

    @Override
    public Map<IProgramVar, TermVariable> getOutVars() {
        return Collections.unmodifiableMap(this.mOutVars);
    }

    @Override
    public Set<IProgramConst> getNonTheoryConsts() {
        return Collections.unmodifiableSet(this.mNonTheoryConsts);
    }

    @Override
    public Set<TermVariable> getAuxVars() {
        return Collections.unmodifiableSet(this.mAuxVars);
    }

    @Override
    public boolean isHavocedOut(IProgramVar bv) {
        TermVariable outVar;
        TermVariable inVar = this.mInVars.get(bv);
        if (inVar == (outVar = this.mOutVars.get(bv))) {
            return false;
        }
        return !Arrays.asList(this.getFormula().getFreeVars()).contains(outVar);
    }

    @Override
    public boolean isHavocedIn(IProgramVar bv) {
        TermVariable outVar;
        TermVariable inVar = this.mInVars.get(bv);
        if (inVar == (outVar = this.mOutVars.get(bv))) {
            return false;
        }
        return !Arrays.asList(this.getFormula().getFreeVars()).contains(inVar);
    }

    public static Set<IProgramVar> collectAllProgramVars(TransFormula tf) {
        HashSet<IProgramVar> allProgramVars = new HashSet<IProgramVar>();
        allProgramVars.addAll(tf.getInVars().keySet());
        allProgramVars.addAll(tf.getOutVars().keySet());
        return allProgramVars;
    }
}

