/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.TransferrerWithVariableCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsProc;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransFormulaBuilder {
    private final Map<IProgramVar, TermVariable> mInVars;
    private final Map<IProgramVar, TermVariable> mOutVars;
    private final Set<IProgramConst> mNonTheoryConsts;
    private final Set<TermVariable> mAuxVars;
    private final Set<TermVariable> mBranchEncoders;
    private UnmodifiableTransFormula.Infeasibility mInfeasibility = null;
    private Term mFormula = null;
    private boolean mConstructionFinished = false;

    public TransFormulaBuilder(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, boolean emptyNonTheoryConsts, Set<IProgramConst> nonTheoryConsts, boolean emptyBranchEncoders, Collection<TermVariable> branchEncoders, boolean emptyAuxVars) {
        this.mInVars = inVars == null ? new HashMap<IProgramVar, TermVariable>() : new HashMap<IProgramVar, TermVariable>(inVars);
        this.mOutVars = outVars == null ? new HashMap<IProgramVar, TermVariable>() : new HashMap<IProgramVar, TermVariable>(outVars);
        if (emptyNonTheoryConsts) {
            this.mNonTheoryConsts = ImmutableSet.empty();
            if (nonTheoryConsts != null && !nonTheoryConsts.isEmpty()) {
                throw new IllegalArgumentException("if emptyNonTheoryConsts=true, you cannot provide nonTheoryConsts");
            }
        } else {
            this.mNonTheoryConsts = nonTheoryConsts == null ? new HashSet<IProgramConst>() : new HashSet<IProgramConst>(nonTheoryConsts);
        }
        this.mAuxVars = emptyAuxVars ? ImmutableSet.empty() : new HashSet<TermVariable>();
        if (emptyBranchEncoders) {
            this.mBranchEncoders = ImmutableSet.empty();
            if (branchEncoders != null && !branchEncoders.isEmpty()) {
                throw new IllegalArgumentException("if emptyBranchEncoders=true, you cannot provide branchEncoders");
            }
        } else {
            this.mBranchEncoders = branchEncoders == null ? new HashSet<TermVariable>() : new HashSet<TermVariable>(branchEncoders);
        }
    }

    public boolean addAuxVar(TermVariable arg0) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mAuxVars.add(arg0);
    }

    public void addAuxVarsButRenameToFreshCopies(Set<? extends TermVariable> arg0, ManagedScript script) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        if (this.mFormula == null) {
            throw new IllegalStateException("Formula not yet set, cannot rename.");
        }
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (TermVariable termVariable : arg0) {
            TermVariable newAuxVar = script.constructFreshCopy(termVariable);
            this.addAuxVar(newAuxVar);
            substitutionMapping.put(termVariable, newAuxVar);
        }
        this.mFormula = Substitution.apply((ManagedScript)script, substitutionMapping, (Term)this.mFormula);
    }

    public boolean removeAuxVar(TermVariable arg0) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mAuxVars.remove(arg0);
    }

    public boolean addBranchEncoder(TermVariable arg0) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mBranchEncoders.add(arg0);
    }

    public boolean addBranchEncoders(Collection<? extends TermVariable> arg0) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mBranchEncoders.addAll(arg0);
    }

    public boolean containsInVar(IProgramVar arg0) {
        return this.mInVars.containsKey(arg0);
    }

    public TermVariable getInVar(IProgramVar key) {
        return this.mInVars.get(key);
    }

    public TermVariable addInVar(IProgramVar key, TermVariable value) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mInVars.put(key, value);
    }

    public void addInVars(Map<? extends IProgramVar, ? extends TermVariable> m) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        this.mInVars.putAll(m);
    }

    public TermVariable removeInVar(IProgramVar key) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mInVars.remove(key);
    }

    public boolean containsOutVar(IProgramVar arg0) {
        return this.mOutVars.containsKey(arg0);
    }

    public TermVariable getOutVar(IProgramVar key) {
        return this.mOutVars.get(key);
    }

    public TermVariable addOutVar(IProgramVar key, TermVariable value) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mOutVars.put(key, value);
    }

    public void addOutVars(Map<? extends IProgramVar, ? extends TermVariable> m) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        this.mOutVars.putAll(m);
    }

    public TermVariable removeOutVar(IProgramVar key) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mOutVars.remove(key);
    }

    public void clearOutVars() {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        this.mOutVars.clear();
    }

    public void removeOutVarsOfLocalContext() {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        Iterator<Map.Entry<IProgramVar, TermVariable>> it = this.mOutVars.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<IProgramVar, TermVariable> next = it.next();
            if (next.getKey().isGlobal() && !next.getKey().isOldvar()) continue;
            it.remove();
        }
    }

    public boolean addProgramConst(IProgramConst progConst) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        return this.mNonTheoryConsts.add(progConst);
    }

    public void setInfeasibility(UnmodifiableTransFormula.Infeasibility infeasibility) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        if (this.mInfeasibility != null) {
            throw new IllegalStateException("Infeasibility already set.");
        }
        this.mInfeasibility = infeasibility;
    }

    public void setFormula(Term formula) {
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        if (this.mFormula != null) {
            throw new IllegalStateException("Formula already set.");
        }
        this.mFormula = formula;
    }

    public void ensureInternalNormalForm() {
        if (this.mFormula == null) {
            throw new IllegalStateException("Cannot ensure internal normal form without formula");
        }
        if (this.mConstructionFinished) {
            throw new IllegalStateException("Construction finished, TransFormula must not be modified.");
        }
        List<TermVariable> freeVars = Arrays.asList(this.mFormula.getFreeVars());
        HashSet<IProgramVar> obsoleteInVars = new HashSet<IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> entry : this.mInVars.entrySet()) {
            if (this.mOutVars.containsKey(entry.getKey()) || freeVars.contains(entry.getValue())) continue;
            this.mOutVars.put(entry.getKey(), entry.getValue());
            obsoleteInVars.add(entry.getKey());
        }
        for (IProgramVar pv : obsoleteInVars) {
            this.mInVars.remove(pv);
        }
    }

    public UnmodifiableTransFormula finishConstruction(ManagedScript script) {
        if (this.mFormula == null) {
            throw new IllegalStateException("cannot finish without formula");
        }
        if (this.mInfeasibility == null) {
            throw new IllegalStateException("cannot finish without feasibility status");
        }
        this.mConstructionFinished = true;
        TransFormulaBuilder.removeSuperfluousVars(this.mFormula, this.mInVars, this.mOutVars, this.mAuxVars);
        return new UnmodifiableTransFormula(this.mFormula, Collections.unmodifiableMap(this.mInVars), Collections.unmodifiableMap(this.mOutVars), (ImmutableSet<IProgramConst>)ImmutableSet.of(this.mNonTheoryConsts), (ImmutableSet<TermVariable>)ImmutableSet.of(this.mAuxVars), (ImmutableSet<TermVariable>)ImmutableSet.of(this.mBranchEncoders), this.mInfeasibility, script);
    }

    private static void removeSuperfluousVars(Term formula, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, Set<TermVariable> auxVars) {
        HashSet<TermVariable> allVars = new HashSet<TermVariable>(Arrays.asList(formula.getFreeVars()));
        if (!auxVars.isEmpty()) {
            auxVars.retainAll(allVars);
        }
        ArrayList<IProgramVar> superfluousOutVars = new ArrayList<IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> entry : outVars.entrySet()) {
            IProgramVar pv = entry.getKey();
            TermVariable outVar = entry.getValue();
            TermVariable inVar = inVars.get(pv);
            if (inVar == null) continue;
            if (inVar == outVar) {
                if (allVars.contains(outVar)) continue;
                inVars.remove(pv);
                superfluousOutVars.add(pv);
                continue;
            }
            if (!allVars.contains(inVar)) {
                inVars.remove(pv);
                continue;
            }
            if (allVars.contains(outVar)) continue;
            superfluousOutVars.add(pv);
        }
        for (IProgramVar iProgramVar : superfluousOutVars) {
            outVars.remove(iProgramVar);
        }
    }

    public static UnmodifiableTransFormula getTrivialTransFormula(ManagedScript script) {
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, true, null, true, null, true);
        tfb.setFormula(script.getScript().term("true", new Term[0]));
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(script);
    }

    public static UnmodifiableTransFormula constructTransFormulaFromPredicate(IPredicate pred, ManagedScript script) {
        return TransFormulaBuilder.constructTransFormulaFromTerm(pred.getFormula(), pred.getVars(), script);
    }

    public static UnmodifiableTransFormula constructTransFormulaFromTerm(Term term, Set<IProgramVar> vars, ManagedScript script) {
        Set consts = SmtUtils.extractConstants((Term)term, (boolean)false);
        if (!consts.isEmpty()) {
            throw new UnsupportedOperationException("constants not yet supported");
        }
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, true, null, true, null, true);
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar bv : vars) {
            TermVariable freshTv = script.constructFreshTermVariable(bv.getGloballyUniqueId(), bv.getTermVariable().getSort());
            substitutionMapping.put(bv.getTermVariable(), freshTv);
            tfb.addInVar(bv, freshTv);
            tfb.addOutVar(bv, freshTv);
        }
        tfb.setFormula(Substitution.apply((ManagedScript)script, substitutionMapping, (Term)term));
        tfb.setInfeasibility(SmtUtils.isFalseLiteral((Term)term) ? UnmodifiableTransFormula.Infeasibility.INFEASIBLE : UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(script);
    }

    public static UnmodifiableTransFormula constructAssignment(List<? extends IProgramVar> lhs, List<Term> rhs, IIcfgSymbolTable symbolTable, ManagedScript mgdScript) {
        return TransFormulaBuilder.constructEquality(lhs, rhs, symbolTable, mgdScript, false);
    }

    public static UnmodifiableTransFormula constructEqualityAssumption(List<? extends IProgramVar> lhs, List<Term> rhs, IIcfgSymbolTable symbolTable, ManagedScript mgdScript) {
        return TransFormulaBuilder.constructEquality(lhs, rhs, symbolTable, mgdScript, true);
    }

    private static UnmodifiableTransFormula constructEquality(List<? extends IProgramVar> lhs, List<Term> rhs, IIcfgSymbolTable symbolTable, ManagedScript mgdScript, boolean lhsAreAlsoInVars) {
        if (lhs.size() != rhs.size()) {
            throw new IllegalArgumentException("different number of argument on LHS and RHS");
        }
        HashSet<IProgramVar> rhsPvs = new HashSet<IProgramVar>();
        int i = 0;
        while (i < rhs.size()) {
            Set consts = SmtUtils.extractConstants((Term)rhs.get(i), (boolean)false);
            if (!consts.isEmpty()) {
                throw new UnsupportedOperationException("constants not yet supported");
            }
            TermVarsProc tvp = TermVarsProc.computeTermVarsProc(rhs.get(i), mgdScript, symbolTable);
            rhsPvs.addAll(tvp.getVars());
            ++i;
        }
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, true, null, true, null, true);
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (IProgramVar pv : rhsPvs) {
            TermVariable freshTv = mgdScript.constructFreshTermVariable(pv.getGloballyUniqueId(), pv.getTermVariable().getSort());
            substitutionMapping.put(pv.getTermVariable(), freshTv);
            tfb.addInVar(pv, freshTv);
            tfb.addOutVar(pv, freshTv);
        }
        List rhsRenamed = rhs.stream().map(x -> Substitution.apply((ManagedScript)mgdScript, (Map)substitutionMapping, (Term)x)).collect(Collectors.toList());
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        int i2 = 0;
        while (i2 < lhs.size()) {
            IProgramVar pv = lhs.get(i2);
            TermVariable outVar = tfb.getOutVar(pv);
            if (outVar == null || !lhsAreAlsoInVars) {
                outVar = mgdScript.constructFreshTermVariable(pv.getGloballyUniqueId(), pv.getTermVariable().getSort());
                tfb.addOutVar(pv, outVar);
                if (lhsAreAlsoInVars) {
                    tfb.addInVar(pv, outVar);
                }
            }
            conjuncts.add(SmtUtils.binaryEquality((Script)mgdScript.getScript(), (Term)outVar, (Term)((Term)rhsRenamed.get(i2))));
            ++i2;
        }
        Term conjunction = SmtUtils.and((Script)mgdScript.getScript(), conjuncts);
        tfb.setFormula(conjunction);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula constructAssignment(List<? extends IProgramVar> lhs, List<? extends IProgramVar> rhs, ManagedScript mgdScript) {
        if (lhs.size() != rhs.size()) {
            throw new IllegalArgumentException("different number of argument on LHS and RHS");
        }
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, true, null, true, null, true);
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        int i = 0;
        while (i < lhs.size()) {
            IProgramVar l = lhs.get(i);
            IProgramVar r = rhs.get(i);
            TermVariable lFreshTv = mgdScript.constructFreshTermVariable(l.getGloballyUniqueId(), l.getTermVariable().getSort());
            TermVariable rFreshTv = mgdScript.constructFreshTermVariable(r.getGloballyUniqueId(), r.getTermVariable().getSort());
            tfb.addInVar(r, rFreshTv);
            if (tfb.getOutVar(r) == null) {
                tfb.addOutVar(r, rFreshTv);
            }
            tfb.addOutVar(l, lFreshTv);
            conjuncts.add(SmtUtils.binaryEquality((Script)mgdScript.getScript(), (Term)lFreshTv, (Term)rFreshTv));
            ++i;
        }
        Term conjunction = SmtUtils.and((Script)mgdScript.getScript(), conjuncts);
        tfb.setFormula(conjunction);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(mgdScript);
    }

    /*
     * WARNING - void declaration
     */
    public static UnmodifiableTransFormula constructCopy(ManagedScript script, TransFormula tf, Collection<IProgramVar> inVarsToRemove, Collection<IProgramVar> outVarsToRemove, Map<IProgramVar, TermVariable> additionalOutVars) {
        void var8_16;
        boolean modified;
        TermVariable outVar;
        TermVariable inVar;
        Set<Object> branchEncoders = tf instanceof UnmodifiableTransFormula ? ((UnmodifiableTransFormula)tf).getBranchEncoders() : ImmutableSet.empty();
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getOutVars(), tf.getNonTheoryConsts().isEmpty(), tf.getNonTheoryConsts().isEmpty() ? null : tf.getNonTheoryConsts(), branchEncoders.isEmpty(), (Collection<TermVariable>)(branchEncoders.isEmpty() ? null : branchEncoders), false);
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>(tf.getAuxVars());
        for (IProgramVar iProgramVar : inVarsToRemove) {
            assert (tfb.mInVars.containsKey(iProgramVar)) : "illegal to remove variable not that is contained";
            inVar = tfb.mInVars.get(iProgramVar);
            outVar = tfb.mOutVars.get(iProgramVar);
            tfb.mInVars.remove(iProgramVar);
            if (inVar == outVar) continue;
            modified = auxVars.add(inVar);
            assert (modified) : "similar var already there";
        }
        for (IProgramVar iProgramVar : outVarsToRemove) {
            assert (tfb.mOutVars.containsKey(iProgramVar)) : "illegal to remove variable not that is contained";
            inVar = tfb.mInVars.get(iProgramVar);
            outVar = tfb.mOutVars.get(iProgramVar);
            tfb.mOutVars.remove(iProgramVar);
            if (inVar == outVar) continue;
            modified = auxVars.add(outVar);
            assert (modified) : "similar var already there";
        }
        for (Map.Entry entry : additionalOutVars.entrySet()) {
            TermVariable oldValue = tfb.mOutVars.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
            if (oldValue == null) continue;
            throw new IllegalArgumentException("Will not add outvar for " + entry.getKey() + " it already  has an outVar");
        }
        if (tf instanceof UnmodifiableTransFormula) {
            UnmodifiableTransFormula.Infeasibility infeasibility = ((UnmodifiableTransFormula)tf).isInfeasible();
        } else {
            UnmodifiableTransFormula.Infeasibility infeasibility = UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        }
        tfb.setFormula(tf.getFormula());
        tfb.setInfeasibility((UnmodifiableTransFormula.Infeasibility)var8_16);
        if (!auxVars.isEmpty()) {
            tfb.addAuxVarsButRenameToFreshCopies(auxVars, script);
        }
        return tfb.finishConstruction(script);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends IProgramVar> UnmodifiableTransFormula constructCopy(ManagedScript script, TransFormula tf, Map<E, E> variableReplacement) {
        void var8_12;
        Set<Object> branchEncoders = tf instanceof UnmodifiableTransFormula ? ((UnmodifiableTransFormula)tf).getBranchEncoders() : ImmutableSet.empty();
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>(tf.getAuxVars());
        HashMap<Term, TermVariable> substitutionMapping = new HashMap<Term, TermVariable>();
        HashMap<IProgramVar, TermVariable> newInVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
            IProgramVar replacement = (IProgramVar)variableReplacement.get(entry.getKey());
            if (replacement != null) {
                TermVariable inVar = script.constructFreshCopy(replacement.getTermVariable());
                substitutionMapping.put((Term)tf.getInVars().get(entry.getKey()), inVar);
                newInVars.put(replacement, inVar);
                continue;
            }
            newInVars.put(entry.getKey(), entry.getValue());
        }
        HashMap<IProgramVar, TermVariable> newOutVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            IProgramVar replacement = (IProgramVar)variableReplacement.get(entry.getKey());
            if (replacement != null) {
                TermVariable outVar;
                if (((TermVariable)entry.getValue()).equals(tf.getInVars().get(entry.getKey()))) {
                    outVar = (TermVariable)newInVars.get(replacement);
                } else {
                    outVar = script.constructFreshCopy(replacement.getTermVariable());
                    substitutionMapping.put((Term)tf.getOutVars().get(entry.getKey()), outVar);
                }
                newOutVars.put(replacement, outVar);
                continue;
            }
            newOutVars.put((IProgramVar)entry.getKey(), (TermVariable)entry.getValue());
        }
        if (tf instanceof UnmodifiableTransFormula) {
            UnmodifiableTransFormula.Infeasibility infeasibility = ((UnmodifiableTransFormula)tf).isInfeasible();
        } else {
            UnmodifiableTransFormula.Infeasibility infeasibility = UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        }
        Term newFormula = Substitution.apply((ManagedScript)script, substitutionMapping, (Term)tf.getFormula());
        TransFormulaBuilder tfb = new TransFormulaBuilder(newInVars, newOutVars, tf.getNonTheoryConsts().isEmpty(), tf.getNonTheoryConsts().isEmpty() ? null : tf.getNonTheoryConsts(), branchEncoders.isEmpty(), (Collection<TermVariable>)(branchEncoders.isEmpty() ? null : branchEncoders), false);
        tfb.setFormula(newFormula);
        tfb.setInfeasibility((UnmodifiableTransFormula.Infeasibility)var8_12);
        if (!auxVars.isEmpty()) {
            tfb.addAuxVarsButRenameToFreshCopies(auxVars, script);
        }
        return tfb.finishConstruction(script);
    }

    public static UnmodifiableTransFormula transferTransformula(TransferrerWithVariableCache tt, ManagedScript script, TransFormula tf, boolean constructFreshVariables) {
        Object branchEncoders;
        if (tf instanceof UnmodifiableTransFormula) {
            Set<TermVariable> oldBranchEncoders = ((UnmodifiableTransFormula)tf).getBranchEncoders();
            branchEncoders = oldBranchEncoders.stream().map(tt::transferTerm).collect(Collectors.toSet());
        } else {
            branchEncoders = ImmutableSet.empty();
        }
        HashMap<IProgramVar, TermVariable> newInVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
            TermVariable newTv;
            IProgramVar newPv = tt.transferProgramVar(entry.getKey());
            if (constructFreshVariables) {
                newTv = script.constructFreshTermVariable(newPv.getGloballyUniqueId(), newPv.getSort());
                tt.getTransferrer().getTransferMapping().put((Term)entry.getValue(), newTv);
            } else {
                newTv = tt.transferTerm(entry.getValue());
            }
            newInVars.put(newPv, newTv);
        }
        HashMap<IProgramVar, TermVariable> newOutVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry entry : tf.getOutVars().entrySet()) {
            TermVariable newTv;
            IProgramVar newPv = tt.transferProgramVar((IProgramVar)entry.getKey());
            if (entry.getValue() == tf.getInVars().get(entry.getKey())) {
                newTv = (TermVariable)newInVars.get(newPv);
            } else if (constructFreshVariables) {
                newTv = script.constructFreshTermVariable(newPv.getGloballyUniqueId(), newPv.getSort());
                tt.getTransferrer().getTransferMapping().put((Term)entry.getValue(), newTv);
            } else {
                newTv = tt.transferTerm((TermVariable)entry.getValue());
            }
            newOutVars.put(newPv, newTv);
        }
        HashSet<TermVariable> hashSet = new HashSet<TermVariable>();
        for (TermVariable auxVar : tf.getAuxVars()) {
            TermVariable newAuxVar = script.constructFreshTermVariable("auxVar", tt.getTransferrer().transferSort(auxVar.getSort()));
            tt.getTransferrer().getTransferMapping().put(auxVar, newAuxVar);
            hashSet.add(newAuxVar);
        }
        UnmodifiableTransFormula.Infeasibility infeasibility = tf instanceof UnmodifiableTransFormula ? ((UnmodifiableTransFormula)tf).isInfeasible() : UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        Term newFormula = tt.transferTerm(tf.getFormula());
        Set<IProgramConst> nonTheoryConsts = tf.getNonTheoryConsts().stream().map(tt::transferProgramConst).collect(Collectors.toSet());
        TransFormulaBuilder tfb = new TransFormulaBuilder(newInVars, newOutVars, nonTheoryConsts.isEmpty(), nonTheoryConsts.isEmpty() ? null : nonTheoryConsts, branchEncoders.isEmpty(), (Collection<TermVariable>)(branchEncoders.isEmpty() ? null : branchEncoders), false);
        for (TermVariable newAuxVar : hashSet) {
            tfb.addAuxVar(newAuxVar);
        }
        tfb.setFormula(newFormula);
        tfb.setInfeasibility(infeasibility);
        return tfb.finishConstruction(script);
    }
}

