/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TransFormulaUnification {
    private final ManagedScript mMgdScript;
    private final UnmodifiableTransFormula[] mTransFormulas;
    private final Term[] mUnifiedFormulas;
    private final Map<IProgramVar, TermVariable> mInVars = new HashMap<IProgramVar, TermVariable>();
    private final Map<IProgramVar, TermVariable> mOutVars = new HashMap<IProgramVar, TermVariable>();
    private final Set<IProgramVar> mAssignedVars = new HashSet<IProgramVar>();
    private final List<Map<Term, Term>> mSubstitutions = new ArrayList<Map<Term, Term>>();
    private final Set<TermVariable> mAuxVars = new HashSet<TermVariable>();
    private final Set<IProgramConst> mNonTheoryConsts = new HashSet<IProgramConst>();

    public TransFormulaUnification(ManagedScript mgdScript, UnmodifiableTransFormula ... transFormulas) {
        this.mMgdScript = mgdScript;
        this.mTransFormulas = transFormulas;
        this.mUnifiedFormulas = new Term[transFormulas.length];
        this.computeJointInOutVars();
        this.collectNonTheoryConsts();
        this.computeSubstitutions();
        this.computeUnifiedFormulas();
    }

    public Map<IProgramVar, TermVariable> getInVars() {
        return this.mInVars;
    }

    public Map<IProgramVar, TermVariable> getOutVars() {
        return this.mOutVars;
    }

    public Set<TermVariable> getAuxVars() {
        return this.mAuxVars;
    }

    public Set<IProgramConst> getNonTheoryConsts() {
        return this.mNonTheoryConsts;
    }

    public Term getUnifiedFormula(int i) {
        return this.mUnifiedFormulas[i];
    }

    public Term getUnifiedFormula(UnmodifiableTransFormula tf) {
        return this.getUnifiedFormula(Arrays.asList(this.mTransFormulas).indexOf(tf));
    }

    private void computeJointInOutVars() {
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula tf = unmodifiableTransFormulaArray[n2];
            for (IProgramVar iProgramVar : tf.getInVars().keySet()) {
                if (this.mInVars.containsKey(iProgramVar)) continue;
                this.addFreshTermVariable(this.mInVars, iProgramVar, "In");
            }
            for (Map.Entry entry : tf.getOutVars().entrySet()) {
                boolean isAssignedVar;
                IProgramVar pv = (IProgramVar)entry.getKey();
                if (!this.mInVars.containsKey(pv) && !this.assignedInAll(pv)) {
                    this.addFreshTermVariable(this.mInVars, pv, "In");
                }
                boolean bl = isAssignedVar = entry.getValue() != tf.getInVars().get(pv);
                if (isAssignedVar) {
                    this.mAssignedVars.add(pv);
                }
                this.mOutVars.put(pv, this.mInVars.get(pv));
            }
            ++n2;
        }
        for (IProgramVar pv : this.mAssignedVars) {
            this.addFreshTermVariable(this.mOutVars, pv, "Out");
        }
    }

    private void collectNonTheoryConsts() {
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula tf = unmodifiableTransFormulaArray[n2];
            this.mNonTheoryConsts.addAll(tf.getNonTheoryConsts());
            ++n2;
        }
    }

    private void addFreshTermVariable(Map<IProgramVar, TermVariable> varMap, IProgramVar variable, String suffix) {
        String baseName = String.valueOf(variable.getGloballyUniqueId()) + "_" + suffix;
        TermVariable termVar = this.mMgdScript.constructFreshTermVariable(baseName, variable.getSort());
        varMap.put(variable, termVar);
    }

    private void computeSubstitutions() {
        this.computeJointInOutVars();
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula tf = unmodifiableTransFormulaArray[n2];
            this.mSubstitutions.add(this.computeSubstitution(tf));
            ++n2;
        }
    }

    private Map<Term, Term> computeSubstitution(UnmodifiableTransFormula tf) {
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
            substitutionMapping.put((Term)entry.getValue(), (Term)this.mInVars.get(entry.getKey()));
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getOutVars().entrySet()) {
            boolean isAssignedVar;
            IProgramVar pv = entry.getKey();
            TermVariable outVar = entry.getValue();
            boolean bl = isAssignedVar = tf.getInVars().get(pv) != outVar;
            if (isAssignedVar) {
                substitutionMapping.put((Term)outVar, (Term)this.mOutVars.get(pv));
                continue;
            }
            assert (substitutionMapping.get(outVar) == this.mInVars.get(pv));
        }
        for (TermVariable oldAuxVar : tf.getAuxVars()) {
            TermVariable newAuxVar = this.mMgdScript.constructFreshCopy(oldAuxVar);
            substitutionMapping.put((Term)oldAuxVar, (Term)newAuxVar);
            this.mAuxVars.add(newAuxVar);
        }
        return substitutionMapping;
    }

    private void computeUnifiedFormulas() {
        int i = 0;
        while (i < this.mTransFormulas.length) {
            this.mUnifiedFormulas[i] = this.computeUnifiedFormula(this.mTransFormulas[i], this.mSubstitutions.get(i));
            ++i;
        }
    }

    private Term computeUnifiedFormula(UnmodifiableTransFormula tf, Map<Term, Term> substitution) {
        Term renamedFormula = Substitution.apply((ManagedScript)this.mMgdScript, substitution, (Term)tf.getFormula());
        Term equalities = this.generateExplicitEqualities(tf);
        return SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{renamedFormula, equalities});
    }

    private Term generateExplicitEqualities(UnmodifiableTransFormula tf) {
        ArrayList<Term> equalities = new ArrayList<Term>();
        for (IProgramVar pv : this.mAssignedVars) {
            TermVariable inVar = tf.getInVars().get(pv);
            TermVariable outVar = tf.getOutVars().get(pv);
            if ((inVar != null || outVar != null) && inVar != outVar) continue;
            TermVariable termInVar = this.mInVars.get(pv);
            assert (termInVar != null);
            TermVariable termOutVar = this.mOutVars.get(pv);
            assert (termOutVar != null);
            equalities.add(SmtUtils.binaryEquality((Script)this.mMgdScript.getScript(), (Term)termInVar, (Term)termOutVar));
        }
        return SmtUtils.and((Script)this.mMgdScript.getScript(), equalities);
    }

    private boolean assignedInAll(IProgramVar bv) {
        UnmodifiableTransFormula[] unmodifiableTransFormulaArray = this.mTransFormulas;
        int n = this.mTransFormulas.length;
        int n2 = 0;
        while (n2 < n) {
            UnmodifiableTransFormula tf = unmodifiableTransFormulaArray[n2];
            if (!tf.getAssignedVars().contains(bv)) {
                return false;
            }
            ++n2;
        }
        return true;
    }
}

