/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.RunningTaskInfo;
import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUnification;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.SMTPrettyPrinter;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.DagSizePrinter;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayStore;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.XnfDer;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.LetTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Triple;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TransFormulaUtils {
    public static final String TRANS_FORMULA_OF_RETURN_MUST_NOT_CONTAIN_AUX_VARS = "TransFormula of return must not contain auxVars";
    public static final String OLD_VAR_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS = "oldVarAssignments must not contain auxVars";
    public static final String GLOBAL_VARS_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS = "globalVarsAssignments must not contain auxVars";

    private TransFormulaUtils() {
    }

    public static Set<IProgramVar> computeAssignedVars(Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        HashSet<IProgramVar> assignedVars = new HashSet<IProgramVar>();
        for (Map.Entry<IProgramVar, TermVariable> entry : outVars.entrySet()) {
            assert (entry.getValue() != null);
            if (entry.getValue() == inVars.get(entry.getKey())) continue;
            assignedVars.add(entry.getKey());
        }
        for (IProgramVar pv : inVars.keySet()) {
            if (outVars.containsKey(pv)) continue;
            assignedVars.add(pv);
        }
        return assignedVars;
    }

    public static UnmodifiableTransFormula sequentialComposition(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, boolean simplify, boolean tryAuxVarElimination, boolean tranformToCNF, SmtUtils.XnfConversionTechnique xnfConversionTechnique, SmtUtils.SimplificationTechnique simplificationTechnique, List<UnmodifiableTransFormula> transFormula) {
        if (logger.isDebugEnabled()) {
            logger.debug("sequential composition with%s formula simplification", new Object[]{simplify ? "" : "out"});
        }
        Script script = mgdScript.getScript();
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>();
        Term formula = mgdScript.getScript().term("true", new Term[0]);
        TransFormulaBuilder tfb = new TransFormulaBuilder(null, null, false, null, false, null, false);
        HashSet<IProgramConst> nonTheoryConsts = new HashSet<IProgramConst>();
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        int i = transFormula.size() - 1;
        while (i >= 0) {
            UnmodifiableTransFormula currentTf = transFormula.get(i);
            for (Map.Entry<IProgramVar, TermVariable> entry : currentTf.getOutVars().entrySet()) {
                TermVariable inVar;
                IProgramVar var = entry.getKey();
                TermVariable outVar = entry.getValue();
                TermVariable newOutVar = tfb.containsInVar(var) ? tfb.getInVar(var) : mgdScript.constructFreshTermVariable(var.getGloballyUniqueId(), var.getTermVariable().getSort());
                substitutionMapping.put(outVar, newOutVar);
                if (!tfb.containsOutVar(var)) {
                    tfb.addOutVar(var, newOutVar);
                }
                if ((inVar = currentTf.getInVars().get(var)) == null) {
                    if (tfb.getOutVar(var) != newOutVar) {
                        auxVars.add(newOutVar);
                    }
                    tfb.removeInVar(var);
                    continue;
                }
                if (inVar == outVar) {
                    tfb.addInVar(var, newOutVar);
                    continue;
                }
                TermVariable newInVar = mgdScript.constructFreshTermVariable(var.getGloballyUniqueId(), var.getTermVariable().getSort());
                substitutionMapping.put(inVar, newInVar);
                tfb.addInVar(var, newInVar);
                if (tfb.getOutVar(var) == newOutVar) continue;
                auxVars.add(newOutVar);
            }
            Map oldAuxVar2newAuxVar = mgdScript.constructFreshCopies(currentTf.getAuxVars());
            substitutionMapping.putAll(oldAuxVar2newAuxVar);
            auxVars.addAll(oldAuxVar2newAuxVar.values());
            tfb.addBranchEncoders(currentTf.getBranchEncoders());
            for (Map.Entry entry : currentTf.getInVars().entrySet()) {
                IProgramVar var = (IProgramVar)entry.getKey();
                if (currentTf.getOutVars().containsKey(var)) continue;
                TermVariable inVar = (TermVariable)entry.getValue();
                if (!tfb.containsOutVar(var)) {
                    TermVariable newOutVar = tfb.containsInVar(var) ? tfb.getInVar(var) : mgdScript.constructFreshTermVariable(var.getGloballyUniqueId(), var.getTermVariable().getSort());
                    tfb.addOutVar(var, newOutVar);
                } else if (tfb.containsInVar(var) && tfb.getOutVar(var) != tfb.getInVar(var)) {
                    tfb.addAuxVar(tfb.getInVar(var));
                }
                TermVariable newInVar = mgdScript.constructFreshTermVariable(var.getGloballyUniqueId(), var.getTermVariable().getSort());
                tfb.addInVar(var, newInVar);
                substitutionMapping.put(inVar, newInVar);
            }
            Term term = currentTf.getFormula();
            Term updatedFormula = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term);
            nonTheoryConsts.addAll(currentTf.getNonTheoryConsts());
            formula = SmtUtils.and((Script)script, (Term[])new Term[]{formula, updatedFormula});
            --i;
        }
        assert (!new SubtermPropertyChecker(LetTerm.class::isInstance).isSatisfiedBySomeSubterm(formula)) : "formula contains LetTerm";
        if (simplify) {
            try {
                formula = SmtUtils.simplify((ManagedScript)mgdScript, (Term)formula, (IUltimateServiceProvider)services, (SmtUtils.SimplificationTechnique)simplificationTechnique);
            }
            catch (ToolchainCanceledException tce) {
                String taskDescription = "doing sequential composition of " + transFormula.size() + " TransFormulas";
                tce.addRunningTaskInfo(new RunningTaskInfo(TransFormulaUtils.class, taskDescription));
                throw tce;
            }
        }
        if (tryAuxVarElimination) {
            Term eliminated = TransFormulaUtils.tryAuxVarElimination(services, mgdScript, simplificationTechnique, formula, auxVars);
            if (logger.isDebugEnabled()) {
                logger.debug("DAG size before PQE %s, DAG size after PQE %s", new Object[]{new DagSizePrinter(formula), new DagSizePrinter(eliminated)});
            }
            formula = eliminated;
        } else {
            XnfDer xnfDer = new XnfDer(mgdScript, services);
            formula = SmtUtils.and((Script)script, (Term[])xnfDer.tryToEliminate(0, SmtUtils.getConjuncts((Term)formula), auxVars));
        }
        if (simplify) {
            formula = SmtUtils.simplify((ManagedScript)mgdScript, (Term)formula, (IUltimateServiceProvider)services, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        }
        UnmodifiableTransFormula.Infeasibility infeasibility = formula == script.term("false", new Term[0]) ? UnmodifiableTransFormula.Infeasibility.INFEASIBLE : UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED;
        if (tranformToCNF) {
            Term cnf;
            formula = cnf = SmtUtils.toCnf((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (Term)formula, (SmtUtils.XnfConversionTechnique)xnfConversionTechnique);
        }
        TransFormulaUtils.addConstantsIfInFormula(tfb, formula, nonTheoryConsts);
        tfb.setFormula(formula);
        tfb.setInfeasibility(infeasibility);
        for (TermVariable auxVar : auxVars) {
            tfb.addAuxVar(auxVar);
        }
        tfb.ensureInternalNormalForm();
        return tfb.finishConstruction(mgdScript);
    }

    public static Term tryAuxVarElimination(IUltimateServiceProvider services, ManagedScript mgdScript, SmtUtils.SimplificationTechnique simplificationTechnique, Term formula, Set<TermVariable> auxVars) {
        Term quantified = SmtUtils.quantifier((Script)mgdScript.getScript(), (int)0, auxVars, (Term)formula);
        auxVars.clear();
        Term partiallyEliminated = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (Term)quantified, (SmtUtils.SimplificationTechnique)simplificationTechnique);
        Term pnf = new PrenexNormalForm(mgdScript).transform(partiallyEliminated);
        if (pnf instanceof QuantifiedFormula && ((QuantifiedFormula)pnf).getQuantifier() == 0) {
            QuantifiedFormula qf = (QuantifiedFormula)pnf;
            auxVars.addAll(Arrays.asList(qf.getVariables()));
            return qf.getSubformula();
        }
        return pnf;
    }

    public static UnmodifiableTransFormula parallelComposition(ILogger logger, IUltimateServiceProvider services, ManagedScript mgdScript, TermVariable[] branchIndicators, boolean tranformToCNF, SmtUtils.XnfConversionTechnique xnfConversionTechnique, boolean isInternal, UnmodifiableTransFormula ... transFormulas) {
        Term resultFormula;
        boolean useBranchEncoders;
        logger.debug((Object)"parallel composition");
        boolean bl = useBranchEncoders = branchIndicators != null;
        if (useBranchEncoders && branchIndicators.length != transFormulas.length) {
            throw new IllegalArgumentException();
        }
        TransFormulaUnification unification = new TransFormulaUnification(mgdScript, transFormulas);
        Set<IProgramConst> consts = unification.getNonTheoryConsts();
        TransFormulaBuilder tfb = useBranchEncoders ? new TransFormulaBuilder(null, null, consts.isEmpty(), consts, false, Arrays.asList(branchIndicators), false) : new TransFormulaBuilder(null, null, consts.isEmpty(), consts, true, null, false);
        tfb.addInVars(unification.getInVars());
        tfb.addOutVars(unification.getOutVars());
        for (TermVariable auxVar : unification.getAuxVars()) {
            tfb.addAuxVar(auxVar);
        }
        Term[] renamedFormulas = new Term[transFormulas.length];
        int i = 0;
        while (i < transFormulas.length) {
            UnmodifiableTransFormula currentTf = transFormulas[i];
            Term unifiedFormula = unification.getUnifiedFormula(i);
            if (useBranchEncoders) {
                tfb.addBranchEncoders(currentTf.getBranchEncoders());
                renamedFormulas[i] = Util.implies((Script)mgdScript.getScript(), (Term[])new Term[]{branchIndicators[i], unifiedFormula});
            } else {
                renamedFormulas[i] = unifiedFormula;
            }
            ++i;
        }
        if (useBranchEncoders) {
            resultFormula = SmtUtils.and((Script)mgdScript.getScript(), (Term[])renamedFormulas);
            Term atLeastOneBranchTaken = SmtUtils.or((Script)mgdScript.getScript(), (Term[])branchIndicators);
            resultFormula = SmtUtils.and((Script)mgdScript.getScript(), (Term[])new Term[]{resultFormula, atLeastOneBranchTaken});
        } else {
            resultFormula = SmtUtils.or((Script)mgdScript.getScript(), (Term[])renamedFormulas);
        }
        if (tranformToCNF) {
            resultFormula = SmtUtils.toCnf((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (Term)resultFormula, (SmtUtils.XnfConversionTechnique)xnfConversionTechnique);
        }
        Set nonTheoryConsts = Arrays.stream(transFormulas).flatMap(tf -> tf.getNonTheoryConsts().stream()).collect(Collectors.toSet());
        TransFormulaUtils.addConstantsIfInFormula(tfb, resultFormula, nonTheoryConsts);
        tfb.setFormula(resultFormula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        if (isInternal) {
            tfb.ensureInternalNormalForm();
        }
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula sequentialCompositionWithPendingCall(ManagedScript mgdScript, boolean simplify, boolean extPqe, boolean transformToCNF, List<UnmodifiableTransFormula> beforeCall, UnmodifiableTransFormula callTf, UnmodifiableTransFormula oldVarsAssignment, UnmodifiableTransFormula globalVarsAssignment, UnmodifiableTransFormula afterCall, ILogger logger, IUltimateServiceProvider services, Set<IProgramNonOldVar> modifiableGlobalsOfEndProcedure, SmtUtils.XnfConversionTechnique xnfConversionTechnique, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable symbolTable, String procAtStart, String procBeforeCall, String procAfterCall, String procAtEnd, ModifiableGlobalsTable modifiableGlobalsTable) {
        UnmodifiableTransFormula result;
        assert (procAtStart != null) : "proc at start must not be null";
        if (!procAtStart.equals(procBeforeCall)) {
            throw new UnsupportedOperationException("proc change before call");
        }
        logger.debug((Object)("sequential composition (pending call) with" + (simplify ? "" : "out") + " formula simplification"));
        ArrayList<UnmodifiableTransFormula> callAndBefore = new ArrayList<UnmodifiableTransFormula>(beforeCall);
        callAndBefore.add(callTf);
        callAndBefore.add(oldVarsAssignment);
        UnmodifiableTransFormula composition = TransFormulaUtils.sequentialComposition(logger, services, mgdScript, simplify, extPqe, transformToCNF, xnfConversionTechnique, simplificationTechnique, callAndBefore);
        ArrayList<IProgramVar> outVarsToRemove = new ArrayList<IProgramVar>();
        for (IProgramVar bv : composition.getOutVars().keySet()) {
            boolean isInterfaceVariable = TransFormulaUtils.isInterfaceVariable(bv, callTf, oldVarsAssignment, procBeforeCall, procAfterCall, true, false);
            if (isInterfaceVariable) continue;
            outVarsToRemove.add(bv);
        }
        HashMap<IProgramVar, TermVariable> varsToHavoc = new HashMap<IProgramVar, TermVariable>();
        Set<IProgramNonOldVar> modifiableByCaller = modifiableGlobalsTable.getModifiedBoogieVars(procBeforeCall);
        for (IProgramNonOldVar modifiable : modifiableByCaller) {
            IProgramOldVar oldVar = modifiable.getOldVar();
            boolean modifiableByCallee = oldVarsAssignment.getAssignedVars().contains(oldVar);
            if (modifiableByCallee) continue;
            varsToHavoc.put(oldVar, mgdScript.constructFreshCopy(oldVar.getTermVariable()));
        }
        Set<ILocalProgramVar> locals = symbolTable.getLocals(procBeforeCall);
        for (ILocalProgramVar localVar : locals) {
            boolean isInParamOfCallee = callTf.getAssignedVars().contains(localVar);
            if (isInParamOfCallee) continue;
            varsToHavoc.put(localVar, mgdScript.constructFreshCopy(localVar.getTermVariable()));
        }
        UnmodifiableTransFormula callAndBeforeTF = TransFormulaBuilder.constructCopy(mgdScript, composition, Collections.emptySet(), outVarsToRemove, varsToHavoc);
        ArrayList<UnmodifiableTransFormula> oldAssignAndAfterList = new ArrayList<UnmodifiableTransFormula>(Arrays.asList(afterCall));
        oldAssignAndAfterList.add(0, globalVarsAssignment);
        UnmodifiableTransFormula composition2 = TransFormulaUtils.sequentialComposition(logger, services, mgdScript, simplify, extPqe, transformToCNF, xnfConversionTechnique, simplificationTechnique, oldAssignAndAfterList);
        ArrayList<IProgramVar> inVarsToRemove = new ArrayList<IProgramVar>();
        for (IProgramVar bv : composition2.getInVars().keySet()) {
            boolean isInterfaceVariable = TransFormulaUtils.isInterfaceVariable(bv, callTf, oldVarsAssignment, procBeforeCall, procAfterCall, false, true);
            if (isInterfaceVariable) continue;
            inVarsToRemove.add(bv);
        }
        UnmodifiableTransFormula globalVarAssignAndAfterTF = TransFormulaBuilder.constructCopy(mgdScript, composition2, inVarsToRemove, Collections.emptySet(), Collections.emptyMap());
        UnmodifiableTransFormula preliminaryResult = TransFormulaUtils.sequentialComposition(logger, services, mgdScript, simplify, extPqe, transformToCNF, xnfConversionTechnique, simplificationTechnique, Arrays.asList(callAndBeforeTF, globalVarAssignAndAfterTF));
        if (procAfterCall.equals(procAtEnd)) {
            result = preliminaryResult;
        } else {
            ArrayList<IProgramVar> outVarsToRemove2 = new ArrayList<IProgramVar>();
            for (IProgramVar pv : preliminaryResult.getOutVars().keySet()) {
                if (!callTf.getAssignedVars().contains(pv)) continue;
                outVarsToRemove2.add(pv);
            }
            result = outVarsToRemove2.isEmpty() ? preliminaryResult : TransFormulaBuilder.constructCopy(mgdScript, preliminaryResult, Collections.emptySet(), outVarsToRemove2, Collections.emptyMap());
        }
        assert (!result.getBranchEncoders().isEmpty() || TransFormulaUtils.predicateBasedResultCheck(services, mgdScript, beforeCall, callTf, oldVarsAssignment, globalVarsAssignment, afterCall, result, symbolTable, modifiableGlobalsOfEndProcedure)) : "sequentialCompositionWithPendingCall - incorrect result";
        return result;
    }

    private static boolean isInterfaceVariable(IProgramVar bv, UnmodifiableTransFormula callTf, UnmodifiableTransFormula oldVarsAssignment, String procBeforeCall, String procAfterCall, boolean tolerateLocalVarsOfCaller, boolean tolerateLocalVarsOfCallee) {
        boolean isInterfaceVariable;
        if (bv.isGlobal()) {
            if (bv.isOldvar()) {
                if (!oldVarsAssignment.getOutVars().containsKey(bv)) {
                    throw new AssertionError((Object)"oldvars not yet implemented");
                }
                isInterfaceVariable = true;
            } else {
                isInterfaceVariable = !oldVarsAssignment.getInVars().containsKey(bv);
            }
        } else if (bv.getProcedure().equals(procAfterCall)) {
            if (callTf.getAssignedVars().contains(bv)) {
                isInterfaceVariable = true;
            } else {
                if (!(tolerateLocalVarsOfCallee || procBeforeCall.equals(procAfterCall) && tolerateLocalVarsOfCaller)) {
                    throw new AssertionError((Object)("local var of callee is no inparam " + bv));
                }
                isInterfaceVariable = false;
            }
        } else if (bv.getProcedure().equals(procBeforeCall)) {
            if (!tolerateLocalVarsOfCaller) {
                throw new AssertionError((Object)("local var of caller " + bv));
            }
            isInterfaceVariable = false;
        } else {
            throw new AssertionError((Object)("local var neither from caller nor callee " + bv));
        }
        return isInterfaceVariable;
    }

    private static boolean predicateBasedResultCheck(IUltimateServiceProvider services, ManagedScript mgdScript, List<UnmodifiableTransFormula> beforeCall, UnmodifiableTransFormula callTf, UnmodifiableTransFormula oldVarsAssignment, UnmodifiableTransFormula globalVarsAssignment, UnmodifiableTransFormula afterCallTf, UnmodifiableTransFormula result, IIcfgSymbolTable symbolTable, Set<IProgramNonOldVar> modifiableGlobalsOfEndProcedure) {
        assert (result.getBranchEncoders().isEmpty()) : "result check not applicable with branch encoders";
        PredicateTransformer<Term, IPredicate, TransFormula> pt = new PredicateTransformer<Term, IPredicate, TransFormula>(mgdScript, new TermDomainOperationProvider(services, mgdScript));
        BasicPredicateFactory bpf = new BasicPredicateFactory(services, mgdScript, symbolTable);
        BasicPredicate truePredicate = bpf.newPredicate(mgdScript.getScript().term("true", new Term[0]));
        Term resultComposition = pt.strongestPostcondition(truePredicate, result);
        resultComposition = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)resultComposition);
        BasicPredicate resultCompositionPredicate = bpf.newPredicate(resultComposition);
        BasicPredicate beforeCallPredicate = truePredicate;
        for (UnmodifiableTransFormula tf : beforeCall) {
            Term tmp = pt.strongestPostcondition(beforeCallPredicate, tf);
            beforeCallPredicate = bpf.newPredicate(tmp);
        }
        Term afterCallTerm = pt.strongestPostconditionCall(beforeCallPredicate, callTf, globalVarsAssignment, oldVarsAssignment, modifiableGlobalsOfEndProcedure);
        BasicPredicate afterCallPredicate = bpf.newPredicate(afterCallTerm);
        Term endTerm = pt.strongestPostcondition(afterCallPredicate, afterCallTf);
        endTerm = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)endTerm);
        BasicPredicate endPredicate = bpf.newPredicate(endTerm);
        MonolithicImplicationChecker mic = new MonolithicImplicationChecker(services, mgdScript);
        IncrementalPlicationChecker.Validity check1 = mic.checkImplication(endPredicate, false, resultCompositionPredicate, false);
        IncrementalPlicationChecker.Validity check2 = mic.checkImplication(resultCompositionPredicate, false, endPredicate, false);
        assert (check1 != IncrementalPlicationChecker.Validity.INVALID && check2 != IncrementalPlicationChecker.Validity.INVALID) : "sequentialCompositionWithPendingCall - incorrect result";
        return check1 != IncrementalPlicationChecker.Validity.INVALID && check2 != IncrementalPlicationChecker.Validity.INVALID;
    }

    public static UnmodifiableTransFormula sequentialCompositionWithCallAndReturn(ManagedScript mgdScript, boolean simplify, boolean extPqe, boolean transformToCNF, UnmodifiableTransFormula callTf, UnmodifiableTransFormula oldVarsAssignment, UnmodifiableTransFormula globalVarsAssignment, UnmodifiableTransFormula procedureTf, UnmodifiableTransFormula returnTf, ILogger logger, IUltimateServiceProvider services, SmtUtils.XnfConversionTechnique xnfConversionTechnique, SmtUtils.SimplificationTechnique simplificationTechnique, IIcfgSymbolTable symbolTable, Set<IProgramNonOldVar> modifiableGlobalsOfCallee) {
        if (!returnTf.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)TRANS_FORMULA_OF_RETURN_MUST_NOT_CONTAIN_AUX_VARS);
        }
        if (!oldVarsAssignment.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)OLD_VAR_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS);
        }
        if (!globalVarsAssignment.getAuxVars().isEmpty()) {
            throw new AssertionError((Object)GLOBAL_VARS_ASSIGNMENTS_MUST_NOT_CONTAIN_AUX_VARS);
        }
        logger.debug((Object)("sequential composition (call/return) with" + (simplify ? "" : "out") + " formula simplification"));
        UnmodifiableTransFormula composition = TransFormulaUtils.sequentialComposition(logger, services, mgdScript, simplify, extPqe, transformToCNF, xnfConversionTechnique, simplificationTechnique, Arrays.asList(callTf, oldVarsAssignment, globalVarsAssignment, procedureTf, returnTf));
        ArrayList<IProgramVar> inVarsToRemove = new ArrayList<IProgramVar>();
        for (IProgramVar bv : composition.getInVars().keySet()) {
            if (bv.isGlobal()) {
                boolean occursInArguments;
                boolean isModifiableByCallee;
                if (!bv.isOldvar() || !(isModifiableByCallee = oldVarsAssignment.getAssignedVars().contains(bv)) || (occursInArguments = callTf.getInVars().containsKey(bv))) continue;
                inVarsToRemove.add(bv);
                continue;
            }
            boolean occursInArguments = callTf.getInVars().containsKey(bv);
            if (occursInArguments) continue;
            inVarsToRemove.add(bv);
        }
        ArrayList<IProgramVar> outVarsToRemove = new ArrayList<IProgramVar>();
        for (IProgramVar bv : composition.getOutVars().keySet()) {
            if (bv.isGlobal()) {
                boolean isModifiableByCallee;
                if (!bv.isOldvar() || !(isModifiableByCallee = oldVarsAssignment.getAssignedVars().contains(bv))) continue;
                outVarsToRemove.add(bv);
                continue;
            }
            if (returnTf.getOutVars().containsKey(bv)) continue;
            outVarsToRemove.add(bv);
        }
        HashMap<IProgramVar, TermVariable> additionalOutVars = new HashMap<IProgramVar, TermVariable>();
        for (Map.Entry<IProgramVar, TermVariable> entry : callTf.getInVars().entrySet()) {
            TermVariable inVar;
            if (composition.getOutVars().containsKey(entry.getKey()) && !outVarsToRemove.contains(entry.getKey()) || (inVar = composition.getInVars().get(entry.getKey())) == null) continue;
            additionalOutVars.put(entry.getKey(), inVar);
        }
        UnmodifiableTransFormula result = TransFormulaBuilder.constructCopy(mgdScript, composition, inVarsToRemove, outVarsToRemove, additionalOutVars);
        assert (SmtUtils.neitherKeyNorValueIsNull(result.getOutVars())) : "sequentialCompositionWithCallAndReturn introduced null entries";
        assert (TransFormulaUtils.isIntraprocedural(result));
        assert (!result.getBranchEncoders().isEmpty() || TransFormulaUtils.predicateBasedResultCheck(services, logger, mgdScript, callTf, oldVarsAssignment, globalVarsAssignment, procedureTf, returnTf, result, symbolTable, modifiableGlobalsOfCallee)) : "sequentialCompositionWithCallAndReturn - incorrect result";
        return result;
    }

    private static boolean predicateBasedResultCheck(IUltimateServiceProvider services, ILogger logger, ManagedScript mgdScript, UnmodifiableTransFormula callTf, UnmodifiableTransFormula oldVarsAssignment, UnmodifiableTransFormula globalVarsAssignment, UnmodifiableTransFormula procedureTf, UnmodifiableTransFormula returnTf, UnmodifiableTransFormula result, IIcfgSymbolTable symbolTable, Set<IProgramNonOldVar> modifiableGlobals) {
        assert (result.getBranchEncoders().isEmpty()) : "result check not applicable with branch encoders";
        PredicateTransformer<Term, IPredicate, TransFormula> pt = new PredicateTransformer<Term, IPredicate, TransFormula>(mgdScript, new TermDomainOperationProvider(services, mgdScript));
        BasicPredicateFactory bpf = new BasicPredicateFactory(services, mgdScript, symbolTable);
        BasicPredicate truePredicate = bpf.newPredicate(mgdScript.getScript().term("true", new Term[0]));
        Term resultComposition = pt.strongestPostcondition(truePredicate, result);
        resultComposition = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)resultComposition);
        BasicPredicate resultCompositionPredicate = bpf.newPredicate(resultComposition);
        Term afterCallTerm = pt.strongestPostconditionCall(truePredicate, callTf, globalVarsAssignment, oldVarsAssignment, modifiableGlobals);
        BasicPredicate afterCallPredicate = bpf.newPredicate(afterCallTerm);
        Term beforeReturnTerm = pt.strongestPostcondition(afterCallPredicate, procedureTf);
        BasicPredicate beforeReturnPredicate = bpf.newPredicate(beforeReturnTerm);
        Term afterReturnTerm = pt.strongestPostconditionReturn(beforeReturnPredicate, truePredicate, returnTf, callTf, oldVarsAssignment, modifiableGlobals);
        afterReturnTerm = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)mgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)afterReturnTerm);
        BasicPredicate afterReturnPredicate = bpf.newPredicate(afterReturnTerm);
        MonolithicImplicationChecker mic = new MonolithicImplicationChecker(services, mgdScript);
        IncrementalPlicationChecker.Validity check1 = mic.checkImplication(afterReturnPredicate, false, resultCompositionPredicate, false);
        IncrementalPlicationChecker.Validity check2 = mic.checkImplication(resultCompositionPredicate, false, afterReturnPredicate, false);
        assert (check1 != IncrementalPlicationChecker.Validity.INVALID && check2 != IncrementalPlicationChecker.Validity.INVALID) : "sequentialCompositionWithCallAndReturn - incorrect result";
        if (check1 == IncrementalPlicationChecker.Validity.UNKNOWN || check2 == IncrementalPlicationChecker.Validity.UNKNOWN) {
            logger.warn((Object)"predicate-based correctness check returned UNKNOWN, hence correctness of interprocedural sequential composition was not checked.");
        }
        return check1 != IncrementalPlicationChecker.Validity.INVALID && check2 != IncrementalPlicationChecker.Validity.INVALID;
    }

    static boolean isIntraprocedural(UnmodifiableTransFormula tf) {
        HashSet<String> procedures = new HashSet<String>();
        for (IProgramVar bv : tf.getInVars().keySet()) {
            if (bv.isGlobal()) continue;
            procedures.add(bv.getProcedure());
        }
        for (IProgramVar bv : tf.getOutVars().keySet()) {
            if (bv.isGlobal()) continue;
            procedures.add(bv.getProcedure());
        }
        return procedures.size() <= 1;
    }

    public static UnmodifiableTransFormula computeGuard(UnmodifiableTransFormula tf, ManagedScript mgdScript, IUltimateServiceProvider services) {
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>(tf.getAuxVars());
        for (IProgramVar bv : tf.getAssignedVars()) {
            TermVariable outVar = tf.getOutVars().get(bv);
            if (!Arrays.asList(tf.getFormula().getFreeVars()).contains(outVar)) continue;
            auxVars.add(outVar);
        }
        if (!tf.getBranchEncoders().isEmpty()) {
            throw new AssertionError((Object)"I think this does not make sense with branch enconders");
        }
        Term withoutAuxVars = TransFormulaUtils.quantifyAndTryToEliminateAuxVars(services, mgdScript, tf.getFormula(), auxVars);
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getInVars(), tf.getNonTheoryConsts().isEmpty(), tf.getNonTheoryConsts().isEmpty() ? null : tf.getNonTheoryConsts(), true, null, false);
        tfb.setFormula(withoutAuxVars);
        tfb.setInfeasibility(tf.isInfeasible());
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula computeGuardedHavoc(UnmodifiableTransFormula tf, ManagedScript mgdScript, IUltimateServiceProvider services, boolean cellPrecisionForArrays) {
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>(tf.getAuxVars());
        HashMap<Object, Object> substitutionMapping = new HashMap<Object, Object>();
        for (IProgramVar bv : tf.getOutVars().keySet()) {
            if (tf.getOutVars().get(bv) == tf.getInVars().get(bv)) continue;
            if (cellPrecisionForArrays && SmtSortUtils.isArraySort((Sort)bv.getTermVariable().getSort())) {
                Set stores = SmtUtils.extractApplicationTerms((String)"store", (Term)tf.getFormula(), (boolean)false);
                for (Term store : stores) {
                    ApplicationTerm appTerm = (ApplicationTerm)store;
                    Term storedValue = appTerm.getParameters()[2];
                    if (SmtSortUtils.isArraySort((Sort)storedValue.getSort())) continue;
                    TermVariable aux = mgdScript.constructFreshTermVariable("rosehip", storedValue.getSort());
                    Term array = appTerm.getParameters()[0];
                    Term index = appTerm.getParameters()[1];
                    Term newSelect = SmtUtils.store((Script)mgdScript.getScript(), (Term)array, (Term)index, (Term)aux);
                    substitutionMapping.put(appTerm, newSelect);
                    auxVars.add(aux);
                }
                continue;
            }
            TermVariable outVar = tf.getOutVars().get(bv);
            TermVariable aux = mgdScript.constructFreshCopy(outVar);
            substitutionMapping.put(outVar, aux);
            auxVars.add(aux);
        }
        if (!tf.getBranchEncoders().isEmpty()) {
            throw new AssertionError((Object)"I think this does not make sense with branch enconders");
        }
        Term term = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)tf.getFormula());
        Term withoutAuxVars = TransFormulaUtils.quantifyAndTryToEliminateAuxVars(services, mgdScript, term, auxVars);
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getOutVars(), tf.getNonTheoryConsts().isEmpty(), tf.getNonTheoryConsts().isEmpty() ? null : tf.getNonTheoryConsts(), true, null, false);
        tfb.setFormula(withoutAuxVars);
        tfb.setInfeasibility(tf.isInfeasible());
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula negate(UnmodifiableTransFormula tf, ManagedScript mgdScript, IUltimateServiceProvider services) {
        if (!tf.getBranchEncoders().isEmpty()) {
            throw new AssertionError((Object)"I think this does not make sense with branch enconders");
        }
        Term withoutAuxVars = TransFormulaUtils.quantifyAndTryToEliminateAuxVars(services, mgdScript, tf.getFormula(), tf.getAuxVars());
        Term formula = SmtUtils.not((Script)mgdScript.getScript(), (Term)withoutAuxVars);
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getOutVars(), tf.getNonTheoryConsts().isEmpty(), tf.getNonTheoryConsts().isEmpty() ? null : tf.getNonTheoryConsts(), false, tf.getBranchEncoders(), true);
        tfb.setFormula(formula);
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula intersect(ManagedScript mgdScript, UnmodifiableTransFormula ... tfs) {
        TransFormulaUnification tfu = new TransFormulaUnification(mgdScript, tfs);
        Set<IProgramConst> consts = tfu.getNonTheoryConsts();
        TransFormulaBuilder tfb = new TransFormulaBuilder(tfu.getInVars(), tfu.getOutVars(), consts.isEmpty(), consts, true, null, false);
        tfu.getAuxVars().stream().forEach(tfb::addAuxVar);
        Term[] terms = new Term[tfs.length];
        int i = 0;
        while (i < tfs.length) {
            terms[i] = tfu.getUnifiedFormula(i);
            ++i;
        }
        tfb.setFormula(SmtUtils.and((Script)mgdScript.getScript(), (Term[])terms));
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        return tfb.finishConstruction(mgdScript);
    }

    private static Term quantifyAndTryToEliminateAuxVars(IUltimateServiceProvider services, ManagedScript maScript, Term term, Set<TermVariable> auxVars) {
        Term quantifiedTerm = SmtUtils.quantifier((Script)maScript.getScript(), (int)0, auxVars, (Term)term);
        Term resultTerm = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)services, (ManagedScript)maScript, (Term)quantifiedTerm, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.POLY_PAC);
        return resultTerm;
    }

    public static <T extends IProgramConst> void addConstantsIfInFormula(TransFormulaBuilder tfb, Term formula, Set<T> progConsts) {
        Set constsInFormula = SmtUtils.extractConstants((Term)formula, (boolean)false);
        for (IProgramConst progConst : progConsts) {
            if (!constsInFormula.contains(progConst.getDefaultConstant())) continue;
            tfb.addProgramConst(progConst);
        }
    }

    public static <V, K> Map<V, K> constructReverseMapping(Map<K, V> map) {
        return map.entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, Map.Entry::getKey));
    }

    public static Map<TermVariable, TermVariable> constructInvarsToDefaultvarsMap(TransFormula tf) {
        return tf.getInVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, x -> ((IProgramVar)x.getKey()).getTermVariable()));
    }

    public static Map<TermVariable, TermVariable> constructDefaultvarsToInvarsMap(TransFormula tf) {
        return tf.getInVars().entrySet().stream().collect(Collectors.toMap(x -> ((IProgramVar)x.getKey()).getTermVariable(), Map.Entry::getValue));
    }

    public static Map<TermVariable, TermVariable> constructOutvarsToDefaultvarsMap(TransFormula tf) {
        return tf.getOutVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getValue, x -> ((IProgramVar)x.getKey()).getTermVariable()));
    }

    public static Map<TermVariable, TermVariable> constructInvarsToOutvarsMap(TransFormula tf) {
        return tf.getInVars().entrySet().stream().filter(x -> tf.getOutVars().containsKey(x.getKey())).collect(Collectors.toMap(Map.Entry::getValue, x -> tf.getOutVars().get(x.getKey())));
    }

    public static Map<TermVariable, TermVariable> constructOutvarsToInvarsMap(TransFormula tf) {
        return tf.getOutVars().entrySet().stream().filter(x -> tf.getInVars().containsKey(x.getKey())).collect(Collectors.toMap(Map.Entry::getValue, x -> tf.getInVars().get(x.getKey())));
    }

    public static boolean eachFreeVarIsInvar(TransFormula tf, Term term) {
        Set inVars = tf.getInVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        return Arrays.stream(term.getFreeVars()).allMatch(inVars::contains);
    }

    public static boolean eachFreeVarIsOutvar(TransFormula tf, Term term) {
        Set outVars = tf.getOutVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        return Arrays.stream(term.getFreeVars()).allMatch(outVars::contains);
    }

    public static Term renameInvarsToDefaultVars(TransFormula tf, ManagedScript mgdScript, Term term) {
        Map<TermVariable, TermVariable> map = TransFormulaUtils.constructInvarsToDefaultvarsMap(tf);
        return Substitution.apply((ManagedScript)mgdScript, map, (Term)term);
    }

    public static Term renameOutvarsToDefaultVars(TransFormula tf, ManagedScript mgdScript, Term term) {
        Map<TermVariable, TermVariable> map = TransFormulaUtils.constructOutvarsToDefaultvarsMap(tf);
        return Substitution.apply((ManagedScript)mgdScript, map, (Term)term);
    }

    public static Term renameInvars(TransFormula tf, ManagedScript mgdScript, Map<IProgramVar, Term> map) {
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : tf.getInVars().entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                throw new IllegalArgumentException("did not provide mapping for " + entry.getKey());
            }
            substitutionMapping.put((Term)entry.getValue(), map.get(entry.getKey()));
        }
        return Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)tf.getFormula());
    }

    public static UnmodifiableTransFormula constructHavoc(TransFormula tf, ManagedScript mgdScript) {
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getOutVars(), false, tf.getNonTheoryConsts(), true, null, false);
        tfb.setFormula(mgdScript.getScript().term("true", new Term[0]));
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula constructHavoc(Set<IProgramVar> havocedVars, ManagedScript mgdScript) {
        Function<IProgramVar, TermVariable> valueMap = x -> mgdScript.constructFreshCopy(x.getTermVariable());
        Map<IProgramVar, TermVariable> outVars = havocedVars.stream().collect(Collectors.toMap(Function.identity(), valueMap));
        TransFormulaBuilder tfb = new TransFormulaBuilder(Collections.emptyMap(), outVars, false, Collections.emptySet(), true, null, false);
        tfb.setFormula(mgdScript.getScript().term("true", new Term[0]));
        tfb.setInfeasibility(UnmodifiableTransFormula.Infeasibility.UNPROVEABLE);
        return tfb.finishConstruction(mgdScript);
    }

    public static UnmodifiableTransFormula substituteTermVars(TransFormula tf, ManagedScript mgdScript, Map<TermVariable, TermVariable> mapping) {
        Map<IProgramVar, TermVariable> inVars = tf.getInVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> mapping.getOrDefault(e.getValue(), (TermVariable)e.getValue())));
        Map<IProgramVar, TermVariable> outVars = tf.getOutVars().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> mapping.getOrDefault(e.getValue(), (TermVariable)e.getValue())));
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>();
        for (TermVariable auxVar : tf.getAuxVars()) {
            auxVars.add(mapping.getOrDefault(auxVar, auxVar));
        }
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>(mapping);
        Term term = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)tf.getFormula());
        TransFormulaBuilder builder = new TransFormulaBuilder(inVars, outVars, true, null, true, null, false);
        builder.setFormula(term);
        builder.setInfeasibility(UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED);
        builder.addAuxVarsButRenameToFreshCopies(auxVars, mgdScript);
        return builder.finishConstruction(mgdScript);
    }

    public static Script.LBool checkImplication(UnmodifiableTransFormula lhs, UnmodifiableTransFormula rhs, ManagedScript mgdScript) {
        mgdScript.lock((Object)lhs);
        mgdScript.push((Object)lhs, 1);
        Script script = mgdScript.getScript();
        Term lhsClosedFormula = TransFormulaUtils.getClosedFormulaWithBranchEncoderConstants(mgdScript, lhs, lhs);
        Term rhsQuantFormula = SmtUtils.quantifier((Script)script, (int)0, (Collection)DataStructureUtils.union(rhs.getAuxVars(), rhs.getBranchEncoders()), (Term)rhs.getFormula());
        Term rhsClosedFormula = UnmodifiableTransFormula.computeClosedFormula(rhsQuantFormula, rhs.getInVars(), rhs.getOutVars(), Collections.emptySet(), mgdScript);
        Set lhsUnmodified = DataStructureUtils.difference(rhs.getAssignedVars(), lhs.getAssignedVars());
        Term lhsEqualities = TransFormulaUtils.constructExplicitEqualities(script, lhsUnmodified);
        Term lhsFormula = SmtUtils.and((Script)script, (Term[])new Term[]{lhsClosedFormula, lhsEqualities});
        Set rhsUnmodified = DataStructureUtils.difference(lhs.getAssignedVars(), rhs.getAssignedVars());
        Term rhsEqualities = TransFormulaUtils.constructExplicitEqualities(script, rhsUnmodified);
        Term rhsFormula = SmtUtils.and((Script)script, (Term[])new Term[]{rhsClosedFormula, rhsEqualities});
        mgdScript.assertTerm((Object)lhs, lhsFormula);
        mgdScript.assertTerm((Object)lhs, SmtUtils.not((Script)script, (Term)rhsFormula));
        Script.LBool result = mgdScript.checkSat((Object)lhs);
        mgdScript.echo((Object)lhs, new QuotedObject("Implication check result was " + result));
        mgdScript.pop((Object)lhs, 1);
        mgdScript.unlock((Object)lhs);
        return result;
    }

    private static Term getClosedFormulaWithBranchEncoderConstants(ManagedScript mgdScript, Object lock, UnmodifiableTransFormula tf) {
        if (tf.getBranchEncoders().isEmpty()) {
            return tf.getClosedFormula();
        }
        HashMap<TermVariable, Term> substitutionMap = new HashMap<TermVariable, Term>();
        int i = 0;
        for (TermVariable be : tf.getBranchEncoders()) {
            String name = String.valueOf(be.getName()) + "_be_" + i;
            mgdScript.declareFun(lock, name, new Sort[0], be.getSort());
            substitutionMap.put(be, mgdScript.term(lock, name, new Term[0]));
            ++i;
        }
        return Substitution.apply((ManagedScript)mgdScript, substitutionMap, (Term)tf.getClosedFormula());
    }

    private static Term constructExplicitEqualities(Script script, Set<IProgramVar> variables) {
        ArrayList<Term> equalities = new ArrayList<Term>(variables.size());
        for (IProgramVar progVar : variables) {
            Term equality = SmtUtils.binaryEquality((Script)script, (Term)progVar.getDefaultConstant(), (Term)progVar.getPrimedConstant());
            equalities.add(equality);
        }
        return SmtUtils.and((Script)script, equalities);
    }

    public static IProgramVarOrConst getProgramVarOrConstForTerm(TransFormula tf, Term term) {
        if (term instanceof TermVariable) {
            return TransFormulaUtils.getProgramVarForTerm(tf, (TermVariable)term);
        }
        if (term instanceof ApplicationTerm) {
            for (IProgramConst ntc : tf.getNonTheoryConsts()) {
                if (!ntc.getDefaultConstant().equals(term)) continue;
                return ntc;
            }
        }
        return null;
    }

    public static IProgramVarOrConst getProgramVarForTerm(TransFormula tf, TermVariable tv) {
        for (Map.Entry<IProgramVar, TermVariable> en : tf.getInVars().entrySet()) {
            if (!en.getValue().equals(tv)) continue;
            return en.getKey();
        }
        for (Map.Entry<IProgramVar, TermVariable> en : tf.getOutVars().entrySet()) {
            if (!en.getValue().equals(tv)) continue;
            return en.getKey();
        }
        return null;
    }

    public static String prettyPrint(TransFormula tf) {
        StringBuilder sb = new StringBuilder();
        String prettyPrintedFormula = new SMTPrettyPrinter(tf.getFormula()).toString();
        sb.append(prettyPrintedFormula);
        sb.append("\n");
        sb.append("Invars:\n");
        sb.append(tf.getInVars());
        sb.append("\n");
        sb.append("Outvars:\n");
        sb.append(tf.getOutVars());
        return sb.toString();
    }

    public static UnmodifiableTransFormula decoupleArrayValues(UnmodifiableTransFormula tf, ManagedScript mgdScript) {
        Map oldAuxVar2newAuxVar = mgdScript.constructFreshCopies(tf.getAuxVars());
        Term renamed = Substitution.apply((ManagedScript)mgdScript, (Map)oldAuxVar2newAuxVar, (Term)tf.getFormula());
        Triple<Term, List<TermVariable>, List<Term>> decoupled = TransFormulaUtils.decoupleArrayValues(renamed, mgdScript);
        TransFormulaBuilder tfb = new TransFormulaBuilder(tf.getInVars(), tf.getOutVars(), false, tf.getNonTheoryConsts(), false, tf.getBranchEncoders(), false);
        ArrayList<Term> resultConjuncts = new ArrayList<Term>((Collection)decoupled.getThird());
        resultConjuncts.add((Term)decoupled.getFirst());
        Term resultTerm = SmtUtils.and((Script)mgdScript.getScript(), resultConjuncts);
        tfb.setFormula(resultTerm);
        for (TermVariable auxVar : oldAuxVar2newAuxVar.values()) {
            tfb.addAuxVar(auxVar);
        }
        for (TermVariable auxVar : (List)decoupled.getSecond()) {
            tfb.addAuxVar(auxVar);
        }
        tfb.setInfeasibility(tf.isInfeasible());
        return tfb.finishConstruction(mgdScript);
    }

    private static Triple<Term, List<TermVariable>, List<Term>> decoupleArrayValues(Term term, ManagedScript mgdScript) {
        Collection arrayStores = ArrayStore.extractStores((Term)term, (boolean)true);
        if (arrayStores.isEmpty()) {
            return new Triple((Object)term, Collections.emptyList(), Collections.emptyList());
        }
        ArrayList<TermVariable> resultVariables = new ArrayList<TermVariable>();
        ArrayList<Term> resultEqualities = new ArrayList<Term>();
        HashMap<Term, Term> substitutionMapping = new HashMap<Term, Term>();
        for (ArrayStore arrayStore : arrayStores) {
            Triple<Term, List<TermVariable>, List<Term>> arrTriple = TransFormulaUtils.decoupleArrayValues(arrayStore.getArray(), mgdScript);
            Triple<Term, List<TermVariable>, List<Term>> idxTriple = TransFormulaUtils.decoupleArrayValues(arrayStore.getIndex(), mgdScript);
            Triple<Term, List<TermVariable>, List<Term>> valueTriple = TransFormulaUtils.decoupleArrayValues(arrayStore.getValue(), mgdScript);
            resultVariables.addAll((Collection)arrTriple.getSecond());
            resultVariables.addAll((Collection)idxTriple.getSecond());
            resultVariables.addAll((Collection)valueTriple.getSecond());
            resultEqualities.addAll((Collection)arrTriple.getThird());
            resultEqualities.addAll((Collection)idxTriple.getThird());
            resultEqualities.addAll((Collection)valueTriple.getThird());
            TermVariable newAuxVar = mgdScript.constructFreshTermVariable("ArrVal", ((Term)valueTriple.getFirst()).getSort());
            resultVariables.add(newAuxVar);
            Term equalitiy = SmtUtils.binaryEquality((Script)mgdScript.getScript(), (Term)newAuxVar, (Term)((Term)valueTriple.getFirst()));
            resultEqualities.add(equalitiy);
            Term resultStore = mgdScript.getScript().term("store", new Term[]{(Term)arrTriple.getFirst(), (Term)idxTriple.getFirst(), newAuxVar});
            substitutionMapping.put(arrayStore.asTerm(), resultStore);
        }
        Term resultTerm = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term);
        return new Triple((Object)resultTerm, resultVariables, resultEqualities);
    }

    public static boolean hasInternalNormalForm(TransFormula tf) {
        Set<IProgramVar> outVars = tf.getOutVars().keySet();
        Set freeVars = Arrays.stream(tf.getFormula().getFreeVars()).collect(Collectors.toSet());
        return tf.getInVars().entrySet().stream().allMatch(e -> outVars.contains(e.getKey()) || freeVars.contains(e.getValue()));
    }
}

