/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.UltimateNormalFormUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ImmutableSet;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class UnmodifiableTransFormula
extends TransFormula
implements Serializable {
    private static final long serialVersionUID = 7058102586141801399L;
    private final Term mFormula;
    private final Set<IProgramVar> mAssignedVars;
    private final Set<TermVariable> mBranchEncoders;
    private final Infeasibility mInfeasibility;
    private final Term mClosedFormula;

    UnmodifiableTransFormula(Term formula, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, ImmutableSet<IProgramConst> nonTheoryConsts, ImmutableSet<TermVariable> auxVars, ImmutableSet<TermVariable> branchEncoders, Infeasibility infeasibility, ManagedScript script) {
        super(inVars, outVars, (Set<TermVariable>)auxVars, (Set<IProgramConst>)nonTheoryConsts);
        assert (UltimateNormalFormUtils.respectsUltimateNormalForm((Term)formula)) : "Term not in UltimateNormalForm";
        this.mFormula = formula;
        this.mBranchEncoders = branchEncoders;
        this.mInfeasibility = infeasibility;
        this.mClosedFormula = UnmodifiableTransFormula.computeClosedFormula(formula, super.getInVars(), super.getOutVars(), super.getAuxVars(), script);
        this.mAssignedVars = TransFormulaUtils.computeAssignedVars(inVars, outVars);
        assert (SmtUtils.neitherKeyNorValueIsNull(inVars)) : "null in inVars";
        assert (SmtUtils.neitherKeyNorValueIsNull(outVars)) : "null in outVars";
        assert (!branchEncoders.isEmpty() || this.mClosedFormula.getFreeVars().length == 0) : String.format("free variables %s", Arrays.asList(this.mClosedFormula.getFreeVars()));
        assert (this.allSubsetInOutAuxBranch()) : "unexpected vars in TransFormula";
        assert (this.eachAuxVarOccursInFormula() == null) : "Superfluous aux var: " + this.eachAuxVarOccursInFormula();
        assert (this.termVariablesHaveUniqueProgramVar()) : "Same TermVariable used for different program variables";
        assert (this.doConstantConsistencyCheck()) : "consts inconsistent";
        assert (this.disjointVarSets()) : "non-disjoint vars in TransFormula";
    }

    public static Term computeClosedFormula(Term formula, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars, Set<TermVariable> auxVars, ManagedScript script) {
        HashMap<TermVariable, Object> substitutionMapping = new HashMap<TermVariable, Object>();
        for (Map.Entry<IProgramVar, TermVariable> entry : inVars.entrySet()) {
            TermVariable inTermVar = entry.getValue();
            assert (!substitutionMapping.containsKey(inTermVar));
            substitutionMapping.put(inTermVar, UnmodifiableTransFormula.getConstantForInVar(entry.getKey()));
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : outVars.entrySet()) {
            IProgramVar outVar = entry.getKey();
            TermVariable outTermVar = entry.getValue();
            if (inVars.get(outVar) == outTermVar) continue;
            substitutionMapping.put(outTermVar, UnmodifiableTransFormula.getConstantForOutVar(entry.getKey(), inVars, outVars));
        }
        for (TermVariable auxVarTv : auxVars) {
            ApplicationTerm auxVarConst = ProgramVarUtils.constructConstantForAuxVar(script, auxVarTv);
            substitutionMapping.put(auxVarTv, auxVarConst);
        }
        return Substitution.apply((ManagedScript)script, substitutionMapping, (Term)formula);
    }

    public static Term getConstantForInVar(IProgramVar pv) {
        return pv.getDefaultConstant();
    }

    public static Term getConstantForOutVar(IProgramVar pv, Map<IProgramVar, TermVariable> inVars, Map<IProgramVar, TermVariable> outVars) {
        Term outVar;
        Term inVar = (Term)inVars.get(pv);
        if (inVar == (outVar = (Term)outVars.get(pv))) {
            return pv.getDefaultConstant();
        }
        return pv.getPrimedConstant();
    }

    private boolean allSubsetInOutAuxBranch() {
        boolean result = true;
        TermVariable[] termVariableArray = this.mFormula.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            assert (result &= this.mInVars.values().contains(tv) || this.mOutVars.values().contains(tv) || this.mAuxVars.contains(tv) || this.mBranchEncoders.contains(tv)) : "unexpected variable in formula";
            ++n2;
        }
        return result;
    }

    private boolean disjointVarSets() {
        boolean result = true;
        for (TermVariable tv : super.getInVars().values()) {
            assert (result &= !super.getAuxVars().contains(tv)) : "in var is also aux var: " + tv;
        }
        for (TermVariable tv : super.getOutVars().values()) {
            assert (result &= !super.getAuxVars().contains(tv)) : "out var is also aux var: " + tv;
        }
        return result;
    }

    private TermVariable eachAuxVarOccursInFormula() {
        HashSet<TermVariable> allVars = new HashSet<TermVariable>(Arrays.asList(this.mFormula.getFreeVars()));
        for (TermVariable tv : super.getAuxVars()) {
            if (allVars.contains(tv)) continue;
            return tv;
        }
        return null;
    }

    private boolean termVariablesHaveUniqueProgramVar() {
        IProgramVar existing;
        HashMap<TermVariable, IProgramVar> progVars = new HashMap<TermVariable, IProgramVar>();
        for (Map.Entry entry : this.mInVars.entrySet()) {
            existing = (IProgramVar)progVars.get(entry.getValue());
            if (existing != null && existing != entry.getKey()) {
                return false;
            }
            progVars.put((TermVariable)entry.getValue(), (IProgramVar)entry.getKey());
        }
        for (Map.Entry entry : this.mOutVars.entrySet()) {
            existing = (IProgramVar)progVars.get(entry.getValue());
            if (existing != null && existing != entry.getKey()) {
                return false;
            }
            progVars.put((TermVariable)entry.getValue(), (IProgramVar)entry.getKey());
        }
        return true;
    }

    private boolean doConstantConsistencyCheck() {
        boolean consistent = true;
        Set constantsInFormula = SmtUtils.extractConstants((Term)this.mFormula, (boolean)false);
        HashSet<ApplicationTerm> nonTheoryConstantTerms = new HashSet<ApplicationTerm>();
        for (IProgramConst programConsts : this.getNonTheoryConsts()) {
            assert (consistent &= !programConsts.getDefaultConstant().getFunction().isIntern()) : "is theory symbol";
            nonTheoryConstantTerms.add(programConsts.getDefaultConstant());
            assert (consistent &= constantsInFormula.contains(programConsts.getDefaultConstant())) : "not in formula";
        }
        for (ApplicationTerm constInFomula : constantsInFormula) {
            if (!constInFomula.getFunction().isIntern()) assert (consistent &= nonTheoryConstantTerms.contains(constInFomula)) : "not in const set: " + constInFomula;
        }
        return consistent;
    }

    @Override
    public Term getFormula() {
        return this.mFormula;
    }

    public Set<TermVariable> getBranchEncoders() {
        return Collections.unmodifiableSet(this.mBranchEncoders);
    }

    public Term getClosedFormula() {
        return this.mClosedFormula;
    }

    @Override
    public Set<IProgramVar> getAssignedVars() {
        return Collections.unmodifiableSet(this.mAssignedVars);
    }

    public String toString() {
        return this.toStringInternal(this.mFormula.toString());
    }

    public String toStringDirect() {
        return this.toStringInternal(this.mFormula.toStringDirect());
    }

    private String toStringInternal(String formula) {
        return "Formula: " + formula + "  InVars " + super.getInVars() + "  OutVars" + super.getOutVars() + "  AuxVars" + super.getAuxVars() + "  AssignedVars" + this.mAssignedVars;
    }

    public Infeasibility isInfeasible() {
        return this.mInfeasibility;
    }

    public static enum Infeasibility {
        INFEASIBLE,
        UNPROVEABLE,
        NOT_DETERMINED;

    }
}

