/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ILocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.LocalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

public class ProgramVarUtils {
    private static final String AUX_VAR_PREFIX = "c_aux_";

    private ProgramVarUtils() {
    }

    public static String generateConstantIdentifierForAuxVar(TermVariable auxVar) {
        return AUX_VAR_PREFIX + auxVar.getName();
    }

    public static ApplicationTerm constructPrimedConstant(ManagedScript script, Object lockOwner, Sort sort, String name) {
        String primedConstantName = "c_" + name + "_primed";
        script.declareFun(lockOwner, primedConstantName, new Sort[0], sort);
        ApplicationTerm primedConstant = (ApplicationTerm)script.term(lockOwner, primedConstantName, new Term[0]);
        return primedConstant;
    }

    public static ApplicationTerm constructDefaultConstant(ManagedScript script, Object lockOwner, Sort sort, String name) {
        String defaultConstantName = "c_" + name;
        script.declareFun(lockOwner, defaultConstantName, new Sort[0], sort);
        ApplicationTerm defaultConstant = (ApplicationTerm)script.term(lockOwner, defaultConstantName, new Term[0]);
        return defaultConstant;
    }

    public static ApplicationTerm constructConstantForAuxVar(ManagedScript mgdScript, TermVariable auxVar) {
        String defaultConstantName = ProgramVarUtils.generateConstantIdentifierForAuxVar(auxVar);
        TermVariable lockOwner = auxVar;
        mgdScript.lock((Object)lockOwner);
        mgdScript.declareFun((Object)lockOwner, defaultConstantName, new Sort[0], auxVar.getSort());
        ApplicationTerm defaultConstant = (ApplicationTerm)mgdScript.term((Object)lockOwner, defaultConstantName, new Term[0]);
        mgdScript.unlock((Object)lockOwner);
        return defaultConstant;
    }

    public static ApplicationTerm getAuxVarConstant(ManagedScript mgdScript, TermVariable auxVar) {
        String defaultConstantName = ProgramVarUtils.generateConstantIdentifierForAuxVar(auxVar);
        return (ApplicationTerm)mgdScript.getScript().term(defaultConstantName, new Term[0]);
    }

    public static Set<IProgramNonOldVar> extractNonOldVars(Term term, IIcfgSymbolTable symbolTable) {
        HashSet<IProgramNonOldVar> result = new HashSet<IProgramNonOldVar>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar pv = symbolTable.getProgramVar(tv);
            if (pv instanceof IProgramNonOldVar) {
                result.add((IProgramNonOldVar)pv);
            }
            ++n2;
        }
        return result;
    }

    public static Set<IProgramOldVar> extractOldVars(Term term, IIcfgSymbolTable symbolTable) {
        HashSet<IProgramOldVar> result = new HashSet<IProgramOldVar>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            IProgramVar pv = symbolTable.getProgramVar(tv);
            if (pv instanceof IProgramOldVar) {
                result.add((IProgramOldVar)pv);
            }
            ++n2;
        }
        return result;
    }

    public static Term renameNonOldGlobalsToOldGlobals(Term term, IIcfgSymbolTable symbolTable, ManagedScript mgdScript) {
        Set<IProgramNonOldVar> nonOldVars = ProgramVarUtils.extractNonOldVars(term, symbolTable);
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (IProgramNonOldVar pv : nonOldVars) {
            if (pv == null) continue;
            IProgramOldVar oldVar = pv.getOldVar();
            substitutionMapping.put(pv.getTermVariable(), oldVar.getTermVariable());
        }
        Term result = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term);
        return result;
    }

    public static Term renameOldGlobalsToNonOldGlobals(Term term, IIcfgSymbolTable symbolTable, ManagedScript mgdScript) {
        Set<IProgramOldVar> oldVars = ProgramVarUtils.extractOldVars(term, symbolTable);
        HashMap<TermVariable, TermVariable> substitutionMapping = new HashMap<TermVariable, TermVariable>();
        for (IProgramOldVar pv : oldVars) {
            if (pv == null) continue;
            IProgramNonOldVar nonoldVar = pv.getNonOldVar();
            substitutionMapping.put(pv.getTermVariable(), nonoldVar.getTermVariable());
        }
        Term result = Substitution.apply((ManagedScript)mgdScript, substitutionMapping, (Term)term);
        return result;
    }

    public static String buildBoogieVarName(String identifier, String procedure, boolean isGlobal, boolean isOldvar) {
        String name;
        if (isGlobal) {
            assert (procedure == null);
            name = isOldvar ? "old(" + identifier + ")" : identifier;
        } else {
            assert (!isOldvar) : "only global vars can be oldvars";
            name = String.valueOf(procedure) + "_" + identifier;
        }
        return name;
    }

    public static ProgramNonOldVar constructGlobalProgramVarPair(String identifier, Sort sort, ManagedScript mgdScript, Object lockOwner) {
        String procedure = null;
        String name = ProgramVarUtils.buildBoogieVarName(identifier, procedure, true, true);
        TermVariable termVariable = mgdScript.variable(name, sort);
        ApplicationTerm defaultConstant = ProgramVarUtils.constructDefaultConstant(mgdScript, lockOwner, sort, name);
        ApplicationTerm primedConstant = ProgramVarUtils.constructPrimedConstant(mgdScript, lockOwner, sort, name);
        ProgramOldVar oldVar = new ProgramOldVar(identifier, termVariable, defaultConstant, primedConstant);
        String name2 = ProgramVarUtils.buildBoogieVarName(identifier, procedure, true, false);
        TermVariable termVariable2 = mgdScript.variable(name2, sort);
        ApplicationTerm defaultConstant2 = ProgramVarUtils.constructDefaultConstant(mgdScript, lockOwner, sort, name2);
        ApplicationTerm primedConstant2 = ProgramVarUtils.constructPrimedConstant(mgdScript, lockOwner, sort, name2);
        ProgramNonOldVar nonOldVar = new ProgramNonOldVar(identifier, termVariable2, defaultConstant2, primedConstant2, oldVar);
        oldVar.setNonOldVar(nonOldVar);
        return nonOldVar;
    }

    public static ILocalProgramVar constructLocalProgramVar(String identifier, String procedure, Sort sort, ManagedScript mgdScript, Object lockOwner) {
        String name = ProgramVarUtils.buildBoogieVarName(identifier, procedure, false, false);
        TermVariable termVariable = mgdScript.variable(name, sort);
        ApplicationTerm defaultConstant = ProgramVarUtils.constructDefaultConstant(mgdScript, lockOwner, sort, name);
        ApplicationTerm primedConstant = ProgramVarUtils.constructPrimedConstant(mgdScript, lockOwner, sort, name);
        return new LocalProgramVar(identifier, procedure, termVariable, defaultConstant, primedConstant);
    }

    public static IProgramVar transferProgramVar(TermTransferrer tt, IProgramVar pv) {
        if (pv instanceof ILocalProgramVar) {
            return new TransferredLocalProgramVar((ILocalProgramVar)pv, tt);
        }
        if (pv instanceof IProgramNonOldVar) {
            return new TransferredProgramNonOldVar((IProgramNonOldVar)pv, tt);
        }
        if (pv instanceof IProgramOldVar) {
            return new TransferredProgramNonOldVar(((IProgramOldVar)pv).getNonOldVar(), tt).getOldVar();
        }
        if (pv instanceof IReplacementVar) {
            return new TransferredReplacementVar((IReplacementVar)pv, tt);
        }
        return new TransferredProgramVar<IProgramVar>(pv, tt);
    }

    public static IProgramConst transferProgramConst(TermTransferrer tt, IProgramConst progConst) {
        return new TransferredProgramConst(progConst, tt);
    }

    private static class TransferredLocalProgramVar
    extends TransferredProgramVar<ILocalProgramVar>
    implements ILocalProgramVar {
        private static final long serialVersionUID = 1L;

        public TransferredLocalProgramVar(ILocalProgramVar pv, TermTransferrer tt) {
            super(pv, tt);
        }

        @Override
        public String getIdentifier() {
            return ((ILocalProgramVar)this.mOriginalProgramVar).getIdentifier();
        }
    }

    private static final class TransferredProgramConst
    implements IProgramConst {
        private final IProgramConst mProgConst;
        private final Term mTerm;
        private final ApplicationTerm mDefaultConst;
        private static final long serialVersionUID = 1L;

        private TransferredProgramConst(IProgramConst progConst, TermTransferrer tt) {
            this.mProgConst = progConst;
            this.mTerm = tt.transform(progConst.getTerm());
            this.mDefaultConst = (ApplicationTerm)tt.transform((Term)progConst.getDefaultConstant());
        }

        @Override
        public String getGloballyUniqueId() {
            return this.mProgConst.getGloballyUniqueId();
        }

        @Override
        public boolean isGlobal() {
            return this.mProgConst.isGlobal();
        }

        @Override
        public Term getTerm() {
            return this.mTerm;
        }

        @Override
        public String getIdentifier() {
            return this.mProgConst.getIdentifier();
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mDefaultConst;
        }

        public String toString() {
            return this.mProgConst.toString();
        }
    }

    private static class TransferredProgramNonOldVar
    implements IProgramNonOldVar {
        private static final long serialVersionUID = 1L;
        private final IProgramVar mNonOld;
        private final IProgramOldVar mOld;
        private final String mIdentifier;

        public TransferredProgramNonOldVar(IProgramNonOldVar nonOldPv, TermTransferrer tt) {
            this.mNonOld = new TransferredProgramVar<IProgramNonOldVar>(nonOldPv, tt);
            this.mOld = new TransferredProgramOldVar(this, nonOldPv.getOldVar(), tt);
            this.mIdentifier = nonOldPv.getIdentifier();
        }

        @Override
        public TermVariable getTermVariable() {
            return this.mNonOld.getTermVariable();
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mNonOld.getDefaultConstant();
        }

        @Override
        public ApplicationTerm getPrimedConstant() {
            return this.mNonOld.getPrimedConstant();
        }

        @Override
        public Term getTerm() {
            return this.mNonOld.getTerm();
        }

        @Override
        public String getIdentifier() {
            return this.mIdentifier;
        }

        @Override
        public IProgramOldVar getOldVar() {
            return this.mOld;
        }

        public String toString() {
            return this.mNonOld.toString();
        }
    }

    private static class TransferredProgramOldVar
    implements IProgramOldVar {
        private static final long serialVersionUID = 1L;
        private final IProgramVar mOld;
        private final IProgramNonOldVar mNonOld;

        private TransferredProgramOldVar(IProgramNonOldVar newNonOldVar, IProgramOldVar oldOldVar, TermTransferrer tt) {
            this.mOld = new TransferredProgramVar<IProgramOldVar>(oldOldVar, tt);
            this.mNonOld = newNonOldVar;
        }

        @Override
        public TermVariable getTermVariable() {
            return this.mOld.getTermVariable();
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mOld.getDefaultConstant();
        }

        @Override
        public ApplicationTerm getPrimedConstant() {
            return this.mOld.getPrimedConstant();
        }

        @Override
        public Term getTerm() {
            return this.mOld.getTerm();
        }

        @Override
        public String getIdentifierOfNonOldVar() {
            return this.mNonOld.getIdentifier();
        }

        @Override
        public IProgramNonOldVar getNonOldVar() {
            return this.mNonOld;
        }

        public String toString() {
            return this.mOld.toString();
        }
    }

    private static class TransferredProgramVar<L extends IProgramVar>
    implements IProgramVar {
        private static final long serialVersionUID = 1L;
        protected final L mOriginalProgramVar;
        private final Term mTerm;
        private final TermVariable mTermVar;
        private final ApplicationTerm mPrimedConstant;
        private final ApplicationTerm mDefaultConstant;

        private TransferredProgramVar(L pv, TermTransferrer tt) {
            this.mOriginalProgramVar = pv;
            this.mTerm = tt.transform(pv.getTerm());
            this.mTermVar = (TermVariable)tt.transform((Term)pv.getTermVariable());
            this.mPrimedConstant = (ApplicationTerm)tt.transform((Term)pv.getPrimedConstant());
            this.mDefaultConstant = (ApplicationTerm)tt.transform((Term)pv.getDefaultConstant());
        }

        @Override
        public String getGloballyUniqueId() {
            return this.mOriginalProgramVar.getGloballyUniqueId();
        }

        @Override
        public boolean isGlobal() {
            return this.mOriginalProgramVar.isGlobal();
        }

        @Override
        public Term getTerm() {
            return this.mTerm;
        }

        @Override
        public boolean isOldvar() {
            return this.mOriginalProgramVar.isOldvar();
        }

        @Override
        public TermVariable getTermVariable() {
            return this.mTermVar;
        }

        @Override
        public String getProcedure() {
            return this.mOriginalProgramVar.getProcedure();
        }

        @Override
        public ApplicationTerm getPrimedConstant() {
            return this.mPrimedConstant;
        }

        @Override
        public ApplicationTerm getDefaultConstant() {
            return this.mDefaultConstant;
        }

        public String toString() {
            return this.mOriginalProgramVar.toString();
        }
    }

    private static class TransferredReplacementVar
    extends TransferredProgramVar<IReplacementVar>
    implements IReplacementVar {
        private static final long serialVersionUID = 1L;
        private final Term mDefinition;

        public TransferredReplacementVar(IReplacementVar pv, TermTransferrer tt) {
            super(pv, tt);
            this.mDefinition = tt.transform(pv.getDefinition());
        }

        @Override
        public Term getDefinition() {
            return this.mDefinition;
        }
    }
}

