/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.dangerinvariants;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IcfgUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IIcfg;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgEdge;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgLocation;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.MonolithicImplicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateTransformer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermDomainOperationProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;

public class DangerInvariantUtils {
    private DangerInvariantUtils() {
    }

    public static IncrementalPlicationChecker.Validity eachStateHasSuccessor(IPredicate predec, HashRelation<IAction, IPredicate> succs, ManagedScript mgdScript, IUltimateServiceProvider services, CfgSmtToolkit csToolkit, BasicPredicateFactory predicateFactory, ILogger logger) {
        PredicateTransformer<Term, IPredicate, TransFormula> pt = new PredicateTransformer<Term, IPredicate, TransFormula>(mgdScript, new TermDomainOperationProvider(services, mgdScript));
        ArrayList<IPredicate> predecessors = new ArrayList<IPredicate>();
        for (Map.Entry entry : succs.getSetOfPairs()) {
            Term pre = DangerInvariantUtils.constructPreInternal(logger, predicateFactory, csToolkit, pt, ((IAction)entry.getKey()).getTransformula(), (IPredicate)entry.getValue(), services);
            predecessors.add(predicateFactory.newPredicate(pre));
        }
        IPredicate disjunction = predicateFactory.or(SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, predecessors);
        MonolithicImplicationChecker mic = new MonolithicImplicationChecker(services, mgdScript);
        IncrementalPlicationChecker.Validity result = mic.checkImplication(predec, false, disjunction, false);
        return result;
    }

    public static IncrementalPlicationChecker.Validity predicateIsNotEmpty(IPredicate pred, ManagedScript mgdScript) {
        Script.LBool lbool = SmtUtils.checkSatTerm((Script)mgdScript.getScript(), (Term)pred.getClosedFormula());
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lbool);
    }

    private static Term constructPreInternal(ILogger logger, BasicPredicateFactory predicateFactory, CfgSmtToolkit csToolkit, PredicateTransformer<Term, IPredicate, TransFormula> pt, TransFormula tf, IPredicate succPred, IUltimateServiceProvider services) {
        Term wp = pt.weakestPrecondition(predicateFactory.not(succPred), tf);
        Term wpLessQuantifiers = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)services, (ManagedScript)csToolkit.getManagedScript(), (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)wp);
        Term pre = SmtUtils.not((Script)csToolkit.getManagedScript().getScript(), (Term)wpLessQuantifiers);
        return pre;
    }

    public static IncrementalPlicationChecker.Validity checkDangerInvariant(Map<IcfgLocation, IPredicate> invariants, IIcfg<?> icfg, ManagedScript mgdScript, IUltimateServiceProvider services, BasicPredicateFactory predicateFactory, ILogger logger) {
        for (IcfgLocation location : icfg.getInitialNodes()) {
            IncrementalPlicationChecker.Validity validity = DangerInvariantUtils.predicateIsNotEmpty(invariants.get(location), mgdScript);
            if (validity == IncrementalPlicationChecker.Validity.VALID) {
                return IncrementalPlicationChecker.Validity.INVALID;
            }
            if (validity == IncrementalPlicationChecker.Validity.INVALID) continue;
            return validity;
        }
        ArrayDeque open = new ArrayDeque(icfg.getInitialNodes());
        HashSet<IcfgLocation> closed = new HashSet<IcfgLocation>();
        while (!open.isEmpty()) {
            IcfgLocation location = (IcfgLocation)open.pop();
            closed.add(location);
            if (IcfgUtils.isErrorLocation(icfg, location)) continue;
            HashRelation relation = new HashRelation();
            for (IcfgEdge transition : location.getOutgoingEdges()) {
                IcfgLocation target = (IcfgLocation)transition.getTarget();
                relation.addPair((Object)transition, (Object)invariants.get(target));
                if (closed.contains(target)) continue;
                open.add(target);
            }
            IncrementalPlicationChecker.Validity validity = DangerInvariantUtils.eachStateHasSuccessor(invariants.get(location), (HashRelation<IAction, IPredicate>)relation, mgdScript, services, icfg.getCfgSmtToolkit(), predicateFactory, logger);
            if (validity == IncrementalPlicationChecker.Validity.VALID) continue;
            return validity;
        }
        return IncrementalPlicationChecker.Validity.VALID;
    }
}

