/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.ModelCheckerUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public abstract class CachingHoareTripleChecker
implements IHoareTripleChecker {
    protected static final boolean UNKNOWN_IF_SOME_EXTENDED_CHECK_IS_UNKNOWN = true;
    protected final ILogger mLogger;
    protected final IHoareTripleChecker mComputingHoareTripleChecker;
    protected final IPredicateUnifier mPredicateUnifer;
    private final InCaReCounter mResultFromSolver = new InCaReCounter();
    private final InCaReCounter mResultFromCache = new InCaReCounter();
    private final InCaReCounter mResultFromExtendedCacheCheck = new InCaReCounter();
    private final NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> mInternalCache;
    private final NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> mCallCache;
    private final Map<IPredicate, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>> mReturnCache;

    public CachingHoareTripleChecker(IUltimateServiceProvider services, IHoareTripleChecker protectedHoareTripleChecker, IPredicateUnifier predicateUnifer) {
        this(services, protectedHoareTripleChecker, predicateUnifer, (NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>)new NestedMap3(), (NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>)new NestedMap3(), new HashMap<IPredicate, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>>());
    }

    public CachingHoareTripleChecker(IUltimateServiceProvider services, IHoareTripleChecker protectedHoareTripleChecker, IPredicateUnifier predicateUnifer, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> initialInternalCache, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> initialCallCache, Map<IPredicate, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>> initialReturnCache) {
        this.mLogger = services.getLoggingService().getLogger(ModelCheckerUtils.PLUGIN_ID);
        this.mComputingHoareTripleChecker = Objects.requireNonNull(protectedHoareTripleChecker);
        this.mPredicateUnifer = Objects.requireNonNull(predicateUnifer);
        this.mInternalCache = Objects.requireNonNull(initialInternalCache);
        this.mCallCache = Objects.requireNonNull(initialCallCache);
        this.mReturnCache = Objects.requireNonNull(initialReturnCache);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate succ) {
        IncrementalPlicationChecker.Validity result = this.getFromInternalCache(pre, act, succ);
        if (result == null) {
            result = this.extendedBinaryCacheCheck(pre, act, succ, this.mInternalCache);
            if (result == null) {
                result = this.mComputingHoareTripleChecker.checkInternal(pre, act, succ);
                this.mResultFromSolver.incIn();
            } else {
                this.mResultFromExtendedCacheCheck.incIn();
            }
            this.addToInternalCache(pre, act, succ, result);
        } else {
            this.mResultFromCache.incIn();
        }
        return result;
    }

    private IncrementalPlicationChecker.Validity getFromInternalCache(IPredicate pre, IInternalAction act, IPredicate succ) {
        return (IncrementalPlicationChecker.Validity)this.mInternalCache.get((Object)act, (Object)pre, (Object)succ);
    }

    private final void addToInternalCache(IPredicate pre, IInternalAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
        this.mInternalCache.put((Object)act, (Object)pre, (Object)succ, (Object)result);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate succ) {
        IncrementalPlicationChecker.Validity result = this.getFromCallCache(pre, act, succ);
        if (result == null) {
            result = this.extendedBinaryCacheCheck(pre, act, succ, this.mCallCache);
            if (result == null) {
                result = this.mComputingHoareTripleChecker.checkCall(pre, act, succ);
                this.mResultFromSolver.incCa();
            } else {
                this.mResultFromExtendedCacheCheck.incCa();
            }
            this.addToCallCache(pre, act, succ, result);
        } else {
            this.mResultFromCache.incCa();
        }
        return result;
    }

    private IncrementalPlicationChecker.Validity getFromCallCache(IPredicate pre, ICallAction act, IPredicate succ) {
        return (IncrementalPlicationChecker.Validity)this.mCallCache.get((Object)act, (Object)pre, (Object)succ);
    }

    private final void addToCallCache(IPredicate pre, ICallAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
        this.mCallCache.put((Object)act, (Object)pre, (Object)succ, (Object)result);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
        IncrementalPlicationChecker.Validity result = this.getFromReturnCache(preLin, preHier, act, succ);
        if (result == null) {
            if (!this.mReturnCache.containsKey(preHier)) {
                this.mReturnCache.put(preHier, (NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>)new NestedMap3());
            }
            if ((result = this.extendedBinaryCacheCheck(preLin, act, succ, this.mReturnCache.get(preHier))) == null) {
                result = this.mComputingHoareTripleChecker.checkReturn(preLin, preHier, act, succ);
                this.mResultFromSolver.incRe();
            } else {
                this.mResultFromExtendedCacheCheck.incRe();
            }
            this.addToReturnCache(preLin, preHier, act, succ, result);
        } else {
            this.mResultFromCache.incRe();
        }
        return result;
    }

    private IncrementalPlicationChecker.Validity getFromReturnCache(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
        NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> map = this.mReturnCache.get(preHier);
        if (map == null) {
            return null;
        }
        return (IncrementalPlicationChecker.Validity)map.get((Object)act, (Object)preLin, (Object)succ);
    }

    private final void addToReturnCache(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
        NestedMap3 map = this.mReturnCache.get(preHier);
        if (map == null) {
            map = new NestedMap3();
            this.mReturnCache.put(preHier, (NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>)map);
        }
        map.put((Object)act, (Object)preLin, (Object)succ, (Object)result);
    }

    protected abstract IncrementalPlicationChecker.Validity extendedBinaryCacheCheck(IPredicate var1, IAction var2, IPredicate var3, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> var4);

    @Override
    public IStatisticsDataProvider getStatistics() {
        return this.mComputingHoareTripleChecker.getStatistics();
    }

    public IHoareTripleChecker getProtectedHoareTripleChecker() {
        return this.mComputingHoareTripleChecker;
    }

    public void releaseLock() {
        this.mComputingHoareTripleChecker.releaseLock();
    }

    public String toString() {
        return this.mComputingHoareTripleChecker.toString();
    }
}

