/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import java.util.Set;

public class CachingHoareTripleCheckerIterative
extends CachingHoareTripleChecker
implements IHoareTripleChecker {
    public CachingHoareTripleCheckerIterative(IUltimateServiceProvider services, IHoareTripleChecker protectedHoareTripleChecker, IPredicateUnifier predicateUnifer) {
        super(services, protectedHoareTripleChecker, predicateUnifer);
    }

    @Override
    protected IncrementalPlicationChecker.Validity extendedBinaryCacheCheck(IPredicate pre, IAction act, IPredicate succ, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> binaryCache) {
        IncrementalPlicationChecker.Validity result;
        boolean someResultWasUnknown = false;
        Set<IPredicate> strongerThanPre = this.mPredicateUnifer.getCoverageRelation().getCoveredPredicates(pre);
        Set<IPredicate> weakerThanSucc = this.mPredicateUnifer.getCoverageRelation().getCoveringPredicates(succ);
        if (strongerThanPre.size() * weakerThanSucc.size() > 100) {
            this.mLogger.warn((Object)("costly cache lookup: " + strongerThanPre.size() * weakerThanSucc.size()));
        }
        for (IPredicate strengthenedPre : strongerThanPre) {
            for (IPredicate weakenedSucc : weakerThanSucc) {
                result = (IncrementalPlicationChecker.Validity)binaryCache.get((Object)act, (Object)strengthenedPre, (Object)weakenedSucc);
                if (result == null) continue;
                switch (result) {
                    case VALID: {
                        break;
                    }
                    case UNKNOWN: {
                        someResultWasUnknown = true;
                        break;
                    }
                    case INVALID: {
                        return result;
                    }
                    case NOT_CHECKED: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"unknown case");
                    }
                }
            }
        }
        Set<IPredicate> weakerThanPre = this.mPredicateUnifer.getCoverageRelation().getCoveringPredicates(pre);
        Set<IPredicate> strongerThanSucc = this.mPredicateUnifer.getCoverageRelation().getCoveredPredicates(succ);
        if (weakerThanPre.size() * strongerThanSucc.size() > 100) {
            this.mLogger.warn((Object)("costly cache lookup: " + weakerThanPre.size() * strongerThanSucc.size()));
        }
        for (IPredicate weakenedPre : weakerThanPre) {
            for (IPredicate strengthenedSucc : strongerThanSucc) {
                result = (IncrementalPlicationChecker.Validity)binaryCache.get((Object)act, (Object)weakenedPre, (Object)strengthenedSucc);
                if (result == null) continue;
                switch (result) {
                    case VALID: {
                        return result;
                    }
                    case UNKNOWN: {
                        someResultWasUnknown = true;
                        break;
                    }
                    case INVALID: {
                        break;
                    }
                    case NOT_CHECKED: {
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)"unknown case");
                    }
                }
            }
        }
        if (someResultWasUnknown) {
            return IncrementalPlicationChecker.Validity.UNKNOWN;
        }
        return null;
    }
}

