/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap2;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.NestedMap3;
import java.util.Map;
import java.util.Set;

public class CachingHoareTripleCheckerMap
extends CachingHoareTripleChecker {
    private static final String UNKNOWN_CASE = "unknown case";
    private static final String CASE_MUST_NOT_OCCUR = "case must not occur";

    public CachingHoareTripleCheckerMap(IUltimateServiceProvider services, IHoareTripleChecker protectedHoareTripleChecker, IPredicateUnifier predicateUnifer) {
        super(services, protectedHoareTripleChecker, predicateUnifer);
    }

    public CachingHoareTripleCheckerMap(IUltimateServiceProvider services, IHoareTripleChecker protectedHoareTripleChecker, IPredicateUnifier predicateUnifer, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> initialInternalCache, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> initialCallCache, Map<IPredicate, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity>> initialReturnCache) {
        super(services, protectedHoareTripleChecker, predicateUnifer, initialInternalCache, initialCallCache, initialReturnCache);
    }

    @Override
    protected IncrementalPlicationChecker.Validity extendedBinaryCacheCheck(IPredicate pre, IAction act, IPredicate succ, NestedMap3<IAction, IPredicate, IPredicate, IncrementalPlicationChecker.Validity> binaryCache) {
        Set<IPredicate> strongerThanSucc;
        Set<IPredicate> weakerThanPre;
        Set<IPredicate> weakerThanSucc;
        NestedMap2 pred2succ = binaryCache.get((Object)act);
        if (pred2succ == null) {
            return null;
        }
        boolean someResultWasUnknown = false;
        Set<IPredicate> strongerThanPre = this.mPredicateUnifer.getCoverageRelation().getCoveredPredicates(pre);
        IncrementalPlicationChecker.Validity validity = (IncrementalPlicationChecker.Validity)new PreIterator(strongerThanPre, (NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity>)pred2succ, weakerThanSucc = this.mPredicateUnifer.getCoverageRelation().getCoveringPredicates(succ), this::evaluteResultStrongerThanPreAndWeakerThanSucc).iterate();
        if (validity != null) {
            switch (validity) {
                case VALID: {
                    throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                }
                case UNKNOWN: {
                    someResultWasUnknown = true;
                    break;
                }
                case INVALID: {
                    return validity;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                }
                default: {
                    throw new AssertionError((Object)UNKNOWN_CASE);
                }
            }
        }
        if ((validity = (IncrementalPlicationChecker.Validity)new PreIterator(weakerThanPre = this.mPredicateUnifer.getCoverageRelation().getCoveringPredicates(pre), (NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity>)pred2succ, strongerThanSucc = this.mPredicateUnifer.getCoverageRelation().getCoveredPredicates(succ), this::evaluteResultWeakerThanPreAndStrongerThanSucc).iterate()) != null) {
            switch (validity) {
                case VALID: {
                    return validity;
                }
                case UNKNOWN: {
                    someResultWasUnknown = true;
                    break;
                }
                case INVALID: {
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)CASE_MUST_NOT_OCCUR);
                }
                default: {
                    throw new AssertionError((Object)UNKNOWN_CASE);
                }
            }
        }
        if (someResultWasUnknown) {
            return IncrementalPlicationChecker.Validity.UNKNOWN;
        }
        return null;
    }

    private IncrementalPlicationChecker.Validity evaluteResultWeakerThanPreAndStrongerThanSucc(IncrementalPlicationChecker.Validity validity) {
        if (validity == null) {
            return validity;
        }
        switch (validity) {
            case VALID: {
                return validity;
            }
            case UNKNOWN: {
                return validity;
            }
            case INVALID: {
                return null;
            }
            case NOT_CHECKED: {
                return null;
            }
        }
        throw new AssertionError((Object)UNKNOWN_CASE);
    }

    private IncrementalPlicationChecker.Validity evaluteResultStrongerThanPreAndWeakerThanSucc(IncrementalPlicationChecker.Validity validity) {
        if (validity == null) {
            return validity;
        }
        switch (validity) {
            case VALID: {
                return null;
            }
            case UNKNOWN: {
                return validity;
            }
            case INVALID: {
                return validity;
            }
            case NOT_CHECKED: {
                return null;
            }
        }
        throw new AssertionError((Object)UNKNOWN_CASE);
    }

    @FunctionalInterface
    public static interface IResultEvaluator {
        public IncrementalPlicationChecker.Validity evaluateResult(IncrementalPlicationChecker.Validity var1);
    }

    private static abstract class IntersectionIterator<E, R> {
        private final Set<E> mSmallerSet;
        private final Set<E> mLargerSet;
        protected R mResult;

        public IntersectionIterator(Set<E> set1, Set<E> set2) {
            if (set1.size() >= set2.size()) {
                this.mSmallerSet = set2;
                this.mLargerSet = set1;
            } else {
                this.mSmallerSet = set1;
                this.mLargerSet = set2;
            }
        }

        protected abstract boolean doOneIterationStep(E var1);

        protected final R iterate() {
            for (E e : this.mSmallerSet) {
                boolean stop;
                if (!this.mLargerSet.contains(e) || !(stop = this.doOneIterationStep(e))) continue;
                return this.mResult;
            }
            return this.mResult;
        }
    }

    private static class PreIterator
    extends IntersectionIterator<IPredicate, IncrementalPlicationChecker.Validity> {
        private final IResultEvaluator mResultEvaluator;
        private final NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity> mPre2Succ2Validity;
        private final Set<IPredicate> mWeakerThenSucc;

        public PreIterator(Set<IPredicate> set1, NestedMap2<IPredicate, IPredicate, IncrementalPlicationChecker.Validity> map, Set<IPredicate> weakerThanSucc, IResultEvaluator resultEvaluator) {
            super(set1, map.keySet());
            this.mPre2Succ2Validity = map;
            this.mWeakerThenSucc = weakerThanSucc;
            this.mResultEvaluator = resultEvaluator;
        }

        @Override
        protected boolean doOneIterationStep(IPredicate strengthenedPre) {
            IncrementalPlicationChecker.Validity validity = (IncrementalPlicationChecker.Validity)new SuccIterator(this.mWeakerThenSucc, this.mPre2Succ2Validity.get((Object)strengthenedPre), this.mResultEvaluator).iterate();
            this.mResult = this.mResultEvaluator.evaluateResult(validity);
            return this.mResult != null && this.mResult != IncrementalPlicationChecker.Validity.UNKNOWN;
        }
    }

    private static class SuccIterator
    extends IntersectionIterator<IPredicate, IncrementalPlicationChecker.Validity> {
        private final IResultEvaluator mResultEvaluator;
        private final Map<IPredicate, IncrementalPlicationChecker.Validity> mSucc2Validity;

        public SuccIterator(Set<IPredicate> set1, Map<IPredicate, IncrementalPlicationChecker.Validity> map, IResultEvaluator resultEvaluator) {
            super(set1, map.keySet());
            this.mSucc2Validity = map;
            this.mResultEvaluator = resultEvaluator;
        }

        @Override
        protected boolean doOneIterationStep(IPredicate weakerThanSucc) {
            IncrementalPlicationChecker.Validity validity = this.mSucc2Validity.get(weakerThanSucc);
            this.mResult = this.mResultEvaluator.evaluateResult(validity);
            return this.mResult != null && this.mResult != IncrementalPlicationChecker.Validity.UNKNOWN;
        }
    }
}

