/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.TermClassifier;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.InCaReCounter;
import de.uni_freiburg.informatik.ultimate.util.Lazy;
import de.uni_freiburg.informatik.ultimate.util.ReflectionUtil;
import de.uni_freiburg.informatik.ultimate.util.VMUtils;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import de.uni_freiburg.informatik.ultimate.util.statistics.AbstractStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.KeyType;
import de.uni_freiburg.informatik.ultimate.util.statistics.StatisticsAggregator;
import de.uni_freiburg.informatik.ultimate.util.statistics.TimeTracker;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class ChainingHoareTripleChecker
implements IHoareTripleChecker {
    private static final int LONG_CHECK_THRESHOLD_MS = 1000;
    private final List<IWrappedHoareTripleChecker> mHtcs;
    private final ILogger mLogger;
    private static final Predicate<IPredicate> SKIP_PRED = a -> false;
    private static final Predicate<IAction> SKIP_ACT = a -> false;

    private ChainingHoareTripleChecker(ILogger logger) {
        this(logger, Collections.emptyList());
    }

    private ChainingHoareTripleChecker(ILogger logger, List<IWrappedHoareTripleChecker> list) {
        this.mLogger = logger;
        this.mHtcs = list;
        DataStructureUtils.filteredCast(this.mHtcs.stream(), ReviewedProtectedHtc.class).forEach(a -> a.setLockRelease(this::releaseLock));
    }

    public void releaseLock() {
        this.mHtcs.stream().forEach(ManagedScript.ILockHolderWithVoluntaryLockRelease::releaseLock);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate succ) {
        for (IWrappedHoareTripleChecker htc : this.mHtcs) {
            IncrementalPlicationChecker.Validity val = htc.checkInternal(pre, act, succ);
            htc.getUnderlying().reportLongChecks(pre, act, succ, val);
            if (val != IncrementalPlicationChecker.Validity.INVALID && val != IncrementalPlicationChecker.Validity.VALID) continue;
            return val;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate succ) {
        for (IWrappedHoareTripleChecker htc : this.mHtcs) {
            IncrementalPlicationChecker.Validity val = htc.checkCall(pre, act, succ);
            htc.getUnderlying().reportLongChecks(pre, act, succ, val);
            if (val != IncrementalPlicationChecker.Validity.INVALID && val != IncrementalPlicationChecker.Validity.VALID) continue;
            return val;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
        for (IWrappedHoareTripleChecker htc : this.mHtcs) {
            IncrementalPlicationChecker.Validity val = htc.checkReturn(preLin, preHier, act, succ);
            htc.getUnderlying().reportLongChecks(preLin, preHier, act, succ, val);
            if (val != IncrementalPlicationChecker.Validity.INVALID && val != IncrementalPlicationChecker.Validity.VALID) continue;
            return val;
        }
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }

    @Override
    public IStatisticsDataProvider getStatistics() {
        StatisticsAggregator aggr = new StatisticsAggregator();
        for (IWrappedHoareTripleChecker htc : this.mHtcs) {
            aggr.aggregateBenchmarkData(htc.getStatistics());
            ProtectedHtc under = htc.getUnderlying();
            String prefix = under.mHtc.getClass().getSimpleName();
            aggr.aggregateBenchmarkData(prefix, (IStatisticsDataProvider)under.mStats);
        }
        return aggr;
    }

    public String toString() {
        return this.mHtcs.stream().map(Object::toString).collect(Collectors.joining(", "));
    }

    public static ChainingHoareTripleChecker with(ILogger logger, IHoareTripleChecker htc) {
        return new ChainingHoareTripleChecker(logger).andThen(htc);
    }

    public static ChainingHoareTripleChecker empty(ILogger logger) {
        return new ChainingHoareTripleChecker(logger);
    }

    public ChainingHoareTripleChecker andThen(IHoareTripleChecker htc) {
        if (htc instanceof ChainingHoareTripleChecker) {
            ChainingHoareTripleChecker chain = (ChainingHoareTripleChecker)htc;
            ChainingHoareTripleChecker rtr = this;
            for (IWrappedHoareTripleChecker wHtc : chain.mHtcs) {
                rtr = rtr.add(wHtc.copy());
            }
            return rtr;
        }
        return this.add(new ProtectedHtc(this.mLogger, htc, SKIP_ACT, SKIP_PRED));
    }

    public ChainingHoareTripleChecker predicatesProtectedBy(Predicate<IPredicate> pred) {
        return this.replaceLast(this.createFromLastProtected(last -> new ProtectedHtc(last.mLogger, last.mHtc, last.mPredActionProtection, last.mPredPredicateProtection.or(pred))));
    }

    public ChainingHoareTripleChecker actionsProtectedBy(Predicate<IAction> pred) {
        return this.replaceLast(this.createFromLastProtected(last -> new ProtectedHtc(last.mLogger, last.mHtc, last.mPredActionProtection.or(pred), last.mPredPredicateProtection)));
    }

    public ChainingHoareTripleChecker reviewWith(IHoareTripleChecker reviewHtc) {
        if (VMUtils.areAssertionsEnabled()) {
            return this.replaceLast(this.createFromLastReview(reviewHtc));
        }
        return this;
    }

    private ChainingHoareTripleChecker replaceLast(IWrappedHoareTripleChecker replacement) {
        ArrayList<IWrappedHoareTripleChecker> list = new ArrayList<IWrappedHoareTripleChecker>(this.mHtcs.size());
        list.addAll(this.mHtcs);
        list.set(list.size() - 1, replacement);
        return new ChainingHoareTripleChecker(this.mLogger, list);
    }

    private ChainingHoareTripleChecker add(IWrappedHoareTripleChecker add) {
        ArrayList<IWrappedHoareTripleChecker> list = new ArrayList<IWrappedHoareTripleChecker>(this.mHtcs.size() + 1);
        list.addAll(this.mHtcs);
        list.add(add);
        return new ChainingHoareTripleChecker(this.mLogger, list);
    }

    private IWrappedHoareTripleChecker getLast() {
        return this.mHtcs.get(this.mHtcs.size() - 1);
    }

    private IWrappedHoareTripleChecker createFromLastReview(IHoareTripleChecker reviewHtc) {
        ProtectedHtc pHtc = this.getLast().getUnderlying();
        return new ReviewedProtectedHtc(reviewHtc, new ProtectedHtc(pHtc.mLogger, pHtc.mHtc, pHtc.mPredActionProtection, pHtc.mPredPredicateProtection));
    }

    private IWrappedHoareTripleChecker createFromLastProtected(Function<ProtectedHtc, ProtectedHtc> replace) {
        IWrappedHoareTripleChecker last = this.getLast();
        return last.replaceUnderlying(replace.apply(last.getUnderlying()));
    }

    private static interface IWrappedHoareTripleChecker
    extends IHoareTripleChecker {
        public ProtectedHtc getUnderlying();

        public IWrappedHoareTripleChecker replaceUnderlying(ProtectedHtc var1);

        public IWrappedHoareTripleChecker copy();
    }

    private static class ProtectedHtc
    implements IWrappedHoareTripleChecker {
        private final IHoareTripleChecker mHtc;
        private final Predicate<IPredicate> mPredPredicateProtection;
        private final Predicate<IAction> mPredActionProtection;
        private final ValidityInCaReCounter mStats;
        private final ILogger mLogger;

        public ProtectedHtc(ILogger logger, IHoareTripleChecker htc, Predicate<IAction> predActionProtection, Predicate<IPredicate> predPredicateProtection) {
            this.mLogger = Objects.requireNonNull(logger);
            this.mHtc = Objects.requireNonNull(htc);
            this.mPredPredicateProtection = Objects.requireNonNull(predPredicateProtection);
            this.mPredActionProtection = Objects.requireNonNull(predActionProtection);
            this.mStats = new ValidityInCaReCounter();
        }

        public ProtectedHtc(ProtectedHtc old) {
            this(old.mLogger, old.mHtc, old.mPredActionProtection, old.mPredPredicateProtection);
        }

        public void releaseLock() {
            this.mHtc.releaseLock();
        }

        @Override
        public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate succ) {
            this.mStats.start();
            IncrementalPlicationChecker.Validity val = this.mPredPredicateProtection.test(pre) || this.mPredPredicateProtection.test(succ) || this.mPredActionProtection.test(act) ? IncrementalPlicationChecker.Validity.NOT_CHECKED : this.mHtc.checkInternal(pre, act, succ);
            this.mStats.stop();
            this.mStats.inc(val, act);
            return val;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate succ) {
            this.mStats.start();
            IncrementalPlicationChecker.Validity val = this.mPredPredicateProtection.test(pre) || this.mPredPredicateProtection.test(succ) || this.mPredActionProtection.test(act) ? IncrementalPlicationChecker.Validity.NOT_CHECKED : this.mHtc.checkCall(pre, act, succ);
            this.mStats.stop();
            this.mStats.inc(val, act);
            return val;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkReturn(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
            this.mStats.start();
            IncrementalPlicationChecker.Validity val = this.mPredPredicateProtection.test(preLin) || this.mPredPredicateProtection.test(preHier) || this.mPredPredicateProtection.test(succ) || this.mPredActionProtection.test(act) ? IncrementalPlicationChecker.Validity.NOT_CHECKED : this.mHtc.checkReturn(preLin, preHier, act, succ);
            this.mStats.stop();
            this.mStats.inc(val, act);
            return val;
        }

        @Override
        public IStatisticsDataProvider getStatistics() {
            return this.mHtc.getStatistics();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.mHtc.getClass().getSimpleName());
            sb.append(" [");
            sb.append((Object)this.mStats);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public ProtectedHtc getUnderlying() {
            return this;
        }

        @Override
        public IWrappedHoareTripleChecker replaceUnderlying(ProtectedHtc underlying) {
            return underlying;
        }

        public void reportLongChecks(IPredicate pre, IAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
            this.reportLongChecks(pre, null, act, succ, result);
        }

        public void reportLongChecks(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
            long delta = this.mStats.mTime.lastDelta(TimeUnit.MILLISECONDS);
            if (delta > 1000L) {
                TermClassifier tc = new TermClassifier();
                tc.checkTerm(act.getTransformula().getFormula());
                tc.checkTerm(preLin.getFormula());
                tc.checkTerm(succ.getFormula());
                if (preHier != null) {
                    tc.checkTerm(preHier.getFormula());
                }
                this.mLogger.warn("%s took %s for a HTC check with result %s. Formula has sorts %s, hasArrays=%s, hasNonlinArith=%s, quantifiers %s", new Object[]{this.mHtc.getClass().getSimpleName(), CoreUtil.humanReadableTime((long)delta, (TimeUnit)TimeUnit.MILLISECONDS, (int)2), result, tc.getOccuringSortNames(), tc.hasArrays(), tc.hasNonlinearArithmetic(), tc.getOccuringQuantifiers()});
            }
        }

        @Override
        public IWrappedHoareTripleChecker copy() {
            return new ProtectedHtc(this);
        }
    }

    private static class ReviewedProtectedHtc
    implements IWrappedHoareTripleChecker {
        private final IHoareTripleChecker mReviewHtc;
        private final ProtectedHtc mHtc;
        private ManagedScript.ILockHolderWithVoluntaryLockRelease mFunReleaseLocks;

        public ReviewedProtectedHtc(IHoareTripleChecker reviewHtc, ProtectedHtc htc) {
            this.mReviewHtc = Objects.requireNonNull(reviewHtc);
            this.mHtc = Objects.requireNonNull(htc);
        }

        private void setLockRelease(ManagedScript.ILockHolderWithVoluntaryLockRelease funReleaseLocks) {
            this.mFunReleaseLocks = funReleaseLocks;
        }

        public void releaseLock() {
            this.mHtc.releaseLock();
            this.mReviewHtc.releaseLock();
        }

        @Override
        public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate succ) {
            IncrementalPlicationChecker.Validity val = this.mHtc.checkInternal(pre, act, succ);
            if (val == IncrementalPlicationChecker.Validity.NOT_CHECKED || val == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return val;
            }
            assert (this.reviewInductiveInternal(pre, act, succ, val));
            return val;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate succ) {
            IncrementalPlicationChecker.Validity val = this.mHtc.checkCall(pre, act, succ);
            if (val == IncrementalPlicationChecker.Validity.NOT_CHECKED || val == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return val;
            }
            assert (this.reviewInductiveCall(pre, act, succ, val));
            return val;
        }

        @Override
        public IncrementalPlicationChecker.Validity checkReturn(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
            IncrementalPlicationChecker.Validity val = this.mHtc.checkReturn(preLin, preHier, act, succ);
            if (val == IncrementalPlicationChecker.Validity.NOT_CHECKED || val == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return val;
            }
            assert (this.reviewInductiveReturn(preLin, preHier, act, succ, val));
            return val;
        }

        private boolean reviewInductiveInternal(IPredicate state, IInternalAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
            this.mFunReleaseLocks.releaseLock();
            IncrementalPlicationChecker.Validity reviewResult = this.mReviewHtc.checkInternal(state, act, succ);
            if (ReviewedProtectedHtc.reviewResult(result, reviewResult)) {
                this.mReviewHtc.releaseLock();
                return true;
            }
            throw this.createAssertionError(result, reviewResult);
        }

        private boolean reviewInductiveCall(IPredicate state, ICallAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
            this.mFunReleaseLocks.releaseLock();
            IncrementalPlicationChecker.Validity reviewResult = this.mReviewHtc.checkCall(state, act, succ);
            if (ReviewedProtectedHtc.reviewResult(result, reviewResult)) {
                this.mReviewHtc.releaseLock();
                return true;
            }
            throw this.createAssertionError(result, reviewResult);
        }

        private boolean reviewInductiveReturn(IPredicate state, IPredicate hier, IReturnAction act, IPredicate succ, IncrementalPlicationChecker.Validity result) {
            this.mFunReleaseLocks.releaseLock();
            IncrementalPlicationChecker.Validity reviewResult = this.mReviewHtc.checkReturn(state, hier, act, succ);
            if (ReviewedProtectedHtc.reviewResult(result, reviewResult)) {
                this.mReviewHtc.releaseLock();
                return true;
            }
            throw this.createAssertionError(result, reviewResult);
        }

        private static boolean reviewResult(IncrementalPlicationChecker.Validity result, IncrementalPlicationChecker.Validity reviewResult) {
            switch (result) {
                case VALID: {
                    return reviewResult == IncrementalPlicationChecker.Validity.VALID || reviewResult == IncrementalPlicationChecker.Validity.UNKNOWN;
                }
                case INVALID: {
                    return reviewResult == IncrementalPlicationChecker.Validity.INVALID || reviewResult == IncrementalPlicationChecker.Validity.UNKNOWN;
                }
                case UNKNOWN: 
                case NOT_CHECKED: {
                    return true;
                }
            }
            throw new UnsupportedOperationException("Unknown validity: " + result);
        }

        private AssertionError createAssertionError(IncrementalPlicationChecker.Validity result, IncrementalPlicationChecker.Validity reviewResult) {
            return new AssertionError((Object)String.format("HoareTripleChecker results differ between %s (result: %s) and %s (result: %s)", this.mHtc.mHtc.getClass().getSimpleName(), result, this.mReviewHtc.getClass().getSimpleName(), reviewResult));
        }

        @Override
        public IStatisticsDataProvider getStatistics() {
            return this.mHtc.getStatistics();
        }

        public String toString() {
            return this.mHtc.toString();
        }

        @Override
        public ProtectedHtc getUnderlying() {
            return this.mHtc;
        }

        @Override
        public IWrappedHoareTripleChecker replaceUnderlying(ProtectedHtc underlying) {
            return new ReviewedProtectedHtc(this.mReviewHtc, underlying);
        }

        @Override
        public IWrappedHoareTripleChecker copy() {
            return new ReviewedProtectedHtc(this.mReviewHtc, new ProtectedHtc(this.mHtc.getUnderlying()));
        }
    }

    private static final class ValidityInCaReCounter
    extends AbstractStatisticsDataProvider {
        @ReflectionUtil.Reflected(prettyName="Valid")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mValid = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Invalid")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mInvalid = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Unknown")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mUnknown = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Unchecked")
        @StatisticsAggregator.Statistics(type=KeyType.IN_CA_RE_COUNTER)
        private final InCaReCounter mUnchecked = new InCaReCounter();
        @ReflectionUtil.Reflected(prettyName="Time")
        @StatisticsAggregator.Statistics(type=KeyType.TT_TIMER)
        private final TimeTracker mTime = new TimeTracker();
        @ReflectionUtil.Reflected(excluded=true)
        private static final Lazy<List<Field>> FIELDS = new Lazy(() -> ReflectionUtil.instanceFields(ValidityInCaReCounter.class).stream().filter(f -> f.getAnnotation(StatisticsAggregator.Statistics.class) != null).collect(Collectors.toList()));

        public ValidityInCaReCounter() {
            for (Field f : (List)FIELDS.get()) {
                StatisticsAggregator.Statistics annot = f.getAnnotation(StatisticsAggregator.Statistics.class);
                this.declare(ReflectionUtil.fieldPrettyName((Field)f), () -> annot.type().convert(ReflectionUtil.access((Object)((Object)this), (Field)f)), annot.type());
            }
        }

        public void start() {
            this.mTime.start();
        }

        public void stop() {
            this.mTime.stop();
        }

        public void inc(IncrementalPlicationChecker.Validity val, IAction action) {
            switch (val) {
                case INVALID: {
                    this.inc(action, this.mInvalid);
                    break;
                }
                case NOT_CHECKED: {
                    this.inc(action, this.mUnchecked);
                    break;
                }
                case UNKNOWN: {
                    this.inc(action, this.mUnknown);
                    break;
                }
                case VALID: {
                    this.inc(action, this.mValid);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unknown validity " + val);
                }
            }
        }

        private void inc(IAction act, InCaReCounter cnt) {
            if (act instanceof IInternalAction) {
                cnt.incIn();
            } else if (act instanceof ICallAction) {
                cnt.incCa();
            } else if (act instanceof IReturnAction) {
                cnt.incRe();
            } else {
                throw new UnsupportedOperationException("Unknown action " + act.getClass());
            }
        }

        public String toString() {
            return this.getBenchmarkType().prettyprintBenchmarkData((IStatisticsDataProvider)this);
        }
    }
}

