/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ApplicationTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class DebuggingHoareTripleChecker
implements IHoareTripleChecker {
    private static final String PREFIX = String.valueOf(DebuggingHoareTripleChecker.class.getSimpleName()) + "_";
    private static final String ANNOT_NAMED = ":named";
    private static final String ID_PRECONDITION = String.valueOf(PREFIX) + "precond";
    private static final String ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY = String.valueOf(PREFIX) + "precondNonModGlobalEquality";
    private static final String ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY = String.valueOf(PREFIX) + "modifiableVarEquality";
    private static final String ID_LOCAL_VARS_ASSIGNMENT = String.valueOf(PREFIX) + "localVarsAssignment";
    private static final String ID_HIERACHICAL_PRECONDITION = String.valueOf(PREFIX) + "hierarchicalPrecondition";
    private static final String ID_NEGATED_POSTCONDITION = String.valueOf(PREFIX) + "notPostcond";
    private static final String MSG_START_EDGE_CHECK = String.valueOf(PREFIX) + "Start";
    private static final String MSG_END_EDGE_CHECK = String.valueOf(PREFIX) + "End";
    private static final boolean SIMPLIFY_IF_ASSERTION_FAILS = true;
    private final ManagedScript mManagedScript;
    private final ModifiableGlobalsTable mModifiableGlobalVariableManager;
    private final OldVarsAssignmentCache mOldVarsAssignmentCache;
    private ScopedHashMap<IProgramVar, Term> mHierConstants;
    private final Deque<Assertion> mAssertions;
    private final ILogger mLogger;
    private final IUltimateServiceProvider mServices;
    private IncrementalPlicationChecker.Validity mExpected;
    private boolean mIsLastOk;
    private final boolean mGenerateUnsatCore;

    public DebuggingHoareTripleChecker(IUltimateServiceProvider services, ILogger logger, CfgSmtToolkit csToolkit, IncrementalPlicationChecker.Validity expected) {
        this.mLogger = logger;
        this.mServices = services;
        this.mManagedScript = csToolkit.getManagedScript();
        this.mModifiableGlobalVariableManager = csToolkit.getModifiableGlobalsTable();
        this.mOldVarsAssignmentCache = csToolkit.getOldVarsAssignmentCache();
        this.mAssertions = new ArrayDeque<Assertion>();
        this.mExpected = expected;
        Object val = this.mManagedScript.getScript().getOption(":produce-unsat-cores");
        this.mGenerateUnsatCore = Boolean.parseBoolean(val.toString());
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        throw new UnsupportedOperationException(String.valueOf(this.getClass().getName()) + " does not support getEdgeCheckerBenchmark()");
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate post) {
        return this.checkValidity(this.mExpected, act, pre, post, null, () -> this.assertAction(act), () -> this.assertPrecondition(pre), () -> this.assertPostcondInternal(post));
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate post) {
        return this.checkValidity(this.mExpected, act, pre, post, null, () -> this.assertAction(act), () -> this.assertPrecondition(pre), () -> this.assertPostcondCall(post));
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate linPre, IPredicate hierPre, IReturnAction act, IPredicate postcond) {
        return this.checkValidity(this.mExpected, act, linPre, postcond, hierPre, () -> this.assertAction(act), () -> this.assertPrecondition(linPre), () -> this.assertHierPred(hierPre), () -> this.assertPostcondReturn(postcond));
    }

    public boolean isLastOk() {
        return this.mIsLastOk;
    }

    public void setExpected(IncrementalPlicationChecker.Validity expected) {
        this.mExpected = expected;
    }

    public void releaseLock() {
        this.clearAssertionStack();
    }

    @SafeVarargs
    private final IncrementalPlicationChecker.Validity checkValidity(IncrementalPlicationChecker.Validity expected, IAction transition, IPredicate precond, IPredicate postcond, IPredicate precondHier, Supplier<Script.LBool> ... funs) {
        Supplier<Script.LBool>[] supplierArray = funs;
        int n = funs.length;
        int n2 = 0;
        while (n2 < n) {
            Supplier<Script.LBool> fun = supplierArray[n2];
            Script.LBool quickCheckResult = fun.get();
            if (quickCheckResult == Script.LBool.UNSAT) {
                return this.checkValidity(expected, IncrementalPlicationChecker.Validity.VALID, transition, precond, postcond, precondHier);
            }
            ++n2;
        }
        Script.LBool isSat = this.mManagedScript.checkSat((Object)this);
        return this.checkValidity(expected, IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)isSat), transition, precond, postcond, precondHier);
    }

    private IncrementalPlicationChecker.Validity checkValidity(IncrementalPlicationChecker.Validity expected, IncrementalPlicationChecker.Validity actual, IAction transition, IPredicate precond, IPredicate postcond, IPredicate precondHier) {
        if (expected == IncrementalPlicationChecker.Validity.NOT_CHECKED || expected == actual) {
            this.mIsLastOk = true;
            this.clearAssertionStack();
            return actual;
        }
        if (actual == IncrementalPlicationChecker.Validity.UNKNOWN) {
            this.mIsLastOk = true;
            this.logUnsoundness(transition, precond, postcond, precondHier, expected, actual);
            this.clearAssertionStack();
            return actual;
        }
        this.mIsLastOk = false;
        this.logUnsoundness(transition, precond, postcond, precondHier, expected, actual);
        this.clearAssertionStack();
        return actual;
    }

    /*
     * Unable to fully structure code
     */
    private void logUnsoundness(IAction transition, IPredicate precond, IPredicate postcond, IPredicate precondHier, IncrementalPlicationChecker.Validity expected, IncrementalPlicationChecker.Validity actual) {
        if (actual == IncrementalPlicationChecker.Validity.UNKNOWN) ** GOTO lbl6
        if (expected == IncrementalPlicationChecker.Validity.UNKNOWN) {
lbl6:
            // 2 sources

            log = (Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, warn(java.lang.Object ), (Ljava/lang/Object;)V)((ILogger)this.mLogger);
        } else {
            log = (Consumer<Object>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, fatal(java.lang.Object ), (Ljava/lang/Object;)V)((ILogger)this.mLogger);
        }
        if (actual == IncrementalPlicationChecker.Validity.UNKNOWN) {
            log.accept("Soundness check inconclusive for the following hoare triple");
        } else {
            log.accept("Soundness check failed for the following hoare triple");
        }
        log.accept("Expected: " + expected + " Actual: " + actual);
        script = this.mManagedScript.getScript();
        log.accept("Solver was " + script.getInfo(":name") + " in version " + script.getInfo(":version"));
        strActions = this.getActionStrings();
        log.accept("--");
        log.accept("Pre:       {" + DebuggingHoareTripleChecker.toString(precond) + "}");
        if (precondHier != null) {
            log.accept("PreHier:   {" + DebuggingHoareTripleChecker.toString(precondHier) + "}");
        }
        log.accept("Action:    " + transition);
        strActions.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$12(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).forEachOrdered((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, accept(T ), (Ljava/lang/String;)V)(log));
        log.accept("Post:      {" + DebuggingHoareTripleChecker.toString(postcond) + "}");
        if (this.mGenerateUnsatCore) {
            if (actual == IncrementalPlicationChecker.Validity.VALID) {
                log.accept("--");
                unsatCore = this.mManagedScript.getUnsatCore((Object)this);
                log.accept("Unsat core");
                var17_12 = unsatCore;
                var16_14 = unsatCore.length;
                var15_16 = 0;
                while (var15_16 < var16_14) {
                    part = var17_12[var15_16];
                    log.accept(part.toStringDirect());
                    ++var15_16;
                }
            } else if (actual == IncrementalPlicationChecker.Validity.INVALID) {
                log.accept("--");
                log.accept("Model of prestate for invars");
                actTf = this.getAction().getTransformula();
                selectFinder = new ApplicationTermFinder(Collections.singleton("select"), false);
                selects = selectFinder.findMatchingSubterms(actTf.getClosedFormula());
                for (Map.Entry<IProgramVar, TermVariable> entry : actTf.getInVars().entrySet()) {
                    key = entry.getKey();
                    tv = key.getTermVariable();
                    inVarConst = UnmodifiableTransFormula.getConstantForInVar(key);
                    this.logUnsoundnessStateVar(log, selects, tv, inVarConst);
                }
                log.accept("Model of poststate for outvars");
                for (Map.Entry<IProgramVar, TermVariable> entry : actTf.getOutVars().entrySet()) {
                    key = entry.getKey();
                    tv = key.getTermVariable();
                    outVarConst = UnmodifiableTransFormula.getConstantForOutVar(key, actTf.getInVars(), actTf.getOutVars());
                    this.logUnsoundnessStateVar(log, selects, tv, outVarConst);
                }
            }
        } else {
            log.accept("unsat core / model generation is disabled, enable it to get more details");
        }
        this.clearAssertionStack();
        log.accept("--");
        log.accept("Simplified triple ");
        log.accept("Pre:       {" + this.toStringSimplified(precond) + "}");
        if (precondHier != null) {
            log.accept("PreHier:   {" + this.toStringSimplified(precondHier) + "}");
        }
        log.accept("Action:    " + transition);
        strActions.stream().map((Function<String, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$14(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)()).forEachOrdered((Consumer<String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, accept(T ), (Ljava/lang/String;)V)(log));
        log.accept("Post:      {" + this.toStringSimplified(postcond) + "}");
    }

    private void logUnsoundnessStateVar(Consumer<Object> log, Set<ApplicationTerm> selects, TermVariable tv, Term varConst) {
        if (SmtUtils.isSortForWhichWeCanGetValues((Sort)tv.getSort())) {
            Map values = this.mManagedScript.getValue((Object)this, new Term[]{varConst});
            log.accept(varConst + " = " + ((Term)values.get(varConst)).toStringDirect());
        } else if (SmtSortUtils.isArraySort((Sort)tv.getSort())) {
            selects.stream().filter(a -> a.getParameters()[0] == varConst).forEachOrdered(s -> {
                Map values = this.mManagedScript.getValue((Object)this, new Term[]{s});
                log.accept(String.valueOf(s.toStringDirect()) + "=" + ((Term)values.get(s)).toStringDirect());
            });
        } else {
            log.accept(varConst + " = ?");
        }
    }

    private static String toString(IPredicate pred) {
        return String.valueOf(pred.hashCode()) + "#" + pred.getClosedFormula().toStringDirect();
    }

    private List<String> getActionStrings() {
        return this.mAssertions.stream().filter(a -> a.getOrigin() instanceof IAction).map(a -> a.getTerm().toStringDirect()).collect(Collectors.toList());
    }

    private String toStringSimplified(IPredicate pred) {
        Term formula = pred.getFormula();
        String pre = String.valueOf(pred.hashCode()) + "#";
        if (formula instanceof QuantifiedFormula) {
            return String.valueOf(pre) + PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)formula).toStringDirect();
        }
        return String.valueOf(pre) + SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)pred.getFormula(), (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA).toStringDirect();
    }

    private void clearAssertionStack() {
        if (this.mAssertions.isEmpty()) {
            return;
        }
        Iterator<Assertion> iter = this.mAssertions.iterator();
        while (iter.hasNext()) {
            iter.next();
            iter.remove();
            this.mManagedScript.pop((Object)this, 1);
        }
        this.mHierConstants = null;
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_END_EDGE_CHECK));
        this.mManagedScript.unlock((Object)this);
    }

    private Script.LBool assertAction(IAction act) {
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_START_EDGE_CHECK));
        Supplier<Term> actSupplier = () -> {
            if (act instanceof IInternalAction) {
                return ((IInternalAction)act).getTransformula().getClosedFormula();
            }
            if (act instanceof ICallAction) {
                return ((ICallAction)act).getLocalVarsAssignment().getClosedFormula();
            }
            if (act instanceof IReturnAction) {
                return ((IReturnAction)act).getAssignmentOfReturn().getClosedFormula();
            }
            throw new AssertionError((Object)"unknown action");
        };
        Script.LBool quickCheck = this.pushAssertion(act, actSupplier);
        if (act instanceof IReturnAction) {
            IReturnAction ret = (IReturnAction)act;
            String proc = ret.getPrecedingProcedure();
            UnmodifiableTransFormula ovaTF = this.mOldVarsAssignmentCache.getOldVarsAssignment(proc);
            Supplier<Term> ovaSupplier = () -> {
                this.mHierConstants = new ScopedHashMap();
                Term ovaFormula = ovaTF.getFormula();
                ovaFormula = this.renameVarsToHierConstants(ovaTF.getInVars(), ovaFormula);
                ovaFormula = this.renameVarsToDefaultConstants(ovaTF.getOutVars(), ovaFormula);
                assert (ovaFormula.getFreeVars().length == 0);
                return this.mManagedScript.annotate((Object)this, ovaFormula, new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY)});
            };
            quickCheck = this.pushAssertion(act, ovaSupplier);
            Supplier<Term> locVarAssignSupplier = () -> {
                Set<IProgramVar> modifiableGlobals = ovaTF.getInVars().keySet();
                UnmodifiableTransFormula callTf = ret.getLocalVarsAssignmentOfCall();
                Term locVarAssign = callTf.getFormula();
                locVarAssign = this.renameNonModifiableGlobalsToDefaultConstants(callTf.getInVars(), modifiableGlobals, locVarAssign);
                locVarAssign = this.renameVarsToHierConstants(callTf.getInVars(), locVarAssign);
                locVarAssign = this.renameVarsToDefaultConstants(callTf.getOutVars(), locVarAssign);
                locVarAssign = this.renameAuxVarsToCorrespondingConstants(callTf.getAuxVars(), locVarAssign);
                assert (locVarAssign.getFreeVars().length == 0);
                return this.mManagedScript.annotate((Object)this, locVarAssign, new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_LOCAL_VARS_ASSIGNMENT)});
            };
            quickCheck = this.pushAssertion(act, locVarAssignSupplier);
        }
        return quickCheck;
    }

    private Script.LBool assertPrecondition(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Script.LBool quickCheck = this.pushAssertion(p, () -> this.mManagedScript.annotate((Object)this, p.getClosedFormula(), new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION)}));
        String predProc = this.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(predProc);
        Collection<Term> oldVarEqualities = DebuggingHoareTripleChecker.constructNonModOldVarsEquality(p.getVars(), modifiableGlobals, this.mManagedScript, this);
        if (!oldVarEqualities.isEmpty()) {
            quickCheck = this.pushAssertion(p, () -> this.mManagedScript.annotate((Object)this, SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])oldVarEqualities.toArray(new Term[oldVarEqualities.size()])), new Annotation[]{new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY)}));
        }
        return quickCheck;
    }

    private Script.LBool assertHierPred(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> fun = () -> {
            this.mHierConstants.beginScope();
            Term hierFormula = p.getFormula();
            String callee = this.getPrecedingProcedure();
            Set<IProgramNonOldVar> modifiableGlobalsCallee = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(callee);
            hierFormula = this.renameNonModifiableNonOldGlobalsToDefaultConstants(p.getVars(), modifiableGlobalsCallee, hierFormula);
            String caller = this.getSucceedingProcedure();
            Set<IProgramNonOldVar> modifiableGlobalsCaller = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(caller);
            hierFormula = DebuggingHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(p.getVars(), modifiableGlobalsCaller, hierFormula, this.mManagedScript, this);
            hierFormula = this.renameVarsToHierConstants(p.getVars(), hierFormula);
            assert (hierFormula.getFreeVars().length == 0);
            Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_HIERACHICAL_PRECONDITION);
            return this.mManagedScript.annotate((Object)this, hierFormula, new Annotation[]{annot});
        };
        return this.pushAssertion(p, fun);
    }

    private Script.LBool assertPostcondInternal(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> fun = () -> {
            Term renamedFormula = DebuggingHoareTripleChecker.constructPostcondFormula(p, this.getInternalAction(), this.mModifiableGlobalVariableManager, this.mManagedScript, this);
            assert (renamedFormula.getFreeVars().length == 0);
            Term negation = this.mManagedScript.term((Object)this, "not", new Term[]{renamedFormula});
            Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
            return this.mManagedScript.annotate((Object)this, negation, new Annotation[]{annot});
        };
        return this.pushAssertion(p, fun);
    }

    private Script.LBool assertPostcondCall(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> fun = () -> {
            Set<IProgramVar> boogieVars = p.getVars();
            Term renamedFormula = this.renameGlobalsAndOldVarsToNonOldDefaultConstants(boogieVars, p.getFormula());
            renamedFormula = DebuggingHoareTripleChecker.renameVarsToPrimedConstants(boogieVars, renamedFormula, this.mManagedScript, this);
            renamedFormula = DebuggingHoareTripleChecker.renameVarsToDefaultConstants(p.getVars(), renamedFormula, this.mManagedScript, this);
            assert (renamedFormula.getFreeVars().length == 0);
            Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
            return this.mManagedScript.annotate((Object)this, this.mManagedScript.term((Object)this, "not", new Term[]{renamedFormula}), new Annotation[]{annot});
        };
        return this.pushAssertion(p, fun);
    }

    private Script.LBool assertPostcondReturn(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        Supplier<Term> fun = () -> {
            this.mHierConstants.beginScope();
            Set<IProgramVar> assignedVars = this.getAssignmentOfReturn().getAssignedVars();
            Term renamedFormula = DebuggingHoareTripleChecker.renameVarsToPrimedConstants(assignedVars, p.getFormula(), this.mManagedScript, this);
            String callee = this.getPrecedingProcedure();
            Set<IProgramNonOldVar> modifiableGlobalsCallee = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(callee);
            renamedFormula = DebuggingHoareTripleChecker.renameVarsToDefaultConstants(modifiableGlobalsCallee, renamedFormula, this.mManagedScript, this);
            renamedFormula = this.renameNonModifiableNonOldGlobalsToDefaultConstants(p.getVars(), modifiableGlobalsCallee, renamedFormula);
            String caller = this.getSucceedingProcedure();
            Set<IProgramNonOldVar> modifiableGlobalsCaller = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(caller);
            renamedFormula = DebuggingHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(p.getVars(), modifiableGlobalsCaller, renamedFormula, this.mManagedScript, this);
            renamedFormula = this.renameVarsToHierConstants(p.getVars(), renamedFormula);
            assert (renamedFormula.getFreeVars().length == 0);
            Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
            return this.mManagedScript.annotate((Object)this, this.mManagedScript.term((Object)this, "not", new Term[]{renamedFormula}), new Annotation[]{annot});
        };
        return this.pushAssertion(p, fun);
    }

    private static Collection<Term> constructNonModOldVarsEquality(Set<IProgramVar> vars, Set<IProgramNonOldVar> oldVarsOfModifiableGlobals, ManagedScript mgdScript, Object lock) {
        ArrayList<Term> conjunction = new ArrayList<Term>();
        for (IProgramVar bv : vars) {
            IProgramNonOldVar pnov;
            if (!(bv instanceof IProgramOldVar) || oldVarsOfModifiableGlobals.contains(pnov = ((IProgramOldVar)bv).getNonOldVar())) continue;
            conjunction.add(DebuggingHoareTripleChecker.oldVarsEquality((IProgramOldVar)bv, mgdScript, lock));
        }
        return conjunction;
    }

    private static Term oldVarsEquality(IProgramOldVar oldVar, ManagedScript mgdScript, Object lock) {
        assert (oldVar.isOldvar());
        IProgramNonOldVar nonOldVar = oldVar.getNonOldVar();
        Term equality = mgdScript.term(lock, "=", new Term[]{oldVar.getDefaultConstant(), nonOldVar.getDefaultConstant()});
        return equality;
    }

    private Script.LBool pushAssertion(Object origin, Supplier<Term> formulaSupplier) {
        this.mManagedScript.push((Object)this, 1);
        Term formula = formulaSupplier.get();
        Script.LBool quickCheck = this.mManagedScript.assertTerm((Object)this, formula);
        this.mAssertions.push(new Assertion(formula, origin, quickCheck));
        return quickCheck;
    }

    private static Term constructPostcondFormula(IPredicate p, IInternalAction action, ModifiableGlobalsTable mgt, ManagedScript mgdScript, Object lock) {
        Set<IProgramVar> assignedVars = action.getTransformula().getAssignedVars();
        Term renamedFormula = DebuggingHoareTripleChecker.renameVarsToPrimedConstants(assignedVars, p.getFormula(), mgdScript, lock);
        String succProc = action.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = mgt.getModifiedBoogieVars(succProc);
        renamedFormula = DebuggingHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(p.getVars(), modifiableGlobals, renamedFormula, mgdScript, lock);
        renamedFormula = DebuggingHoareTripleChecker.renameVarsToDefaultConstants(p.getVars(), renamedFormula, mgdScript, lock);
        return renamedFormula;
    }

    private static Term renameVarsToDefaultConstants(Set<? extends IProgramVar> set, Term formula, ManagedScript managedScript, Object lock) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar iProgramVar : set) {
            replacees.add(iProgramVar.getTermVariable());
            replacers.add(iProgramVar.getDefaultConstant());
        }
        TermVariable[] termVariableArray = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return managedScript.let(lock, termVariableArray, values, formula);
    }

    private Term renameVarsToDefaultConstants(Map<IProgramVar, TermVariable> bv2tv, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> bv : bv2tv.entrySet()) {
            replacees.add(bv.getValue());
            replacers.add(bv.getKey().getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private static Term renameVarsToPrimedConstants(Set<IProgramVar> boogieVars, Term formula, ManagedScript managedScript, Object lock) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            replacees.add(bv.getTermVariable());
            replacers.add(bv.getPrimedConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return managedScript.let(lock, vars, values, formula);
    }

    private Term renameVarsToHierConstants(Set<IProgramVar> boogieVars, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<Term> replacers = new ArrayList<Term>();
        for (IProgramVar bv : boogieVars) {
            replacees.add(bv.getTermVariable());
            replacers.add(this.getOrConstructHierConstant(bv));
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term renameVarsToHierConstants(Map<IProgramVar, TermVariable> bv2tv, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<Term> replacers = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : bv2tv.entrySet()) {
            replacees.add(entry.getValue());
            replacers.add(this.getOrConstructHierConstant(entry.getKey()));
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term renameAuxVarsToCorrespondingConstants(Set<TermVariable> auxVars, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<Term> replacers = new ArrayList<Term>();
        for (TermVariable auxVarTv : auxVars) {
            replacees.add(auxVarTv);
            Term correspondingConstant = this.mManagedScript.term((Object)this, ProgramVarUtils.generateConstantIdentifierForAuxVar(auxVarTv), new Term[0]);
            replacers.add(correspondingConstant);
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term getOrConstructHierConstant(IProgramVar bv) {
        Term preHierConstant = (Term)this.mHierConstants.get((Object)bv);
        if (preHierConstant == null) {
            String name = "c_" + bv.getTermVariable().getName() + "_Hier";
            Sort sort = bv.getTermVariable().getSort();
            this.mManagedScript.declareFun((Object)this, name, new Sort[0], sort);
            preHierConstant = this.mManagedScript.term((Object)this, name, new Term[0]);
            this.mHierConstants.put((Object)bv, (Object)preHierConstant);
        }
        return preHierConstant;
    }

    private Term renameNonModifiableNonOldGlobalsToDefaultConstants(Set<IProgramVar> boogieVars, Set<IProgramNonOldVar> modifiableGlobalsCallee, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            if (!bv.isGlobal() || !(bv instanceof IProgramNonOldVar) || modifiableGlobalsCallee.contains(bv)) continue;
            replacees.add(bv.getTermVariable());
            replacers.add(bv.getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private static Term renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(Set<IProgramVar> boogieVars, Set<IProgramNonOldVar> modifiableGlobalsCaller, Term formula, ManagedScript mgdScript, Object lock) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            IProgramNonOldVar nonOldVar;
            if (!(bv instanceof IProgramOldVar) || modifiableGlobalsCaller.contains(nonOldVar = ((IProgramOldVar)bv).getNonOldVar())) continue;
            replacees.add(bv.getTermVariable());
            replacers.add(nonOldVar.getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return mgdScript.let(lock, vars, values, formula);
    }

    private Term renameNonModifiableGlobalsToDefaultConstants(Map<IProgramVar, TermVariable> boogieVars, Set<IProgramVar> modifiableGlobals, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> entry : boogieVars.entrySet()) {
            IProgramVar bv = entry.getKey();
            if (bv.isGlobal()) {
                if (bv.isOldvar()) {
                    assert (!modifiableGlobals.contains(bv));
                    continue;
                }
                if (modifiableGlobals.contains(bv)) continue;
                replacees.add(entry.getValue());
                replacers.add(bv.getDefaultConstant());
                continue;
            }
            assert (!modifiableGlobals.contains(bv));
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term renameGlobalsAndOldVarsToNonOldDefaultConstants(Set<IProgramVar> boogieVars, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            if (!bv.isGlobal()) continue;
            if (bv.isOldvar()) {
                replacees.add(bv.getTermVariable());
                IProgramNonOldVar nonOldbv = ((IProgramOldVar)bv).getNonOldVar();
                replacers.add(nonOldbv.getDefaultConstant());
                continue;
            }
            replacees.add(bv.getTermVariable());
            replacers.add(bv.getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private IAction getAction() {
        Optional<Assertion> result = this.mAssertions.stream().filter(a -> a.getOrigin() instanceof IAction).findFirst();
        if (result.isPresent()) {
            return (IAction)result.get().getOrigin();
        }
        throw new AssertionError((Object)"No action");
    }

    private IInternalAction getInternalAction() {
        IAction action = this.getAction();
        if (action instanceof IInternalAction) {
            return (IInternalAction)action;
        }
        throw new AssertionError((Object)"No internal action");
    }

    private String getSucceedingProcedure() {
        return this.getAction().getSucceedingProcedure();
    }

    private String getPrecedingProcedure() {
        return this.getAction().getPrecedingProcedure();
    }

    private UnmodifiableTransFormula getAssignmentOfReturn() {
        IAction action = this.getAction();
        if (action instanceof IReturnAction) {
            return ((IReturnAction)action).getAssignmentOfReturn();
        }
        throw new AssertionError((Object)"No return action");
    }

    private static /* synthetic */ String lambda$12(String a) {
        return "ActionStr: " + a;
    }

    private static /* synthetic */ String lambda$14(String a) {
        return "ActionStr: " + a;
    }

    private static final class Assertion {
        private final Term mTerm;
        private final Object mOrigin;
        private final Script.LBool mResult;

        public Assertion(Term term, Object origin, Script.LBool quickCheckResult) {
            this.mTerm = term;
            this.mOrigin = origin;
            this.mResult = quickCheckResult;
        }

        public Term getTerm() {
            return this.mTerm;
        }

        public Object getOrigin() {
            return this.mOrigin;
        }

        public Script.LBool getResult() {
            return this.mResult;
        }
    }
}

