/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsType;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public final class HoareTripleCheckerStatisticsType
implements IStatisticsType {
    private static final HoareTripleCheckerStatisticsType INSTANCE = new HoareTripleCheckerStatisticsType();
    private final Map<String, Function<Object, Function<Object, Object>>> mAggrFuns = new LinkedHashMap<String, Function<Object, Function<Object, Object>>>();
    private final Map<String, Function<String, Function<Object, String>>> mPrintFuns = new LinkedHashMap<String, Function<String, Function<Object, String>>>();

    private HoareTripleCheckerStatisticsType() {
        IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions[] hoareTripleCheckerStatisticsDefinitionsArray = IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions.values();
        int n = hoareTripleCheckerStatisticsDefinitionsArray.length;
        int n2 = 0;
        while (n2 < n) {
            IHoareTripleChecker.HoareTripleCheckerStatisticsDefinitions val = hoareTripleCheckerStatisticsDefinitionsArray[n2];
            this.registerKey(val.name(), x -> y -> val.aggregate(x, y), x -> val::prettyprint);
            ++n2;
        }
    }

    public static HoareTripleCheckerStatisticsType getInstance() {
        return INSTANCE;
    }

    public Collection<String> getKeys() {
        return this.mPrintFuns.keySet();
    }

    public void registerKey(String key, Function<Object, Function<Object, Object>> funAggregate, Function<String, Function<Object, String>> funPrettyPrint) {
        Function<Object, Function<Object, Object>> oldAgr = this.mAggrFuns.put(key, funAggregate);
        if (oldAgr != null) {
            throw new IllegalArgumentException();
        }
        Function<String, Function<Object, String>> oldPrint = this.mPrintFuns.put(key, funPrettyPrint);
        if (oldPrint != null) {
            throw new IllegalArgumentException();
        }
    }

    public Object aggregate(String key, Object value1, Object value2) {
        Function<Object, Function<Object, Object>> fun = this.mAggrFuns.get(key);
        if (fun == null) {
            throw new IllegalStateException(String.format("Key %s is unknown", key));
        }
        return fun.apply(value1).apply(value2);
    }

    public String prettyprintBenchmarkData(IStatisticsDataProvider benchmarkData) {
        StringBuilder sb = new StringBuilder();
        Iterator<Map.Entry<String, Function<String, Function<Object, String>>>> iter = this.mPrintFuns.entrySet().iterator();
        sb.append(this.getClass().getSimpleName());
        sb.append(" [");
        while (iter.hasNext()) {
            Map.Entry<String, Function<String, Function<Object, String>>> entry = iter.next();
            Object value = benchmarkData.getValue(entry.getKey());
            sb.append(entry.getValue().apply(entry.getKey()).apply(value));
            if (!iter.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

