/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.CachingHoareTripleCheckerMap;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.ChainingHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.MonolithicHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubtermPropertyChecker;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import java.util.function.Predicate;

public final class HoareTripleCheckerUtils {
    private static final boolean REVIEW_SMT_RESULTS_IF_ASSERTIONS_ENABLED = true;
    private static final boolean REVIEW_SD_RESULTS_IF_ASSERTIONS_ENABLED = true;

    private HoareTripleCheckerUtils() {
    }

    public static ChainingHoareTripleChecker constructEfficientHoareTripleChecker(IUltimateServiceProvider services, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit csToolkit, IPredicateUnifier unifier) {
        ILogger logger = services.getLoggingService().getLogger(HoareTripleCheckerUtils.class);
        ChainingHoareTripleChecker sdHtc = HoareTripleCheckerUtils.constructSdHoareTripleChecker(logger, csToolkit, unifier);
        ChainingHoareTripleChecker solverHtc = HoareTripleCheckerUtils.constructSmtHoareTripleChecker(logger, hoareTripleChecks, csToolkit, unifier);
        return sdHtc.andThen(solverHtc);
    }

    public static ChainingHoareTripleChecker constructSdHoareTripleChecker(ILogger logger, CfgSmtToolkit csToolkit, IPredicateUnifier unifier) {
        ChainingHoareTripleChecker chain = ChainingHoareTripleChecker.with(logger, new SdHoareTripleChecker(csToolkit, unifier));
        chain = chain.reviewWith(new MonolithicHoareTripleChecker(csToolkit));
        return chain;
    }

    public static ChainingHoareTripleChecker constructSmtHoareTripleChecker(ILogger logger, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit csToolkit, IPredicateUnifier unifier) {
        IHoareTripleChecker solverHtc;
        switch (hoareTripleChecks) {
            case MONOLITHIC: {
                solverHtc = new MonolithicHoareTripleChecker(csToolkit);
                break;
            }
            case INCREMENTAL: {
                solverHtc = new IncrementalHoareTripleChecker(csToolkit, false);
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown value " + (Object)((Object)hoareTripleChecks));
            }
        }
        ChainingHoareTripleChecker chain = ChainingHoareTripleChecker.with(logger, solverHtc);
        SubtermPropertyChecker quantifierFinder = new SubtermPropertyChecker(QuantifiedFormula.class::isInstance);
        Predicate<IPredicate> noIntricateNoQuantifier = p -> unifier.isIntricatePredicate((IPredicate)p) || quantifierFinder.isSatisfiedBySomeSubterm(p.getFormula());
        Predicate<IAction> noQuantifier = a -> quantifierFinder.isSatisfiedBySomeSubterm(a.getTransformula().getFormula());
        chain = chain.predicatesProtectedBy(noIntricateNoQuantifier).actionsProtectedBy(noQuantifier);
        chain = chain.reviewWith(new MonolithicHoareTripleChecker(csToolkit));
        return chain;
    }

    public static IHoareTripleChecker constructEfficientHoareTripleCheckerWithCaching(IUltimateServiceProvider services, HoareTripleChecks hoareTripleChecks, CfgSmtToolkit csToolkit, IPredicateUnifier predicateUnifier) {
        return new CachingHoareTripleCheckerMap(services, HoareTripleCheckerUtils.constructEfficientHoareTripleChecker(services, hoareTripleChecks, csToolkit, predicateUnifier), predicateUnifier);
    }

    public static enum HoareTripleChecks {
        MONOLITHIC,
        INCREMENTAL;

    }
}

