/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IncrementalHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class HoareTripleCheckerWithPreconditionRelevanceAnalysis
extends IncrementalHoareTripleChecker {
    private List<IPredicate> mAssertedPrecond;

    public HoareTripleCheckerWithPreconditionRelevanceAnalysis(CfgSmtToolkit csToolkit, ILogger logger) {
        super(csToolkit, false);
    }

    private Script.LBool assertPrecondition(List<IPredicate> pres) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first";
        assert (this.mAssertedPrecond == null) : "precond already asserted";
        this.mAssertedPrecond = pres;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        Script.LBool quickCheck = null;
        HashSet<IProgramVar> vars = new HashSet<IProgramVar>();
        int i = 0;
        while (i < pres.size()) {
            Term predcondition = pres.get(i).getClosedFormula();
            Annotation annot = new Annotation(":named", (Object)this.getIdentifierForPrecond(i));
            predcondition = this.mManagedScript.annotate((Object)this, predcondition, new Annotation[]{annot});
            quickCheck = this.mManagedScript.assertTerm((Object)this, predcondition);
            vars.addAll(pres.get(i).getVars());
            ++i;
        }
        String predProc = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(predProc);
        Collection<Term> oldVarEqualities = HoareTripleCheckerWithPreconditionRelevanceAnalysis.constructNonModOldVarsEquality(vars, modifiableGlobals, this.mManagedScript, this);
        if (!oldVarEqualities.isEmpty()) {
            Term nonModOldVarsEquality = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])oldVarEqualities.toArray(new Term[oldVarEqualities.size()]));
            Annotation annot = new Annotation(":named", (Object)"precondNonModGlobalEquality");
            nonModOldVarsEquality = this.mManagedScript.annotate((Object)this, nonModOldVarsEquality, new Annotation[]{annot});
            quickCheck = this.mManagedScript.assertTerm((Object)this, nonModOldVarsEquality);
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return quickCheck;
    }

    private String getIdentifierForPrecond(int i) {
        return "precondition" + i;
    }

    private void unAssertPrecondition() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null) : "No PrePred asserted";
        this.mAssertedPrecond = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedAction == null) {
            throw new AssertionError((Object)"CodeBlock is assigned first");
        }
    }

    public Pair<IncrementalPlicationChecker.Validity, List<IPredicate>> checkInternal(List<IPredicate> pre, IInternalAction act, IPredicate post) {
        this.assertCodeBlock(act);
        this.assertPrecondition(pre);
        this.assertPostcond(post);
        IncrementalPlicationChecker.Validity validity = this.checkValidity();
        List<IPredicate> preconditionsInUnsatCore = validity == IncrementalPlicationChecker.Validity.VALID ? this.determinePreconditionsInUnsatCore() : null;
        this.unAssertPostcondition();
        this.unAssertPrecondition();
        this.unAssertCodeBlock();
        return new Pair((Object)validity, preconditionsInUnsatCore);
    }

    private List<IPredicate> determinePreconditionsInUnsatCore() {
        Term[] unsatCore = this.mManagedScript.getUnsatCore((Object)this);
        HashSet<String> idsInUnsatCore = new HashSet<String>();
        Term[] termArray = unsatCore;
        int n = unsatCore.length;
        int n2 = 0;
        while (n2 < n) {
            Term term = termArray[n2];
            ApplicationTerm appTerm = (ApplicationTerm)term;
            idsInUnsatCore.add(appTerm.getFunction().getApplicationString());
            ++n2;
        }
        ArrayList<IPredicate> result = new ArrayList<IPredicate>();
        int i = 0;
        while (i < this.mAssertedPrecond.size()) {
            if (idsInUnsatCore.contains(this.getIdentifierForPrecond(i))) {
                result.add(this.mAssertedPrecond.get(i));
            }
            ++i;
        }
        return result;
    }

    public Pair<IncrementalPlicationChecker.Validity, List<IPredicate>> checkCall(List<IPredicate> pre, ICallAction act, IPredicate post) {
        this.assertCodeBlock(act);
        this.assertPrecondition(pre);
        this.assertPostcond(post);
        IncrementalPlicationChecker.Validity validity = this.checkValidity();
        List<IPredicate> preconditionsInUnsatCore = validity == IncrementalPlicationChecker.Validity.VALID ? this.determinePreconditionsInUnsatCore() : null;
        this.unAssertPostcondition();
        this.unAssertPrecondition();
        this.unAssertCodeBlock();
        return new Pair((Object)validity, preconditionsInUnsatCore);
    }

    public Pair<IncrementalPlicationChecker.Validity, List<IPredicate>> checkReturn(List<IPredicate> linPre, IPredicate hierPre, IReturnAction act, IPredicate post) {
        this.assertCodeBlock(act);
        this.assertPrecondition(linPre);
        this.assertHierPred(hierPre);
        this.assertPostcond(post);
        IncrementalPlicationChecker.Validity validity = this.checkValidity();
        List<IPredicate> preconditionsInUnsatCore = validity == IncrementalPlicationChecker.Validity.VALID ? this.determinePreconditionsInUnsatCore() : null;
        this.unAssertPostcondition();
        this.unAssertHierPred();
        this.unAssertPrecondition();
        this.unAssertCodeBlock();
        return new Pair((Object)validity, preconditionsInUnsatCore);
    }
}

