/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.core.model.translation.IProgramExecution;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.OldVarsAssignmentCache;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.GlobalProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SubTermFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class IncrementalHoareTripleChecker
implements IHoareTripleChecker {
    private static final String MSG_UNEXPECTED_QUICKCHECK_RESULT = "unexpected quickcheck result";
    private static final String MSG_WRONG_KIND_OF_ACTION = "Wrong kind of action";
    private static final String ANNOT_NAMED = ":named";
    public static final boolean UNLET_TERMS = true;
    protected static final String ID_PRECONDITION = "precondition";
    protected static final String ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY = "precondNonModGlobalEquality";
    protected static final String ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY = "modifiableVarEquality";
    protected static final String ID_TRANSITION_FORMULA = "codeBlock";
    protected static final String ID_LOCAL_VARS_ASSIGNMENT = "localVarsAssignment";
    protected static final String ID_HIERACHICAL_PRECONDITION = "hierarchicalPrecondition";
    protected static final String ID_NEGATED_POSTCONDITION = "negatedPostcondition";
    private static final String MSG_START_EDGE_CHECK = "starting to check validity of Hoare triples";
    private static final String MSG_END_EDGE_CHECK = "finished to check validity of Hoare triples";
    protected final ManagedScript mManagedScript;
    protected final ModifiableGlobalsTable mModifiableGlobalVariableManager;
    private final OldVarsAssignmentCache mOldVarsAssignmentCache;
    private IPredicate mAssertedPrecond;
    protected IPredicate mAssertedHier;
    protected IAction mAssertedAction;
    private IPredicate mAssertedPostcond;
    private ScopedHashMap<IProgramVar, Term> mHierConstants;
    public final boolean mUseNamedTerms = true;
    protected final HoareTripleCheckerStatisticsGenerator mEdgeCheckerBenchmark;
    private final boolean mConstructCounterexamples;
    private IProgramExecution.ProgramState<Term> mCounterexampleStatePrecond;
    private IProgramExecution.ProgramState<Term> mCounterexampleStatePostcond;

    public IncrementalHoareTripleChecker(CfgSmtToolkit csToolkit, boolean constructCounterexamples) {
        this.mManagedScript = csToolkit.getManagedScript();
        this.mModifiableGlobalVariableManager = csToolkit.getModifiableGlobalsTable();
        this.mOldVarsAssignmentCache = csToolkit.getOldVarsAssignmentCache();
        this.mEdgeCheckerBenchmark = new HoareTripleCheckerStatisticsGenerator();
        this.mConstructCounterexamples = constructCounterexamples;
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return this.mEdgeCheckerBenchmark;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate post) {
        Script.LBool quickCheckTrans = this.prepareAssertionStackAndAddTransition(act);
        if (quickCheckTrans == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckLinPred = this.prepareAssertionStackAndAddPrecondition(pre);
        if (quickCheckLinPred == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckPostcond = this.prepareAssertionStackAndAddPostcond(post);
        if (quickCheckPostcond == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        assert (quickCheckPostcond == Script.LBool.UNKNOWN || quickCheckPostcond == null) : "unexpected quickcheck result";
        assert (this.mAssertedPrecond == pre && this.mAssertedHier == null && this.mAssertedAction == act && this.mAssertedPostcond == post);
        return this.checkValidity();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate post) {
        Script.LBool quickCheckTrans = this.prepareAssertionStackAndAddTransition(act);
        if (quickCheckTrans == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckLinPred = this.prepareAssertionStackAndAddPrecondition(pre);
        if (quickCheckLinPred == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckPostcond = this.prepareAssertionStackAndAddPostcond(post);
        if (quickCheckPostcond == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        assert (quickCheckPostcond == Script.LBool.UNKNOWN || quickCheckPostcond == null) : "unexpected quickcheck result";
        assert (this.mAssertedPrecond == pre && this.mAssertedHier == null && this.mAssertedAction == act && this.mAssertedPostcond == post);
        return this.checkValidity();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate linPre, IPredicate hierPre, IReturnAction act, IPredicate postcond) {
        Script.LBool quickCheckTrans = this.prepareAssertionStackAndAddTransition(act);
        if (quickCheckTrans == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckLinPred = this.prepareAssertionStackAndAddPrecondition(linPre);
        if (quickCheckLinPred == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckHierPred = this.prepareAssertionStackAndAddHierpred(hierPre);
        if (quickCheckHierPred == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        Script.LBool quickCheckPostcond = this.prepareAssertionStackAndAddPostcond(postcond);
        if (quickCheckPostcond == Script.LBool.UNSAT) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        assert (quickCheckPostcond == Script.LBool.UNKNOWN || quickCheckPostcond == null) : "unexpected quickcheck result";
        assert (this.mAssertedPrecond == linPre && this.mAssertedHier == hierPre && this.mAssertedAction == act && this.mAssertedPostcond == postcond);
        return this.checkValidity();
    }

    protected Script.LBool prepareAssertionStackAndAddTransition(IAction act) {
        if (this.mAssertedAction != act) {
            if (this.mAssertedAction != null) {
                if (this.mAssertedPrecond != null) {
                    if (this.mAssertedPostcond != null) {
                        this.unAssertPostcondition();
                    }
                    if (this.mAssertedHier != null) {
                        this.unAssertHierPred();
                    }
                    this.unAssertPrecondition();
                }
                this.unAssertCodeBlock();
            }
            Script.LBool quickCheck = this.assertCodeBlock(act);
            return quickCheck;
        }
        return null;
    }

    protected Script.LBool prepareAssertionStackAndAddPrecondition(IPredicate precond) {
        if (this.mAssertedPrecond != precond) {
            if (this.mAssertedPrecond != null) {
                if (this.mAssertedPostcond != null) {
                    this.unAssertPostcondition();
                }
                if (this.mAssertedHier != null) {
                    this.unAssertHierPred();
                }
                this.unAssertPrecondition();
            }
            Script.LBool quickCheck = this.assertPrecondition(precond);
            return quickCheck;
        }
        return null;
    }

    protected Script.LBool prepareAssertionStackAndAddHierpred(IPredicate hierpred) {
        if (this.mAssertedHier != hierpred) {
            if (this.mAssertedPostcond != null) {
                this.unAssertPostcondition();
            }
            if (this.mAssertedHier != null) {
                this.unAssertHierPred();
            }
            Script.LBool quickCheck = this.assertHierPred(hierpred);
            return quickCheck;
        }
        return null;
    }

    protected Script.LBool prepareAssertionStackAndAddPostcond(IPredicate postcond) {
        if (this.mAssertedPostcond != postcond) {
            if (this.mAssertedPostcond != null) {
                this.unAssertPostcondition();
            }
            Script.LBool quickCheck = this.assertPostcond(postcond);
            return quickCheck;
        }
        return null;
    }

    protected Script.LBool assertPostcond(IPredicate postcond) {
        if (this.mAssertedAction instanceof IInternalAction) {
            return this.assertPostcondInternal(postcond);
        }
        if (this.mAssertedAction instanceof ICallAction) {
            return this.assertPostcondCall(postcond);
        }
        if (this.mAssertedAction instanceof IReturnAction) {
            return this.assertPostcondReturn(postcond);
        }
        throw new AssertionError((Object)"unknown trans type");
    }

    public void clearAssertionStack() {
        if (this.mAssertedPostcond != null) {
            this.unAssertPostcondition();
        }
        if (this.mAssertedPrecond != null) {
            this.unAssertPrecondition();
        }
        if (this.mAssertedHier != null) {
            this.unAssertHierPred();
        }
        if (this.mAssertedAction != null) {
            this.unAssertCodeBlock();
        }
    }

    public void releaseLock() {
        this.clearAssertionStack();
        assert (!this.mManagedScript.isLocked()) : "script should not be locked";
    }

    private Script.LBool assertPrecondition(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first";
        assert (this.mAssertedPrecond == null) : "precond already asserted";
        this.mAssertedPrecond = p;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        Term predcondition = p.getClosedFormula();
        Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION);
        predcondition = this.mManagedScript.annotate((Object)this, predcondition, new Annotation[]{annot});
        Script.LBool quickCheck = this.mManagedScript.assertTerm((Object)this, predcondition);
        String predProc = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(predProc);
        Collection<Term> oldVarEqualities = IncrementalHoareTripleChecker.constructNonModOldVarsEquality(p.getVars(), modifiableGlobals, this.mManagedScript, this);
        if (!oldVarEqualities.isEmpty()) {
            Term nonModOldVarsEquality = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])oldVarEqualities.toArray(new Term[oldVarEqualities.size()]));
            Annotation annot2 = new Annotation(ANNOT_NAMED, (Object)ID_PRECONDITION_NON_MOD_GLOBAL_EQUALITY);
            nonModOldVarsEquality = this.mManagedScript.annotate((Object)this, nonModOldVarsEquality, new Annotation[]{annot2});
            quickCheck = this.mManagedScript.assertTerm((Object)this, nonModOldVarsEquality);
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return quickCheck;
    }

    protected static Collection<Term> constructNonModOldVarsEquality(Set<IProgramVar> vars, Set<IProgramNonOldVar> oldVarsOfModifiableGlobals, ManagedScript mgdScript, Object lock) {
        ArrayList<Term> conjunction = new ArrayList<Term>();
        for (IProgramVar bv : vars) {
            IProgramNonOldVar pnov;
            if (!(bv instanceof IProgramOldVar) || oldVarsOfModifiableGlobals.contains(pnov = ((IProgramOldVar)bv).getNonOldVar())) continue;
            conjunction.add(IncrementalHoareTripleChecker.oldVarsEquality((IProgramOldVar)bv, mgdScript, lock));
        }
        return conjunction;
    }

    private static Term oldVarsEquality(IProgramOldVar oldVar, ManagedScript mgdScript, Object lock) {
        assert (oldVar.isOldvar());
        IProgramNonOldVar nonOldVar = oldVar.getNonOldVar();
        Term equality = mgdScript.term(lock, "=", new Term[]{oldVar.getDefaultConstant(), nonOldVar.getDefaultConstant()});
        return equality;
    }

    private void unAssertPrecondition() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null) : "No PrePred asserted";
        this.mAssertedPrecond = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedAction == null) {
            throw new AssertionError((Object)"CodeBlock is assigned first");
        }
    }

    protected Script.LBool assertCodeBlock(IAction act) {
        Term cbFormula;
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_START_EDGE_CHECK));
        assert (this.mAssertedAction == null) : "CodeBlock already asserted";
        this.mAssertedAction = act;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        if (act instanceof IInternalAction) {
            cbFormula = ((IInternalAction)act).getTransformula().getClosedFormula();
        } else if (act instanceof ICallAction) {
            cbFormula = ((ICallAction)act).getLocalVarsAssignment().getClosedFormula();
        } else if (act instanceof IReturnAction) {
            cbFormula = ((IReturnAction)act).getAssignmentOfReturn().getClosedFormula();
        } else {
            throw new AssertionError((Object)"unknown action");
        }
        Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_TRANSITION_FORMULA);
        cbFormula = this.mManagedScript.annotate((Object)this, cbFormula, new Annotation[]{annot});
        Script.LBool quickCheck = this.mManagedScript.assertTerm((Object)this, cbFormula);
        if (act instanceof IReturnAction) {
            this.mHierConstants = new ScopedHashMap();
            IReturnAction ret = (IReturnAction)act;
            String proc = ret.getPrecedingProcedure();
            UnmodifiableTransFormula ovaTF = this.mOldVarsAssignmentCache.getOldVarsAssignment(proc);
            Term ovaFormula = ovaTF.getFormula();
            ovaFormula = this.renameVarsToHierConstants(ovaTF.getInVars(), ovaFormula);
            ovaFormula = this.renameVarsToDefaultConstants(ovaTF.getOutVars(), ovaFormula);
            ovaFormula = new FormulaUnLet().unlet(ovaFormula);
            assert (ovaFormula.getFreeVars().length == 0);
            Annotation annot2 = new Annotation(ANNOT_NAMED, (Object)ID_TRANSITION_MODIFIABLE_GLOBAL_EQUALITY);
            ovaFormula = this.mManagedScript.annotate((Object)this, ovaFormula, new Annotation[]{annot2});
            quickCheck = this.mManagedScript.assertTerm((Object)this, ovaFormula);
            Set<IProgramVar> modifiableGlobals = ovaTF.getInVars().keySet();
            UnmodifiableTransFormula callTf = ret.getLocalVarsAssignmentOfCall();
            Term locVarAssign = callTf.getFormula();
            locVarAssign = this.renameNonModifiableGlobalsToDefaultConstants(callTf.getInVars(), modifiableGlobals, locVarAssign);
            locVarAssign = this.renameVarsToHierConstants(callTf.getInVars(), locVarAssign);
            locVarAssign = this.renameVarsToDefaultConstants(callTf.getOutVars(), locVarAssign);
            locVarAssign = this.renameAuxVarsToCorrespondingConstants(callTf.getAuxVars(), locVarAssign);
            locVarAssign = new FormulaUnLet().unlet(locVarAssign);
            assert (locVarAssign.getFreeVars().length == 0);
            Annotation annot3 = new Annotation(ANNOT_NAMED, (Object)ID_LOCAL_VARS_ASSIGNMENT);
            locVarAssign = this.mManagedScript.annotate((Object)this, locVarAssign, new Annotation[]{annot3});
            quickCheck = this.mManagedScript.assertTerm((Object)this, locVarAssign);
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return quickCheck;
    }

    protected void unAssertCodeBlock() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "No CodeBlock asserted";
        this.mAssertedAction = null;
        this.mHierConstants = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedPrecond != null) {
            throw new AssertionError((Object)"CodeBlock is unasserted last");
        }
        this.mManagedScript.echo((Object)this, new QuotedObject(MSG_END_EDGE_CHECK));
        this.mManagedScript.unlock((Object)this);
    }

    protected Script.LBool assertHierPred(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "assert Return first";
        assert (this.mAssertedAction instanceof IReturnAction) : "assert Return first";
        assert (this.mAssertedPrecond != null) : "assert precond fist";
        assert (this.mAssertedHier == null) : "HierPred already asserted";
        this.mAssertedHier = p;
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mHierConstants.beginScope();
        Term hierFormula = p.getFormula();
        String callee = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCallee = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(callee);
        hierFormula = this.renameNonModifiableNonOldGlobalsToDefaultConstants(p.getVars(), modifiableGlobalsCallee, hierFormula);
        String caller = this.mAssertedAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCaller = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(caller);
        hierFormula = IncrementalHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(p.getVars(), modifiableGlobalsCaller, hierFormula, this.mManagedScript, this);
        hierFormula = this.renameVarsToHierConstants(p.getVars(), hierFormula);
        hierFormula = new FormulaUnLet().unlet(hierFormula);
        assert (hierFormula.getFreeVars().length == 0);
        Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_HIERACHICAL_PRECONDITION);
        hierFormula = this.mManagedScript.annotate((Object)this, hierFormula, new Annotation[]{annot});
        Script.LBool quickCheck = this.mManagedScript.assertTerm((Object)this, hierFormula);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return quickCheck;
    }

    private Collection<Term> constructCalleeNonModOldVarsEquality(Set<IProgramVar> vars, Set<IProgramVar> modifiableGlobalsCaller, Set<IProgramVar> modifiableGlobalsCallee) {
        if (!modifiableGlobalsCallee.containsAll(modifiableGlobalsCaller)) {
            // empty if block
        }
        ArrayList<Term> conjunction = new ArrayList<Term>();
        for (IProgramVar bv : vars) {
            IProgramNonOldVar bnov;
            if (!(bv instanceof GlobalProgramVar) || !modifiableGlobalsCaller.contains(bnov = bv instanceof IProgramOldVar ? ((IProgramOldVar)bv).getNonOldVar() : (IProgramNonOldVar)bv) || modifiableGlobalsCallee.contains(bnov)) continue;
            Term hierConst = this.getOrConstructHierConstant(bnov);
            Term conjunct = SmtUtils.binaryEquality((Script)this.mManagedScript.getScript(), (Term)bv.getDefaultConstant(), (Term)hierConst);
            conjunction.add(conjunct);
        }
        return conjunction;
    }

    protected void unAssertHierPred() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedHier != null) : "No HierPred asserted";
        assert (this.mAssertedAction instanceof IReturnAction) : "Wrong kind of action";
        this.mAssertedHier = null;
        this.mManagedScript.pop((Object)this, 1);
        this.mHierConstants.endScope();
    }

    private Script.LBool assertPostcondInternal(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null);
        assert (this.mAssertedAction != null);
        assert (this.mAssertedAction instanceof IInternalAction) : "Wrong kind of action";
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mAssertedPostcond = p;
        Term renamedFormula = IncrementalHoareTripleChecker.constructPostcondFormula(p, (IInternalAction)this.mAssertedAction, this.mModifiableGlobalVariableManager, this.mManagedScript, this);
        renamedFormula = new FormulaUnLet().unlet(renamedFormula);
        assert (renamedFormula.getFreeVars().length == 0);
        Term negation = this.mManagedScript.term((Object)this, "not", new Term[]{renamedFormula});
        Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
        negation = this.mManagedScript.annotate((Object)this, negation, new Annotation[]{annot});
        Script.LBool isSat = this.mManagedScript.assertTerm((Object)this, negation);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return isSat;
    }

    public static Term constructPostcondFormula(IPredicate p, IInternalAction action, ModifiableGlobalsTable mgt, ManagedScript mgdScript, Object lock) {
        Set<IProgramVar> assignedVars = action.getTransformula().getAssignedVars();
        Term renamedFormula = IncrementalHoareTripleChecker.renameVarsToPrimedConstants(assignedVars, p.getFormula(), mgdScript, lock);
        String succProc = action.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = mgt.getModifiedBoogieVars(succProc);
        renamedFormula = IncrementalHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(p.getVars(), modifiableGlobals, renamedFormula, mgdScript, lock);
        renamedFormula = IncrementalHoareTripleChecker.renameVarsToDefaultConstants(p.getVars(), renamedFormula, mgdScript, lock);
        return renamedFormula;
    }

    private Script.LBool assertPostcondCall(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null);
        assert (this.mAssertedAction != null);
        assert (this.mAssertedAction instanceof ICallAction) : "Wrong kind of action";
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mAssertedPostcond = p;
        Set<IProgramVar> boogieVars = p.getVars();
        Term renamedFormula = this.renameGlobalsAndOldVarsToNonOldDefaultConstants(boogieVars, p.getFormula());
        renamedFormula = IncrementalHoareTripleChecker.renameVarsToPrimedConstants(boogieVars, renamedFormula, this.mManagedScript, this);
        renamedFormula = IncrementalHoareTripleChecker.renameVarsToDefaultConstants(p.getVars(), renamedFormula, this.mManagedScript, this);
        renamedFormula = new FormulaUnLet().unlet(renamedFormula);
        assert (renamedFormula.getFreeVars().length == 0);
        Term negation = this.mManagedScript.term((Object)this, "not", new Term[]{renamedFormula});
        Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
        negation = this.mManagedScript.annotate((Object)this, negation, new Annotation[]{annot});
        Script.LBool isSat = this.mManagedScript.assertTerm((Object)this, negation);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return isSat;
    }

    private Script.LBool assertPostcondReturn(IPredicate p) {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedPrecond != null);
        assert (this.mAssertedAction instanceof IReturnAction) : "Wrong kind of action";
        assert (this.mAssertedHier != null);
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        this.mManagedScript.push((Object)this, 1);
        this.mHierConstants.beginScope();
        this.mAssertedPostcond = p;
        Set<IProgramVar> assignedVars = ((IReturnAction)this.mAssertedAction).getAssignmentOfReturn().getAssignedVars();
        Term renamedFormula = IncrementalHoareTripleChecker.renameVarsToPrimedConstants(assignedVars, p.getFormula(), this.mManagedScript, this);
        String callee = this.mAssertedAction.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCallee = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(callee);
        renamedFormula = IncrementalHoareTripleChecker.renameVarsToDefaultConstants(modifiableGlobalsCallee, renamedFormula, this.mManagedScript, this);
        renamedFormula = this.renameNonModifiableNonOldGlobalsToDefaultConstants(p.getVars(), modifiableGlobalsCallee, renamedFormula);
        String caller = this.mAssertedAction.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCaller = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(caller);
        renamedFormula = IncrementalHoareTripleChecker.renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(p.getVars(), modifiableGlobalsCaller, renamedFormula, this.mManagedScript, this);
        renamedFormula = this.renameVarsToHierConstants(p.getVars(), renamedFormula);
        renamedFormula = new FormulaUnLet().unlet(renamedFormula);
        assert (renamedFormula.getFreeVars().length == 0);
        Term negation = this.mManagedScript.term((Object)this, "not", new Term[]{renamedFormula});
        Annotation annot = new Annotation(ANNOT_NAMED, (Object)ID_NEGATED_POSTCONDITION);
        negation = this.mManagedScript.annotate((Object)this, negation, new Annotation[]{annot});
        Script.LBool isSat = this.mManagedScript.assertTerm((Object)this, negation);
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return isSat;
    }

    protected void unAssertPostcondition() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first!";
        assert (this.mAssertedPrecond != null) : "Assert precond first!";
        assert (this.mAssertedPostcond != null) : "Assert postcond first!";
        this.mAssertedPostcond = null;
        this.mCounterexampleStatePrecond = null;
        this.mCounterexampleStatePostcond = null;
        this.mManagedScript.pop((Object)this, 1);
        if (this.mAssertedAction instanceof IReturnAction) {
            assert (this.mHierConstants != null) : "Assert hierPred first!";
            assert (this.mAssertedHier != null) : "Assert hierPred first!";
            this.mHierConstants.endScope();
        }
    }

    protected IncrementalPlicationChecker.Validity checkValidity() {
        assert (this.mManagedScript.isLockOwner((Object)this));
        assert (this.mAssertedAction != null) : "Assert CodeBlock first!";
        assert (this.mAssertedPrecond != null) : "Assert precond first! ";
        assert (this.mAssertedPostcond != null) : "Assert postcond first! ";
        this.mEdgeCheckerBenchmark.continueEdgeCheckerTime();
        Script.LBool isSat = this.mManagedScript.checkSat((Object)this);
        switch (isSat) {
            case SAT: {
                if (this.mConstructCounterexamples) {
                    this.mCounterexampleStatePrecond = this.constructCounterexampleStateForPrecondition();
                    this.mCounterexampleStatePostcond = this.constructCounterexampleStateForPostcondition();
                }
                this.mEdgeCheckerBenchmark.getSolverCounterSat().incRe();
                break;
            }
            case UNKNOWN: {
                this.mEdgeCheckerBenchmark.getSolverCounterUnknown().incRe();
                break;
            }
            case UNSAT: {
                this.mEdgeCheckerBenchmark.getSolverCounterUnsat().incRe();
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        this.mEdgeCheckerBenchmark.stopEdgeCheckerTime();
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)isSat);
    }

    private IProgramExecution.ProgramState<Term> constructCounterexampleStateForPrecondition() {
        UnmodifiableTransFormula tf = this.mAssertedAction.getTransformula();
        return this.constructCounterexampleState(tf.getInVars(), TransFormulaUtils::constructOutvarsToInvarsMap, x -> TransFormulaUtils.renameInvarsToDefaultVars(tf, this.mManagedScript, x));
    }

    private IProgramExecution.ProgramState<Term> constructCounterexampleStateForPostcondition() {
        UnmodifiableTransFormula tf = this.mAssertedAction.getTransformula();
        return this.constructCounterexampleState(tf.getOutVars(), TransFormulaUtils::constructInvarsToOutvarsMap, x -> TransFormulaUtils.renameOutvarsToDefaultVars(tf, this.mManagedScript, x));
    }

    private IProgramExecution.ProgramState<Term> constructCounterexampleState(Map<IProgramVar, TermVariable> xVars, Function<TransFormula, Map<TermVariable, TermVariable>> toXVarsMap, Function<Term, Term> xVarToDefaultVar) {
        HashMap<Term, Term> representativeTerm2ClosedTerm = new HashMap<Term, Term>();
        UnmodifiableTransFormula tf = this.mAssertedAction.getTransformula();
        for (Map.Entry<IProgramVar, TermVariable> entry : xVars.entrySet()) {
            if (!SmtUtils.isSortForWhichWeCanGetValues((Sort)entry.getKey().getTermVariable().getSort())) continue;
            Term xVarConst = UnmodifiableTransFormula.computeClosedFormula((Term)xVars.get(entry.getKey()), tf.getInVars(), tf.getOutVars(), Collections.emptySet(), this.mManagedScript);
            representativeTerm2ClosedTerm.put((Term)entry.getKey().getTermVariable(), xVarConst);
        }
        Set inAndOutVars = tf.getInVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet());
        inAndOutVars.addAll(tf.getOutVars().entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toSet()));
        Set selectTerms = SubTermFinder.find((Term)tf.getFormula(), x -> this.isSuitableArrayReadTerm((Term)x, inAndOutVars), (boolean)false);
        for (Term selectTerm : selectTerms) {
            Term selectTermAllOut = Substitution.apply((ManagedScript)this.mManagedScript, toXVarsMap.apply(tf), (Term)selectTerm);
            Term selectTermWithDefaultVars = xVarToDefaultVar.apply(selectTermAllOut);
            Term selectTermClosed = UnmodifiableTransFormula.computeClosedFormula(selectTermAllOut, tf.getInVars(), tf.getOutVars(), Collections.emptySet(), this.mManagedScript);
            representativeTerm2ClosedTerm.put(selectTermWithDefaultVars, selectTermClosed);
        }
        return this.generateProgramState(representativeTerm2ClosedTerm);
    }

    private IProgramExecution.ProgramState<Term> generateProgramState(Map<Term, Term> representativeTerm2ClosedTerm) {
        HashMap<Term, List<Term>> valuesMapping = new HashMap<Term, List<Term>>();
        for (Map.Entry<Term, Term> entry : representativeTerm2ClosedTerm.entrySet()) {
            Map values = this.mManagedScript.getValue((Object)this, new Term[]{entry.getValue()});
            Term value = (Term)values.get(entry.getValue());
            valuesMapping.put(entry.getKey(), Collections.singletonList(value));
        }
        return new IProgramExecution.ProgramState(valuesMapping, Term.class);
    }

    private boolean isSuitableArrayReadTerm(Term term, Set<TermVariable> varSet) {
        return term instanceof ApplicationTerm && ((ApplicationTerm)term).getFunction().getName().equals("select") && SmtUtils.isSortForWhichWeCanGetValues((Sort)term.getSort()) && Arrays.stream(term.getFreeVars()).allMatch(x -> varSet.contains(x));
    }

    private static Term renameVarsToDefaultConstants(Set<? extends IProgramVar> set, Term formula, ManagedScript managedScript, Object lock) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar iProgramVar : set) {
            replacees.add(iProgramVar.getTermVariable());
            replacers.add(iProgramVar.getDefaultConstant());
        }
        TermVariable[] termVariableArray = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return managedScript.let(lock, termVariableArray, values, formula);
    }

    private Term renameVarsToDefaultConstants(Map<IProgramVar, TermVariable> bv2tv, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> bv : bv2tv.entrySet()) {
            replacees.add(bv.getValue());
            replacers.add(bv.getKey().getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private static Term renameVarsToPrimedConstants(Set<IProgramVar> boogieVars, Term formula, ManagedScript managedScript, Object lock) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            replacees.add(bv.getTermVariable());
            replacers.add(bv.getPrimedConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return managedScript.let(lock, vars, values, formula);
    }

    private Term renameVarsToHierConstants(Set<IProgramVar> boogieVars, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<Term> replacers = new ArrayList<Term>();
        for (IProgramVar bv : boogieVars) {
            replacees.add(bv.getTermVariable());
            replacers.add(this.getOrConstructHierConstant(bv));
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term renameVarsToHierConstants(Map<IProgramVar, TermVariable> bv2tv, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<Term> replacers = new ArrayList<Term>();
        for (Map.Entry<IProgramVar, TermVariable> entry : bv2tv.entrySet()) {
            replacees.add(entry.getValue());
            replacers.add(this.getOrConstructHierConstant(entry.getKey()));
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term renameAuxVarsToCorrespondingConstants(Set<TermVariable> auxVars, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<Term> replacers = new ArrayList<Term>();
        for (TermVariable auxVarTv : auxVars) {
            replacees.add(auxVarTv);
            Term correspondingConstant = this.mManagedScript.term((Object)this, ProgramVarUtils.generateConstantIdentifierForAuxVar(auxVarTv), new Term[0]);
            replacers.add(correspondingConstant);
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term getOrConstructHierConstant(IProgramVar bv) {
        Term preHierConstant = (Term)this.mHierConstants.get((Object)bv);
        if (preHierConstant == null) {
            String name = "c_" + bv.getTermVariable().getName() + "_Hier";
            Sort sort = bv.getTermVariable().getSort();
            this.mManagedScript.declareFun((Object)this, name, new Sort[0], sort);
            preHierConstant = this.mManagedScript.term((Object)this, name, new Term[0]);
            this.mHierConstants.put((Object)bv, (Object)preHierConstant);
        }
        return preHierConstant;
    }

    private Term renameNonModifiableNonOldGlobalsToDefaultConstants(Set<IProgramVar> boogieVars, Set<IProgramNonOldVar> modifiableGlobalsCallee, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            if (!bv.isGlobal() || !(bv instanceof IProgramNonOldVar) || modifiableGlobalsCallee.contains(bv)) continue;
            replacees.add(bv.getTermVariable());
            replacers.add(bv.getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private static Term renameNonModifiableOldGlobalsToDefaultConstantOfNonOldVar(Set<IProgramVar> boogieVars, Set<IProgramNonOldVar> modifiableGlobalsCaller, Term formula, ManagedScript mgdScript, Object lock) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            IProgramNonOldVar nonOldVar;
            if (!(bv instanceof IProgramOldVar) || modifiableGlobalsCaller.contains(nonOldVar = ((IProgramOldVar)bv).getNonOldVar())) continue;
            replacees.add(bv.getTermVariable());
            replacers.add(nonOldVar.getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return mgdScript.let(lock, vars, values, formula);
    }

    private Term renameNonModifiableGlobalsToDefaultConstants(Map<IProgramVar, TermVariable> boogieVars, Set<IProgramVar> modifiableGlobals, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (Map.Entry<IProgramVar, TermVariable> entry : boogieVars.entrySet()) {
            IProgramVar bv = entry.getKey();
            if (bv.isGlobal()) {
                if (bv.isOldvar()) {
                    assert (!modifiableGlobals.contains(bv));
                    continue;
                }
                if (modifiableGlobals.contains(bv)) continue;
                replacees.add(entry.getValue());
                replacers.add(bv.getDefaultConstant());
                continue;
            }
            assert (!modifiableGlobals.contains(bv));
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    private Term renameGlobalsAndOldVarsToNonOldDefaultConstants(Set<IProgramVar> boogieVars, Term formula) {
        ArrayList<TermVariable> replacees = new ArrayList<TermVariable>();
        ArrayList<ApplicationTerm> replacers = new ArrayList<ApplicationTerm>();
        for (IProgramVar bv : boogieVars) {
            if (!bv.isGlobal()) continue;
            if (bv.isOldvar()) {
                replacees.add(bv.getTermVariable());
                IProgramNonOldVar nonOldbv = ((IProgramOldVar)bv).getNonOldVar();
                replacers.add(nonOldbv.getDefaultConstant());
                continue;
            }
            replacees.add(bv.getTermVariable());
            replacers.add(bv.getDefaultConstant());
        }
        TermVariable[] vars = replacees.toArray(new TermVariable[replacees.size()]);
        Term[] values = replacers.toArray(new Term[replacers.size()]);
        return this.mManagedScript.let((Object)this, vars, values, formula);
    }

    public boolean isAssertionStackEmpty() {
        if (this.mAssertedAction == null) {
            assert (this.mAssertedPrecond == null);
            assert (this.mAssertedHier == null);
            return true;
        }
        return false;
    }

    public IProgramExecution.ProgramState<Term> getCounterexampleStatePrecond() {
        if (!this.mConstructCounterexamples) {
            throw new IllegalStateException("Construction of counterexamples is not enabled.");
        }
        if (this.mCounterexampleStatePrecond == null) {
            throw new IllegalStateException("Last response was valid or assertion stack has been altered.");
        }
        return this.mCounterexampleStatePrecond;
    }

    public IProgramExecution.ProgramState<Term> getCounterexampleStatePostcond() {
        if (!this.mConstructCounterexamples) {
            throw new IllegalStateException("Construction of counterexamples is not enabled.");
        }
        if (this.mCounterexampleStatePrecond == null) {
            throw new IllegalStateException("Last response was valid or assertion stack has been altered.");
        }
        return this.mCounterexampleStatePostcond;
    }
}

