/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleCheckerHelper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.ReasonUnknown;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ScopedHashMap;
import java.util.HashSet;
import java.util.Set;

public class MonolithicHoareTripleChecker
implements IHoareTripleChecker {
    private final CfgSmtToolkit mCsToolkit;
    private final ManagedScript mManagedScript;
    private final ModifiableGlobalsTable mModifiableGlobals;
    private final HoareTripleCheckerStatisticsGenerator mHoareTripleCheckerStatistics;
    private ScopedHashMap<String, Term> mIndexedConstants;
    private int mTrivialSatQueries = 0;
    private int mNontrivialSatQueries = 0;
    private long mSatCheckSolverTime = 0L;
    private final int mTrivialCoverQueries = 0;
    private final int mNontrivialCoverQueries = 0;
    private long mSatCheckTime = 0L;
    private static final boolean DEBUG_TEST_DATAFLOW = false;

    public MonolithicHoareTripleChecker(CfgSmtToolkit csToolkit) {
        this.mCsToolkit = csToolkit;
        this.mManagedScript = csToolkit.getManagedScript();
        this.mModifiableGlobals = csToolkit.getModifiableGlobalsTable();
        this.mHoareTripleCheckerStatistics = new HoareTripleCheckerStatisticsGenerator();
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate succ) {
        this.mHoareTripleCheckerStatistics.continueEdgeCheckerTime();
        IncrementalPlicationChecker.Validity result = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)this.isInductive(pre, act, succ));
        this.mHoareTripleCheckerStatistics.stopEdgeCheckerTime();
        switch (result) {
            case INVALID: {
                this.mHoareTripleCheckerStatistics.getSolverCounterSat().incIn();
                break;
            }
            case UNKNOWN: {
                this.mHoareTripleCheckerStatistics.getSolverCounterUnknown().incIn();
                break;
            }
            case VALID: {
                this.mHoareTripleCheckerStatistics.getSolverCounterUnsat().incIn();
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        return result;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate succ) {
        this.mHoareTripleCheckerStatistics.continueEdgeCheckerTime();
        IncrementalPlicationChecker.Validity result = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)this.isInductiveCall(pre, act, succ));
        this.mHoareTripleCheckerStatistics.stopEdgeCheckerTime();
        switch (result) {
            case INVALID: {
                this.mHoareTripleCheckerStatistics.getSolverCounterSat().incCa();
                break;
            }
            case UNKNOWN: {
                this.mHoareTripleCheckerStatistics.getSolverCounterUnknown().incCa();
                break;
            }
            case VALID: {
                this.mHoareTripleCheckerStatistics.getSolverCounterUnsat().incCa();
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        return result;
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
        this.mHoareTripleCheckerStatistics.continueEdgeCheckerTime();
        IncrementalPlicationChecker.Validity result = IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)this.isInductiveReturn(preLin, preHier, act, succ));
        this.mHoareTripleCheckerStatistics.stopEdgeCheckerTime();
        switch (result) {
            case INVALID: {
                this.mHoareTripleCheckerStatistics.getSolverCounterSat().incRe();
                break;
            }
            case UNKNOWN: {
                this.mHoareTripleCheckerStatistics.getSolverCounterUnknown().incRe();
                break;
            }
            case VALID: {
                this.mHoareTripleCheckerStatistics.getSolverCounterUnsat().incRe();
                break;
            }
            default: {
                throw new AssertionError((Object)"unknown case");
            }
        }
        return result;
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return this.mHoareTripleCheckerStatistics;
    }

    public void releaseLock() {
    }

    public Script.LBool isInductive(IPredicate ps1, IInternalAction ta, IPredicate ps2) {
        return this.isInductive(ps1, ta, ps2, false);
    }

    public Script.LBool isInductive(IPredicate ps1, IInternalAction ta, IPredicate ps2, boolean expectUnsat) {
        this.mManagedScript.lock((Object)this);
        long startTime = System.nanoTime();
        if (MonolithicHoareTripleChecker.isDontCare(ps1) || MonolithicHoareTripleChecker.isDontCare(ps2)) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNKNOWN;
        }
        if (SmtUtils.isFalseLiteral((Term)ps1.getFormula()) || SmtUtils.isTrueLiteral((Term)ps2.getFormula())) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNSAT;
        }
        UnmodifiableTransFormula tf = ta.getTransformula();
        String procPred = ta.getPrecedingProcedure();
        String procSucc = ta.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsPred = this.mModifiableGlobals.getModifiedBoogieVars(procPred);
        Set<IProgramNonOldVar> modifiableGlobalsSucc = this.mModifiableGlobals.getModifiedBoogieVars(procSucc);
        Script.LBool result = PredicateUtils.isInductiveHelper(this.mManagedScript.getScript(), ps1, ps2, tf, modifiableGlobalsPred, modifiableGlobalsSucc);
        if (expectUnsat) assert (result == Script.LBool.UNSAT || result == Script.LBool.UNKNOWN) : "From " + ps1.getFormula().toStringDirect() + "Statements " + ta.toString() + "To " + ps2.getFormula().toStringDirect() + "Not inductive!";
        this.mSatCheckTime += System.nanoTime() - startTime;
        this.mManagedScript.unlock((Object)this);
        return result;
    }

    public Script.LBool isInductiveCall(IPredicate ps1, ICallAction ta, IPredicate ps2) {
        return this.isInductiveCall(ps1, ta, ps2, false);
    }

    public Script.LBool isInductiveCall(IPredicate ps1, ICallAction ta, IPredicate ps2, boolean expectUnsat) {
        this.mManagedScript.lock((Object)this);
        long startTime = System.nanoTime();
        if (MonolithicHoareTripleChecker.isDontCare(ps1) || MonolithicHoareTripleChecker.isDontCare(ps2)) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNKNOWN;
        }
        if (SmtUtils.isFalseLiteral((Term)ps1.getFormula()) || SmtUtils.isTrueLiteral((Term)ps2.getFormula())) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNSAT;
        }
        this.mManagedScript.getScript().push(1);
        this.mIndexedConstants = new ScopedHashMap();
        String caller = ta.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCaller = this.mModifiableGlobals.getModifiedBoogieVars(caller);
        Term ps1renamed = PredicateUtils.formulaWithIndexedVars(ps1, new HashSet<IProgramVar>(0), 4, 0, Integer.MIN_VALUE, null, -5, 0, this.mIndexedConstants, this.mManagedScript.getScript(), modifiableGlobalsCaller);
        UnmodifiableTransFormula tf = ta.getLocalVarsAssignment();
        HashSet<IProgramVar> assignedVars = new HashSet<IProgramVar>();
        Term fTrans = PredicateUtils.formulaWithIndexedVars(tf, 0, 1, assignedVars, this.mIndexedConstants, this.mManagedScript.getScript());
        String callee = ta.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCallee = this.mModifiableGlobals.getModifiedBoogieVars(callee);
        Term ps2renamed = PredicateUtils.formulaWithIndexedVars(ps2, new HashSet<IProgramVar>(0), 4, 1, 0, null, 23, 0, this.mIndexedConstants, this.mManagedScript.getScript(), modifiableGlobalsCallee);
        Term f = SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)ps2renamed);
        f = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{fTrans, f});
        f = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{ps1renamed, f});
        Script.LBool result = this.checkSatisfiable(f);
        this.mIndexedConstants = null;
        this.mManagedScript.getScript().pop(1);
        if (expectUnsat) assert (result == Script.LBool.UNSAT || result == Script.LBool.UNKNOWN) : "call statement not inductive";
        this.mSatCheckTime += System.nanoTime() - startTime;
        this.mManagedScript.unlock((Object)this);
        return result;
    }

    public Script.LBool isInductiveReturn(IPredicate ps1, IPredicate psk, IReturnAction ta, IPredicate ps2) {
        return this.isInductiveReturn(ps1, psk, ta, ps2, false);
    }

    public Script.LBool isInductiveReturn(IPredicate ps1, IPredicate psk, IReturnAction ta, IPredicate ps2, boolean expectUnsat) {
        this.mManagedScript.lock((Object)this);
        long startTime = System.nanoTime();
        if (MonolithicHoareTripleChecker.isDontCare(ps1) || MonolithicHoareTripleChecker.isDontCare(ps2) || MonolithicHoareTripleChecker.isDontCare(psk)) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNKNOWN;
        }
        if (SmtUtils.isFalseLiteral((Term)ps1.getFormula()) || SmtUtils.isFalseLiteral((Term)psk.getFormula()) || SmtUtils.isTrueLiteral((Term)ps2.getFormula())) {
            ++this.mTrivialSatQueries;
            this.mManagedScript.unlock((Object)this);
            return Script.LBool.UNSAT;
        }
        this.mManagedScript.getScript().push(1);
        this.mIndexedConstants = new ScopedHashMap();
        UnmodifiableTransFormula tfReturn = ta.getAssignmentOfReturn();
        HashSet<IProgramVar> assignedVarsOnReturn = new HashSet<IProgramVar>();
        Term fReturn = PredicateUtils.formulaWithIndexedVars(tfReturn, 1, 2, assignedVarsOnReturn, this.mIndexedConstants, this.mManagedScript.getScript());
        UnmodifiableTransFormula tfCall = ta.getLocalVarsAssignmentOfCall();
        HashSet<IProgramVar> assignedVarsOnCall = new HashSet<IProgramVar>();
        Term fCall = PredicateUtils.formulaWithIndexedVars(tfCall, 0, 1, assignedVarsOnCall, this.mIndexedConstants, this.mManagedScript.getScript());
        String callee = ta.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCallee = this.mModifiableGlobals.getModifiedBoogieVars(callee);
        String caller = ta.getSucceedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobalsCaller = this.mModifiableGlobals.getModifiedBoogieVars(caller);
        Term pskrenamed = PredicateUtils.formulaWithIndexedVars(psk, new HashSet<IProgramVar>(0), 23, 0, Integer.MIN_VALUE, null, 23, 0, this.mIndexedConstants, this.mManagedScript.getScript(), modifiableGlobalsCaller);
        HashSet<IProgramVar> modifiableGlobalsAssignedOnReturn = new HashSet<IProgramVar>();
        for (IProgramVar assignedVar : tfReturn.getAssignedVars()) {
            if (!modifiableGlobalsCallee.contains(assignedVar)) continue;
            modifiableGlobalsAssignedOnReturn.add(assignedVar);
        }
        Term ps1renamed = PredicateUtils.formulaWithIndexedVars(ps1, modifiableGlobalsAssignedOnReturn, 1, 1, 0, modifiableGlobalsCallee, 2, 0, this.mIndexedConstants, this.mManagedScript.getScript(), modifiableGlobalsCallee);
        Term ps2renamed = PredicateUtils.formulaWithIndexedVars(ps2, assignedVarsOnReturn, 2, 0, Integer.MIN_VALUE, modifiableGlobalsCallee, 2, 0, this.mIndexedConstants, this.mManagedScript.getScript(), modifiableGlobalsCaller);
        Term f = SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)ps2renamed);
        f = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{fReturn, f});
        f = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{ps1renamed, f});
        f = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{fCall, f});
        f = SmtUtils.and((Script)this.mManagedScript.getScript(), (Term[])new Term[]{pskrenamed, f});
        Script.LBool result = this.checkSatisfiable(f);
        this.mManagedScript.getScript().pop(1);
        this.mIndexedConstants = null;
        if (expectUnsat) assert (result == Script.LBool.UNSAT || result == Script.LBool.UNKNOWN) : "From " + ps1.getFormula().toStringDirect() + "Caller " + psk.getFormula().toStringDirect() + "Statements " + ta + "To " + ps2.getFormula().toStringDirect() + "Not inductive!";
        this.mSatCheckTime += System.nanoTime() - startTime;
        this.mManagedScript.unlock((Object)this);
        return result;
    }

    public Script.LBool assertTerm(Term term) {
        long startTime = System.nanoTime();
        Script.LBool result = null;
        result = this.mManagedScript.getScript().assertTerm(term);
        this.mSatCheckSolverTime += System.nanoTime() - startTime;
        return result;
    }

    Script.LBool checkSatisfiable(Term f) {
        long startTime = System.nanoTime();
        Script.LBool result = null;
        try {
            this.assertTerm(f);
        }
        catch (SMTLIBException e) {
            if (e.getMessage().equals("Unsupported non-linear arithmetic")) {
                return Script.LBool.UNKNOWN;
            }
            throw e;
        }
        result = this.mManagedScript.getScript().checkSat();
        this.mSatCheckSolverTime += System.nanoTime() - startTime;
        ++this.mNontrivialSatQueries;
        if (result == Script.LBool.UNKNOWN) {
            Object info = this.mManagedScript.getScript().getInfo(":reason-unknown");
            if (!(info instanceof ReasonUnknown)) {
                this.mManagedScript.getScript().getInfo(":reason-unknown");
            }
            ReasonUnknown reason = (ReasonUnknown)info;
            switch (reason) {
                case CRASHED: {
                    throw new AssertionError((Object)"Solver crashed");
                }
                case MEMOUT: {
                    throw new AssertionError((Object)"Solver out of memory, solver might be in inconsistent state");
                }
            }
        }
        return result;
    }

    private static boolean isDontCare(IPredicate ps2) {
        return false;
    }

    private void testMyReturnDataflowCheck(IPredicate ps1, IPredicate psk, IReturnAction ta, IPredicate ps2, Script.LBool result) {
        if (ps2.getFormula() == this.mManagedScript.getScript().term("false", new Term[0])) {
            return;
        }
        SdHoareTripleCheckerHelper sdhtch = new SdHoareTripleCheckerHelper(this.mCsToolkit, null);
        IncrementalPlicationChecker.Validity testRes = sdhtch.sdecReturn(ps1, psk, ta, ps2);
        if (testRes != null && testRes != IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)result)) {
            sdhtch.sdecReturn(ps1, psk, ta, ps2);
        }
    }

    private void testMyCallDataflowCheck(IPredicate ps1, ICallAction ta, IPredicate ps2, Script.LBool result) {
        if (ps2.getFormula() == this.mManagedScript.getScript().term("false", new Term[0])) {
            return;
        }
        SdHoareTripleCheckerHelper sdhtch = new SdHoareTripleCheckerHelper(this.mCsToolkit, null);
        IncrementalPlicationChecker.Validity testRes = sdhtch.sdecCall(ps1, ta, ps2);
        if (testRes != null) assert (testRes == IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)result)) : "my call dataflow check failed";
    }

    private void testMyInternalDataflowCheck(IPredicate ps1, IInternalAction ta, IPredicate ps2, Script.LBool result) {
        SdHoareTripleCheckerHelper sdhtch;
        IncrementalPlicationChecker.Validity testRes;
        if (ps2.getFormula() == this.mManagedScript.getScript().term("false", new Term[0])) {
            SdHoareTripleCheckerHelper sdhtch2 = new SdHoareTripleCheckerHelper(this.mCsToolkit, null);
            IncrementalPlicationChecker.Validity testRes2 = sdhtch2.sdecInternalToFalse(ps1, ta);
            if (testRes2 != null) assert (testRes2 == IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)result) || testRes2 == IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)Script.LBool.UNKNOWN) && result == Script.LBool.SAT) : "my internal dataflow check failed";
            return;
        }
        if (ps1 == ps2 && (testRes = (sdhtch = new SdHoareTripleCheckerHelper(this.mCsToolkit, null)).sdecInternalSelfloop(ps1, ta)) != null) assert (testRes == IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)result)) : "my internal dataflow check failed";
        if (ta.getTransformula().isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
            return;
        }
        sdhtch = new SdHoareTripleCheckerHelper(this.mCsToolkit, null);
        testRes = sdhtch.sdecInternal(ps1, ta, ps2);
        if (testRes != null) assert (testRes == IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)result)) : "my internal dataflow check failed";
    }
}

