/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.IHoareTripleChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.SdHoareTripleCheckerHelper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class SdHoareTripleChecker
implements IHoareTripleChecker {
    private final SdHoareTripleCheckerHelper mSdHoareTripleChecker;
    private final IPredicateCoverageChecker mPredicateCoverageChecker;
    private final IPredicate mTruePredicate;
    private final IPredicate mFalsePredicate;
    private static final boolean LAZY_CHECKS = false;
    private final InternalCheckHelper mInternalCheckHelper = new InternalCheckHelper();
    private final CallCheckHelper mCallCheckHelper = new CallCheckHelper();
    private final ReturnCheckHelper mReturnCheckHelper = new ReturnCheckHelper();

    public SdHoareTripleChecker(CfgSmtToolkit csToolkit, IPredicateUnifier predicateUnifier) {
        this.mPredicateCoverageChecker = predicateUnifier.getCoverageRelation();
        this.mTruePredicate = predicateUnifier.getTruePredicate();
        this.mFalsePredicate = predicateUnifier.getFalsePredicate();
        this.mSdHoareTripleChecker = new SdHoareTripleCheckerHelper(csToolkit, this.mPredicateCoverageChecker, new HoareTripleCheckerStatisticsGenerator());
    }

    @Override
    public IncrementalPlicationChecker.Validity checkInternal(IPredicate pre, IInternalAction act, IPredicate succ) {
        return this.mInternalCheckHelper.check(pre, null, act, succ);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkCall(IPredicate pre, ICallAction act, IPredicate succ) {
        return this.mCallCheckHelper.check(pre, null, act, succ);
    }

    @Override
    public IncrementalPlicationChecker.Validity checkReturn(IPredicate preLin, IPredicate preHier, IReturnAction act, IPredicate succ) {
        return this.mReturnCheckHelper.check(preLin, preHier, act, succ);
    }

    @Override
    public HoareTripleCheckerStatisticsGenerator getStatistics() {
        return this.mSdHoareTripleChecker.getEdgeCheckerBenchmark();
    }

    protected SdHoareTripleCheckerHelper getSdHoareTripleChecker() {
        return this.mSdHoareTripleChecker;
    }

    protected IPredicateCoverageChecker getPredicateCoverageChecker() {
        return this.mPredicateCoverageChecker;
    }

    protected IPredicate getFalsePredicate() {
        return this.mFalsePredicate;
    }

    protected IPredicate getTruePredicate() {
        return this.mTruePredicate;
    }

    public void releaseLock() {
    }

    protected class CallCheckHelper
    extends CheckHelper {
        protected CallCheckHelper() {
        }

        @Override
        public IncrementalPlicationChecker.Validity sdecToFalse(IPredicate preLin, IPredicate preHier, IAction act) {
            assert (preHier == null);
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecCallToFalse(preLin, (ICallAction)act);
        }

        @Override
        public boolean isInductiveSefloop(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            assert (preHier == null);
            return preLin == succ && SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecCallSelfloop(preLin, (ICallAction)act) == IncrementalPlicationChecker.Validity.VALID;
        }

        @Override
        public IncrementalPlicationChecker.Validity sdec(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            assert (preHier == null);
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecCall(preLin, (ICallAction)act, succ);
        }

        @Override
        public IncrementalPlicationChecker.Validity sdLazyEc(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            assert (preHier == null);
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdLazyEcCall(preLin, (ICallAction)act, succ);
        }
    }

    public abstract class CheckHelper {
        public IncrementalPlicationChecker.Validity check(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            if (act instanceof IInternalAction && ((IInternalAction)act).getTransformula().isInfeasible() == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
                return IncrementalPlicationChecker.Validity.VALID;
            }
            boolean unknownCoverage = false;
            switch (SdHoareTripleChecker.this.getPredicateCoverageChecker().isCovered(preLin, SdHoareTripleChecker.this.getFalsePredicate())) {
                case INVALID: {
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"unchecked predicate");
                }
                case UNKNOWN: {
                    unknownCoverage = true;
                    break;
                }
                case VALID: {
                    return IncrementalPlicationChecker.Validity.VALID;
                }
                default: {
                    throw new AssertionError((Object)"unknown case");
                }
            }
            if (preHier != null) {
                switch (SdHoareTripleChecker.this.getPredicateCoverageChecker().isCovered(preHier, SdHoareTripleChecker.this.getFalsePredicate())) {
                    case INVALID: {
                        break;
                    }
                    case NOT_CHECKED: {
                        throw new AssertionError((Object)"unchecked predicate");
                    }
                    case UNKNOWN: {
                        unknownCoverage = true;
                        break;
                    }
                    case VALID: {
                        return IncrementalPlicationChecker.Validity.VALID;
                    }
                    default: {
                        throw new AssertionError((Object)"unknown case");
                    }
                }
            }
            switch (SdHoareTripleChecker.this.getPredicateCoverageChecker().isCovered(SdHoareTripleChecker.this.getTruePredicate(), succ)) {
                case INVALID: {
                    break;
                }
                case NOT_CHECKED: {
                    throw new AssertionError((Object)"unchecked predicate");
                }
                case UNKNOWN: {
                    unknownCoverage = true;
                    break;
                }
                case VALID: {
                    return IncrementalPlicationChecker.Validity.VALID;
                }
                default: {
                    throw new AssertionError((Object)"unknown case");
                }
            }
            if (unknownCoverage) {
                return IncrementalPlicationChecker.Validity.UNKNOWN;
            }
            boolean isInductiveSelfloop = this.isInductiveSefloop(preLin, preHier, act, succ);
            if (isInductiveSelfloop) {
                return IncrementalPlicationChecker.Validity.VALID;
            }
            if (SmtUtils.isFalseLiteral((Term)succ.getFormula())) {
                IncrementalPlicationChecker.Validity toFalse = this.sdecToFalse(preLin, preHier, act);
                if (toFalse == null) {
                    assert (this.sdec(preLin, preHier, act, succ) == null) : "inconsistent check results";
                    return IncrementalPlicationChecker.Validity.UNKNOWN;
                }
                switch (toFalse) {
                    case INVALID: {
                        return IncrementalPlicationChecker.Validity.INVALID;
                    }
                    case NOT_CHECKED: {
                        throw new AssertionError((Object)"unchecked predicate");
                    }
                    case UNKNOWN: {
                        throw new AssertionError((Object)"this case should have been filtered out before");
                    }
                    case VALID: {
                        throw new AssertionError((Object)"this case should have been filtered out before");
                    }
                }
                throw new AssertionError((Object)"unknown case");
            }
            IncrementalPlicationChecker.Validity general = this.sdec(preLin, preHier, act, succ);
            if (general != null) {
                switch (general) {
                    case INVALID: {
                        return IncrementalPlicationChecker.Validity.INVALID;
                    }
                    case NOT_CHECKED: {
                        throw new AssertionError((Object)"unchecked predicate");
                    }
                    case UNKNOWN: {
                        throw new AssertionError((Object)"this case should have been filtered out before");
                    }
                    case VALID: {
                        return IncrementalPlicationChecker.Validity.VALID;
                    }
                }
                throw new AssertionError((Object)"unknown case");
            }
            return IncrementalPlicationChecker.Validity.UNKNOWN;
        }

        public abstract IncrementalPlicationChecker.Validity sdecToFalse(IPredicate var1, IPredicate var2, IAction var3);

        public abstract boolean isInductiveSefloop(IPredicate var1, IPredicate var2, IAction var3, IPredicate var4);

        public abstract IncrementalPlicationChecker.Validity sdec(IPredicate var1, IPredicate var2, IAction var3, IPredicate var4);

        public abstract IncrementalPlicationChecker.Validity sdLazyEc(IPredicate var1, IPredicate var2, IAction var3, IPredicate var4);
    }

    protected class InternalCheckHelper
    extends CheckHelper {
        protected InternalCheckHelper() {
        }

        @Override
        public IncrementalPlicationChecker.Validity sdecToFalse(IPredicate preLin, IPredicate preHier, IAction act) {
            assert (preHier == null);
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecInternalToFalse(preLin, (IInternalAction)act);
        }

        @Override
        public boolean isInductiveSefloop(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            assert (preHier == null);
            return preLin == succ && SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecInternalSelfloop(preLin, (IInternalAction)act) == IncrementalPlicationChecker.Validity.VALID;
        }

        @Override
        public IncrementalPlicationChecker.Validity sdec(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            assert (preHier == null);
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecInternal(preLin, (IInternalAction)act, succ);
        }

        @Override
        public IncrementalPlicationChecker.Validity sdLazyEc(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            assert (preHier == null);
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdLazyEcInternal(preLin, (IInternalAction)act, succ);
        }
    }

    public class ReturnCheckHelper
    extends CheckHelper {
        @Override
        public IncrementalPlicationChecker.Validity sdecToFalse(IPredicate preLin, IPredicate preHier, IAction act) {
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecReturnToFalse(preLin, preHier, (IReturnAction)act);
        }

        @Override
        public boolean isInductiveSefloop(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            if (preLin == succ && SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecReturnSelfloopPre(preLin, (IReturnAction)act) == IncrementalPlicationChecker.Validity.VALID) {
                return true;
            }
            return preHier == succ && SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecReturnSelfloopHier(preHier, (IReturnAction)act) == IncrementalPlicationChecker.Validity.VALID;
        }

        @Override
        public IncrementalPlicationChecker.Validity sdec(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdecReturn(preLin, preHier, (IReturnAction)act, succ);
        }

        @Override
        public IncrementalPlicationChecker.Validity sdLazyEc(IPredicate preLin, IPredicate preHier, IAction act, IPredicate succ) {
            return SdHoareTripleChecker.this.getSdHoareTripleChecker().sdLazyEcReturn(preLin, preHier, (IReturnAction)act, succ);
        }
    }
}

