/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.ModifiableGlobalsTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.ICallAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IInternalAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IReturnAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgForkThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IcfgJoinThreadOtherTransition;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramNonOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramOldVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.hoaretriple.HoareTripleCheckerStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.DataStructureUtils;
import java.util.Collections;
import java.util.Set;

public class SdHoareTripleCheckerHelper {
    private final ModifiableGlobalsTable mModifiableGlobalVariableManager;
    private final HoareTripleCheckerStatisticsGenerator mHoareTripleCheckerStatistics;
    private final IPredicateCoverageChecker mPredicateCoverageChecker;

    public SdHoareTripleCheckerHelper(CfgSmtToolkit csToolkit, IPredicateCoverageChecker predicateCoverageChecker, HoareTripleCheckerStatisticsGenerator edgeCheckerBenchmarkGenerator) {
        this.mModifiableGlobalVariableManager = csToolkit.getModifiableGlobalsTable();
        this.mPredicateCoverageChecker = predicateCoverageChecker;
        this.mHoareTripleCheckerStatistics = edgeCheckerBenchmarkGenerator == null ? new HoareTripleCheckerStatisticsGenerator() : edgeCheckerBenchmarkGenerator;
    }

    public SdHoareTripleCheckerHelper(CfgSmtToolkit csToolkit, HoareTripleCheckerStatisticsGenerator edgeCheckerBenchmarkGenerator) {
        this(csToolkit, null, edgeCheckerBenchmarkGenerator);
    }

    public HoareTripleCheckerStatisticsGenerator getEdgeCheckerBenchmark() {
        return this.mHoareTripleCheckerStatistics;
    }

    private static boolean varSetDisjoint(Set<IProgramVar> set1, Set<IProgramVar> set2) {
        return DataStructureUtils.haveEmptyIntersection(set1, set2);
    }

    public IncrementalPlicationChecker.Validity sdecInternalToFalse(IPredicate pre, IInternalAction act) {
        UnmodifiableTransFormula.Infeasibility infeasiblity = act.getTransformula().isInfeasible();
        if (infeasiblity == UnmodifiableTransFormula.Infeasibility.UNPROVEABLE) {
            if (SdHoareTripleCheckerHelper.varsDisjoinedFormInVars(pre, act.getTransformula())) {
                this.mHoareTripleCheckerStatistics.getSDtfsCounter().incIn();
                return IncrementalPlicationChecker.Validity.INVALID;
            }
            return null;
        }
        if (infeasiblity == UnmodifiableTransFormula.Infeasibility.INFEASIBLE) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        if (infeasiblity == UnmodifiableTransFormula.Infeasibility.NOT_DETERMINED) {
            return null;
        }
        throw new IllegalArgumentException();
    }

    private static boolean varsDisjoinedFormInVars(IPredicate state, UnmodifiableTransFormula tf) {
        return DataStructureUtils.haveEmptyIntersection(state.getVars(), tf.getInVars().keySet());
    }

    public IncrementalPlicationChecker.Validity sdecInternal(IPredicate pre, IInternalAction act, IPredicate post) {
        IncrementalPlicationChecker.Validity sat;
        if (this.mPredicateCoverageChecker != null && (sat = this.mPredicateCoverageChecker.isCovered(pre, post)) == IncrementalPlicationChecker.Validity.VALID && DataStructureUtils.haveEmptyIntersection(pre.getVars(), act.getTransformula().getAssignedVars())) {
            this.mHoareTripleCheckerStatistics.getSDsluCounter().incIn();
            return IncrementalPlicationChecker.Validity.VALID;
        }
        for (IProgramVar bv : pre.getVars()) {
            if (!act.getTransformula().getInVars().containsKey(bv)) continue;
            return null;
        }
        for (IProgramVar bv : post.getVars()) {
            if (act.getTransformula().getInVars().containsKey(bv)) {
                return null;
            }
            if (!act.getTransformula().getOutVars().containsKey(bv)) continue;
            return null;
        }
        if (this.mPredicateCoverageChecker != null) {
            sat = this.mPredicateCoverageChecker.isCovered(pre, post);
            if (sat == IncrementalPlicationChecker.Validity.VALID) {
                this.mHoareTripleCheckerStatistics.getSDsluCounter().incIn();
                return IncrementalPlicationChecker.Validity.VALID;
            }
            if (sat == IncrementalPlicationChecker.Validity.UNKNOWN) {
                return null;
            }
            if (sat == IncrementalPlicationChecker.Validity.NOT_CHECKED) {
                return null;
            }
            if (sat == IncrementalPlicationChecker.Validity.INVALID) {
                String proc = act.getPrecedingProcedure();
                assert (proc.equals(act.getSucceedingProcedure()) || act instanceof IcfgForkThreadOtherTransition || act instanceof IcfgJoinThreadOtherTransition) : "internal statement must not change procedure";
                if (this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(pre, proc) || this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(post, proc)) {
                    return null;
                }
            }
        } else if (!Collections.disjoint(pre.getVars(), post.getVars())) {
            return null;
        }
        this.mHoareTripleCheckerStatistics.getSDsCounter().incIn();
        switch (act.getTransformula().isInfeasible()) {
            case INFEASIBLE: {
                throw new IllegalArgumentException("case should have been handled before");
            }
            case NOT_DETERMINED: {
                return null;
            }
            case UNPROVEABLE: {
                return IncrementalPlicationChecker.Validity.INVALID;
            }
        }
        throw new AssertionError((Object)"illegal value");
    }

    public IncrementalPlicationChecker.Validity sdLazyEcInternal(IPredicate pre, IInternalAction act, IPredicate post) {
        if (SdHoareTripleCheckerHelper.isOrIteFormula(post)) {
            return this.sdecInternal(pre, act, post);
        }
        for (IProgramVar bv : post.getVars()) {
            if (pre.getVars().contains(bv) && act.getTransformula().getInVars().containsKey(bv) && act.getTransformula().getOutVars().containsKey(bv)) continue;
            this.mHoareTripleCheckerStatistics.getSdLazyCounter().incIn();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    public IncrementalPlicationChecker.Validity sdecCallToFalse(IPredicate pre, ICallAction act) {
        this.mHoareTripleCheckerStatistics.getSDtfsCounter().incCa();
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    public IncrementalPlicationChecker.Validity sdecCall(IPredicate pre, ICallAction act, IPredicate post) {
        if (this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(pre, act.getPrecedingProcedure()) || this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(post, act.getSucceedingProcedure())) {
            return null;
        }
        for (IProgramVar bv : post.getVars()) {
            if (bv.isOldvar()) {
                return null;
            }
            if (!bv.isGlobal()) continue;
            assert (!bv.isOldvar());
            if (!pre.getVars().contains(bv)) continue;
            return null;
        }
        UnmodifiableTransFormula locVarAssignTf = act.getLocalVarsAssignment();
        if (!SdHoareTripleCheckerHelper.varSetDisjoint(locVarAssignTf.getAssignedVars(), pre.getVars())) {
            return null;
        }
        if (this.preHierIndependent(post, pre, act.getLocalVarsAssignment(), act.getSucceedingProcedure())) {
            this.mHoareTripleCheckerStatistics.getSDsCounter().incCa();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    public IncrementalPlicationChecker.Validity sdLazyEcCall(IPredicate pre, ICallAction cb, IPredicate post) {
        if (SdHoareTripleCheckerHelper.isOrIteFormula(post)) {
            return this.sdecCall(pre, cb, post);
        }
        UnmodifiableTransFormula locVarAssignTf = cb.getLocalVarsAssignment();
        boolean argumentsRestrictedByPre = !SdHoareTripleCheckerHelper.varSetDisjoint(locVarAssignTf.getInVars().keySet(), pre.getVars());
        for (IProgramVar bv : post.getVars()) {
            if (bv.isGlobal() || locVarAssignTf.getAssignedVars().contains(bv) && argumentsRestrictedByPre) continue;
            this.mHoareTripleCheckerStatistics.getSdLazyCounter().incCa();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    public IncrementalPlicationChecker.Validity sdecReturn(IPredicate pre, IPredicate hier, IReturnAction ret, IPredicate post) {
        if (this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(pre, ret.getPrecedingProcedure()) || this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(hier, ret.getSucceedingProcedure()) || this.mModifiableGlobalVariableManager.containsNonModifiableOldVars(post, ret.getSucceedingProcedure())) {
            return null;
        }
        if (this.hierPostIndependent(hier, ret, post) && this.preHierNotFalse(pre, hier, ret.getLocalVarsAssignmentOfCall(), ret.getPrecedingProcedure()) && SdHoareTripleCheckerHelper.prePostIndependent(pre, ret, post)) {
            this.mHoareTripleCheckerStatistics.getSDsCounter().incRe();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    public IncrementalPlicationChecker.Validity sdecReturnToFalse(IPredicate pre, IPredicate hier, IReturnAction ret) {
        if (this.preHierNotFalse(pre, hier, ret.getLocalVarsAssignmentOfCall(), ret.getPrecedingProcedure())) {
            this.mHoareTripleCheckerStatistics.getSDtfsCounter().incRe();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    public IncrementalPlicationChecker.Validity sdLazyEcReturn(IPredicate pre, IPredicate hier, IReturnAction ret, IPredicate post) {
        if (SdHoareTripleCheckerHelper.isOrIteFormula(post)) {
            return this.sdecReturn(pre, hier, ret, post);
        }
        Set<IProgramVar> parameters = ret.getLocalVarsAssignmentOfCall().getAssignedVars();
        if (!SdHoareTripleCheckerHelper.varSetDisjoint(parameters, pre.getVars())) {
            return null;
        }
        String proc = ret.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(proc);
        boolean assignedVarsRestrictedByPre = !SdHoareTripleCheckerHelper.varSetDisjoint(ret.getAssignmentOfReturn().getInVars().keySet(), pre.getVars());
        Set<IProgramVar> assignedVars = ret.getAssignmentOfReturn().getAssignedVars();
        for (IProgramVar bv : post.getVars()) {
            if (SdHoareTripleCheckerHelper.continueSdLazyEcReturnLoop(bv, modifiableGlobals, hier, pre, assignedVars, assignedVarsRestrictedByPre)) continue;
            this.mHoareTripleCheckerStatistics.getSdLazyCounter().incRe();
            return IncrementalPlicationChecker.Validity.INVALID;
        }
        return null;
    }

    private static boolean continueSdLazyEcReturnLoop(IProgramVar bv, Set<IProgramNonOldVar> modifiableGlobals, IPredicate hier, IPredicate pre, Set<IProgramVar> assignedVars, boolean assignedVarsRestrictedByPre) {
        if (bv.isGlobal()) {
            if (bv.isOldvar()) {
                if (hier.getVars().contains(bv)) {
                    return true;
                }
            } else {
                if (modifiableGlobals.contains(bv)) {
                    if (pre.getVars().contains(bv)) {
                        return true;
                    }
                } else {
                    if (hier.getVars().contains(bv)) {
                        return true;
                    }
                    if (pre.getVars().contains(bv)) {
                        return true;
                    }
                }
                if (assignedVars.contains(bv) && assignedVarsRestrictedByPre) {
                    return true;
                }
            }
        } else if (assignedVars.contains(bv) ? assignedVarsRestrictedByPre : hier.getVars().contains(bv)) {
            return true;
        }
        return false;
    }

    private boolean preHierIndependent(IPredicate pre, IPredicate hier, UnmodifiableTransFormula localVarsAssignment, String calledProcedure) {
        if (!SdHoareTripleCheckerHelper.varSetDisjoint(localVarsAssignment.getAssignedVars(), pre.getVars())) {
            return false;
        }
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(calledProcedure);
        for (IProgramVar bv : pre.getVars()) {
            if (!bv.isGlobal() || !(bv.isOldvar() ? hier.getVars().contains(((IProgramOldVar)bv).getNonOldVar()) : !modifiableGlobals.contains(bv) && hier.getVars().contains(bv))) continue;
            return false;
        }
        return true;
    }

    private boolean preHierNotFalse(IPredicate pre, IPredicate hier, UnmodifiableTransFormula localVarsAssignment, String calledProcedure) {
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(calledProcedure);
        boolean isSelfConnectedViaLocalVarsAssignment = SdHoareTripleCheckerHelper.isSelfConnectedViaLocalVarsAssignment(pre, localVarsAssignment);
        if (isSelfConnectedViaLocalVarsAssignment) {
            return false;
        }
        boolean isConnectedViaLocalVarsAssignment = SdHoareTripleCheckerHelper.isConnectedViaLocalVarsAssignment(hier, localVarsAssignment, pre);
        if (isConnectedViaLocalVarsAssignment) {
            return false;
        }
        IncrementalPlicationChecker.Validity preImpliesHier = this.mPredicateCoverageChecker.isCovered(pre, hier);
        boolean canBeCrossConnectedViaGlobalVars = SdHoareTripleCheckerHelper.canBeCrossConnectedViaGlobalVars(hier, pre, modifiableGlobals, preImpliesHier == IncrementalPlicationChecker.Validity.VALID);
        if (canBeCrossConnectedViaGlobalVars) {
            return false;
        }
        if (preImpliesHier == IncrementalPlicationChecker.Validity.VALID) {
            return true;
        }
        return SdHoareTripleCheckerHelper.disjointOnNonModifiableGlobals(hier, pre, modifiableGlobals);
    }

    private static boolean disjointOnNonModifiableGlobals(IPredicate hier, IPredicate returnPred, Set<IProgramNonOldVar> modifiableGlobals) {
        for (IProgramVar pv : returnPred.getVars()) {
            if (!(pv instanceof IProgramNonOldVar) || modifiableGlobals.contains(pv) || !hier.getVars().contains(pv)) continue;
            return false;
        }
        return true;
    }

    private static boolean canBeCrossConnectedViaGlobalVars(IPredicate hier, IPredicate returnPred, Set<IProgramNonOldVar> modifiableGlobals, boolean returnPredImpliesHier) {
        for (IProgramVar pv : returnPred.getVars()) {
            if (pv instanceof IProgramOldVar) {
                IProgramNonOldVar nonOld = ((IProgramOldVar)pv).getNonOldVar();
                if (hier.getVars().contains(nonOld)) {
                    return true;
                }
                if (returnPredImpliesHier || modifiableGlobals.contains(nonOld) || !hier.getVars().contains(pv)) continue;
                return true;
            }
            if (!(pv instanceof IProgramNonOldVar) || returnPredImpliesHier || modifiableGlobals.contains(pv)) continue;
            if (hier.getVars().contains(pv)) {
                return true;
            }
            IProgramOldVar oldVar = ((IProgramNonOldVar)pv).getOldVar();
            if (!hier.getVars().contains(oldVar)) continue;
            return true;
        }
        return false;
    }

    private static boolean isConnectedViaLocalVarsAssignment(IPredicate hier, UnmodifiableTransFormula localVarsAssignment, IPredicate returnPred) {
        return !SdHoareTripleCheckerHelper.varSetDisjoint(localVarsAssignment.getAssignedVars(), returnPred.getVars()) && !SdHoareTripleCheckerHelper.varSetDisjoint(hier.getVars(), localVarsAssignment.getInVars().keySet());
    }

    private static boolean isSelfConnectedViaLocalVarsAssignment(IPredicate returnPred, UnmodifiableTransFormula localVarsAssignment) {
        return !SdHoareTripleCheckerHelper.varSetDisjoint(localVarsAssignment.getAssignedVars(), returnPred.getVars());
    }

    private static boolean prePostIndependent(IPredicate pre, IReturnAction ret, IPredicate post) {
        UnmodifiableTransFormula returnAssignTf = ret.getAssignmentOfReturn();
        if (!SdHoareTripleCheckerHelper.varSetDisjoint(pre.getVars(), returnAssignTf.getInVars().keySet()) && !SdHoareTripleCheckerHelper.varSetDisjoint(returnAssignTf.getAssignedVars(), post.getVars())) {
            return false;
        }
        UnmodifiableTransFormula locVarAssignTf = ret.getLocalVarsAssignmentOfCall();
        if (!SdHoareTripleCheckerHelper.varSetDisjoint(post.getVars(), locVarAssignTf.getInVars().keySet()) && !SdHoareTripleCheckerHelper.varSetDisjoint(locVarAssignTf.getAssignedVars(), pre.getVars())) {
            return false;
        }
        for (IProgramVar bv : pre.getVars()) {
            if (!bv.isGlobal() || bv.isOldvar() || !post.getVars().contains(bv)) continue;
            return false;
        }
        return true;
    }

    private boolean hierPostIndependent(IPredicate hier, IReturnAction ret, IPredicate post) {
        Set<IProgramVar> assignedVars = ret.getAssignmentOfReturn().getAssignedVars();
        String proc = ret.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(proc);
        for (IProgramVar bv : post.getVars()) {
            if (modifiableGlobals.contains(bv) || assignedVars.contains(bv) || !hier.getVars().contains(bv)) continue;
            return false;
        }
        return true;
    }

    public IncrementalPlicationChecker.Validity sdecInternalSelfloop(IPredicate p, IInternalAction act) {
        Set<IProgramVar> assignedVars = act.getTransformula().getAssignedVars();
        Set<IProgramVar> occVars = p.getVars();
        for (IProgramVar occVar : occVars) {
            if (!assignedVars.contains(occVar)) continue;
            return null;
        }
        this.mHoareTripleCheckerStatistics.getSDsluCounter().incIn();
        return IncrementalPlicationChecker.Validity.VALID;
    }

    public IncrementalPlicationChecker.Validity sdecCallSelfloop(IPredicate p, ICallAction call) {
        for (IProgramVar bv : p.getVars()) {
            if (!bv.isGlobal()) {
                return null;
            }
            if (!bv.isOldvar()) continue;
            return null;
        }
        this.mHoareTripleCheckerStatistics.getSDsluCounter().incCa();
        return IncrementalPlicationChecker.Validity.VALID;
    }

    public IncrementalPlicationChecker.Validity sdecReturnSelfloopPre(IPredicate p, IReturnAction ret) {
        Set<IProgramVar> assignedVars = ret.getAssignmentOfReturn().getAssignedVars();
        for (IProgramVar bv : p.getVars()) {
            if (!bv.isGlobal()) {
                return null;
            }
            if (bv.isOldvar()) {
                return null;
            }
            if (!assignedVars.contains(bv)) continue;
            return null;
        }
        this.mHoareTripleCheckerStatistics.getSDsluCounter().incRe();
        return IncrementalPlicationChecker.Validity.VALID;
    }

    public IncrementalPlicationChecker.Validity sdecReturnSelfloopHier(IPredicate p, IReturnAction ret) {
        Set<IProgramVar> assignedVars = ret.getAssignmentOfReturn().getAssignedVars();
        String proc = ret.getPrecedingProcedure();
        Set<IProgramNonOldVar> modifiableGlobals = this.mModifiableGlobalVariableManager.getModifiedBoogieVars(proc);
        for (IProgramVar bv : p.getVars()) {
            if (modifiableGlobals.contains(bv)) {
                return null;
            }
            if (!assignedVars.contains(bv)) continue;
            return null;
        }
        return IncrementalPlicationChecker.Validity.VALID;
    }

    private static boolean isOrIteFormula(IPredicate p) {
        Term formula = p.getFormula();
        if (formula instanceof ApplicationTerm) {
            ApplicationTerm appTerm = (ApplicationTerm)formula;
            FunctionSymbol symbol = appTerm.getFunction();
            return "or".equals(symbol.getName()) || "ite".equals(symbol.getName());
        }
        return false;
    }
}

