/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.lib.exceptions.ToolchainCanceledException;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.util.LexicographicCounter;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.ThreeValuedEquivalenceRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.SymmetricHashRelation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class EquivalenceRelationIterator<E>
implements Iterable<Set<Doubleton<E>>> {
    private final IUltimateServiceProvider mServices;
    private final List<Set<Doubleton<E>>> mResult = new ArrayList<Set<Doubleton<E>>>();
    private final LinkedList<Boolean> mStack = new LinkedList();
    private SymmetricHashRelation<E> mCurrentRelation;
    private final List<Doubleton<E>> mNonDisjointDoubletons;
    private final ThreeValuedEquivalenceRelation<E> mEqualityInformation;
    private final IExternalOracle<E> mExternalOracle;

    public EquivalenceRelationIterator(IUltimateServiceProvider services, Collection<E> indices, ThreeValuedEquivalenceRelation<E> equalityInformation, IExternalOracle<E> externalOracle, List<Doubleton<E>> relevant) {
        boolean failedToPushOnEmptyStack;
        this.mServices = services;
        this.mNonDisjointDoubletons = relevant;
        this.mEqualityInformation = equalityInformation;
        this.mExternalOracle = externalOracle;
        this.mCurrentRelation = new SymmetricHashRelation();
        do {
            if (this.mStack.size() != this.mNonDisjointDoubletons.size()) continue;
            this.addRelationToResult();
            if (this.mCurrentRelation.isEmpty()) break;
        } while (!(failedToPushOnEmptyStack = this.advance()));
    }

    public EquivalenceRelationIterator(IUltimateServiceProvider services, Collection<E> indices, ThreeValuedEquivalenceRelation<E> equalityInformation, IExternalOracle<E> externalOracle) {
        this(services, indices, equalityInformation, externalOracle, EquivalenceRelationIterator.buildListOfNonDisjointDoubletons(indices, equalityInformation));
    }

    private boolean checkResultWithOldCombinationIterator(Collection<E> indices, ThreeValuedEquivalenceRelation<E> equalityInformation) {
        HashSet<Set<Doubleton<E>>> newResult = new HashSet<Set<Doubleton<E>>>(this.mResult);
        HashSet oldResult = new HashSet();
        EquivalenceRelationIterator2 ci = new EquivalenceRelationIterator2(indices, equalityInformation);
        for (Set e : ci) {
            oldResult.add(e);
        }
        assert (newResult.equals(oldResult)) : "result of CombinationIterator and CombinationIterator2 is different " + newResult.size() + " vs. " + oldResult.size();
        return newResult.equals(oldResult);
    }

    private boolean advance() {
        if (this.mStack.size() == this.mNonDisjointDoubletons.size()) {
            boolean finished = this.remove1true();
            if (finished) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        return this.tryToPush1True();
    }

    private boolean tryToPush1False() {
        Doubleton<E> d = this.mNonDisjointDoubletons.get(this.mStack.size());
        if (this.mCurrentRelation.containsPair(d.getOneElement(), d.getOtherElement())) {
            boolean finished = this.remove1true();
            if (finished) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        this.mStack.add(false);
        if (!this.mExternalOracle.isConsistent(this.mStack, this.mNonDisjointDoubletons)) {
            this.mStack.removeLast();
            if (this.mStack.isEmpty()) {
                return true;
            }
            boolean finished = this.remove1true();
            if (finished) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        return false;
    }

    private boolean tryToPush1True() {
        Doubleton<E> d = this.mNonDisjointDoubletons.get(this.mStack.size());
        if (this.mEqualityInformation.getEqualityStatus(d.getOneElement(), d.getOtherElement()) == EqualityStatus.NOT_EQUAL) {
            return false;
        }
        this.mStack.add(true);
        this.mCurrentRelation.addPair(d.getOneElement(), d.getOtherElement());
        Set newPairs = this.mCurrentRelation.makeTransitive();
        boolean containsDisjointPair = this.containsNotEqualsPair(newPairs);
        if (containsDisjointPair || !this.mExternalOracle.isConsistent(this.mStack, this.mNonDisjointDoubletons)) {
            boolean finished = this.remove1true();
            if (finished) {
                return true;
            }
            this.rebuildCurrentRelation();
            return this.tryToPush1False();
        }
        return false;
    }

    private boolean containsNotEqualsPair(Set<Doubleton<E>> pairs1) {
        for (Doubleton<E> pairFrom1 : pairs1) {
            if (this.mEqualityInformation.getEqualityStatus(pairFrom1.getOneElement(), pairFrom1.getOtherElement()) != EqualityStatus.NOT_EQUAL) continue;
            return true;
        }
        return false;
    }

    private void rebuildCurrentRelation() {
        this.mCurrentRelation = new SymmetricHashRelation();
        int offset = 0;
        for (Boolean bool : this.mStack) {
            if (bool.booleanValue()) {
                Doubleton<E> doubleton = this.mNonDisjointDoubletons.get(offset);
                this.mCurrentRelation.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
            }
            ++offset;
        }
        this.mCurrentRelation.makeTransitive();
    }

    private boolean remove1true() {
        while (!this.mStack.peekLast().booleanValue()) {
            this.mStack.removeLast();
            if (!this.mStack.isEmpty()) continue;
            return true;
        }
        this.mStack.removeLast();
        return false;
    }

    private void addRelationToResult() {
        this.mResult.add(this.mCurrentRelation.buildSetOfNonSymmetricDoubletons());
    }

    public int size() {
        return this.mResult.size();
    }

    @Override
    public Iterator<Set<Doubleton<E>>> iterator() {
        return this.mResult.iterator();
    }

    static <E> List<Doubleton<E>> buildListOfNonDisjointDoubletons(Collection<E> indices, ThreeValuedEquivalenceRelation<E> equalityInformation) {
        ArrayList<Doubleton<Doubleton>> doubeltons = new ArrayList<Doubleton<Doubleton>>();
        ArrayList<E> indexList = new ArrayList<E>(indices);
        int i = 0;
        while (i < indexList.size()) {
            if (equalityInformation.isRepresentative(indexList.get(i))) {
                int j = i + 1;
                while (j < indexList.size()) {
                    if (equalityInformation.isRepresentative(indexList.get(j)) && equalityInformation.getEqualityStatus(indexList.get(i), indexList.get(j)) != EqualityStatus.NOT_EQUAL) {
                        doubeltons.add(new Doubleton(indexList.get(i), indexList.get(j)));
                    }
                    ++j;
                }
            }
            ++i;
        }
        return doubeltons;
    }

    public static <E> boolean isClosedUnderTransitivity(HashRelation<E, E> relation) {
        for (Map.Entry entry : relation.getSetOfPairs()) {
            for (Object image : relation.getImage(entry.getValue())) {
                if (relation.containsPair(entry.getKey(), image)) continue;
                return false;
            }
        }
        return true;
    }

    public static class DefaultExternalOracle<E>
    implements IExternalOracle<E> {
        @Override
        public boolean isConsistent(LinkedList<Boolean> stack, List<Doubleton<E>> nonDisjointDoubletons) {
            return true;
        }
    }

    private class EquivalenceRelationIterator2
    implements Iterable<Set<Doubleton<E>>> {
        private final List<Set<Doubleton<E>>> mResult = new ArrayList();

        public EquivalenceRelationIterator2(Collection<E> indices, ThreeValuedEquivalenceRelation<E> equalityInformation) {
            List doubeltons = EquivalenceRelationIterator.buildListOfNonDisjointDoubletons(indices, equalityInformation);
            int[] numberOfValues = new int[doubeltons.size()];
            Arrays.fill(numberOfValues, 2);
            LexicographicCounter lc = new LexicographicCounter(numberOfValues);
            do {
                if (!EquivalenceRelationIterator.this.mServices.getProgressMonitorService().continueProcessing()) {
                    throw new ToolchainCanceledException(this.getClass(), "iterating over LexicographicCounter " + lc);
                }
                HashRelation relationCandidate = new HashRelation();
                for (Object index : indices) {
                    if (!equalityInformation.isRepresentative(index)) continue;
                    relationCandidate.addPair(index, index);
                }
                HashSet resultCandidate = new HashSet();
                int i = 0;
                while (i < doubeltons.size()) {
                    if (lc.getCurrentValue()[i] == 1) {
                        Doubleton doubleton = doubeltons.get(i);
                        relationCandidate.addPair(doubleton.getOneElement(), doubleton.getOtherElement());
                        relationCandidate.addPair(doubleton.getOtherElement(), doubleton.getOneElement());
                        resultCandidate.add(doubleton);
                    }
                    ++i;
                }
                if (EquivalenceRelationIterator.isClosedUnderTransitivity(relationCandidate)) {
                    this.mResult.add(resultCandidate);
                }
                lc.increment();
            } while (!lc.isZero());
        }

        public int size() {
            return this.mResult.size();
        }

        @Override
        public Iterator<Set<Doubleton<E>>> iterator() {
            return this.mResult.iterator();
        }
    }

    public static interface IExternalOracle<E> {
        public boolean isConsistent(LinkedList<Boolean> var1, List<Doubleton<E>> var2);
    }
}

