/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;

public class MonolithicImplicationChecker {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mManagedScript;

    public MonolithicImplicationChecker(IUltimateServiceProvider services, ManagedScript managedScript) {
        this.mServices = services;
        this.mManagedScript = managedScript;
    }

    public IncrementalPlicationChecker.Validity checkImplication(IPredicate antecedent, boolean affirmAntecedentNeitherValidNorUnsat, IPredicate succedent, boolean affirmSuccedentNeitherValidNorUnsat) {
        return this.checkImplication(antecedent.getFormula(), antecedent.getClosedFormula(), affirmAntecedentNeitherValidNorUnsat, succedent.getFormula(), succedent.getClosedFormula(), affirmSuccedentNeitherValidNorUnsat);
    }

    public IncrementalPlicationChecker.Validity checkImplication(Term antecedent, Term antecedentClosedFormula, boolean affirmAntecedentNeitherValidNorUnsat, Term succedent, Term succedentClosedFormula, boolean affirmSuccedentNeitherValidNorUnsat) {
        IncrementalPlicationChecker.Validity dataflowAnalysisResult;
        if (affirmAntecedentNeitherValidNorUnsat && affirmSuccedentNeitherValidNorUnsat && (dataflowAnalysisResult = this.dataflowBasedImplicationCheck(antecedent, succedent)) == IncrementalPlicationChecker.Validity.INVALID) {
            return dataflowAnalysisResult;
        }
        if (this.mManagedScript.isLocked()) {
            this.mManagedScript.requestLockRelease();
        }
        this.mManagedScript.lock((Object)this);
        this.mManagedScript.echo((Object)this, new QuotedObject("Start implication check"));
        this.mManagedScript.push((Object)this, 1);
        this.mManagedScript.assertTerm((Object)this, antecedentClosedFormula);
        this.mManagedScript.assertTerm((Object)this, SmtUtils.not((Script)this.mManagedScript.getScript(), (Term)succedentClosedFormula));
        Script.LBool lbool = this.mManagedScript.checkSat((Object)this);
        this.mManagedScript.pop((Object)this, 1);
        this.mManagedScript.echo((Object)this, new QuotedObject("Finished implication check"));
        this.mManagedScript.unlock((Object)this);
        return IncrementalPlicationChecker.convertLBool2Validity((Script.LBool)lbool);
    }

    private IncrementalPlicationChecker.Validity dataflowBasedImplicationCheck(Term antecedent, Term succedent) {
        return IncrementalPlicationChecker.Validity.UNKNOWN;
    }
}

