/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.NnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierPusher;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;

public class QuantifierOverapproximatingSolver
extends WrapperScript {
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final Stack<Boolean> mOverapproxiamtionStack;
    private boolean mInUsatCoreMode;
    private Set<Term> mAdditionalUnsatCoreContent;

    public QuantifierOverapproximatingSolver(IUltimateServiceProvider services, ILogger logger, Script script) {
        super(script);
        this.mServices = services;
        this.mMgdScript = new ManagedScript(services, script);
        this.mOverapproxiamtionStack = new Stack();
        this.mOverapproxiamtionStack.push(false);
    }

    public void setOption(String opt, Object value) throws UnsupportedOperationException, SMTLIBException {
        Boolean b;
        if (opt.equals(":produce-unsat-cores") && (b = (Boolean)value).booleanValue()) {
            this.mInUsatCoreMode = true;
            assert (this.mAdditionalUnsatCoreContent == null);
            this.mAdditionalUnsatCoreContent = new HashSet<Term>();
        }
        this.mScript.setOption(opt, value);
    }

    public void push(int levels) throws SMTLIBException {
        int i = 0;
        while (i < levels) {
            this.mOverapproxiamtionStack.push(false);
            ++i;
        }
        this.mScript.push(levels);
    }

    public void pop(int levels) throws SMTLIBException {
        int i = 0;
        while (i < levels) {
            this.mOverapproxiamtionStack.pop();
            ++i;
        }
        this.mScript.pop(levels);
    }

    private Term skolemizeOA(QuantifiedFormula inputFormula) {
        QuantifierSequence qs = new QuantifierSequence(this.mMgdScript, (Term)inputFormula);
        QuantifierSequence.QuantifiedVariables qb = (QuantifierSequence.QuantifiedVariables)qs.getQuantifierBlocks().get(0);
        Term newInnerTerm = qs.getInnerTerm();
        int block = 0;
        while (block < qs.getQuantifierBlocks().size()) {
            List qVar = qs.getQuantifierBlocks();
            if (((QuantifierSequence.QuantifiedVariables)qVar.get(block)).getQuantifier() == 0 && block == 0) {
                HashMap<TermVariable, Term> subMap = new HashMap<TermVariable, Term>();
                for (TermVariable qtv : qb.getVariables()) {
                    TermVariable ctv = this.mMgdScript.constructFreshTermVariable("skolemconst", qtv.getSort());
                    Term newConst = SmtUtils.termVariable2constant((Script)this.mMgdScript.getScript(), (TermVariable)ctv, (boolean)true);
                    subMap.put(qtv, newConst);
                }
                newInnerTerm = Substitution.apply((ManagedScript)this.mMgdScript, subMap, (Term)newInnerTerm);
            }
            ++block;
        }
        Term reAddQuantifiers = QuantifierSequence.prependQuantifierSequence((Script)this.mMgdScript.getScript(), (List)qs.getQuantifierBlocks(), (Term)newInnerTerm);
        return reAddQuantifiers;
    }

    private Term overApproximate(Term term) {
        Term nnf = new NnfTransformer(this.mMgdScript, this.mServices, NnfTransformer.QuantifierHandling.KEEP, true).transform(term);
        Term pushed = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (boolean)true, (QuantifierPusher.PqeTechniques)QuantifierPusher.PqeTechniques.ALL_LOCAL, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.NONE, (Term)nnf);
        Term qfree = this.mMgdScript.getScript().term("true", new Term[0]);
        Term[] termArray = SmtUtils.getConjuncts((Term)pushed);
        int n = termArray.length;
        int n2 = 0;
        while (n2 < n) {
            Term pnfTerm;
            Term cojunct = termArray[n2];
            if (!QuantifierUtils.isQuantifierFree((Term)cojunct) && !QuantifierUtils.isQuantifierFree((Term)(pnfTerm = new PrenexNormalForm(this.mMgdScript).transform(cojunct)))) {
                Term snfTerm = this.skolemizeOA((QuantifiedFormula)pnfTerm);
                cojunct = snfTerm instanceof QuantifiedFormula ? this.mMgdScript.getScript().term("true", new Term[0]) : snfTerm;
            }
            qfree = SmtUtils.and((Script)this.mMgdScript.getScript(), (Term[])new Term[]{cojunct, qfree});
            ++n2;
        }
        return qfree;
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        Script.LBool result;
        Term withoutLet = new FormulaUnLet().transform(term);
        if (!QuantifierUtils.isQuantifierFree((Term)withoutLet)) {
            if (!this.mOverapproxiamtionStack.peek().booleanValue()) {
                this.mOverapproxiamtionStack.pop();
                this.mOverapproxiamtionStack.push(true);
            }
            withoutLet = this.overApproximate(withoutLet);
        }
        if ((result = this.mScript.assertTerm(withoutLet)).equals((Object)Script.LBool.SAT) && this.wasSomeAssertedTermOverapproximated()) {
            return Script.LBool.UNKNOWN;
        }
        return result;
    }

    private boolean wasSomeAssertedTermOverapproximated() {
        return this.mOverapproxiamtionStack.stream().anyMatch(x -> x);
    }

    public Script.LBool checkSat() throws SMTLIBException {
        Script.LBool result = this.mScript.checkSat();
        if (result.equals((Object)Script.LBool.SAT) && this.wasSomeAssertedTermOverapproximated()) {
            return Script.LBool.UNKNOWN;
        }
        if (this.mInUsatCoreMode && result.equals((Object)Script.LBool.UNSAT)) {
            Term[] uc = this.getUnsatCore();
            this.mAdditionalUnsatCoreContent.addAll(Arrays.asList(uc));
        }
        return result;
    }

    public boolean isInUsatCoreMode() {
        return this.mInUsatCoreMode;
    }

    public Set<Term> getAdditionalUnsatCoreContent() {
        return this.mAdditionalUnsatCoreContent;
    }
}

