/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.logic.AnnotatedTerm;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;

public class SMTPrettyPrinter {
    private static final String INDENT = "    ";
    private static final String[] INFIX_FUNCTIONS = new String[]{"+", "-", "*", "/", "=", ">=", "<=", ">", "<"};
    private final Term mTerm;

    public SMTPrettyPrinter(Term term) {
        this.mTerm = term;
    }

    private static void indent(StringBuilder sb, int indentation) {
        int i = 0;
        while (i < indentation) {
            sb.append(INDENT);
            ++i;
        }
    }

    private static String print(Term term, int indentation) {
        assert (indentation >= 0);
        StringBuilder sb = new StringBuilder();
        if (term instanceof ConstantTerm) {
            return term.toString();
        }
        if (term instanceof TermVariable) {
            return term.toString();
        }
        if (term instanceof ApplicationTerm) {
            ApplicationTerm appt = (ApplicationTerm)term;
            String fname = appt.getFunction().getName();
            if (appt.getParameters().length == 0) {
                return fname;
            }
            if (fname.equals("ite")) {
                sb.append("(");
                sb.append(SMTPrettyPrinter.print(appt.getParameters()[0], indentation + 1));
                sb.append(" ? ");
                sb.append(SMTPrettyPrinter.print(appt.getParameters()[1], indentation + 1));
                sb.append(" : ");
                sb.append(SMTPrettyPrinter.print(appt.getParameters()[2], indentation + 1));
                sb.append(")");
                return sb.toString();
            }
            sb.append("(");
            boolean infix = false;
            String[] stringArray = INFIX_FUNCTIONS;
            int n = INFIX_FUNCTIONS.length;
            int n2 = 0;
            while (n2 < n) {
                String infix_fname = stringArray[n2];
                if (fname.equals(infix_fname)) {
                    infix = true;
                }
                ++n2;
            }
            if (appt.getParameters().length == 1) {
                sb.append(fname);
                sb.append(" ");
                sb.append(SMTPrettyPrinter.print(appt.getParameters()[0], 0));
                sb.append(")");
                return sb.toString();
            }
            if (!infix) {
                sb.append(fname);
                sb.append("\n");
            }
            int i = 0;
            while (i < appt.getParameters().length) {
                if (infix) {
                    if (i > 0) {
                        sb.append(" ");
                        sb.append(fname);
                        sb.append(" ");
                    }
                } else {
                    SMTPrettyPrinter.indent(sb, indentation + 1);
                }
                sb.append(SMTPrettyPrinter.print(appt.getParameters()[i], indentation + 1));
                if (!infix) {
                    sb.append("\n");
                }
                ++i;
            }
            if (!infix) {
                SMTPrettyPrinter.indent(sb, indentation);
            }
            sb.append(")");
        } else if (term instanceof AnnotatedTerm) {
            AnnotatedTerm annot = (AnnotatedTerm)term;
            Annotation[] annotationArray = annot.getAnnotations();
            int n = annotationArray.length;
            int n3 = 0;
            while (n3 < n) {
                Annotation a = annotationArray[n3];
                SMTPrettyPrinter.indent(sb, indentation);
                sb.append("{");
                sb.append(a.getKey());
                sb.append(" ");
                sb.append(a.getValue());
                sb.append("}\n");
                ++n3;
            }
            sb.append(SMTPrettyPrinter.print(annot.getSubterm(), indentation));
        } else assert (false);
        return sb.toString();
    }

    public String toString() {
        return SMTPrettyPrinter.print(this.mTerm, 0);
    }
}

