/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.CfgSmtToolkit;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IteRemover;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.smtsolver.external.TermParseUtils;
import java.util.Set;
import java.util.stream.Collectors;

public final class SmtParserUtils {
    private SmtParserUtils() {
    }

    public static Term parseWithVariables(String syntax, IUltimateServiceProvider services, CfgSmtToolkit csToolkit) {
        return SmtParserUtils.parseWithVariables(syntax, services, csToolkit.getManagedScript(), csToolkit.getSymbolTable());
    }

    public static Term parseWithVariables(String syntax, IUltimateServiceProvider services, ManagedScript mgdScript, IIcfgSymbolTable symbolTable) {
        Set<TermVariable> termVars = symbolTable.getGlobals().stream().map(IProgramVar::getTermVariable).collect(Collectors.toSet());
        return SmtParserUtils.parseWithVariables(syntax, services, mgdScript, termVars);
    }

    public static Term parseWithVariables(String syntax, IUltimateServiceProvider services, ManagedScript mgdScript, Set<TermVariable> variables) {
        if (variables.isEmpty()) {
            return SmtParserUtils.parse(syntax, services, mgdScript);
        }
        String declarations = variables.stream().map(tv -> String.format("(%1$s %2$s)", tv.getName(), tv.getSort())).collect(Collectors.joining(" "));
        String fullSyntax = "(forall (" + declarations + ") " + syntax + ")";
        QuantifiedFormula quant = (QuantifiedFormula)TermParseUtils.parseTerm((Script)mgdScript.getScript(), (String)fullSyntax);
        return SmtParserUtils.normalize(quant.getSubformula(), services, mgdScript);
    }

    public static Term parse(String syntax, IUltimateServiceProvider services, ManagedScript mgdScript) {
        Term parsed = TermParseUtils.parseTerm((Script)mgdScript.getScript(), (String)syntax);
        return SmtParserUtils.normalize(parsed, services, mgdScript);
    }

    private static Term normalize(Term term, IUltimateServiceProvider services, ManagedScript mgdScript) {
        Term noLet = new FormulaUnLet().transform(term);
        Term noIte = SmtSortUtils.isBoolSort((Sort)noLet.getSort()) ? new IteRemover(mgdScript).transform(noLet) : noLet;
        return new CommuhashNormalForm(services, mgdScript.getScript()).transform(noIte);
    }
}

