/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtSortUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation3;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public final class SmtTestGenerationUtils {
    private SmtTestGenerationUtils() {
    }

    @Deprecated
    public static String generateStringForTestfile(Term term) {
        StringBuilder result = new StringBuilder();
        result.append(System.lineSeparator());
        HashSet<Sort> sorts = new HashSet<Sort>();
        TermVariable[] freeVars = term.getFreeVars();
        TermVariable[] termVariableArray = freeVars;
        int n = freeVars.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable tv = termVariableArray[n2];
            sorts.add(tv.getSort());
            ++n2;
        }
        HashMap<Sort, String> sortVarMapping = new HashMap<Sort, String>();
        int counter = 0;
        for (Sort sort : sorts) {
            String varName;
            String declaration;
            if (SmtSortUtils.isIntSort((Sort)sort)) {
                sortVarMapping.put(sort, "intSort");
                declaration = String.format("final Sort %s = SmtSortUtils.getIntSort(mMgdScript);", "intSort");
            } else if (SmtSortUtils.isArraySort((Sort)sort)) {
                if (SmtTestGenerationUtils.isIntIntArray(sort)) {
                    sortVarMapping.put(sort, "intintArraySort");
                    declaration = String.format("final Sort %s = SmtSortUtils.getArraySort(mScript, intSort, intSort);", "intintArraySort");
                } else if (SmtTestGenerationUtils.isIntIntIntArray(sort)) {
                    sortVarMapping.put(sort, "intintintArraySort");
                    declaration = String.format("final Sort %s = SmtSortUtils.getArraySort(mScript, intSort, SmtSortUtils.getArraySort(mScript, intSort, intSort));", "intintintArraySort");
                } else {
                    varName = "arraySort" + counter;
                    ++counter;
                    sortVarMapping.put(sort, varName);
                    declaration = String.format("final Sort %s = SmtSortUtils.getArraySort(...); // %s", varName, sort);
                }
            } else {
                varName = "otherSort" + counter;
                ++counter;
                sortVarMapping.put(sort, varName);
                declaration = String.format("final Sort %s = // %s", varName, sort);
            }
            result.append(declaration);
            result.append(System.lineSeparator());
        }
        TermVariable[] termVariableArray2 = freeVars;
        int n3 = freeVars.length;
        int n4 = 0;
        while (n4 < n3) {
            TermVariable tv = termVariableArray2[n4];
            String declaration = String.format("mScript.declareFun(\"%s\", new Sort[0], %s);", tv.getName(), sortVarMapping.get(tv.getSort()));
            result.append(declaration);
            result.append(System.lineSeparator());
            ++n4;
        }
        result.append(String.format("final String formulaAsString = \"%s\";", term.toStringDirect()));
        result.append(System.lineSeparator());
        result.append("final Term formulaAsTerm = TermParseUtils.parseTerm(mScript, formulaAsString);");
        return result.toString();
    }

    public static String generateStringForTestfile2(Term term) {
        int n;
        Object object;
        TermVariable[] freeVars = term.getFreeVars();
        Set funSyms = SmtUtils.extractNonTheoryFunctionSymbols((Term)term);
        HashSet<Sort> sorts = new HashSet<Sort>();
        TermVariable[] termVariableArray = freeVars;
        int n2 = freeVars.length;
        int n3 = 0;
        while (n3 < n2) {
            TermVariable tv = termVariableArray[n3];
            sorts.add(tv.getSort());
            ++n3;
        }
        for (FunctionSymbol fun : funSyms) {
            sorts.add(fun.getReturnSort());
            object = fun.getParameterSorts();
            n = ((Sort[])object).length;
            int n4 = 0;
            while (n4 < n) {
                Sort pSort = object[n4];
                sorts.add(pSort);
                ++n4;
            }
        }
        HashMap<Sort, String> sortVarMapping = new HashMap<Sort, String>();
        for (Sort sort : sorts) {
            String constructionString = SmtSortUtils.isBoolSort((Sort)sort) ? "SmtSortUtils::getBoolSort" : (SmtSortUtils.isRealSort((Sort)sort) ? "SmtSortUtils::getRealSort" : (SmtSortUtils.isIntSort((Sort)sort) ? "SmtSortUtils::getIntSort" : (SmtSortUtils.isArraySort((Sort)sort) ? (SmtTestGenerationUtils.isIntIntArray(sort) ? "QuantifierEliminationTest::constructIntIntArray" : (SmtTestGenerationUtils.isIntIntIntArray(sort) ? "QuantifierEliminationTest::constructIntIntIntArray" : "arraySort0")) : "otherSort0")));
            sortVarMapping.put(sort, constructionString);
        }
        HashRelation sort2TermVariable = new HashRelation();
        object = freeVars;
        n = freeVars.length;
        int constructionString = 0;
        while (constructionString < n) {
            Sort tv = object[constructionString];
            sort2TermVariable.addPair((Object)tv.getSort(), (Object)tv);
            ++constructionString;
        }
        HashRelation3 sortFunctionSymbol = new HashRelation3();
        for (FunctionSymbol funSym : funSyms) {
            sortFunctionSymbol.addTriple((Object)funSym.getParameterSorts(), (Object)funSym.getReturnSort(), (Object)funSym);
        }
        StringBuilder result = new StringBuilder();
        result.append(System.lineSeparator());
        result.append("\tfinal FunDecl[] funDecls = new FunDecl[] {");
        result.append(System.lineSeparator());
        for (Map.Entry entry : sort2TermVariable.entrySet()) {
            String idList = ((HashSet)entry.getValue()).stream().map(x -> "\"" + x + "\"").collect(Collectors.joining(", "));
            String sortConstructionString = (String)sortVarMapping.get(entry.getKey());
            String funDecl = String.format("\t\tnew FunDecl(%s, %s),", sortConstructionString, idList);
            result.append(funDecl);
            result.append(System.lineSeparator());
        }
        for (Object[] paramSorts : sortFunctionSymbol.projectToFst()) {
            for (Sort returnSort : sortFunctionSymbol.projectToSnd((Object)paramSorts)) {
                String returnSortConstructionString = (String)sortVarMapping.get(returnSort);
                Set funs = sortFunctionSymbol.projectToTrd((Object)paramSorts, (Object)returnSort);
                String idList = funs.stream().map(x -> "\"" + x.getName() + "\"").collect(Collectors.joining(", "));
                if (Arrays.equals(paramSorts, new Sort[0])) {
                    String funDecl = String.format("\t\tnew FunDecl(%s, %s),", returnSortConstructionString, idList);
                    result.append(funDecl);
                    result.append(System.lineSeparator());
                    continue;
                }
                throw new UnsupportedOperationException("not yet implemented");
            }
        }
        result.append("\t};");
        result.append(System.lineSeparator());
        result.append(String.format("\tfinal String formulaAsString = \"%s\";", term.toStringDirect()));
        result.append(System.lineSeparator());
        return result.toString();
    }

    private static boolean isIntIntArray(Sort sort) {
        return SmtSortUtils.isArraySort((Sort)sort) && sort.getArguments().length == 2 && SmtSortUtils.isIntSort((Sort)sort.getArguments()[0]) && SmtSortUtils.isIntSort((Sort)sort.getArguments()[1]);
    }

    private static boolean isIntIntIntArray(Sort sort) {
        return SmtSortUtils.isArraySort((Sort)sort) && sort.getArguments().length == 2 && SmtSortUtils.isIntSort((Sort)sort.getArguments()[0]) && SmtTestGenerationUtils.isIntIntArray(sort.getArguments()[1]);
    }
}

