/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.ConstantTerm;
import de.uni_freiburg.informatik.ultimate.logic.QuantifiedFormula;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.simplifier.INormalFormable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public class TermNormalFormTransformer
implements INormalFormable<Term> {
    private final Script mScript;
    private final Term mTrue;
    private final Term mFalse;

    public TermNormalFormTransformer(Script script) {
        this.mScript = script;
        this.mTrue = this.mScript.term("true", new Term[0]);
        this.mFalse = this.mScript.term("false", new Term[0]);
    }

    public Term changeForall(Term oldForAll, Term operand) {
        QuantifiedFormula quant = (QuantifiedFormula)oldForAll;
        return this.mScript.quantifier(1, quant.getVariables(), operand, (Term[][])new Term[0][]);
    }

    public Term makeAnd(Term next, Term notor) {
        return this.mScript.term("and", new Term[]{next, notor});
    }

    public Term makeFalse() {
        return this.mFalse;
    }

    public Term makeTrue() {
        return this.mTrue;
    }

    public Term changeExists(Term oldExists, Term operand) {
        QuantifiedFormula quant = (QuantifiedFormula)oldExists;
        return this.mScript.quantifier(0, quant.getVariables(), operand, (Term[][])new Term[0][]);
    }

    public Term makeOr(Iterator<Term> operands) {
        return this.mScript.term("or", TermNormalFormTransformer.toArray(operands));
    }

    public Term makeAnd(Iterator<Term> operands) {
        return this.mScript.term("and", TermNormalFormTransformer.toArray(operands));
    }

    public Term makeNot(Term operand) {
        return this.mScript.term("not", new Term[]{operand});
    }

    public Term getOperand(Term term) {
        ApplicationTerm appt;
        if (term instanceof ApplicationTerm && (appt = (ApplicationTerm)term).getParameters().length == 1) {
            return appt.getParameters()[0];
        }
        if (term instanceof QuantifiedFormula) {
            QuantifiedFormula quantf = (QuantifiedFormula)term;
            return quantf.getSubformula();
        }
        throw new IllegalArgumentException("Term " + term + " has no single operand");
    }

    public Collection<? extends Term> normalizeNesting(Term formula, Term subformula) {
        throw new UnsupportedOperationException();
    }

    public Term rewritePredNotEquals(Term atom) {
        throw new UnsupportedOperationException();
    }

    public Term negatePred(Term atom) {
        throw new UnsupportedOperationException();
    }

    public Iterator<Term> getOperands(Term formula) {
        throw new UnsupportedOperationException();
    }

    public boolean isAtom(Term formula) {
        return formula instanceof TermVariable || formula instanceof ConstantTerm;
    }

    public boolean isLiteral(Term formula) {
        ApplicationTerm appl;
        if (this.isAtom(formula)) {
            return true;
        }
        if (formula instanceof ApplicationTerm && "not".equals((appl = (ApplicationTerm)formula).getFunction().getName())) {
            Term param = appl.getParameters()[0];
            return this.isAtom(param);
        }
        return false;
    }

    public boolean isNot(Term formula) {
        return TermNormalFormTransformer.isFunctionApplication(formula, "not");
    }

    public boolean isAnd(Term formula) {
        return TermNormalFormTransformer.isFunctionApplication(formula, "and");
    }

    public boolean isOr(Term formula) {
        return TermNormalFormTransformer.isFunctionApplication(formula, "or");
    }

    public boolean isExists(Term formula) {
        return TermNormalFormTransformer.isQuantifier(formula, 0);
    }

    public boolean isForall(Term formula) {
        return TermNormalFormTransformer.isQuantifier(formula, 1);
    }

    public boolean isEqual(Term one, Term other) {
        return Objects.equals(one, other);
    }

    private static boolean isFunctionApplication(Term formula, String funName) {
        if (formula instanceof ApplicationTerm) {
            ApplicationTerm appl = (ApplicationTerm)formula;
            return appl.getFunction().getName().equals(funName);
        }
        return false;
    }

    private static boolean isQuantifier(Term formula, int quantifier) {
        if (formula instanceof QuantifiedFormula) {
            QuantifiedFormula quant = (QuantifiedFormula)formula;
            return quant.getQuantifier() == quantifier;
        }
        return false;
    }

    private static Term[] toArray(Iterator<Term> operands) {
        ArrayList list = new ArrayList();
        operands.forEachRemaining(list::add);
        Term[] terms = list.toArray(new Term[list.size()]);
        return terms;
    }

    public boolean isTrue(Term formula) {
        return "true".equals(formula.toString());
    }

    public boolean isFalse(Term formula) {
        return "false".equals(formula.toString());
    }
}

