/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.TransFormulaBuilder;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.UnmodifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.ProgramVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.SmtFreePredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.scripttransfer.TermTransferrer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class TransferrerWithVariableCache {
    private final ManagedScript mTargetScript;
    private final TermTransferrer mTransferrer;
    private final SmtFreePredicateFactory mFactory = new SmtFreePredicateFactory();
    private final Map<IProgramVarOrConst, IProgramVarOrConst> mCache = new HashMap<IProgramVarOrConst, IProgramVarOrConst>();

    public TransferrerWithVariableCache(Script sourceScript, ManagedScript targetScript) {
        this.mTargetScript = targetScript;
        this.mTransferrer = new TermTransferrer(sourceScript, targetScript.getScript(), new HashMap(), false);
    }

    public IProgramVar transferProgramVar(IProgramVar oldPv) {
        return (IProgramVar)this.mCache.computeIfAbsent(oldPv, x -> ProgramVarUtils.transferProgramVar(this.mTransferrer, oldPv));
    }

    public IProgramConst transferProgramConst(IProgramConst oldPc) {
        return (IProgramConst)this.mCache.computeIfAbsent(oldPc, x -> ProgramVarUtils.transferProgramConst(this.mTransferrer, oldPc));
    }

    public Set<IProgramVar> transferVariables(Set<IProgramVar> vars) {
        return vars.stream().map(this::transferProgramVar).collect(Collectors.toSet());
    }

    public UnmodifiableTransFormula transferTransFormula(UnmodifiableTransFormula tf) {
        return TransFormulaBuilder.transferTransformula(this, this.mTargetScript, tf, true);
    }

    public BasicPredicate transferPredicate(IPredicate predicate) {
        Set<IProgramVar> variables = this.transferVariables(predicate.getVars());
        Term transferredFormula = this.transferTerm(predicate.getFormula());
        Term transferredClosed = this.transferTerm(predicate.getClosedFormula());
        return this.mFactory.construct(serial -> new BasicPredicate(serial, predicate.getProcedures(), transferredFormula, variables, transferredClosed));
    }

    public <T extends Term> T transferTerm(T term) {
        return (T)this.mTransferrer.transform(term);
    }

    public TermTransferrer getTransferrer() {
        return this.mTransferrer;
    }
}

