/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt;

import de.uni_freiburg.informatik.ultimate.core.lib.results.GenericResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResult;
import de.uni_freiburg.informatik.ultimate.core.model.results.IResultWithSeverity;
import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.AnnotationRemover;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.NamedTermWrapper;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.QuantifierOverapproximatingSolver;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.normalforms.UnfTransformer;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PrenexNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierSequence;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.Annotation;
import de.uni_freiburg.informatik.ultimate.logic.FormulaUnLet;
import de.uni_freiburg.informatik.ultimate.logic.Logics;
import de.uni_freiburg.informatik.ultimate.logic.SMTLIBException;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.WrapperScript;
import de.uni_freiburg.informatik.ultimate.smtinterpol.util.DAGSize;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;

public class UltimateEliminator
extends WrapperScript {
    private static final boolean WRAP_BACKEND_SOLVER_WITH_QUANTIFIER_OVERAPPROXIMATION = true;
    private static final boolean APPLY_SIMPLE_E_SKOLEMIZATION = true;
    private static final boolean LOG_JUNIT_TEST = false;
    private final IUltimateServiceProvider mServices;
    private final ILogger mLogger;
    private final ManagedScript mMgdScript;
    private Script.LBool mExpectedResult;
    private long mTreeSizeOfAssertedTerms = 0L;
    private int mNumberOfAssertedTerms = 0;

    public UltimateEliminator(IUltimateServiceProvider services, ILogger logger, Script script) {
        super(UltimateEliminator.wrapIfNecessary(services, logger, script));
        this.mServices = services;
        this.mLogger = logger;
        this.mMgdScript = new ManagedScript(services, this.mScript);
    }

    private static Script wrapIfNecessary(IUltimateServiceProvider services, ILogger logger, Script script) {
        return new QuantifierOverapproximatingSolver(services, logger, script);
    }

    public void setLogic(String logic) throws UnsupportedOperationException, SMTLIBException {
        if (logic.startsWith("QF_")) {
            this.mScript.setLogic(logic);
        } else {
            String qFLogic = "QF_" + logic;
            if (Logics.valueOf((String)qFLogic) != null) {
                this.mScript.setLogic(qFLogic);
            } else {
                throw new AssertionError((Object)"No Quantifier Free Logic found for Overapproximation");
            }
        }
    }

    public void setLogic(Logics logic) throws UnsupportedOperationException, SMTLIBException {
        if (logic.isQuantified()) {
            Logics qFLogic = Logics.valueOf((String)("QF_" + logic.toString()));
            this.mScript.setLogic(qFLogic);
        } else {
            this.mScript.setLogic(logic);
        }
    }

    public void setInfo(String info, Object value) {
        if (info.equals(":status")) {
            String valueAsString = (String)value;
            this.mExpectedResult = Script.LBool.valueOf((String)valueAsString.toUpperCase());
        } else {
            this.mScript.setInfo(info, value);
        }
    }

    public void defineFun(String fun, TermVariable[] params, Sort resultSort, Term definition) throws SMTLIBException {
        if (!QuantifierUtils.isQuantifierFree((Term)definition)) {
            throw new UnsupportedOperationException("Cannot handle define-fun with quantified definition " + definition);
        }
        this.mScript.defineFun(fun, params, resultSort, definition);
    }

    public Script.LBool assertTerm(Term term) throws SMTLIBException {
        ++this.mNumberOfAssertedTerms;
        NamedTermWrapper ntw = new NamedTermWrapper(term);
        if (ntw.isIsNamed()) {
            this.mTreeSizeOfAssertedTerms += new DAGSize().treesize(ntw.getUnnamedTerm());
            return this.mScript.assertTerm(term);
        }
        Term hopfullyQuantifierFree = this.makeQuantifierFree(ntw.getUnnamedTerm());
        this.mTreeSizeOfAssertedTerms += new DAGSize().treesize(hopfullyQuantifierFree);
        return this.mScript.assertTerm(hopfullyQuantifierFree);
    }

    private Term makeQuantifierFree(Term term) {
        Term letFree = new FormulaUnLet().transform(term);
        Term annotationFree = new AnnotationRemover().transform(letFree);
        Term unf = new UnfTransformer(this.mMgdScript.getScript()).transform(annotationFree);
        Term lessQuantifier = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)unf);
        if (!QuantifierUtils.isQuantifierFree((Term)lessQuantifier)) {
            Term pnf = new PrenexNormalForm(this.mMgdScript).transform(lessQuantifier);
            QuantifierSequence qs = new QuantifierSequence(this.mMgdScript, pnf);
            if (qs.getNumberOfQuantifierBlocks() == 1 && ((QuantifierSequence.QuantifiedVariables)qs.getQuantifierBlocks().get(0)).getQuantifier() == 0) {
                return this.doSimpleESkolemization(lessQuantifier, qs);
            }
            throw new AssertionError((Object)("Result of partial quantifier elimination is not quantifier-free but an " + qs.buildQuantifierSequenceStringRepresentation() + " term."));
        }
        return lessQuantifier;
    }

    private Term doSimpleESkolemization(Term lessQuantifier, QuantifierSequence qs) {
        QuantifierSequence.QuantifiedVariables firstBlock = (QuantifierSequence.QuantifiedVariables)qs.getQuantifierBlocks().get(0);
        HashMap<TermVariable, Term> substitutionMapping = new HashMap<TermVariable, Term>();
        for (TermVariable tv : firstBlock.getVariables()) {
            String identifier = this.generateIdentifierForESkolemization(tv);
            this.mMgdScript.getScript().declareFun(identifier, new Sort[0], tv.getSort());
            Term constant = this.mMgdScript.getScript().term(identifier, new Term[0]);
            substitutionMapping.put(tv, constant);
        }
        Term result = Substitution.apply((ManagedScript)this.mMgdScript, substitutionMapping, (Term)qs.getInnerTerm());
        return result;
    }

    private String generateIdentifierForESkolemization(TermVariable tv) {
        return "UltimateSkolemizationId" + this.mNumberOfAssertedTerms + "_" + tv.getName();
    }

    public Script.LBool checkSat() throws SMTLIBException {
        Script.LBool result = this.mScript.checkSat();
        if (this.mExpectedResult != null) {
            this.mLogger.info((Object)("Expected result: " + result));
            if (this.mExpectedResult == Script.LBool.UNKNOWN) {
                if (result != Script.LBool.UNKNOWN) {
                    throw new AssertionError((Object)"Congratulations! We solved a difficult benchmark");
                }
            } else if (result != Script.LBool.UNKNOWN && result != this.mExpectedResult) {
                throw new AssertionError((Object)("Result incorrect: expected " + this.mExpectedResult + " obtained " + result + ". Treesize of asserted terms " + this.mTreeSizeOfAssertedTerms));
            }
        }
        this.mLogger.info((Object)("Computed result: " + result));
        IResult ultimateOutput = this.constructResult("check-sat", String.valueOf(result));
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", ultimateOutput);
        return result;
    }

    public Term[] getUnsatCore() throws SMTLIBException, UnsupportedOperationException {
        QuantifierOverapproximatingSolver qos = (QuantifierOverapproximatingSolver)this.mScript;
        assert (qos.isInUsatCoreMode());
        Term[] uc = this.mScript.getUnsatCore();
        HashSet<Term> result = new HashSet<Term>();
        result.addAll(qos.getAdditionalUnsatCoreContent());
        result.addAll(Arrays.asList(uc));
        IResult ultimateOutput = this.constructResult("get-unsat-core", String.valueOf(result));
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", ultimateOutput);
        return result.toArray(new Term[result.size()]);
    }

    public void exit() {
    }

    public Term annotate(Term t, Annotation ... annotations) throws SMTLIBException {
        if (Arrays.stream(annotations).anyMatch(x -> x.getKey().equals(":named"))) {
            Term hopfullyQuantifierFree = this.makeQuantifierFree(t);
            return this.mScript.annotate(hopfullyQuantifierFree, annotations);
        }
        return this.mScript.annotate(t, annotations);
    }

    public Term simplify(Term term) throws SMTLIBException {
        Term letFree = new FormulaUnLet().transform(term);
        Term annotationFree = new AnnotationRemover().transform(letFree);
        Term unf = new UnfTransformer(this.mMgdScript.getScript()).transform(annotationFree);
        Term lessQuantifier = PartialQuantifierElimination.eliminateCompat((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mMgdScript, (SmtUtils.SimplificationTechnique)SmtUtils.SimplificationTechnique.SIMPLIFY_DDA, (Term)unf);
        IResult result = this.constructResult("simplify", String.valueOf(lessQuantifier));
        this.mServices.getResultService().reportResult("de.uni_freiburg.informatik.ultimate.core", result);
        return lessQuantifier;
    }

    private IResult constructResult(String command, String response) {
        String shortDescription = "Response to " + command + " command";
        String longDescription = "Response to " + command + " command is: " + response;
        IResultWithSeverity.Severity severity = IResultWithSeverity.Severity.INFO;
        GenericResult ultimateOutput = new GenericResult("de.uni_freiburg.informatik.ultimate.core", shortDescription, longDescription, severity);
        return ultimateOutput;
    }
}

