/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationMap;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.PredicateTrie;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.RestructureHelperObject;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateCoverageChecker;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.PredicateUnifierStatisticsGenerator;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.CommuhashNormalForm;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import de.uni_freiburg.informatik.ultimate.util.statistics.IStatisticsDataProvider;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BPredicateUnifier
implements IPredicateUnifier {
    private static final boolean USE_MAP = true;
    private static final boolean USE_RESTRUCTURE = true;
    private final IUltimateServiceProvider mServices;
    private final ManagedScript mMgdScript;
    private final Script mScript;
    private final IImplicationGraph<IPredicate> mImplicationGraph;
    private final BasicPredicateFactory mBasicPredicateFactory;
    private final IPredicate mTruePredicate;
    private final IPredicate mFalsePredicate;
    private final Collection<IPredicate> mPredicates;
    private final Set<IPredicate> mIntricatePredicate;
    private final IIcfgSymbolTable mSymbolTable;
    private final PredicateUnifierStatisticsGenerator mStatisticsTracker;
    private final ILogger mLogger;
    private PredicateTrie<IPredicate> mPredicateTrie;
    private long mImplicationTime = 0L;
    private int mDepthOffset;

    public BPredicateUnifier(IUltimateServiceProvider services, ILogger logger, ManagedScript script, BasicPredicateFactory factory, IIcfgSymbolTable symbolTable) {
        this.mLogger = logger;
        this.mServices = services;
        this.mMgdScript = script;
        this.mScript = this.mMgdScript.getScript();
        this.mBasicPredicateFactory = factory;
        this.mSymbolTable = symbolTable;
        this.mTruePredicate = factory.newPredicate(this.mScript.term("true", new Term[0]));
        this.mFalsePredicate = factory.newPredicate(this.mScript.term("false", new Term[0]));
        this.mPredicates = new HashSet<IPredicate>();
        this.mIntricatePredicate = new HashSet<IPredicate>();
        this.mStatisticsTracker = new PredicateUnifierStatisticsGenerator();
        this.mPredicateTrie = new PredicateTrie<IPredicate>(logger, services, this.mMgdScript, this.mTruePredicate, this.mFalsePredicate, factory, this.mSymbolTable);
        this.mImplicationGraph = new ImplicationMap<IPredicate>(this.mMgdScript, this, this.mFalsePredicate, this.mTruePredicate, true);
        this.mPredicates.add(this.mTruePredicate);
        this.mPredicates.add(this.mFalsePredicate);
        this.mDepthOffset = 0;
        logger.info((Object)"Initialized predicate-trie based predicate unifier");
    }

    @Override
    public IPredicate getOrConstructPredicateForDisjunction(Collection<IPredicate> disjunction) {
        for (IPredicate d : disjunction) {
            if (!this.mPredicates.contains(d)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the predicate " + d));
            }
        }
        Collection<IPredicate> minimalDisjunction = this.mImplicationGraph.removeImplyingVerticesFromCollection(disjunction);
        IPredicate pred = this.mBasicPredicateFactory.or(minimalDisjunction);
        for (IPredicate p : this.mPredicates) {
            if (!p.getFormula().equals(pred.getFormula())) continue;
            return p;
        }
        IPredicate result = this.getOrConstructPredicate(pred);
        return result;
    }

    @Override
    public IPredicate getOrConstructPredicateForConjunction(Collection<IPredicate> conjunction) {
        for (IPredicate c : conjunction) {
            if (!this.mPredicates.contains(c)) {
                throw new AssertionError((Object)("PredicateUnifier does not know the predicate " + c));
            }
        }
        Collection<IPredicate> minimalConjunction = this.mImplicationGraph.removeImpliedVerticesFromCollection(conjunction);
        IPredicate pred = this.mBasicPredicateFactory.and(minimalConjunction);
        for (IPredicate p : this.mPredicates) {
            if (!p.getFormula().equals(pred.getFormula())) continue;
            return p;
        }
        IPredicate result = this.getOrConstructPredicate(pred);
        return result;
    }

    @Override
    public String collectPredicateUnifierStatistics() {
        StringBuilder builder = new StringBuilder();
        builder.append(PredicateUnifierStatisticsGenerator.PredicateUnifierStatisticsType.getInstance().prettyprintBenchmarkData(this.mStatisticsTracker));
        builder.append(" " + (double)(this.mImplicationTime / 100L) / 10.0 + "s impTime " + this.mPredicateTrie.getDepth());
        return builder.toString();
    }

    @Override
    public IPredicateCoverageChecker getCoverageRelation() {
        return this.mImplicationGraph;
    }

    @Override
    public IStatisticsDataProvider getPredicateUnifierBenchmark() {
        return this.mStatisticsTracker;
    }

    @Override
    public boolean isIntricatePredicate(IPredicate pred) {
        return this.mIntricatePredicate.contains(pred);
    }

    private Script.LBool isDistinct(IPredicate pred1, IPredicate pred2) {
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        Term isDistinct = this.mScript.term("distinct", new Term[]{pred1.getClosedFormula(), pred2.getClosedFormula()});
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        try {
            Script.LBool result;
            this.mMgdScript.assertTerm((Object)this, isDistinct);
            Script.LBool lBool = result = this.mMgdScript.checkSat((Object)this);
            return lBool;
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    @Override
    public Set<IPredicate> cannibalize(boolean splitNumericEqualities, Term term) {
        Term[] conjuncts = SmtUtils.cannibalize((ManagedScript)this.mMgdScript, (IUltimateServiceProvider)this.mServices, (boolean)splitNumericEqualities, (Term)term);
        HashSet<IPredicate> result = new HashSet<IPredicate>(conjuncts.length);
        Term[] termArray = conjuncts;
        int n = conjuncts.length;
        int n2 = 0;
        while (n2 < n) {
            Term conjunct = termArray[n2];
            IPredicate predicate = this.getOrConstructPredicate(conjunct);
            result.add(predicate);
            ++n2;
        }
        return result;
    }

    @Override
    public Set<IPredicate> cannibalizeAll(boolean splitNumericEqualities, Collection<IPredicate> predicates) {
        HashSet<IPredicate> result = new HashSet<IPredicate>();
        for (IPredicate predicate : predicates) {
            result.addAll(this.cannibalize(splitNumericEqualities, predicate.getFormula()));
        }
        return result;
    }

    @Override
    public IPredicate getOrConstructPredicate(Term term) {
        this.mStatisticsTracker.incrementGetRequests();
        return this.getOrConstructPredicateInternal(term);
    }

    private IPredicate getOrConstructPredicateInternal(Term term) {
        this.mStatisticsTracker.continueTime();
        Term commuNF = new CommuhashNormalForm(this.mServices, this.mScript).transform(term);
        BasicPredicate predicate = this.mBasicPredicateFactory.newPredicate(commuNF);
        IPredicate tfPred = this.catchTrueOrFalse(predicate);
        if (tfPred != null) {
            return tfPred;
        }
        IPredicate unifiedPredicate = this.mPredicateTrie.unifyPredicate(predicate);
        if (this.mPredicates.add(unifiedPredicate)) {
            long start = System.currentTimeMillis();
            this.mImplicationGraph.unifyPredicate(unifiedPredicate);
            this.mImplicationTime += System.currentTimeMillis() - start;
            this.mStatisticsTracker.incrementConstructedPredicates();
        } else if (unifiedPredicate.getFormula().toString().equals(predicate.getFormula().toString())) {
            this.mStatisticsTracker.incrementSyntacticMatches();
        } else {
            this.mStatisticsTracker.incrementSemanticMatches();
        }
        this.mStatisticsTracker.stopTime();
        return unifiedPredicate;
    }

    private IPredicate catchTrueOrFalse(IPredicate pred) {
        if (this.mTruePredicate.getFormula().equals(pred.getFormula())) {
            this.mStatisticsTracker.incrementSyntacticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mTruePredicate;
        }
        if (this.mFalsePredicate.getFormula().equals(pred.getFormula())) {
            this.mStatisticsTracker.incrementSyntacticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mFalsePredicate;
        }
        Script.LBool equalsTrue = this.isDistinct(pred, this.mTruePredicate);
        if (equalsTrue == Script.LBool.UNSAT) {
            this.mStatisticsTracker.incrementSemanticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mTruePredicate;
        }
        if (equalsTrue == Script.LBool.UNKNOWN) {
            this.mIntricatePredicate.add(pred);
            return pred;
        }
        Script.LBool equalsFalse = this.isDistinct(pred, this.mFalsePredicate);
        if (equalsFalse == Script.LBool.UNSAT) {
            this.mStatisticsTracker.incrementSemanticMatches();
            this.mStatisticsTracker.stopTime();
            return this.mFalsePredicate;
        }
        if (equalsFalse == Script.LBool.UNKNOWN) {
            this.mIntricatePredicate.add(pred);
            return pred;
        }
        return null;
    }

    @Override
    public IPredicate getOrConstructPredicate(IPredicate predicate) {
        if (this.mPredicates.contains(predicate)) {
            return predicate;
        }
        return this.getOrConstructPredicate(predicate.getFormula());
    }

    @Override
    public boolean isRepresentative(IPredicate pred) {
        return this.mPredicates.contains(pred);
    }

    @Override
    public BasicPredicateFactory getPredicateFactory() {
        return this.mBasicPredicateFactory;
    }

    @Override
    public IPredicate getTruePredicate() {
        return this.mTruePredicate;
    }

    @Override
    public IPredicate getFalsePredicate() {
        return this.mFalsePredicate;
    }

    public String print(boolean trie, boolean graph) {
        StringBuilder sb = new StringBuilder();
        if (trie) {
            sb.append("Predicate Trie:\n" + this.mPredicateTrie.toString());
        }
        if (graph) {
            sb.append("Implication Graph:\n" + this.mImplicationGraph.toString());
        }
        return sb.toString();
    }

    @Override
    public IPredicate constructNewPredicate(Term term, Map<IPredicate, IncrementalPlicationChecker.Validity> impliedPredicates, Map<IPredicate, IncrementalPlicationChecker.Validity> expliedPredicates) {
        return this.getOrConstructPredicate(term);
    }

    public boolean restructurePredicateTrie() {
        int oldDepth = this.mPredicateTrie.getDepth();
        if (oldDepth <= this.minDepth(this.mPredicates.size())) {
            return false;
        }
        if (!(this.mImplicationGraph instanceof ImplicationMap)) {
            throw new UnsupportedOperationException("restructure only possible with ImplicationMap");
        }
        ImplicationMap map = (ImplicationMap)this.mImplicationGraph;
        HashMap<IPredicate, Set<IPredicate>> descendantsMap = new HashMap<IPredicate, Set<IPredicate>>();
        map.getDescendantsMap().entrySet().forEach(d -> {
            HashSet hashSet = descendantsMap.put((IPredicate)d.getKey(), new HashSet((Collection)d.getValue()));
        });
        descendantsMap.remove(this.mFalsePredicate);
        descendantsMap.remove(this.mTruePredicate);
        descendantsMap.keySet().forEach(d -> {
            boolean bl = ((Set)descendantsMap.get(d)).remove(this.mTruePredicate);
        });
        HashMap<IPredicate, Set<IPredicate>> ancestorsMap = new HashMap<IPredicate, Set<IPredicate>>();
        map.getAncestorsMap().entrySet().forEach(a -> {
            HashSet hashSet = ancestorsMap.put((IPredicate)a.getKey(), new HashSet((Collection)a.getValue()));
        });
        ancestorsMap.remove(this.mFalsePredicate);
        ancestorsMap.remove(this.mTruePredicate);
        ancestorsMap.keySet().forEach(a -> {
            boolean bl = ((Set)ancestorsMap.get(a)).remove(this.mFalsePredicate);
        });
        HashMap<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>> witnessMap = new HashMap<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>>();
        RestructureHelperObject root = this.getWitnessInductive(descendantsMap, ancestorsMap, witnessMap);
        PredicateTrie<IPredicate> restructuredTrie = new PredicateTrie<IPredicate>(this.mLogger, this.mServices, this.mMgdScript, this.mTruePredicate, this.mFalsePredicate, this.mBasicPredicateFactory, this.mSymbolTable);
        restructuredTrie.fillTrie(root, witnessMap);
        if (oldDepth - restructuredTrie.getDepth() > 0) {
            this.mPredicateTrie = restructuredTrie;
            return true;
        }
        return false;
    }

    private RestructureHelperObject getWitnessInductive(Map<IPredicate, Set<IPredicate>> descendantsMap, Map<IPredicate, Set<IPredicate>> ancestorsMap, Map<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>> witnessMap) {
        Pair<IPredicate, IPredicate> pivot = this.getPivot(descendantsMap, ancestorsMap);
        Term distinct = this.mScript.term("and", new Term[]{((IPredicate)pivot.getFirst()).getFormula(), this.mScript.term("not", new Term[]{((IPredicate)pivot.getSecond()).getFormula()})});
        RestructureHelperObject witness = new RestructureHelperObject(this.mPredicateTrie.getWitness(distinct), null);
        Pair<Set<IPredicate>, Set<IPredicate>> split = this.splitPredicates(witness, pivot, descendantsMap, ancestorsMap);
        RestructureHelperObject trueWitness = null;
        RestructureHelperObject falseWitness = null;
        Pair<Map<IPredicate, Set<IPredicate>>, Map<IPredicate, Set<IPredicate>>> trueSide = this.prepareSubGraph((Set)split.getFirst(), descendantsMap, ancestorsMap);
        trueWitness = ((Map)trueSide.getFirst()).size() == 1 ? new RestructureHelperObject(-1, null, (IPredicate)((Map)trueSide.getFirst()).keySet().iterator().next()) : this.getWitnessInductive((Map)trueSide.getFirst(), (Map)trueSide.getSecond(), witnessMap);
        Pair<Map<IPredicate, Set<IPredicate>>, Map<IPredicate, Set<IPredicate>>> falseSide = this.prepareSubGraph((Set)split.getSecond(), descendantsMap, ancestorsMap);
        falseWitness = ((Map)falseSide.getFirst()).size() == 1 ? new RestructureHelperObject(-1, null, (IPredicate)((Map)falseSide.getFirst()).keySet().iterator().next()) : this.getWitnessInductive((Map)falseSide.getFirst(), (Map)falseSide.getSecond(), witnessMap);
        witnessMap.put(witness, (Pair<RestructureHelperObject, RestructureHelperObject>)new Pair((Object)trueWitness, (Object)falseWitness));
        return witness;
    }

    private Pair<Map<IPredicate, Set<IPredicate>>, Map<IPredicate, Set<IPredicate>>> prepareSubGraph(Set<IPredicate> preds, Map<IPredicate, Set<IPredicate>> descendantsMap, Map<IPredicate, Set<IPredicate>> ancestorsMap) {
        HashMap newDescendantsMap = new HashMap();
        for (IPredicate pred : preds) {
            newDescendantsMap.put(pred, new HashSet(descendantsMap.get(pred)));
            for (IPredicate old : descendantsMap.get(pred)) {
                if (preds.contains(old)) continue;
                ((Set)newDescendantsMap.get(pred)).remove(old);
            }
        }
        HashMap newAncestersMap = new HashMap();
        for (IPredicate pred : preds) {
            newAncestersMap.put(pred, new HashSet(ancestorsMap.get(pred)));
            for (IPredicate old : ancestorsMap.get(pred)) {
                if (preds.contains(old)) continue;
                ((Set)newAncestersMap.get(pred)).remove(old);
            }
        }
        return new Pair(newDescendantsMap, newAncestersMap);
    }

    private Pair<Set<IPredicate>, Set<IPredicate>> splitPredicates(RestructureHelperObject witness, Pair<IPredicate, IPredicate> pivot, Map<IPredicate, Set<IPredicate>> descendantsMap, Map<IPredicate, Set<IPredicate>> ancestorsMap) {
        HashDeque toCheck = new HashDeque();
        toCheck.addAll(descendantsMap.keySet());
        HashSet<IPredicate> included = new HashSet<IPredicate>((Collection)descendantsMap.get(pivot.getFirst()));
        included.add((IPredicate)pivot.getFirst());
        HashSet<IPredicate> excluded = new HashSet<IPredicate>((Collection)ancestorsMap.get(pivot.getSecond()));
        excluded.add((IPredicate)pivot.getSecond());
        excluded.removeAll(included);
        toCheck.removeAll(included);
        toCheck.removeAll(excluded);
        while (!toCheck.isEmpty()) {
            IPredicate current = (IPredicate)toCheck.pop();
            if (this.mPredicateTrie.fulfillsPredicate(current, witness.getWitness())) {
                included.add(current);
                included.addAll((Collection)descendantsMap.get(current));
                toCheck.removeAll((Collection)descendantsMap.get(current));
                continue;
            }
            excluded.add(current);
            excluded.addAll((Collection)ancestorsMap.get(current));
            toCheck.removeAll((Collection)ancestorsMap.get(current));
        }
        return new Pair(included, excluded);
    }

    private Pair<IPredicate, IPredicate> getPivot(Map<IPredicate, Set<IPredicate>> descendantsMap, Map<IPredicate, Set<IPredicate>> ancestorsMap) {
        float optimum;
        assert (!descendantsMap.isEmpty() && !ancestorsMap.isEmpty());
        float minDif = optimum = (float)descendantsMap.keySet().size() / 2.0f;
        IPredicate pivotIn = null;
        for (IPredicate pred : descendantsMap.keySet()) {
            float vCount = descendantsMap.get(pred).size() + 1;
            if (vCount == optimum) {
                pivotIn = pred;
                break;
            }
            if (!(Math.abs(optimum - vCount) < minDif)) continue;
            minDif = Math.abs(optimum - vCount);
            pivotIn = pred;
        }
        HashMap ancestors = new HashMap();
        for (Map.Entry<IPredicate, Set<IPredicate>> ancestor : ancestorsMap.entrySet()) {
            ancestors.put(ancestor.getKey(), new HashSet(ancestor.getValue()));
        }
        for (IPredicate pivotDescendants : descendantsMap.get(pivotIn)) {
            for (IPredicate descendants : descendantsMap.get(pivotDescendants)) {
                ((Set)ancestors.get(descendants)).remove(pivotDescendants);
            }
        }
        for (IPredicate pivotDescendants : descendantsMap.get(pivotIn)) {
            ancestors.remove(pivotDescendants);
        }
        ancestors.remove(pivotIn);
        minDif = optimum;
        IPredicate pivotOut = null;
        for (Map.Entry pred : ancestors.entrySet()) {
            float vCount = ((Set)pred.getValue()).size() + 1;
            if (vCount == optimum) {
                pivotOut = (IPredicate)pred.getKey();
                break;
            }
            if (!(Math.abs(optimum - vCount) < minDif)) continue;
            minDif = Math.abs(optimum - vCount);
            pivotOut = (IPredicate)pred.getKey();
        }
        return new Pair((Object)pivotIn, pivotOut);
    }

    private int minDepth(int x) {
        return (int)Math.ceil(Math.log(x) / Math.log(2.0) + 1.0);
    }
}

