/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.BPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.TransitiveClosureIG;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImplicationGraph<T extends IPredicate>
implements IImplicationGraph<T> {
    private final ManagedScript mMgdScript;
    private final BPredicateUnifier mUnifier;
    private final Set<ImplicationVertex<T>> mVertices;
    private final Map<T, ImplicationVertex<T>> mPredicateMap;
    private ImplicationVertex<T> mTrueVertex;
    private ImplicationVertex<T> mFalseVertex;

    protected ImplicationGraph(ManagedScript script, BPredicateUnifier unifier, T predicateFalse, T predicateTrue) {
        this.mMgdScript = script;
        this.mUnifier = unifier;
        this.mVertices = new HashSet<ImplicationVertex<T>>();
        this.mPredicateMap = new HashMap<T, ImplicationVertex<T>>();
        this.mFalseVertex = new ImplicationVertex<T>(predicateFalse, new HashSet(), new HashSet());
        HashSet parent = new HashSet();
        parent.add(this.mFalseVertex);
        this.mTrueVertex = new ImplicationVertex<T>(predicateTrue, new HashSet(), parent);
        this.mFalseVertex.addChild(this.mTrueVertex);
        this.mVertices.add(this.mTrueVertex);
        this.mVertices.add(this.mFalseVertex);
        this.mPredicateMap.put(predicateTrue, this.mTrueVertex);
        this.mPredicateMap.put(predicateFalse, this.mFalseVertex);
    }

    public Set<ImplicationVertex<T>> getVertices() {
        return this.mVertices;
    }

    public ImplicationVertex<T> getFalseVertex() {
        return this.mFalseVertex;
    }

    public ImplicationVertex<T> getTrueVertex() {
        return this.mTrueVertex;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        for (ImplicationVertex<T> vertex : this.mVertices) {
            bld.append("\n " + vertex.toString());
        }
        return bld.toString();
    }

    @Override
    public Set<IPredicate> getCoveredPredicates(IPredicate pred) {
        Set<ImplicationVertex<ImplicationVertex>> ancestors = this.mPredicateMap.get(pred).getAncestors();
        HashSet<IPredicate> covered = new HashSet<IPredicate>();
        ancestors.forEach(a -> {
            boolean bl = covered.add((IPredicate)a.getPredicate());
        });
        covered.add(pred);
        return covered;
    }

    @Override
    public Set<IPredicate> getCoveringPredicates(IPredicate pred) {
        Set<ImplicationVertex<ImplicationVertex>> descendants = this.mPredicateMap.get(pred).getDescendants();
        HashSet<IPredicate> covering = new HashSet<IPredicate>();
        descendants.forEach(a -> {
            boolean bl = covering.add((IPredicate)a.getPredicate());
        });
        covering.add(pred);
        return covering;
    }

    @Override
    public IPartialComparator<IPredicate> getPartialComparator() {
        return (o1, o2) -> {
            if (!this.mUnifier.isRepresentative((IPredicate)o1) || !this.mUnifier.isRepresentative((IPredicate)o2)) {
                throw new AssertionError((Object)"predicates unknown to predicate unifier");
            }
            if (o1.equals(o2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (this.getCoveringPredicates((IPredicate)o1).contains(o2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            if (this.getCoveringPredicates((IPredicate)o2).contains(o1)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
    }

    @Override
    public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean unifyPredicate(T predicate) {
        TransitiveClosureIG transitiveClosure = new TransitiveClosureIG(this);
        HashSet marked = new HashSet();
        while (!marked.containsAll(transitiveClosure.getVertices())) {
            ImplicationVertex maxVertex = transitiveClosure.getMaxTransitiveClosureCount(marked, true);
            if (this.internImplication((IPredicate)maxVertex.getPredicate(), (IPredicate)predicate)) {
                marked.add(maxVertex);
                transitiveClosure.removeAncestorsFromTC(maxVertex);
                continue;
            }
            transitiveClosure.removeDescendantsFromTC(maxVertex, null);
            transitiveClosure.removeVertex(maxVertex);
        }
        HashSet parents = new HashSet(transitiveClosure.getVertices());
        transitiveClosure = new TransitiveClosureIG(this, parents);
        marked.clear();
        while (!marked.containsAll(transitiveClosure.getVertices())) {
            ImplicationVertex maxVertex = transitiveClosure.getMaxTransitiveClosureCount(marked, false);
            if (this.internImplication((IPredicate)predicate, (IPredicate)maxVertex.getPredicate())) {
                marked.add(maxVertex);
                transitiveClosure.removeDescendantsFromTC(maxVertex, null);
                continue;
            }
            transitiveClosure.removeAncestorsFromTC(maxVertex);
            transitiveClosure.removeVertex(maxVertex);
        }
        HashSet children = new HashSet(transitiveClosure.getVertices());
        ImplicationVertex<T> newVertex = new ImplicationVertex<T>(predicate, children, parents);
        this.mVertices.add(newVertex);
        this.mPredicateMap.put(predicate, newVertex);
        return true;
    }

    @Override
    public Collection<T> removeImpliedVerticesFromCollection(Collection<T> collection) {
        HashSet vertexCollection = new HashSet();
        collection.forEach(c -> {
            boolean bl = vertexCollection.add(this.mPredicateMap.get(c));
        });
        HashSet<T> result = new HashSet<T>(collection);
        block0: for (ImplicationVertex c1 : vertexCollection) {
            for (ImplicationVertex c2 : vertexCollection) {
                if (!c1.getAncestors().contains(c2)) continue;
                result.remove(c1.getPredicate());
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Collection<T> removeImplyingVerticesFromCollection(Collection<T> collection) {
        HashSet vertexCollection = new HashSet();
        collection.forEach(c -> {
            boolean bl = vertexCollection.add(this.mPredicateMap.get(c));
        });
        HashSet<T> result = new HashSet<T>(collection);
        block0: for (ImplicationVertex c1 : vertexCollection) {
            for (ImplicationVertex c2 : vertexCollection) {
                if (!c1.getDescendants().contains(c2)) continue;
                result.remove(c1.getPredicate());
                continue block0;
            }
        }
        return result;
    }

    @Override
    public IncrementalPlicationChecker.Validity isCovered(IPredicate lhs, IPredicate rhs) {
        if (this.getCoveringPredicates(lhs).contains(rhs)) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    public boolean internImplication(IPredicate a, IPredicate b) {
        if (a.equals(b)) {
            return true;
        }
        if (this.mPredicateMap.containsKey(a) && this.mPredicateMap.containsKey(b)) {
            return this.getCoveringPredicates(a).contains(b);
        }
        Term acf = a.getClosedFormula();
        Term bcf = b.getClosedFormula();
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        Term imp = this.mMgdScript.term((Object)this, "and", new Term[]{acf, this.mMgdScript.term((Object)this, "not", new Term[]{bcf})});
        this.mMgdScript.push((Object)this, 1);
        try {
            this.mMgdScript.assertTerm((Object)this, imp);
            Script.LBool result = this.mMgdScript.checkSat((Object)this);
            if (result == Script.LBool.UNSAT) {
                return true;
            }
            if (result == Script.LBool.SAT) {
                return false;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide implication of predicates");
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }
}

