/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.BPredicateUnifier;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.IncrementalPlicationChecker;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.poset.IPartialComparator;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImplicationMap<T extends IPredicate>
implements IImplicationGraph<T> {
    private final ManagedScript mMgdScript;
    private final BPredicateUnifier mUnifier;
    private final Map<T, Set<T>> mDescendants;
    private final Map<T, Set<T>> mAncestors;
    private final boolean mRandom;

    protected ImplicationMap(ManagedScript script, BPredicateUnifier unifer, T falsePred, T truePred, boolean random) {
        this.mMgdScript = script;
        this.mUnifier = unifer;
        this.mDescendants = new HashMap<T, Set<T>>();
        this.mAncestors = new HashMap<T, Set<T>>();
        this.mRandom = random;
        this.mDescendants.put(falsePred, new HashSet());
        this.mDescendants.put(truePred, new HashSet());
        this.mAncestors.put(falsePred, new HashSet());
        this.mAncestors.put(truePred, new HashSet());
        this.mDescendants.get(falsePred).add(truePred);
        this.mAncestors.get(truePred).add(falsePred);
    }

    protected Map<T, Set<T>> getDescendantsMap() {
        return this.mDescendants;
    }

    protected Map<T, Set<T>> getAncestorsMap() {
        return this.mAncestors;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        for (IPredicate pred : this.mDescendants.keySet()) {
            bld.append("\n " + pred + "is covered by:" + this.mDescendants.get(pred));
        }
        return bld.toString();
    }

    @Override
    public IncrementalPlicationChecker.Validity isCovered(IPredicate lhs, IPredicate rhs) {
        if (this.getCoveringPredicates(lhs).contains(rhs)) {
            return IncrementalPlicationChecker.Validity.VALID;
        }
        return IncrementalPlicationChecker.Validity.INVALID;
    }

    @Override
    public Set<IPredicate> getCoveredPredicates(IPredicate pred) {
        Set<IPredicate> ancestors = this.mAncestors.get(pred);
        HashSet<IPredicate> covered = new HashSet<IPredicate>(ancestors.size() + 1);
        ancestors.forEach(a -> {
            boolean bl = covered.add((IPredicate)a);
        });
        covered.add(pred);
        return covered;
    }

    @Override
    public Set<IPredicate> getCoveringPredicates(IPredicate pred) {
        Set<IPredicate> descendants = this.mDescendants.get(pred);
        HashSet<IPredicate> covering = new HashSet<IPredicate>(descendants.size() + 1);
        descendants.forEach(d -> {
            boolean bl = covering.add((IPredicate)d);
        });
        covering.add(pred);
        return covering;
    }

    @Override
    public IPartialComparator<IPredicate> getPartialComparator() {
        return (o1, o2) -> {
            if (!this.mUnifier.isRepresentative((IPredicate)o1) || !this.mUnifier.isRepresentative((IPredicate)o2)) {
                throw new AssertionError((Object)"predicates unknown to predicate unifier");
            }
            if (o1.equals(o2)) {
                return IPartialComparator.ComparisonResult.EQUAL;
            }
            if (this.getCoveringPredicates((IPredicate)o1).contains(o2)) {
                return IPartialComparator.ComparisonResult.STRICTLY_SMALLER;
            }
            if (this.getCoveringPredicates((IPredicate)o2).contains(o1)) {
                return IPartialComparator.ComparisonResult.STRICTLY_GREATER;
            }
            return IPartialComparator.ComparisonResult.INCOMPARABLE;
        };
    }

    @Override
    public HashRelation<IPredicate, IPredicate> getCopyOfImplicationRelation() {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public boolean unifyPredicate(T predicate) {
        HashMap dCopy = new HashMap(this.mDescendants);
        HashSet predDescendants = new HashSet();
        while (!dCopy.isEmpty()) {
            Object pivot = this.chosePivot(dCopy.keySet(), true);
            Set pivotDescendants = (Set)dCopy.remove(pivot);
            if (this.internImplication(predicate, pivot)) {
                predDescendants.add(pivot);
                predDescendants.addAll(pivotDescendants);
                pivotDescendants.forEach(d -> {
                    Object v = dCopy.remove(d);
                });
                continue;
            }
            this.mAncestors.get(pivot).forEach(a -> {
                Object v = dCopy.remove(a);
            });
        }
        HashMap aCopy = new HashMap();
        this.mAncestors.get(predDescendants.iterator().next()).forEach(a -> {
            Set<T> set = aCopy.put(a, this.mAncestors.get(a));
        });
        for (IPredicate d2 : predDescendants) {
            HashSet it = new HashSet(aCopy.keySet());
            for (IPredicate a2 : it) {
                if (this.mAncestors.get(d2).contains(a2)) continue;
                aCopy.remove(a2);
            }
        }
        HashSet predAncestors = new HashSet();
        while (!aCopy.isEmpty()) {
            Object pivot = this.chosePivot(aCopy.keySet(), false);
            Set pivotAncestors = (Set)aCopy.remove(pivot);
            if (this.internImplication(pivot, predicate)) {
                predAncestors.add(pivot);
                predAncestors.addAll(pivotAncestors);
                pivotAncestors.forEach(a -> {
                    Object v = aCopy.remove(a);
                });
                continue;
            }
            this.mDescendants.get(pivot).forEach(d -> {
                Object v = aCopy.remove(d);
            });
        }
        predAncestors.forEach(a -> {
            boolean bl = this.mDescendants.get(a).add(predicate);
        });
        predDescendants.forEach(d -> {
            boolean bl = this.mAncestors.get(d).add(predicate);
        });
        this.mDescendants.put(predicate, predDescendants);
        this.mAncestors.put(predicate, predAncestors);
        return true;
    }

    private boolean internImplication(T a, T b) {
        if (a.equals(b)) {
            return true;
        }
        if (this.mDescendants.containsKey(a) && this.mDescendants.containsKey(b)) {
            return this.getCoveringPredicates((IPredicate)a).contains(b);
        }
        Term acf = a.getClosedFormula();
        Term bcf = b.getClosedFormula();
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        Term imp = this.mMgdScript.term((Object)this, "and", new Term[]{acf, this.mMgdScript.term((Object)this, "not", new Term[]{bcf})});
        this.mMgdScript.push((Object)this, 1);
        try {
            this.mMgdScript.assertTerm((Object)this, imp);
            Script.LBool result = this.mMgdScript.checkSat((Object)this);
            if (result == Script.LBool.UNSAT) {
                return true;
            }
            if (result == Script.LBool.SAT) {
                return false;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide implication of predicates");
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    private T chosePivot(Set<T> set, boolean first) {
        if (this.mRandom) {
            return (T)((IPredicate)set.iterator().next());
        }
        int max = 0;
        IPredicate pivot = (IPredicate)set.iterator().next();
        for (IPredicate pred : set) {
            int a = this.mAncestors.get(pred).size();
            int b = this.mDescendants.get(pred).size();
            if (first) {
                ++b;
            } else {
                ++a;
            }
            int count = a * b / (a + b);
            if (count < max) continue;
            max = count;
            pivot = pred;
        }
        return (T)pivot;
    }

    @Override
    public Collection<T> removeImpliedVerticesFromCollection(Collection<T> collection) {
        HashSet<T> result = new HashSet<T>(collection);
        block0: for (IPredicate c1 : collection) {
            for (IPredicate c2 : collection) {
                if (!this.mAncestors.get(c1).contains(c2)) continue;
                result.remove(c1);
                continue block0;
            }
        }
        return result;
    }

    @Override
    public Collection<T> removeImplyingVerticesFromCollection(Collection<T> collection) {
        HashSet<T> result = new HashSet<T>(collection);
        block0: for (IPredicate c1 : collection) {
            for (IPredicate c2 : collection) {
                if (!this.mDescendants.get(c1).contains(c2)) continue;
                result.remove(c1);
                continue block0;
            }
        }
        return result;
    }
}

