/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.HashSet;
import java.util.Set;

public class ImplicationVertex<T extends IPredicate> {
    private final T mPredicate;
    private final Set<ImplicationVertex<T>> mChildren;
    private final Set<ImplicationVertex<T>> mParents;
    private Set<ImplicationVertex<T>> mDescendants;
    private Set<ImplicationVertex<T>> mAncestors;

    public ImplicationVertex(T predicate, Set<ImplicationVertex<T>> children, Set<ImplicationVertex<T>> parents) {
        this.mPredicate = predicate;
        this.mChildren = children;
        this.mParents = parents;
        this.mDescendants = new HashSet<ImplicationVertex<T>>();
        this.mAncestors = new HashSet<ImplicationVertex<T>>();
        this.transitiveReductionAfterAdding();
        this.updateTransitiveClosure();
    }

    private void updateTransitiveClosure() {
        this.mDescendants.addAll(this.mChildren);
        for (ImplicationVertex<T> child : this.mChildren) {
            this.mDescendants.addAll(child.getDescendants());
        }
        this.mAncestors.addAll(this.mParents);
        for (ImplicationVertex<T> parent : this.mParents) {
            this.mAncestors.addAll(parent.getAncestors());
        }
        for (ImplicationVertex<T> descendant : this.mDescendants) {
            descendant.addAncestor(this);
        }
        for (ImplicationVertex<T> ancestor : this.mAncestors) {
            ancestor.addDescendant(this);
        }
    }

    protected void transitiveReductionAfterAdding() {
        for (ImplicationVertex<T> parent : this.mParents) {
            for (ImplicationVertex<T> child : this.mChildren) {
                if (parent.getChildren().contains(child)) {
                    parent.removeChild(child);
                    child.removeParent(parent);
                }
                child.addParent(this);
            }
            parent.addChild(this);
        }
    }

    public String toString() {
        HashSet c = new HashSet();
        this.mChildren.forEach(child -> {
            boolean bl = c.add(child.mPredicate);
        });
        return String.valueOf(String.valueOf(this.mPredicate.toString())) + "-> " + ((Object)c).toString();
    }

    public Set<ImplicationVertex<T>> getDescendants() {
        return this.mDescendants;
    }

    public Set<ImplicationVertex<T>> getAncestors() {
        return this.mAncestors;
    }

    protected Set<ImplicationVertex<T>> getChildren() {
        return this.mChildren;
    }

    protected Set<ImplicationVertex<T>> getParents() {
        return this.mParents;
    }

    public boolean addAncestor(ImplicationVertex<T> ancestor) {
        return this.mAncestors.add(ancestor);
    }

    public boolean addDescendant(ImplicationVertex<T> descendant) {
        return this.mDescendants.add(descendant);
    }

    protected boolean addChild(ImplicationVertex<T> child) {
        return this.mChildren.add(child);
    }

    protected boolean addParent(ImplicationVertex<T> parent) {
        return this.mParents.add(parent);
    }

    protected boolean removeChild(ImplicationVertex<T> child) {
        return this.mChildren.remove(child);
    }

    protected boolean removeParent(ImplicationVertex<T> parent) {
        return this.mParents.remove(parent);
    }

    public T getPredicate() {
        return this.mPredicate;
    }
}

