/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IVertex;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.util.Map;

public class ModelVertex
implements IVertex {
    private final Map<Term, Term> mWitness;
    private IVertex mTrueChild;
    private IVertex mFalseChild;

    protected ModelVertex(IVertex trueChild, IVertex falseChild, Map<Term, Term> witness) {
        this.mWitness = witness;
        this.mTrueChild = trueChild;
        this.mFalseChild = falseChild;
    }

    protected void setTrueChild(IVertex trueChild) {
        this.mTrueChild = trueChild;
    }

    protected void setFalseChild(IVertex falseChild) {
        this.mFalseChild = falseChild;
    }

    protected IVertex getChild(boolean edge) {
        if (edge) {
            return this.mTrueChild;
        }
        return this.mFalseChild;
    }

    protected void swapChild(IVertex oldChild, IVertex newChild) {
        if (oldChild.equals(this.mTrueChild)) {
            this.mTrueChild = newChild;
        } else if (oldChild.equals(this.mFalseChild)) {
            this.mFalseChild = newChild;
        } else {
            throw new IllegalArgumentException("the node to swap is not a child of this node");
        }
    }

    protected Map<Term, Term> getWitness() {
        return this.mWitness;
    }

    @Override
    public String print() {
        return "inner: " + this.hashCode() % 100 + this.mWitness.toString() + " : " + this.mTrueChild.hashCode() % 100 + this.mTrueChild.toString() + " | " + this.mFalseChild.hashCode() % 100 + this.mFalseChild.toString();
    }

    public String toString() {
        return this.mWitness.toString();
    }
}

