/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.IVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ModelVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.PredicateVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.RestructureHelperObject;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicateFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.TermVarsProc;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.HashDeque;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class PredicateTrie<T extends IPredicate> {
    private final IUltimateServiceProvider mServices;
    private final BasicPredicateFactory mFactory;
    private final T mTruePredicate;
    private final T mFalsePredicate;
    private final IIcfgSymbolTable mSymbolTable;
    private final ManagedScript mMgdScript;
    private final ILogger mLogger;
    private final Set<T> mPredicates = new HashSet<T>();
    private IVertex mRoot;

    protected PredicateTrie(ILogger logger, IUltimateServiceProvider services, ManagedScript script, T truePredicate, T falsePredicate, BasicPredicateFactory factory, IIcfgSymbolTable symbolTable) {
        this.mServices = services;
        this.mFactory = factory;
        this.mLogger = logger;
        this.mMgdScript = script;
        this.mSymbolTable = symbolTable;
        this.mTruePredicate = truePredicate;
        this.mFalsePredicate = falsePredicate;
        this.mRoot = null;
    }

    private Deque<Map<Term, Term>> findRPath(T pred) {
        HashDeque path = new HashDeque();
        IVertex current = this.mRoot;
        ModelVertex parent = null;
        while (current instanceof ModelVertex) {
            parent = (ModelVertex)current;
            boolean edge = this.fulfillsPredicate(pred, parent.getWitness());
            current = parent.getChild(edge);
            path.add(parent.getWitness());
        }
        this.mLogger.info((Object)("predicate at end of path: " + current));
        return path;
    }

    private Deque<Map<Term, Term>> findRealPath(T pred) {
        ArrayDeque<Object> path = new ArrayDeque<ModelVertex>();
        path.addFirst((ModelVertex)this.mRoot);
        ArrayDeque<ModelVertex> pathT = this.findPathHelper(pred, true, (ArrayDeque<ModelVertex>)path.clone());
        ArrayDeque<ModelVertex> pathF = this.findPathHelper(pred, false, (ArrayDeque<ModelVertex>)path.clone());
        path = pathT.size() > pathF.size() ? pathT : pathF;
        this.mLogger.info((Object)("predicate at end of path true: " + ((ModelVertex)path.getLast()).getChild(true)));
        this.mLogger.info((Object)("predicate at end of path false: " + ((ModelVertex)path.getLast()).getChild(false)));
        ArrayDeque<Map<Term, Term>> result = new ArrayDeque<Map<Term, Term>>();
        while (!path.isEmpty()) {
            result.addLast(((ModelVertex)path.removeFirst()).getWitness());
        }
        return result;
    }

    private ArrayDeque<ModelVertex> findPathHelper(T pred, boolean turn, ArrayDeque<ModelVertex> path) {
        IVertex end = path.getLast().getChild(turn);
        if (end instanceof PredicateVertex) {
            if (((PredicateVertex)end).mPredicate.equals(pred)) {
                return path;
            }
            return new ArrayDeque<ModelVertex>();
        }
        path.addLast((ModelVertex)end);
        ArrayDeque<ModelVertex> pathT = this.findPathHelper(pred, true, (ArrayDeque<ModelVertex>)path.clone());
        ArrayDeque<ModelVertex> pathF = this.findPathHelper(pred, false, (ArrayDeque<ModelVertex>)path.clone());
        if (pathT.size() > pathF.size()) {
            return pathT;
        }
        return pathF;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.stringHelper(this.mRoot, sb);
        return sb.toString();
    }

    private void stringHelper(IVertex vertex, StringBuilder sb) {
        if (vertex instanceof ModelVertex) {
            sb.append(String.valueOf(vertex.print()) + "\n");
            this.stringHelper(((ModelVertex)vertex).getChild(true), sb);
            this.stringHelper(((ModelVertex)vertex).getChild(false), sb);
        }
    }

    protected T unifyPredicate(T predicate) {
        ModelVertex newNode;
        if (this.mRoot == null) {
            this.mRoot = new PredicateVertex<T>(predicate);
            this.mPredicates.add(predicate);
            return predicate;
        }
        IVertex current = this.mRoot;
        ModelVertex parent = null;
        while (current instanceof ModelVertex) {
            parent = (ModelVertex)current;
            boolean edge = this.fulfillsPredicate(predicate, parent.getWitness());
            current = parent.getChild(edge);
        }
        Object currentPredicate = ((PredicateVertex)current).mPredicate;
        Map<Term, Term> newWitness = this.compare(predicate, currentPredicate);
        if (newWitness.isEmpty()) {
            return currentPredicate;
        }
        for (IPredicate p : this.mPredicates) {
            Term a = p.getClosedFormula();
            Term b = predicate.getClosedFormula();
            if (this.mMgdScript.isLocked()) {
                this.mMgdScript.requestLockRelease();
            }
            this.mMgdScript.lock((Object)this);
            this.mMgdScript.push((Object)this, 1);
            Term isEqual = this.mMgdScript.term((Object)this, "distinct", new Term[]{a, b});
            try {
                this.mMgdScript.assertTerm((Object)this, isEqual);
                Script.LBool result = this.mMgdScript.checkSat((Object)this);
                if (result != Script.LBool.UNSAT) continue;
                this.mLogger.info((Object)("new: " + predicate));
                this.mLogger.info((Object)("newPath: " + this.findRPath(predicate)));
                this.mLogger.info((Object)("old: " + p));
                this.mLogger.info((Object)("newPath: " + this.findRealPath(p)));
                throw new UnsupportedOperationException("EQUALITY NOT FOUND" + this.mPredicates.size());
            }
            finally {
                this.mMgdScript.pop((Object)this, 1);
                this.mMgdScript.unlock((Object)this);
            }
        }
        ModelVertex modelVertex = newNode = this.fulfillsPredicate(predicate, newWitness) ? new ModelVertex(new PredicateVertex<T>(predicate), current, newWitness) : new ModelVertex(current, new PredicateVertex<T>(predicate), newWitness);
        if (parent != null) {
            parent.swapChild(current, newNode);
        } else {
            this.mRoot = newNode;
        }
        this.mPredicates.add(predicate);
        return predicate;
    }

    protected boolean fulfillsPredicate(T predicate, Map<Term, Term> witness) {
        Term result = Substitution.apply((ManagedScript)this.mMgdScript, witness, (Term)predicate.getClosedFormula());
        if (this.mTruePredicate.getFormula().equals(result)) {
            return true;
        }
        assert (this.checkFalseCase(predicate, witness, result)) : "unexpected false case";
        return false;
    }

    private boolean checkFalseCase(T predicate, Map<Term, Term> witness, Term result) {
        if (this.mFalsePredicate.getFormula().equals(result)) {
            return true;
        }
        Term trueTerm = this.mTruePredicate.getClosedFormula();
        Term query = this.mMgdScript.getScript().term("distinct", new Term[]{trueTerm, result});
        Script.LBool isNotTrue = SmtUtils.checkSatTerm((Script)this.mMgdScript.getScript(), (Term)query);
        if (isNotTrue == Script.LBool.UNSAT) {
            this.mLogger.fatal((Object)"Simplification failed: it is actually equal to true");
            this.mLogger.fatal((Object)query.toStringDirect());
            this.mLogger.fatal((Object)("original predicate: " + predicate.toString()));
            this.mLogger.fatal((Object)("witness           : " + witness.toString()));
            return false;
        }
        return true;
    }

    private Map<Term, Term> compare(T predicate, T leafPredicate) {
        T localPred = leafPredicate;
        Term local = localPred.getClosedFormula();
        Term other = predicate.getClosedFormula();
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        Term isEqual = this.mMgdScript.term((Object)this, "distinct", new Term[]{local, other});
        try {
            this.mMgdScript.assertTerm((Object)this, isEqual);
            Script.LBool result = this.mMgdScript.checkSat((Object)this);
            if (result == Script.LBool.UNSAT) {
                Map<Term, Term> map = Collections.emptyMap();
                return map;
            }
            if (result == Script.LBool.SAT) {
                Set<ApplicationTerm> terms = this.mSymbolTable.computeAllDefaultConstants();
                Map map = this.mMgdScript.getScript().getValue(terms.toArray(new Term[terms.size()]));
                return map;
            }
            throw new UnsupportedOperationException("Cannot handle case were solver cannot decide equality of predicates");
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    protected Map<Term, Term> getWitness(Term term) {
        TermVarsProc termVarsProc = TermVarsProc.computeTermVarsProc(term, this.mMgdScript, this.mSymbolTable);
        if (this.mMgdScript.isLocked()) {
            this.mMgdScript.requestLockRelease();
        }
        this.mMgdScript.lock((Object)this);
        this.mMgdScript.push((Object)this, 1);
        try {
            this.mMgdScript.assertTerm((Object)this, termVarsProc.getClosedFormula());
            Script.LBool result = this.mMgdScript.checkSat((Object)this);
            if (result == Script.LBool.SAT) {
                Set<IProgramVar> vars = termVarsProc.getVars();
                Set<Term> terms = vars.stream().map(IProgramVar::getDefaultConstant).collect(Collectors.toSet());
                Map map = this.mMgdScript.getScript().getValue(terms.toArray(new Term[terms.size()]));
                return map;
            }
            throw new UnsupportedOperationException("Solver cannot find a model for the term " + term);
        }
        finally {
            this.mMgdScript.pop((Object)this, 1);
            this.mMgdScript.unlock((Object)this);
        }
    }

    protected int getDepth() {
        if (this.mRoot == null) {
            return 0;
        }
        return this.getDepthHelper(this.mRoot, 0);
    }

    private int getDepthHelper(IVertex vertex, int depth) {
        if (vertex instanceof PredicateVertex) {
            return depth + 1;
        }
        int trueMaxDepth = this.getDepthHelper(((ModelVertex)vertex).getChild(false), depth + 1);
        int falseMaxDepth = this.getDepthHelper(((ModelVertex)vertex).getChild(true), depth + 1);
        return Math.max(trueMaxDepth, falseMaxDepth);
    }

    public PredicateTrie<T> fillTrie(RestructureHelperObject root, Map<RestructureHelperObject, Pair<RestructureHelperObject, RestructureHelperObject>> witnessMap) {
        if (this.mRoot != null) {
            throw new UnsupportedOperationException("trie must be empty");
        }
        HashMap<RestructureHelperObject, ModelVertex> modelVertices = new HashMap<RestructureHelperObject, ModelVertex>();
        for (RestructureHelperObject restructureHelperObject : witnessMap.keySet()) {
            modelVertices.put(restructureHelperObject, new ModelVertex(null, null, restructureHelperObject.getWitness()));
        }
        for (Map.Entry entry : witnessMap.entrySet()) {
            Pair children = (Pair)entry.getValue();
            if (((RestructureHelperObject)children.getFirst()).getSerialNumber() == -1) {
                PredicateVertex<IPredicate> trueChild = new PredicateVertex<IPredicate>(((RestructureHelperObject)children.getFirst()).getPredicate());
                ((ModelVertex)modelVertices.get(entry.getKey())).setTrueChild(trueChild);
            } else {
                ((ModelVertex)modelVertices.get(entry.getKey())).setTrueChild((IVertex)modelVertices.get(children.getFirst()));
            }
            if (((RestructureHelperObject)children.getSecond()).getSerialNumber() == -1) {
                PredicateVertex<IPredicate> falseChild = new PredicateVertex<IPredicate>(((RestructureHelperObject)children.getSecond()).getPredicate());
                ((ModelVertex)modelVertices.get(entry.getKey())).setFalseChild(falseChild);
                continue;
            }
            ((ModelVertex)modelVertices.get(entry.getKey())).setFalseChild((IVertex)modelVertices.get(children.getSecond()));
        }
        this.mRoot = (IVertex)modelVertices.get(root);
        return this;
    }
}

