/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationGraph;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.biesenb.ImplicationVertex;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class TransitiveClosureIG<T extends IPredicate> {
    private Set<ImplicationVertex<T>> mVertices;
    private final Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> mDescendantsMapping;
    private final Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> mAncestorsMapping;

    public TransitiveClosureIG(ImplicationGraph<T> graph) {
        this.mVertices = new HashSet<ImplicationVertex<T>>(graph.getVertices());
        this.mDescendantsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.mAncestorsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.constructTransitiveClosure();
    }

    private void constructTransitiveClosure() {
        this.mVertices.forEach(v -> {
            HashSet hashSet = this.mDescendantsMapping.put((ImplicationVertex<T>)v, new HashSet(v.getDescendants()));
        });
        this.mVertices.forEach(v -> {
            HashSet hashSet = this.mAncestorsMapping.put((ImplicationVertex<T>)v, new HashSet(v.getAncestors()));
        });
    }

    public TransitiveClosureIG(ImplicationGraph<T> graph, Set<ImplicationVertex<T>> init) {
        this.mVertices = new HashSet<ImplicationVertex<T>>(init.iterator().next().getDescendants());
        for (ImplicationVertex<T> i : init) {
            HashSet<ImplicationVertex<T>> current = new HashSet<ImplicationVertex<T>>();
            for (ImplicationVertex<T> v : this.mVertices) {
                if (!i.getDescendants().contains(v)) continue;
                current.add(v);
            }
            this.mVertices = current;
        }
        this.mVertices.addAll(init);
        this.mDescendantsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.mAncestorsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.constructSubTransitiveClosure();
    }

    private void constructSubTransitiveClosure() {
        for (ImplicationVertex<T> v : this.mVertices) {
            HashSet<ImplicationVertex<T>> descendants = new HashSet<ImplicationVertex<T>>();
            for (ImplicationVertex<T> descendant : v.getDescendants()) {
                if (!this.mVertices.contains(descendant)) continue;
                descendants.add(descendant);
            }
            this.mDescendantsMapping.put(v, descendants);
            HashSet<ImplicationVertex<T>> ancestors = new HashSet<ImplicationVertex<T>>();
            for (ImplicationVertex<T> ancestor : v.getAncestors()) {
                if (!this.mVertices.contains(ancestor)) continue;
                ancestors.add(ancestor);
            }
            this.mAncestorsMapping.put(v, ancestors);
        }
    }

    public TransitiveClosureIG(ImplicationVertex<T> root, Set<ImplicationVertex<T>> descendants, ImplicationVertex<T> falseVertex) {
        this.mVertices = new HashSet<ImplicationVertex<T>>(descendants);
        this.mVertices.add(root);
        this.mDescendantsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        this.mAncestorsMapping = new HashMap<ImplicationVertex<T>, Set<ImplicationVertex<T>>>();
        for (ImplicationVertex<T> v : this.mVertices) {
            HashSet<ImplicationVertex<T>> des = new HashSet<ImplicationVertex<T>>();
            for (ImplicationVertex<T> descendant : v.getDescendants()) {
                if (!this.mVertices.contains(descendant)) continue;
                des.add(descendant);
            }
            this.mDescendantsMapping.put(v, des);
            HashSet<ImplicationVertex<T>> ancestors = new HashSet<ImplicationVertex<T>>();
            for (ImplicationVertex<T> ancestor : v.getAncestors()) {
                if (!this.mVertices.contains(ancestor)) continue;
                ancestors.add(ancestor);
            }
            this.mAncestorsMapping.put(v, ancestors);
        }
        this.mVertices.add(falseVertex);
        this.mAncestorsMapping.put(falseVertex, new HashSet());
        this.mDescendantsMapping.put(falseVertex, new HashSet());
        for (ImplicationVertex<T> ancestor : this.mAncestorsMapping.keySet()) {
            if (!this.mAncestorsMapping.get(ancestor).isEmpty()) continue;
            this.mAncestorsMapping.get(ancestor).add(falseVertex);
            this.mDescendantsMapping.get(falseVertex).add(ancestor);
        }
    }

    protected void removeVertex(ImplicationVertex<T> vertex) {
        if (this.mVertices.remove(vertex)) {
            Set<ImplicationVertex<ImplicationVertex>> descendants = this.mDescendantsMapping.remove(vertex);
            descendants.forEach(d -> {
                boolean bl = this.mAncestorsMapping.get(d).remove(vertex);
            });
            Set<ImplicationVertex<ImplicationVertex>> ancestors = this.mAncestorsMapping.remove(vertex);
            ancestors.forEach(a -> {
                boolean bl = this.mDescendantsMapping.get(a).remove(vertex);
            });
        }
    }

    public void removeAncestorsFromTC(ImplicationVertex<T> vertex) {
        while (!this.mAncestorsMapping.get(vertex).isEmpty()) {
            ImplicationVertex<T> remove = this.mAncestorsMapping.get(vertex).iterator().next();
            if (!this.mVertices.remove(remove)) continue;
            Set<ImplicationVertex<ImplicationVertex>> descendants = this.mDescendantsMapping.remove(remove);
            descendants.forEach(d -> {
                boolean bl = this.mAncestorsMapping.get(d).remove(remove);
            });
            Set<ImplicationVertex<ImplicationVertex>> ancestors = this.mAncestorsMapping.remove(remove);
            ancestors.forEach(a -> {
                boolean bl = this.mDescendantsMapping.get(a).remove(remove);
            });
        }
    }

    public void removeDescendantsFromTC(ImplicationVertex<T> vertex, ImplicationVertex<T> trueVertex) {
        if (trueVertex == null) {
            while (!this.mDescendantsMapping.get(vertex).isEmpty()) {
                this.removeVertex(this.mDescendantsMapping.get(vertex).iterator().next());
            }
        } else {
            HashSet a = new HashSet(this.mDescendantsMapping.get(vertex));
            while (!a.isEmpty()) {
                vertex = (ImplicationVertex)a.iterator().next();
                a.remove(vertex);
                if (!vertex.equals(trueVertex)) {
                    this.removeVertex(vertex);
                    continue;
                }
                this.mAncestorsMapping.get(trueVertex).clear();
            }
            for (ImplicationVertex<T> d : this.mDescendantsMapping.keySet()) {
                if (!this.mDescendantsMapping.get(d).isEmpty()) continue;
                this.mDescendantsMapping.get(d).add(trueVertex);
                this.mAncestorsMapping.get(trueVertex).add(d);
            }
        }
    }

    protected ImplicationVertex<T> getMaxTransitiveClosureCount(Set<ImplicationVertex<T>> marked, boolean first) {
        int max = 0;
        ImplicationVertex<T> maxVertex = this.mVertices.iterator().next();
        for (ImplicationVertex<T> vertex : this.mVertices) {
            if (marked.contains(vertex)) continue;
            int a = this.mAncestorsMapping.get(vertex).size();
            int b = this.mDescendantsMapping.get(vertex).size();
            if (first) {
                ++b;
            } else {
                ++a;
            }
            int count = a * b / (a + b);
            if (count < max) continue;
            max = count;
            maxVertex = vertex;
        }
        return maxVertex;
    }

    protected Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> getDescendantsMapping() {
        return this.mDescendantsMapping;
    }

    protected Map<ImplicationVertex<T>, Set<ImplicationVertex<T>>> getAncestorsMapping() {
        return this.mAncestorsMapping;
    }

    protected Set<ImplicationVertex<T>> getVertices() {
        return this.mVertices;
    }
}

