/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.debug;

import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermTransformer;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.io.PrintWriter;
import java.util.HashSet;
import java.util.Set;

public final class DeclarationAdder
extends TermTransformer {
    private final Set<FunctionSymbol> mFuncSymbols;
    private final Set<TermVariable> mTermSymbols;
    private final PrintWriter mWriter;

    public DeclarationAdder(PrintWriter pw) {
        this.mWriter = pw;
        this.mFuncSymbols = new HashSet<FunctionSymbol>();
        this.mTermSymbols = new HashSet<TermVariable>();
    }

    protected void convert(Term term) {
        TermVariable termVar;
        if (term instanceof ApplicationTerm) {
            FunctionSymbol symbol = ((ApplicationTerm)term).getFunction();
            if (!symbol.isIntern() && this.mFuncSymbols.add(symbol)) {
                this.mWriter.append("(declare-fun ").append(symbol.getName()).append(" () ").append(symbol.getReturnSort().toString()).append(")").println();
            }
        } else if (term instanceof TermVariable && this.mTermSymbols.add(termVar = (TermVariable)term)) {
            this.mWriter.append("(declare-fun ").append(termVar.getName()).append(" () ").append(termVar.getSort().toString()).append(")").println();
        }
        super.convert(term);
    }
}

