/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.debug;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.debug.DeclarationAdder;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.TimerTask;
import java.util.zip.GZIPOutputStream;

public class InputTermDumper
extends TimerTask {
    private final Term mInputTerm;
    private final Term[] mAssertions;
    private final String mPrefix;

    public InputTermDumper(Term inputTerm, Term[] assertions, String tempFilePrefix) {
        this.mInputTerm = inputTerm;
        this.mAssertions = assertions;
        this.mPrefix = tempFilePrefix;
    }

    @Override
    public void run() {
        try {
            File file = File.createTempFile(this.mPrefix, ".smt2.gz");
            PrintWriter printWriter = new PrintWriter(new GZIPOutputStream(new FileOutputStream(file)));
            DeclarationAdder declAdder = new DeclarationAdder(printWriter);
            printWriter.append("(set-logic ").append(this.mInputTerm.getTheory().getLogic().toString()).append(")").println();
            if (this.mAssertions != null && this.mAssertions.length > 0) {
                Term[] termArray = this.mAssertions;
                int n = this.mAssertions.length;
                int n2 = 0;
                while (n2 < n) {
                    Term assertion = termArray[n2];
                    declAdder.transform(assertion);
                    printWriter.append("(assert ").append(assertion.toString()).append(")").println();
                    ++n2;
                }
            }
            declAdder.transform(this.mInputTerm);
            printWriter.append("(simplify ").append(this.mInputTerm.toString()).append(")").println();
            printWriter.flush();
            printWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

