/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import java.util.List;
import java.util.Set;

public class IndexAnalysisResult
extends EqualityAnalysisResult {
    private final Set<Doubleton<Term>> mIgnoredDoubletons;

    public IndexAnalysisResult(Set<Doubleton<Term>> equalDoubletons, Set<Doubleton<Term>> distinctDoubletons, Set<Doubleton<Term>> unknownDoubletons, Set<Doubleton<Term>> ignoredDoubletons) {
        super(equalDoubletons, distinctDoubletons, unknownDoubletons);
        this.mIgnoredDoubletons = ignoredDoubletons;
    }

    public EqualityStatus isEqual(List<Term> index1, List<Term> index2) {
        assert (index1.size() == index2.size());
        boolean oneEntryWasUnknown = false;
        int i = 0;
        while (i < index1.size()) {
            if (index1.get(i) != index2.get(i)) {
                if (this.isDistinctDoubleton(index1.get(i), index2.get(i))) {
                    return EqualityStatus.NOT_EQUAL;
                }
                if (this.isUnknownDoubleton(index1.get(i), index2.get(i))) {
                    oneEntryWasUnknown = true;
                } else if (this.isIgnoredDoubleton(index1.get(i), index2.get(i))) {
                    oneEntryWasUnknown = true;
                } else assert (this.isEqualDoubleton(index1.get(i), index2.get(i)));
            }
            ++i;
        }
        if (oneEntryWasUnknown) {
            return EqualityStatus.UNKNOWN;
        }
        return EqualityStatus.EQUAL;
    }

    public boolean isEqualDoubleton(Term t1, Term t2) {
        return this.getEqualDoubletons().contains(new Doubleton((Object)t1, (Object)t2));
    }

    public boolean isDistinctDoubleton(Term t1, Term t2) {
        return this.getDistinctDoubletons().contains(new Doubleton((Object)t1, (Object)t2));
    }

    public boolean isUnknownDoubleton(Term t1, Term t2) {
        return this.getUnknownDoubletons().contains(new Doubleton((Object)t1, (Object)t2));
    }

    public boolean isIgnoredDoubleton(Term t1, Term t2) {
        return this.mIgnoredDoubletons.contains(new Doubleton((Object)t1, (Object)t2));
    }
}

