/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.logic.QuotedObject;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.CoreUtil;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.EqualityStatus;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class IndexAnalyzer {
    private final ILogger mLogger;
    private final Term mTerm;
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final IIcfgSymbolTable mSymbolTable;
    private final ModifiableTransFormula mTransFormula;
    private final Set<Doubleton<Term>> mDistinctDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mEqualDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mUnknownDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final Set<Doubleton<Term>> mIgnoredDoubletons = new LinkedHashSet<Doubleton<Term>>();
    private final EqualityAnalysisResult mInvariantEqualitiesBefore;
    private final EqualityAnalysisResult mInvariantEqualitiesAfter;
    private final boolean mUseArrayIndexSupportingInvariants = true;

    public IndexAnalyzer(Term term, Set<Doubleton<Term>> doubletons, IIcfgSymbolTable symbolTable, ModifiableTransFormula tf, EqualityAnalysisResult invariantEqualitiesBefore, EqualityAnalysisResult invariantEqualitiesAfter, ILogger logger, ManagedScript mgdScript) {
        this.mLogger = logger;
        this.mTerm = term;
        this.mSymbolTable = symbolTable;
        this.mScript = mgdScript.getScript();
        this.mManagedScript = mgdScript;
        this.mTransFormula = tf;
        this.mInvariantEqualitiesBefore = invariantEqualitiesBefore;
        this.mInvariantEqualitiesAfter = invariantEqualitiesAfter;
        Set<Doubleton<Term>> allDoubletons = doubletons;
        Set<Doubleton<Term>> remainingDoubletons = this.preprocessWithInvariants(allDoubletons);
        Term equalitiesOriginal = SmtUtils.and((Script)this.mScript, this.mInvariantEqualitiesBefore.constructListOfEqualities(this.mScript));
        Term notequalsOriginal = SmtUtils.and((Script)this.mScript, this.mInvariantEqualitiesBefore.constructListOfNotEquals(this.mScript));
        Term equalitiesRenamed = ModifiableTransFormulaUtils.translateTermVariablesToInVars(this.mManagedScript, this.mTransFormula, equalitiesOriginal, this.mSymbolTable);
        Term notequalsRenamed = ModifiableTransFormulaUtils.translateTermVariablesToInVars(this.mManagedScript, this.mTransFormula, notequalsOriginal, this.mSymbolTable);
        Term termWithAdditionalInvariants = SmtUtils.and((Script)this.mScript, (Term[])new Term[]{this.mTerm, equalitiesRenamed, notequalsRenamed});
        this.processDoubletonsWithOwnAnalysis(remainingDoubletons, termWithAdditionalInvariants);
        if (this.mLogger.isDebugEnabled()) {
            this.mLogger.debug((Object)("Indices for " + tf.getFormula()));
            if (!(this.mEqualDoubletons.isEmpty() && this.mDistinctDoubletons.isEmpty() && this.mUnknownDoubletons.isEmpty() && this.mIgnoredDoubletons.isEmpty())) {
                this.mLogger.debug((Object)(String.valueOf(this.mEqualDoubletons.size()) + " equalDoubletons"));
                this.mLogger.debug((Object)(String.valueOf(this.mDistinctDoubletons.size()) + " distinctDoubletons"));
                this.mLogger.debug((Object)(String.valueOf(this.mUnknownDoubletons.size()) + " unknownDoubletons"));
                this.mLogger.debug((Object)(String.valueOf(this.mIgnoredDoubletons.size()) + " ignoredDoubletons"));
            } else {
                this.mLogger.debug((Object)"No Doubletons");
            }
        }
    }

    public IndexAnalyzer(Term formula, HashRelation<Term, ArrayIndex> arrays2Indices, IIcfgSymbolTable boogie2SmtSymbolTable, ModifiableTransFormula tf, EqualityAnalysisResult invariantEqualitiesBefore, EqualityAnalysisResult invariantEqualitiesAfter, ILogger logger, ManagedScript mgdScript) {
        this(formula, IndexAnalyzer.extractDoubletons(arrays2Indices), boogie2SmtSymbolTable, tf, invariantEqualitiesBefore, invariantEqualitiesAfter, logger, mgdScript);
    }

    private Set<Doubleton<Term>> preprocessWithInvariants(Set<Doubleton<Term>> allDoubletons) {
        HashSet<Doubleton<Term>> result = new HashSet<Doubleton<Term>>();
        for (Doubleton<Term> doubleton : allDoubletons) {
            if (this.isInVarDoubleton(doubleton)) {
                this.gradeDoubleton(doubleton, this.mInvariantEqualitiesBefore, this.mEqualDoubletons, this.mDistinctDoubletons, result);
                continue;
            }
            if (this.isOutVarDoubleton(doubleton)) {
                this.gradeDoubleton(doubleton, this.mInvariantEqualitiesAfter, this.mEqualDoubletons, this.mDistinctDoubletons, result);
                continue;
            }
            result.add(doubleton);
        }
        return result;
    }

    private void gradeDoubleton(Doubleton<Term> doubleton, EqualityAnalysisResult invariantEqualities, Set<Doubleton<Term>> equalDoubletons, Set<Doubleton<Term>> distinctDoubletons, Set<Doubleton<Term>> furtherAnalysisRequired) throws AssertionError {
        EqualityStatus equalityStatus;
        Doubleton<Term> definingDoubleton = this.constructDefiningDoubleton(doubleton);
        try {
            equalityStatus = invariantEqualities.getEqualityStatus(definingDoubleton);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            furtherAnalysisRequired.add(doubleton);
            return;
        }
        switch (equalityStatus) {
            case EQUAL: {
                equalDoubletons.add(doubleton);
                break;
            }
            case NOT_EQUAL: {
                distinctDoubletons.add(doubleton);
                break;
            }
            case UNKNOWN: {
                furtherAnalysisRequired.add(doubleton);
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
    }

    private boolean isInVarDoubleton(Doubleton<Term> doubleton) {
        boolean fstIndexIsInvarIndex = ModifiableTransFormulaUtils.allVariablesAreInVars((Term)doubleton.getOneElement(), this.mTransFormula);
        boolean sndIndexIsInvarIndex = ModifiableTransFormulaUtils.allVariablesAreInVars((Term)doubleton.getOtherElement(), this.mTransFormula);
        boolean isInvarPair = fstIndexIsInvarIndex && sndIndexIsInvarIndex;
        return isInvarPair;
    }

    private boolean isOutVarDoubleton(Doubleton<Term> doubleton) {
        boolean fstIndexIsOutvarIndex = ModifiableTransFormulaUtils.allVariablesAreOutVars((Term)doubleton.getOneElement(), this.mTransFormula);
        boolean sndIndexIsOutvarIndex = ModifiableTransFormulaUtils.allVariablesAreOutVars((Term)doubleton.getOtherElement(), this.mTransFormula);
        boolean isOutvarPair = fstIndexIsOutvarIndex && sndIndexIsOutvarIndex;
        return isOutvarPair;
    }

    private static Set<Doubleton<Term>> extractDoubletons(HashRelation<Term, ArrayIndex> array2Indices) {
        HashSet<Doubleton<Term>> result = new HashSet<Doubleton<Term>>();
        for (Term tv : array2Indices.getDomain()) {
            Set test = array2Indices.getImage((Object)tv);
            ArrayIndex[] testArr = test.toArray(new ArrayIndex[test.size()]);
            int i = 0;
            while (i < testArr.length) {
                int j = i + 1;
                while (j < testArr.length) {
                    ArrayIndex fstIndex = testArr[i];
                    ArrayIndex sndIndex = testArr[j];
                    assert (fstIndex.size() == sndIndex.size()) : "incompatible size";
                    int k = 0;
                    while (k < fstIndex.size()) {
                        result.add((Doubleton<Term>)new Doubleton((Object)fstIndex.get(k), (Object)sndIndex.get(k)));
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    private void addDistinctDoubleton(Doubleton<Term> doubleton) {
        this.mDistinctDoubletons.add(doubleton);
    }

    private void addEqualDoubleton(Doubleton<Term> doubleton) {
        this.mEqualDoubletons.add(doubleton);
    }

    private void addUnknownDoubleton(Doubleton<Term> doubleton) {
        this.mUnknownDoubletons.add(doubleton);
    }

    private void processDoubletonsWithOwnAnalysis(Set<Doubleton<Term>> doubletons, Term termWithAdditionalInvariants) {
        this.mScript.echo(new QuotedObject("starting index analysis for TransFormula"));
        this.mScript.push(1);
        HashSet<TermVariable> allTvs = new HashSet<TermVariable>(Arrays.asList(termWithAdditionalInvariants.getFreeVars()));
        allTvs.addAll(CoreUtil.filter(this.mTransFormula.getInVarsReverseMapping().keySet(), TermVariable.class));
        allTvs.addAll(CoreUtil.filter(this.mTransFormula.getOutVarsReverseMapping().keySet(), TermVariable.class));
        Map substitutionMapping = SmtUtils.termVariables2Constants((Script)this.mScript, allTvs, (boolean)true);
        this.mScript.assertTerm(Substitution.apply((ManagedScript)this.mManagedScript, (Map)substitutionMapping, (Term)termWithAdditionalInvariants));
        for (Doubleton<Term> doubleton : doubletons) {
            if (IndexAnalyzer.allVarsOccurInFormula(doubleton, termWithAdditionalInvariants)) {
                Term equal = Substitution.apply((ManagedScript)this.mManagedScript, (Map)substitutionMapping, (Term)SmtUtils.binaryEquality((Script)this.mScript, (Term)((Term)doubleton.getOneElement()), (Term)((Term)doubleton.getOtherElement())));
                this.mScript.push(1);
                this.mScript.assertTerm(equal);
                Script.LBool lbool = this.mScript.checkSat();
                this.mScript.pop(1);
                if (lbool == Script.LBool.UNSAT) {
                    this.addDistinctDoubleton(doubleton);
                    continue;
                }
                Term notEqual = SmtUtils.not((Script)this.mScript, (Term)equal);
                this.mScript.push(1);
                this.mScript.assertTerm(notEqual);
                lbool = this.mScript.checkSat();
                this.mScript.pop(1);
                if (lbool == Script.LBool.UNSAT) {
                    this.addEqualDoubleton(doubleton);
                    continue;
                }
                this.addUnknownDoubleton(doubleton);
                continue;
            }
            this.mIgnoredDoubletons.add(doubleton);
        }
        this.mScript.pop(1);
        this.mScript.echo(new QuotedObject("finished index analysis for TransFormula"));
    }

    private static boolean allVarsOccurInFormula(Doubleton<Term> doubleton, Term termWithAdditionalInvariants) {
        HashSet<TermVariable> freeVarsInDoubleton = new HashSet<TermVariable>();
        freeVarsInDoubleton.addAll(Arrays.asList(((Term)doubleton.getOneElement()).getFreeVars()));
        freeVarsInDoubleton.addAll(Arrays.asList(((Term)doubleton.getOtherElement()).getFreeVars()));
        HashSet<TermVariable> freeVarsInFormula = new HashSet<TermVariable>(Arrays.asList(termWithAdditionalInvariants.getFreeVars()));
        return freeVarsInFormula.containsAll(freeVarsInDoubleton);
    }

    private Doubleton<Term> constructDefiningDoubleton(Doubleton<Term> inVarDoubleton) {
        Term oneElement = (Term)inVarDoubleton.getOneElement();
        Term otherElement = (Term)inVarDoubleton.getOtherElement();
        Term translatedOne = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, this.mTransFormula, oneElement);
        Term translatedOther = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, this.mTransFormula, otherElement);
        return new Doubleton((Object)translatedOne, (Object)translatedOther);
    }

    public IndexAnalysisResult getResult() {
        return new IndexAnalysisResult(Collections.unmodifiableSet(this.mEqualDoubletons), Collections.unmodifiableSet(this.mDistinctDoubletons), Collections.unmodifiableSet(this.mUnknownDoubletons), Collections.unmodifiableSet(this.mIgnoredDoubletons));
    }
}

