/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.TracePredicates;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public final class QualifiedTracePredicates {
    private final TracePredicates mTracePredicates;
    private final boolean mIsPerfect;
    private final Class<?> mOrigin;

    public QualifiedTracePredicates(TracePredicates sequence, Class<?> origin, boolean isPerfect) {
        this.mTracePredicates = Objects.requireNonNull(sequence);
        this.mOrigin = Objects.requireNonNull(origin);
        this.mIsPerfect = isPerfect;
    }

    public boolean isPerfect() {
        return this.mIsPerfect;
    }

    public TracePredicates getTracePredicates() {
        return this.mTracePredicates;
    }

    public Class<?> getOrigin() {
        return this.mOrigin;
    }

    public List<IPredicate> getPredicates() {
        return this.mTracePredicates.getPredicates();
    }

    public static List<TracePredicates> toList(List<QualifiedTracePredicates> usedIpps) {
        if (usedIpps.isEmpty()) {
            return Collections.emptyList();
        }
        return usedIpps.stream().map(QualifiedTracePredicates::getTracePredicates).collect(Collectors.toList());
    }

    public String toString() {
        return this.mTracePredicates.toString();
    }
}

