/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.structure.IAction;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.interpolant.IInterpolantGenerator;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class TracePredicates {
    private final IPredicate mPrecondition;
    private final IPredicate mPostcondition;
    private final List<IPredicate> mPredicates;

    public TracePredicates(IInterpolantGenerator<? extends IAction> interpolantGenerator) {
        if (interpolantGenerator.getInterpolants() == null) {
            throw new AssertionError((Object)"We can only build an interpolant automaton for which interpolants were computed.");
        }
        this.mPrecondition = interpolantGenerator.getPrecondition();
        this.mPostcondition = interpolantGenerator.getPostcondition();
        this.mPredicates = Arrays.asList(interpolantGenerator.getInterpolants());
    }

    public TracePredicates(IPredicate precondition, IPredicate postcondition, List<IPredicate> predicates) {
        this.mPrecondition = precondition;
        this.mPostcondition = postcondition;
        this.mPredicates = predicates;
    }

    public IPredicate getPredicate(int pos) {
        if (pos < 0) {
            throw new AssertionError((Object)"index beyond precondition");
        }
        if (pos == 0) {
            return this.mPrecondition;
        }
        if (pos <= this.mPredicates.size()) {
            return this.mPredicates.get(pos - 1);
        }
        if (pos == this.mPredicates.size() + 1) {
            return this.mPostcondition;
        }
        throw new AssertionError((Object)"index beyond postcondition");
    }

    public List<IPredicate> getPredicates() {
        return Collections.unmodifiableList(this.mPredicates);
    }

    public IPredicate getPrecondition() {
        return this.mPrecondition;
    }

    public IPredicate getPostcondition() {
        return this.mPostcondition;
    }

    public String toString() {
        return String.format("{%s} %s {%s}", this.mPrecondition, this.mPredicates, this.mPostcondition);
    }
}

