/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayWrite;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.UFTemplate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbol;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.NonTheorySymbolFinder;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class MapEliminationPreAnalysis {
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final HashRelation<Term, ArrayIndex> mVariablesToIndices;
    private final HashRelation<MapTemplate, ArrayIndex> mMapsToIndices;
    private final HashRelation<ArrayIndex, MapTemplate> mIndicesToMaps;
    private final Set<Doubleton<Term>> mRelatedArays;
    private final Set<String> mUninterpretedFunctions;
    private final Map<ModifiableTransFormula, HashRelation<MapTemplate, ArrayIndex>> mTransFormulasToLocalIndices;
    private final Set<Doubleton<Term>> mDoubletons;

    public MapEliminationPreAnalysis(ManagedScript managedScript, Collection<ModifiableTransFormula> transformulas) {
        this.mScript = managedScript.getScript();
        this.mManagedScript = managedScript;
        this.mTransFormulasToLocalIndices = new HashMap<ModifiableTransFormula, HashRelation<MapTemplate, ArrayIndex>>();
        this.mVariablesToIndices = new HashRelation();
        this.mMapsToIndices = new HashRelation();
        this.mIndicesToMaps = new HashRelation();
        this.mRelatedArays = new HashSet<Doubleton<Term>>();
        this.mUninterpretedFunctions = new HashSet<String>();
        this.findAllIndices(transformulas);
        this.mDoubletons = this.getIndexDoubletons(this.mMapsToIndices);
    }

    private void findAllIndices(Collection<ModifiableTransFormula> transformulas) {
        for (ModifiableTransFormula tf : transformulas) {
            this.mTransFormulasToLocalIndices.put(tf, (HashRelation<MapTemplate, ArrayIndex>)new HashRelation());
            this.findIndices(tf);
        }
        UnionFind unionFind = new UnionFind();
        HashMap<Term, ArrayTemplate> templates = new HashMap<Term, ArrayTemplate>();
        for (Doubleton<Term> doubleton : this.mRelatedArays) {
            Term array1 = (Term)doubleton.getOneElement();
            Term array2 = (Term)doubleton.getOtherElement();
            templates.put(array1, new ArrayTemplate(array1, this.mScript));
            templates.put(array2, new ArrayTemplate(array2, this.mScript));
            unionFind.findAndConstructEquivalenceClassIfNeeded((Object)array1);
            unionFind.findAndConstructEquivalenceClassIfNeeded((Object)array2);
            unionFind.union((Object)array1, (Object)array2);
        }
        for (Set equivalenceClass : unionFind.getAllEquivalenceClasses()) {
            HashSet indices = new HashSet();
            for (Term array : equivalenceClass) {
                indices.addAll(this.mMapsToIndices.getImage((Object)((MapTemplate)templates.get(array))));
            }
            for (Term array : equivalenceClass) {
                for (ArrayIndex index : indices) {
                    this.mMapsToIndices.addPair((Object)((MapTemplate)templates.get(array)), (Object)index);
                    this.mIndicesToMaps.addPair((Object)index, (Object)((MapTemplate)templates.get(array)));
                }
            }
        }
    }

    private void findIndices(ModifiableTransFormula transformula) {
        ArrayWrite arrayWrite;
        Term term = transformula.getFormula();
        for (MultiDimensionalSelect select : MultiDimensionalSelect.extractSelectDeep((Term)term, (boolean)false)) {
            arrayWrite = new ArrayWrite(select.getArray(), this.mScript);
            this.findIndicesArrayWrite(arrayWrite, transformula);
            this.addArrayAccessToRelation(arrayWrite.getOldArray(), select.getIndex(), transformula);
        }
        for (Term t : SmtUtils.extractApplicationTerms((String)"=", (Term)term, (boolean)false)) {
            Term globalArray2;
            Term globalArray1;
            if (!((ApplicationTerm)t).getParameters()[0].getSort().isArraySort()) continue;
            arrayWrite = new ArrayWrite(t, this.mScript);
            ArrayWrite arrayWrite2 = new ArrayWrite(arrayWrite.getNewArray(), this.mScript);
            this.findIndicesArrayWrite(arrayWrite, transformula);
            this.findIndicesArrayWrite(arrayWrite2, transformula);
            Term array1 = arrayWrite.getOldArray();
            Term array2 = arrayWrite2.getOldArray();
            if (!ModifiableTransFormulaUtils.allVariablesAreVisible(array1, transformula) || !ModifiableTransFormulaUtils.allVariablesAreVisible(array2, transformula) || (globalArray1 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, array1)) == (globalArray2 = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, array2))) continue;
            this.mRelatedArays.add((Doubleton<Term>)new Doubleton((Object)globalArray1, (Object)globalArray2));
        }
        for (NonTheorySymbol s : new NonTheorySymbolFinder().findNonTheorySymbols(term)) {
            Object symbol = s.getSymbol();
            if (!(symbol instanceof FunctionSymbol)) continue;
            String function = ((FunctionSymbol)symbol).getName();
            for (Term t : SmtUtils.extractApplicationTerms((String)function, (Term)term, (boolean)false)) {
                ArrayIndex index = new ArrayIndex(Arrays.asList(((ApplicationTerm)t).getParameters()));
                this.addCallToRelation(function, index, transformula);
            }
        }
    }

    private void findIndicesArrayWrite(ArrayWrite arrayWrite, ModifiableTransFormula transformula) {
        for (Pair<ArrayIndex, Term> pair : arrayWrite.getIndexValuePairs()) {
            this.addArrayAccessToRelation(arrayWrite.getOldArray(), (ArrayIndex)pair.getFirst(), transformula);
        }
    }

    private void addArrayAccessToRelation(Term array, ArrayIndex index, ModifiableTransFormula transformula) {
        if (!ModifiableTransFormulaUtils.allVariablesAreVisible(array, transformula) || index.size() != SmtUtils.getDimension((Sort)array.getSort())) {
            return;
        }
        for (Term t : index) {
            if (!SmtUtils.containsFunctionApplication((Term)t, (String)"store")) continue;
            return;
        }
        Term globalArray = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, array);
        this.mTransFormulasToLocalIndices.get(transformula).addPair((Object)new ArrayTemplate(globalArray, this.mScript), (Object)index);
        if (ModifiableTransFormulaUtils.allVariablesAreVisible((List<Term>)index, transformula)) {
            ArrayIndex globalIndex = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, (List<Term>)index));
            for (TermVariable var : globalIndex.getFreeVars()) {
                this.mVariablesToIndices.addPair((Object)var, (Object)globalIndex);
            }
            ArrayTemplate template = new ArrayTemplate(globalArray, this.mScript);
            this.mMapsToIndices.addPair((Object)template, (Object)globalIndex);
            this.mIndicesToMaps.addPair((Object)globalIndex, (Object)template);
        }
    }

    private void addCallToRelation(String functionName, ArrayIndex index, ModifiableTransFormula transformula) {
        if (index.isEmpty()) {
            return;
        }
        for (Term t : index) {
            if (!SmtUtils.containsFunctionApplication((Term)t, (String)"store")) continue;
            return;
        }
        UFTemplate template = new UFTemplate(functionName, this.mScript);
        this.mTransFormulasToLocalIndices.get(transformula).addPair((Object)template, (Object)index);
        this.mUninterpretedFunctions.add(functionName);
        if (ModifiableTransFormulaUtils.allVariablesAreVisible((List<Term>)index, transformula)) {
            ArrayIndex globalIndex = new ArrayIndex(ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, (List<Term>)index));
            for (TermVariable var : globalIndex.getFreeVars()) {
                this.mVariablesToIndices.addPair((Object)var, (Object)globalIndex);
            }
            this.mMapsToIndices.addPair((Object)template, (Object)globalIndex);
            this.mIndicesToMaps.addPair((Object)globalIndex, (Object)template);
        }
    }

    public Set<MapTemplate> getAllTemplates() {
        return this.mMapsToIndices.getDomain();
    }

    public Set<MapTemplate> getTemplate(ArrayIndex index) {
        return this.mIndicesToMaps.getImage((Object)index);
    }

    public Set<ArrayIndex> getIndices(MapTemplate template) {
        return this.mMapsToIndices.getImage((Object)template);
    }

    public Set<ArrayIndex> getIndicesWithVariable(Term variable) {
        return this.mVariablesToIndices.getImage((Object)variable);
    }

    public HashRelation<MapTemplate, ArrayIndex> getLocalIndices(ModifiableTransFormula transformula) {
        return this.mTransFormulasToLocalIndices.get(transformula);
    }

    public Stream<Term> findMapReads(Term term) {
        Stream<Term> arrays = SmtUtils.extractApplicationTerms((String)"select", (Term)term, (boolean)true).stream().filter(x -> !x.getSort().isArraySort());
        Stream functions = this.mUninterpretedFunctions.stream().flatMap(x -> SmtUtils.extractApplicationTerms((String)x, (Term)term, (boolean)true).stream());
        return Stream.concat(arrays, functions);
    }

    public Set<Doubleton<Term>> getIndexDoubletons(HashRelation<MapTemplate, ArrayIndex> mapsToIndices) {
        HashSet<Doubleton<Term>> result = new HashSet<Doubleton<Term>>();
        for (MapTemplate template : mapsToIndices.getDomain()) {
            Set indicesSet = mapsToIndices.getImage((Object)template);
            ArrayIndex[] indices = indicesSet.toArray(new ArrayIndex[indicesSet.size()]);
            int i = 0;
            while (i < indices.length) {
                int j = i + 1;
                while (j < indices.length) {
                    ArrayIndex index1 = indices[i];
                    ArrayIndex index2 = indices[j];
                    int k = 0;
                    while (k < index1.size()) {
                        Term term2;
                        Term term1 = index1.get(k);
                        if (term1 != (term2 = index2.get(k))) {
                            result.add((Doubleton<Term>)new Doubleton((Object)term1, (Object)term2));
                        }
                        ++k;
                    }
                    ++j;
                }
                ++i;
            }
        }
        return result;
    }

    public Set<Doubleton<Term>> getAllDoubletons() {
        return this.mDoubletons;
    }
}

