/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination;

import de.uni_freiburg.informatik.ultimate.core.model.services.ILogger;
import de.uni_freiburg.informatik.ultimate.core.model.services.IUltimateServiceProvider;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.EqualityAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalysisResult;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.equalityanalysis.IndexAnalyzer;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayTemplate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.ArrayWrite;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationPreAnalysis;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminationSettings;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapEliminatorUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination.MapTemplate;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.PartialQuantifierElimination;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.quantifier.QuantifierUtils;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.Script;
import de.uni_freiburg.informatik.ultimate.logic.Sort;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import de.uni_freiburg.informatik.ultimate.logic.Util;
import de.uni_freiburg.informatik.ultimate.util.datastructures.Doubleton;
import de.uni_freiburg.informatik.ultimate.util.datastructures.UnionFind;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.HashRelation;
import de.uni_freiburg.informatik.ultimate.util.datastructures.relation.Pair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class MapEliminator {
    private final IUltimateServiceProvider mServices;
    private final Script mScript;
    private final ManagedScript mManagedScript;
    private final ReplacementVarFactory mReplacementVarFactory;
    private final ILogger mLogger;
    private final IIcfgSymbolTable mSymbolTable;
    private final MapEliminationSettings mSettings;
    private final MapEliminationPreAnalysis mAnalysis;

    public MapEliminator(IUltimateServiceProvider services, ILogger logger, ManagedScript managedScript, IIcfgSymbolTable symbolTable, ReplacementVarFactory replacementVarFactory, Collection<ModifiableTransFormula> transformulas, MapEliminationSettings settings) {
        this.mSettings = settings;
        this.mServices = services;
        this.mScript = managedScript.getScript();
        this.mLogger = logger;
        this.mLogger.info((Object)("Using MapEliminator with " + this.mSettings));
        this.mManagedScript = managedScript;
        this.mReplacementVarFactory = replacementVarFactory;
        this.mSymbolTable = symbolTable;
        this.mAnalysis = new MapEliminationPreAnalysis(managedScript, transformulas);
    }

    public ModifiableTransFormula eliminateMaps(ModifiableTransFormula transformula, EqualityAnalysisResult equalityAnalysisBefore, EqualityAnalysisResult equalityAnalysisAfter) {
        ModifiableTransFormula newTF = new ModifiableTransFormula(transformula);
        Term term = newTF.getFormula();
        if (!QuantifierUtils.isQuantifierFree((Term)term)) {
            throw new UnsupportedOperationException("Quantifiers are not supported");
        }
        if (!SmtUtils.isNNF((Term)term)) {
            throw new UnsupportedOperationException("Only formulae in NNF are supported");
        }
        HashRelation<MapTemplate, ArrayIndex> localIndices = this.getLocalIndices(newTF, this.mAnalysis.getLocalIndices(transformula));
        IndexAnalyzer indexAnalyzer = new IndexAnalyzer(term, this.mAnalysis.getIndexDoubletons(localIndices), this.mSymbolTable, newTF, equalityAnalysisBefore, equalityAnalysisAfter, this.mLogger, this.mManagedScript);
        IndexAnalysisResult invariants = indexAnalyzer.getResult();
        HashSet<TermVariable> auxVars = new HashSet<TermVariable>();
        Term storeFreeTerm = this.replaceStoreTerms(term, newTF, invariants, auxVars);
        assert (!SmtUtils.containsFunctionApplication((Term)storeFreeTerm, (String)"store")) : "The formula contains still store-terms";
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        conjuncts.add(storeFreeTerm);
        conjuncts.addAll(this.getAdditionalEqualities(localIndices, invariants));
        if (!this.mSettings.onlyTrivialImplicationsForModifiedArguments()) {
            conjuncts.addAll(this.getAllImplicationsForIndexAssignment(newTF, invariants));
        }
        conjuncts.addAll(invariants.constructListOfEqualities(this.mScript));
        if (this.mSettings.addInequalities()) {
            conjuncts.addAll(invariants.constructListOfNotEquals(this.mScript));
        }
        Term mapFreeTerm = this.replaceMapReads(newTF, SmtUtils.and((Script)this.mScript, conjuncts), auxVars);
        assert (SmtUtils.isArrayFree((Term)mapFreeTerm)) : "The formula contains still arrays";
        assert (!SmtUtils.containsUninterpretedFunctionApplication((Term)mapFreeTerm)) : "The formula contains still UFs";
        this.setFormulaAndSimplify(newTF, mapFreeTerm, auxVars);
        return newTF;
    }

    private HashRelation<MapTemplate, ArrayIndex> getLocalIndices(ModifiableTransFormula transformula, HashRelation<MapTemplate, ArrayIndex> occurringIndices) {
        HashRelation result = new HashRelation();
        for (MapTemplate globalTemplate : occurringIndices.getDomain()) {
            for (MapTemplate template : this.getLocalTemplates(globalTemplate, transformula)) {
                for (ArrayIndex index : occurringIndices.getImage((Object)globalTemplate)) {
                    result.addPair((Object)template, (Object)index);
                }
            }
        }
        for (MapTemplate globalTemplate : this.mAnalysis.getAllTemplates()) {
            for (MapTemplate template : this.getLocalTemplates(globalTemplate, transformula)) {
                for (ArrayIndex index : this.getInAndOutVarIndices(this.mAnalysis.getIndices(globalTemplate), transformula)) {
                    result.addPair((Object)template, (Object)index);
                }
            }
        }
        return result;
    }

    private Collection<MapTemplate> getLocalTemplates(MapTemplate template, ModifiableTransFormula transformula) {
        if (template instanceof ArrayTemplate) {
            Term array = (Term)template.getIdentifier();
            ArrayTemplate inVarTemplate = new ArrayTemplate(MapEliminatorUtils.getInVarTerm(array, transformula, this.mManagedScript, this.mSymbolTable), this.mScript);
            ArrayTemplate outVarTemplate = new ArrayTemplate(MapEliminatorUtils.getOutVarTerm(array, transformula, this.mManagedScript, this.mSymbolTable), this.mScript);
            return Arrays.asList(inVarTemplate, outVarTemplate);
        }
        return Arrays.asList(template);
    }

    private List<Term> getAdditionalEqualities(HashRelation<MapTemplate, ArrayIndex> localIndices, EqualityAnalysisResult invariants) {
        ArrayList<Term> result = new ArrayList<Term>();
        for (MapTemplate template : localIndices.getDomain()) {
            UnionFind unionFind = new UnionFind();
            Set indicesSet = localIndices.getImage((Object)template);
            ArrayIndex[] indices = indicesSet.toArray(new ArrayIndex[indicesSet.size()]);
            int i = 0;
            while (i < indices.length) {
                int j = i + 1;
                while (j < indices.length) {
                    if (MapEliminator.areIndicesEqual(indices[i], indices[j], invariants)) {
                        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)indices[i]);
                        unionFind.findAndConstructEquivalenceClassIfNeeded((Object)indices[j]);
                        unionFind.union((Object)indices[i], (Object)indices[j]);
                    }
                    ++j;
                }
                ++i;
            }
            for (ArrayIndex index1 : unionFind.getAllRepresentatives()) {
                Term term1 = template.getTerm(index1);
                if (term1.getSort().isArraySort()) continue;
                for (ArrayIndex index2 : unionFind.getEquivalenceClassMembers((Object)index1)) {
                    if (index1 == index2) continue;
                    Term term2 = template.getTerm(index2);
                    result.add(SmtUtils.binaryEquality((Script)this.mScript, (Term)term1, (Term)term2));
                }
            }
        }
        return result;
    }

    private void setFormulaAndSimplify(ModifiableTransFormula transformula, Term term, Set<TermVariable> auxVars) {
        Term newTerm;
        if (auxVars.isEmpty()) {
            newTerm = term;
        } else {
            Term quantifier = SmtUtils.quantifier((Script)this.mScript, (int)0, auxVars, (Term)term);
            newTerm = PartialQuantifierElimination.eliminate((IUltimateServiceProvider)this.mServices, (ManagedScript)this.mManagedScript, (Term)quantifier, (SmtUtils.SimplificationTechnique)this.mSettings.getSimplificationTechnique());
            transformula.addAuxVars(auxVars);
            auxVars.clear();
        }
        transformula.setFormula(SmtUtils.simplify((ManagedScript)this.mManagedScript, (Term)newTerm, (IUltimateServiceProvider)this.mServices, (SmtUtils.SimplificationTechnique)this.mSettings.getSimplificationTechnique()));
        MapEliminator.clearTransFormula(transformula);
    }

    private static void clearTransFormula(ModifiableTransFormula transformula) {
        ArrayList<IProgramVar> inVarsToRemove = new ArrayList<IProgramVar>();
        ArrayList<IProgramVar> outVarsToRemove = new ArrayList<IProgramVar>();
        HashSet<TermVariable> freeVars = new HashSet<TermVariable>(Arrays.asList(transformula.getFormula().getFreeVars()));
        List<TermVariable> auxVarsToRemove = transformula.getAuxVars().stream().filter(tv -> !freeVars.contains(tv)).collect(Collectors.toList());
        for (Map.Entry<IProgramVar, TermVariable> entry : transformula.getInVars().entrySet()) {
            Term inVar = (Term)entry.getValue();
            IProgramVar var = entry.getKey();
            if (inVar.getSort().isArraySort()) {
                inVarsToRemove.add(var);
                continue;
            }
            if (freeVars.contains(inVar) || transformula.getOutVars().get(var) != inVar || SmtUtils.isConstant((Term)inVar)) continue;
            inVarsToRemove.add(var);
            outVarsToRemove.add(var);
        }
        for (Map.Entry<IProgramVar, TermVariable> entry : transformula.getOutVars().entrySet()) {
            Term outVar = (Term)entry.getValue();
            if (!outVar.getSort().isArraySort()) continue;
            outVarsToRemove.add(entry.getKey());
        }
        inVarsToRemove.forEach(transformula::removeInVar);
        outVarsToRemove.forEach(transformula::removeOutVar);
        auxVarsToRemove.forEach(transformula::removeAuxVar);
    }

    private Term replaceMapReads(ModifiableTransFormula transformula, Term term, Set<TermVariable> auxVars) {
        for (MapTemplate template : this.mAnalysis.getAllTemplates()) {
            for (ArrayIndex index : this.mAnalysis.getIndices(template)) {
                Term mapTerm = template.getTerm(index);
                MapEliminatorUtils.addReplacementVar(mapTerm, transformula, this.mManagedScript, this.mReplacementVarFactory, this.mSymbolTable);
            }
        }
        Map<Term, Term> substitution = this.mAnalysis.findMapReads(term).collect(Collectors.toMap(x -> x, x -> MapEliminatorUtils.getReplacementVar(x, transformula, this.mManagedScript, this.mReplacementVarFactory, auxVars)));
        return Substitution.apply((ManagedScript)this.mManagedScript, substitution, (Term)term);
    }

    private Term replaceStoreTerms(Term term, ModifiableTransFormula transformula, EqualityAnalysisResult invariants, Set<TermVariable> auxVars) {
        HashMap<Term, Object> substitutionMap = new HashMap<Term, Object>();
        ArrayList<Term> conjuncts = new ArrayList<Term>();
        Term replacedTerm = this.replaceArrayInequalities(term);
        for (MultiDimensionalSelect select : MultiDimensionalSelect.extractSelectDeep((Term)replacedTerm, (boolean)false)) {
            if (!SmtUtils.isFunctionApplication((Term)select.getArray(), (String)"store")) continue;
            Term selectTerm = select.getSelectTerm();
            substitutionMap.put(selectTerm, this.replaceSelectStoreTerm(selectTerm, transformula, invariants, conjuncts, auxVars));
        }
        for (Term t : SmtUtils.extractApplicationTerms((String)"=", (Term)replacedTerm, (boolean)false)) {
            if (!((ApplicationTerm)t).getParameters()[0].getSort().isArraySort()) continue;
            substitutionMap.put(t, this.replaceArrayEquality(t, transformula, invariants));
        }
        conjuncts.add(replacedTerm);
        return Substitution.apply((ManagedScript)this.mManagedScript, substitutionMap, (Term)Substitution.apply((ManagedScript)this.mManagedScript, substitutionMap, (Term)SmtUtils.and((Script)this.mScript, conjuncts)));
    }

    private Term replaceArrayInequalities(Term term) {
        HashMap<Term, Term> substitutionMap = new HashMap<Term, Term>();
        for (Term t : SmtUtils.extractApplicationTerms((String)"not", (Term)term, (boolean)false)) {
            ApplicationTerm equality;
            Term subterm = ((ApplicationTerm)t).getParameters()[0];
            if (!SmtUtils.isFunctionApplication((Term)subterm, (String)"=") || !(equality = (ApplicationTerm)subterm).getParameters()[0].getSort().isArraySort()) continue;
            substitutionMap.put(t, this.mScript.term("true", new Term[0]));
        }
        return Substitution.apply((ManagedScript)this.mManagedScript, substitutionMap, (Term)term);
    }

    private TermVariable replaceSelectStoreTerm(Term term, ModifiableTransFormula transformula, EqualityAnalysisResult invariants, List<Term> auxVarEqualities, Set<TermVariable> auxVars) {
        MultiDimensionalSelect multiDimensionalSelect = new MultiDimensionalSelect(term);
        ArrayIndex index = multiDimensionalSelect.getIndex();
        ArrayWrite arrayWrite = new ArrayWrite(multiDimensionalSelect.getArray(), this.mScript);
        HashSet<ArrayIndex> processedIndices = new HashSet<ArrayIndex>();
        TermVariable auxVar = MapEliminatorUtils.getAndAddAuxVar(term, auxVars, this.mReplacementVarFactory);
        for (Pair<ArrayIndex, Term> pair : arrayWrite.getIndexValuePairs()) {
            ArrayIndex assignedIndex = (ArrayIndex)pair.getFirst();
            if (processedIndices.contains(assignedIndex)) continue;
            Term value = (Term)pair.getSecond();
            Term newTerm = this.indexEqualityInequalityImpliesValueEquality(index, assignedIndex, processedIndices, (Term)auxVar, value, invariants, transformula);
            if (!SmtUtils.isFunctionApplication((Term)newTerm, (String)"or") || !this.mSettings.onlyTrivialImplicationsArrayWrite()) {
                auxVarEqualities.add(newTerm);
            }
            processedIndices.add(assignedIndex);
        }
        Term selectTerm = SmtUtils.multiDimensionalSelect((Script)this.mScript, (Term)arrayWrite.getOldArray(), (ArrayIndex)index);
        Term arrayRead = this.indexEqualityInequalityImpliesValueEquality(index, index, processedIndices, (Term)auxVar, selectTerm, invariants, transformula);
        if (!SmtUtils.isFunctionApplication((Term)arrayRead, (String)"or") || !this.mSettings.onlyTrivialImplicationsArrayWrite()) {
            auxVarEqualities.add(arrayRead);
        }
        return auxVar;
    }

    private Term replaceArrayEquality(Term term, ModifiableTransFormula transformula, EqualityAnalysisResult invariants) {
        ArrayWrite arrayWrite = new ArrayWrite(term, this.mScript);
        Term oldArray = arrayWrite.getOldArray();
        Term newArray = arrayWrite.getNewArray();
        if (!ModifiableTransFormulaUtils.allVariablesAreVisible(oldArray, transformula) || !ModifiableTransFormulaUtils.allVariablesAreVisible(newArray, transformula) || SmtUtils.isFunctionApplication((Term)newArray, (String)"store")) {
            return this.mScript.term("true", new Term[0]);
        }
        ArrayList<Term> result = new ArrayList<Term>();
        boolean oldIsInVar = transformula.getInVarsReverseMapping().containsKey(oldArray);
        boolean newIsInVar = transformula.getInVarsReverseMapping().containsKey(newArray);
        Term globalOldArray = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, oldArray);
        Term globalNewArray = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(this.mManagedScript, transformula, newArray);
        ArrayTemplate oldTemplate = new ArrayTemplate(globalOldArray, this.mScript);
        ArrayTemplate newTemplate = new ArrayTemplate(globalNewArray, this.mScript);
        HashSet<ArrayIndex> processedIndices = new HashSet<ArrayIndex>();
        for (Pair<ArrayIndex, Term> pair : arrayWrite.getIndexValuePairs()) {
            ArrayIndex assignedIndex = (ArrayIndex)pair.getFirst();
            if (processedIndices.contains(assignedIndex) || assignedIndex.size() != SmtUtils.getDimension((Sort)oldArray.getSort())) continue;
            Term value = (Term)pair.getSecond();
            for (ArrayIndex globalIndex : this.mAnalysis.getIndices(newTemplate)) {
                Term newTerm;
                ArrayIndex index;
                Term select;
                Term globalSelect = newTemplate.getTerm(globalIndex);
                if (newIsInVar) {
                    select = MapEliminatorUtils.getInVarTerm(globalSelect, transformula, this.mManagedScript, this.mSymbolTable);
                    index = MapEliminatorUtils.getInVarIndex(globalIndex, transformula, this.mManagedScript, this.mSymbolTable);
                } else {
                    select = MapEliminatorUtils.getOutVarTerm(globalSelect, transformula, this.mManagedScript, this.mSymbolTable);
                    index = MapEliminatorUtils.getOutVarIndex(globalIndex, transformula, this.mManagedScript, this.mSymbolTable);
                }
                if (processedIndices.contains(index) || SmtUtils.isFunctionApplication((Term)(newTerm = this.indexEqualityInequalityImpliesValueEquality(index, assignedIndex, processedIndices, select, value, invariants, transformula)), (String)"or") && this.mSettings.onlyTrivialImplicationsArrayWrite()) continue;
                result.add(newTerm);
            }
            processedIndices.add(assignedIndex);
        }
        for (ArrayIndex globalIndex : this.mAnalysis.getIndices(oldTemplate)) {
            ArrayIndex index2;
            Term selectNew;
            ArrayIndex index1;
            Term selectOld;
            if (oldIsInVar) {
                selectOld = MapEliminatorUtils.getInVarTerm(oldTemplate.getTerm(globalIndex), transformula, this.mManagedScript, this.mSymbolTable);
                index1 = MapEliminatorUtils.getInVarIndex(globalIndex, transformula, this.mManagedScript, this.mSymbolTable);
            } else {
                selectOld = MapEliminatorUtils.getOutVarTerm(oldTemplate.getTerm(globalIndex), transformula, this.mManagedScript, this.mSymbolTable);
                index1 = MapEliminatorUtils.getOutVarIndex(globalIndex, transformula, this.mManagedScript, this.mSymbolTable);
            }
            if (newIsInVar) {
                selectNew = MapEliminatorUtils.getInVarTerm(newTemplate.getTerm(globalIndex), transformula, this.mManagedScript, this.mSymbolTable);
                index2 = MapEliminatorUtils.getInVarIndex(globalIndex, transformula, this.mManagedScript, this.mSymbolTable);
            } else {
                selectNew = MapEliminatorUtils.getOutVarTerm(newTemplate.getTerm(globalIndex), transformula, this.mManagedScript, this.mSymbolTable);
                index2 = MapEliminatorUtils.getOutVarIndex(globalIndex, transformula, this.mManagedScript, this.mSymbolTable);
            }
            Term newTerm = this.indexEqualityInequalityImpliesValueEquality(index1, index2, processedIndices, selectNew, selectOld, invariants, transformula);
            if (SmtUtils.isFunctionApplication((Term)newTerm, (String)"or") && this.mSettings.onlyTrivialImplicationsArrayWrite()) continue;
            result.add(newTerm);
        }
        return SmtUtils.and((Script)this.mScript, result);
    }

    private List<Term> getAllImplicationsForIndexAssignment(ModifiableTransFormula transformula, EqualityAnalysisResult invariants) {
        ArrayList<Term> result = new ArrayList<Term>();
        for (IProgramVar var : transformula.getAssignedVars()) {
            Term definition = ReplacementVarUtils.getDefinition(var);
            for (ArrayIndex globalIndexWritten : this.mAnalysis.getIndicesWithVariable(definition)) {
                ArrayIndex indexWrittenIn = MapEliminatorUtils.getInVarIndex(globalIndexWritten, transformula, this.mManagedScript, this.mSymbolTable);
                ArrayIndex indexWrittenOut = MapEliminatorUtils.getOutVarIndex(globalIndexWritten, transformula, this.mManagedScript, this.mSymbolTable);
                for (MapTemplate template : this.mAnalysis.getTemplate(globalIndexWritten)) {
                    boolean isAssigned = template.isAssigned(transformula);
                    Term written = template.getTerm(globalIndexWritten);
                    Term writtenOut = MapEliminatorUtils.getOutVarTerm(written, transformula, this.mManagedScript, this.mSymbolTable);
                    if (!isAssigned) {
                        Term writtenIn = MapEliminatorUtils.getInVarTerm(written, transformula, this.mManagedScript, this.mSymbolTable);
                        result.add(this.indexEqualityImpliesValueEquality(indexWrittenOut, indexWrittenIn, writtenOut, writtenIn, invariants, transformula));
                    }
                    for (ArrayIndex globalIndexRead : this.mAnalysis.getIndices(template)) {
                        if (globalIndexWritten.equals((Object)globalIndexRead)) continue;
                        Term read = template.getTerm(globalIndexRead);
                        if (!isAssigned) {
                            Term readIn = MapEliminatorUtils.getInVarTerm(read, transformula, this.mManagedScript, this.mSymbolTable);
                            ArrayIndex indexReadIn = MapEliminatorUtils.getInVarIndex(globalIndexRead, transformula, this.mManagedScript, this.mSymbolTable);
                            result.add(this.indexEqualityImpliesValueEquality(indexWrittenOut, indexReadIn, writtenOut, readIn, invariants, transformula));
                        }
                        Term readOut = MapEliminatorUtils.getOutVarTerm(read, transformula, this.mManagedScript, this.mSymbolTable);
                        ArrayIndex indexReadOut = MapEliminatorUtils.getOutVarIndex(globalIndexRead, transformula, this.mManagedScript, this.mSymbolTable);
                        result.add(this.indexEqualityImpliesValueEquality(indexWrittenOut, indexReadOut, writtenOut, readOut, invariants, transformula));
                    }
                }
            }
        }
        return result;
    }

    private Collection<ArrayIndex> getInAndOutVarIndices(Set<ArrayIndex> indices, ModifiableTransFormula transformula) {
        HashSet<ArrayIndex> result = new HashSet<ArrayIndex>();
        for (ArrayIndex index : indices) {
            result.add(MapEliminatorUtils.getInVarIndex(index, transformula, this.mManagedScript, this.mSymbolTable));
            result.add(MapEliminatorUtils.getOutVarIndex(index, transformula, this.mManagedScript, this.mSymbolTable));
        }
        return result;
    }

    public Set<Doubleton<Term>> getDoubletons() {
        return this.mAnalysis.getAllDoubletons();
    }

    private static boolean areIndicesEqual(ArrayIndex index1, ArrayIndex index2, EqualityAnalysisResult invariants) {
        if (index1.size() != index2.size()) {
            return false;
        }
        int i = 0;
        while (i < index1.size()) {
            Term term2;
            Term term1 = index1.get(i);
            if (term1 != (term2 = index2.get(i)) && !invariants.getEqualDoubletons().contains(new Doubleton((Object)term1, (Object)term2))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private Term getEqualTerm(ArrayIndex index1, ArrayIndex index2, EqualityAnalysisResult invariants) {
        if (index1.size() != index2.size()) {
            return this.mScript.term("false", new Term[0]);
        }
        ArrayList<Term> result = new ArrayList<Term>();
        int i = 0;
        while (i < index1.size()) {
            Term term2;
            Term term1 = index1.get(i);
            if (term1 != (term2 = index2.get(i))) {
                Doubleton doubleton = new Doubleton((Object)term1, (Object)term2);
                if (invariants.getDistinctDoubletons().contains(doubleton)) {
                    return this.mScript.term("false", new Term[0]);
                }
                if (!invariants.getEqualDoubletons().contains(doubleton)) {
                    result.add(SmtUtils.binaryEquality((Script)this.mScript, (Term)term1, (Term)term2));
                }
            }
            ++i;
        }
        return SmtUtils.and((Script)this.mScript, result);
    }

    private Term indexEqualityInequalityImpliesValueEquality(ArrayIndex index, ArrayIndex equal, Collection<ArrayIndex> unequal, Term value1, Term value2, EqualityAnalysisResult invariants, ModifiableTransFormula transformula) {
        List<TermVariable> freeVarsFormula = Arrays.asList(transformula.getFormula().getFreeVars());
        Term inequality = Util.not((Script)this.mScript, (Term)this.getEqualTerm(index, equal, invariants));
        List<TermVariable> freeVarsInequality = Arrays.asList(inequality.getFreeVars());
        if (SmtUtils.isTrueLiteral((Term)inequality) || !freeVarsFormula.containsAll(freeVarsInequality) && this.mSettings.onlyArgumentsInFormula()) {
            return this.mScript.term("true", new Term[0]);
        }
        ArrayList<Term> disjuncts = new ArrayList<Term>();
        disjuncts.add(inequality);
        for (ArrayIndex i : unequal) {
            Term equality = this.getEqualTerm(index, i, invariants);
            List<TermVariable> freeVarsEquality = Arrays.asList(equality.getFreeVars());
            if (SmtUtils.isTrueLiteral((Term)equality) || !freeVarsFormula.containsAll(freeVarsEquality) && this.mSettings.onlyArgumentsInFormula()) {
                return this.mScript.term("true", new Term[0]);
            }
            disjuncts.add(equality);
        }
        if (!value1.getSort().equals(value2.getSort())) {
            throw new AssertionError((Object)String.format("%s tries to combine %s and %s", this.getClass().getSimpleName(), value1.getSort(), value2.getSort()));
        }
        disjuncts.add(SmtUtils.binaryEquality((Script)this.mScript, (Term)value1, (Term)value2));
        return SmtUtils.or((Script)this.mScript, disjuncts);
    }

    private Term indexEqualityImpliesValueEquality(ArrayIndex index, ArrayIndex equal, Term value1, Term value2, EqualityAnalysisResult invariants, ModifiableTransFormula transformula) {
        return this.indexEqualityInequalityImpliesValueEquality(index, equal, List.of(), value1, value2, invariants, transformula);
    }
}

