/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.mapelimination;

import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.IIcfgSymbolTable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVar;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.IReplacementVarOrConst;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transformations.ReplacementVarFactory;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormula;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.transitions.ModifiableTransFormulaUtils;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.cfg.variables.IProgramVar;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.ManagedScript;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.SmtUtils;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.Substitution;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.ArrayIndex;
import de.uni_freiburg.informatik.ultimate.lib.smtlibutils.arrays.MultiDimensionalSelect;
import de.uni_freiburg.informatik.ultimate.logic.ApplicationTerm;
import de.uni_freiburg.informatik.ultimate.logic.FunctionSymbol;
import de.uni_freiburg.informatik.ultimate.logic.Term;
import de.uni_freiburg.informatik.ultimate.logic.TermVariable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;

public final class MapEliminatorUtils {
    private MapEliminatorUtils() {
    }

    private static Term getLocalTerm(Term term, ModifiableTransFormula transformula, ManagedScript managedScript, IIcfgSymbolTable symbolTable, boolean returnInVar) {
        HashMap<TermVariable, Term> substitution = new HashMap<TermVariable, Term>();
        TermVariable[] termVariableArray = term.getFreeVars();
        int n = termVariableArray.length;
        int n2 = 0;
        while (n2 < n) {
            TermVariable var = termVariableArray[n2];
            IProgramVar programVar = symbolTable.getProgramVar(var);
            TermVariable freshTermVar = MapEliminatorUtils.getFreshTermVar((Term)var, managedScript);
            if (!transformula.getInVars().containsKey(programVar)) {
                transformula.addInVar(programVar, freshTermVar);
            }
            if (!transformula.getOutVars().containsKey(programVar)) {
                transformula.addOutVar(programVar, freshTermVar);
            }
            if (returnInVar) {
                substitution.put(var, (Term)transformula.getInVars().get(programVar));
            } else {
                substitution.put(var, (Term)transformula.getOutVars().get(programVar));
            }
            ++n2;
        }
        return Substitution.apply((ManagedScript)managedScript, substitution, (Term)term);
    }

    public static Term getInVarTerm(Term term, ModifiableTransFormula transformula, ManagedScript managedScript, IIcfgSymbolTable symbolTable) {
        return MapEliminatorUtils.getLocalTerm(term, transformula, managedScript, symbolTable, true);
    }

    public static Term getOutVarTerm(Term term, ModifiableTransFormula transformula, ManagedScript managedScript, IIcfgSymbolTable symbolTable) {
        return MapEliminatorUtils.getLocalTerm(term, transformula, managedScript, symbolTable, false);
    }

    public static ArrayIndex getInVarIndex(ArrayIndex index, ModifiableTransFormula transformula, ManagedScript managedScript, IIcfgSymbolTable symbolTable) {
        return new ArrayIndex(index.stream().map(t -> MapEliminatorUtils.getInVarTerm(t, transformula, managedScript, symbolTable)).collect(Collectors.toList()));
    }

    public static ArrayIndex getOutVarIndex(ArrayIndex index, ModifiableTransFormula transformula, ManagedScript managedScript, IIcfgSymbolTable symbolTable) {
        return new ArrayIndex(index.stream().map(t -> MapEliminatorUtils.getOutVarTerm(t, transformula, managedScript, symbolTable)).collect(Collectors.toList()));
    }

    private static TermVariable getFreshTermVar(Term term, ManagedScript managedScript) {
        return managedScript.constructFreshTermVariable(MapEliminatorUtils.niceTermString(term), term.getSort());
    }

    private static String niceTermString(Term term) {
        if (SmtUtils.isFunctionApplication((Term)term, (String)"select")) {
            StringBuilder stringBuilder = new StringBuilder();
            MultiDimensionalSelect select = new MultiDimensionalSelect(term);
            stringBuilder.append("array_").append(MapEliminatorUtils.niceTermString(select.getArray())).append('[');
            ArrayIndex index = select.getIndex();
            int i = 0;
            while (i < index.size()) {
                stringBuilder.append(MapEliminatorUtils.niceTermString(index.get(i))).append(i == index.size() - 1 ? (char)']' : ',');
                ++i;
            }
            return stringBuilder.toString();
        }
        if (term instanceof ApplicationTerm && !SmtUtils.isConstant((Term)term)) {
            StringBuilder stringBuilder = new StringBuilder();
            ApplicationTerm applicationTerm = (ApplicationTerm)term;
            FunctionSymbol function = applicationTerm.getFunction();
            if (!function.isIntern()) {
                stringBuilder.append("uf_");
            }
            stringBuilder.append('(').append(function.getName()).append(' ');
            Term[] params = applicationTerm.getParameters();
            int i = 0;
            while (i < params.length) {
                stringBuilder.append(MapEliminatorUtils.niceTermString(params[i])).append(i == params.length - 1 ? (char)')' : ' ');
                ++i;
            }
            return stringBuilder.toString();
        }
        return SmtUtils.removeSmtQuoteCharacters((String)term.toString());
    }

    public static void addReplacementVar(Term term, ModifiableTransFormula transformula, ManagedScript managedScript, ReplacementVarFactory replacementVarFactory, IIcfgSymbolTable symbolTable) {
        IReplacementVarOrConst varOrConst = replacementVarFactory.getOrConstuctReplacementVar(term, false);
        if (!(varOrConst instanceof IReplacementVar)) {
            throw new UnsupportedOperationException("Unsupported type " + varOrConst.getClass());
        }
        IReplacementVar var = (IReplacementVar)varOrConst;
        TermVariable termVar = MapEliminatorUtils.getFreshTermVar(term, managedScript);
        Map<IProgramVar, TermVariable> inVars = transformula.getInVars();
        Map<IProgramVar, TermVariable> outVars = transformula.getOutVars();
        if (!inVars.containsKey(var)) {
            transformula.addInVar(var, termVar);
        }
        if (!outVars.containsKey(var)) {
            if (Arrays.stream(term.getFreeVars()).map(symbolTable::getProgramVar).anyMatch(x -> inVars.get(x) != outVars.get(x))) {
                transformula.addOutVar(var, MapEliminatorUtils.getFreshTermVar(term, managedScript));
            } else {
                transformula.addOutVar(var, termVar);
            }
        }
    }

    public static Term getReplacementVar(Term term, ModifiableTransFormula transformula, ManagedScript script, ReplacementVarFactory replacementVarFactory, Collection<TermVariable> auxVars) {
        if (!ModifiableTransFormulaUtils.allVariablesAreInVars(term, transformula) && !ModifiableTransFormulaUtils.allVariablesAreOutVars(term, transformula)) {
            return MapEliminatorUtils.getAndAddAuxVar(term, auxVars, replacementVarFactory);
        }
        Term definition = ModifiableTransFormulaUtils.translateTermVariablesToDefinitions(script, transformula, term);
        IReplacementVarOrConst varOrConst = replacementVarFactory.getOrConstuctReplacementVar(definition, false);
        if (!(varOrConst instanceof IReplacementVar)) {
            throw new UnsupportedOperationException("Unsupported type " + varOrConst.getClass());
        }
        IReplacementVar var = (IReplacementVar)varOrConst;
        TermVariable inVar = transformula.getInVars().get(var);
        TermVariable outVar = transformula.getOutVars().get(var);
        if (inVar == null || outVar == null) {
            throw new AssertionError((Object)(var + " was not added to the transformula!"));
        }
        return ModifiableTransFormulaUtils.allVariablesAreInVars(term, transformula) ? inVar : outVar;
    }

    public static TermVariable getAndAddAuxVar(Term term, Collection<TermVariable> auxVars, ReplacementVarFactory replacementVarFactory) {
        TermVariable auxVar = replacementVarFactory.getOrConstructAuxVar(MapEliminatorUtils.niceTermString(term), term.getSort());
        auxVars.add(auxVar);
        return auxVar;
    }
}

