/*
 * Decompiled with CFR 0.152.
 */
package de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates;

import de.uni_freiburg.informatik.ultimate.core.model.models.annotation.Visualizable;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.absint.IAbstractState;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.BasicPredicate;
import de.uni_freiburg.informatik.ultimate.lib.modelcheckerutils.smt.predicates.IPredicate;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class AbsIntPredicate<STATE extends IAbstractState<STATE>>
extends BasicPredicate {
    private static final long serialVersionUID = 1L;
    private final Set<STATE> mAbstractStates;
    private final IPredicate mPredicate;

    public AbsIntPredicate(IPredicate classicPredicate, STATE abstractState) {
        this(classicPredicate, Collections.singleton(abstractState));
    }

    public AbsIntPredicate(IPredicate classicPredicate, Set<STATE> abstractState) {
        super(classicPredicate.hashCode(), classicPredicate.getProcedures(), classicPredicate.getFormula(), classicPredicate.getVars(), classicPredicate.getClosedFormula());
        this.mAbstractStates = Objects.requireNonNull(abstractState);
        this.mPredicate = Objects.requireNonNull(classicPredicate);
        assert (!this.mAbstractStates.isEmpty());
        assert (!(this.mPredicate instanceof AbsIntPredicate));
    }

    @Visualizable
    public Set<STATE> getAbstractStates() {
        return Collections.unmodifiableSet(this.mAbstractStates);
    }

    @Visualizable
    public IPredicate getBackingPredicate() {
        return this.mPredicate;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.mPredicate.toString()).append(" (");
        return sb.append(this.mAbstractStates.stream().map(IAbstractState::toLogString).collect(Collectors.toSet())).append(")").toString();
    }
}

